/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.featuresTrainer.ift;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.python.featuresTrainer.ift.PythonLessonsBundle;
import com.intellij.python.featuresTrainer.ift.PythonLessonsUtil;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.inspections.PyInterpreterInspection;
import com.jetbrains.python.newProject.DeprecatedUtils;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.statistics.PyStatisticToolsKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonArrayBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObjectBuilder;
import org.jetbrains.annotations.NotNull;
import training.dsl.LessonContext;
import training.dsl.TaskContext;
import training.dsl.TaskRuntimeContext;
import training.lang.LangSupport;
import training.ui.LearningUiManager;
import training.ui.OnboardingFeedbackFormKt;
import training.util.LessonEndInfo;
import training.util.OnboardingFeedbackData;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\n\u0010\b\u001a\u00020\t*\u00020\nJ>\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r\u00a8\u0006\u0015"}, d2={"Lcom/intellij/python/featuresTrainer/ift/PythonLessonsUtil;", "", "<init>", "()V", "isPython3Installed", "", "project", "Lcom/intellij/openapi/project/Project;", "showWarningIfPython3NotFound", "", "Ltraining/dsl/LessonContext;", "prepareFeedbackDataForOnboardingLesson", "configPropertyName", "", "reportTitle", "feedbackReportId", "primaryLanguage", "Ltraining/lang/LangSupport;", "lessonEndInfo", "Ltraining/util/LessonEndInfo;", "usedInterpreterAtStart", "intellij.python.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nPythonLessonsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonLessonsUtil.kt\ncom/intellij/python/featuresTrainer/ift/PythonLessonsUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1617#2,9:113\n1869#2:122\n1870#2:124\n1626#2:125\n1#3:123\n*S KotlinDebug\n*F\n+ 1 PythonLessonsUtil.kt\ncom/intellij/python/featuresTrainer/ift/PythonLessonsUtil\n*L\n68#1:113,9\n68#1:122\n68#1:124\n68#1:125\n68#1:123\n*E\n"})
public final class PythonLessonsUtil {
    @NotNull
    public static final PythonLessonsUtil INSTANCE = new PythonLessonsUtil();

    private PythonLessonsUtil() {
    }

    public final boolean isPython3Installed(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Sdk sdk2 = PySdkExtKt.getPythonSdk(project);
        if (sdk2 == null) {
            return false;
        }
        Sdk sdk3 = sdk2;
        Object object = PythonSdkFlavor.getFlavor(sdk3);
        return object != null && (object = ((PythonSdkFlavor)object).getLanguageLevel(sdk3)) != null ? ((LanguageLevel)((Object)object)).isPy3K() : false;
    }

    public final void showWarningIfPython3NotFound(@NotNull LessonContext $this$showWarningIfPython3NotFound) {
        Intrinsics.checkNotNullParameter((Object)$this$showWarningIfPython3NotFound, (String)"<this>");
        $this$showWarningIfPython3NotFound.task(PythonLessonsUtil::showWarningIfPython3NotFound$lambda$3);
    }

    public final void prepareFeedbackDataForOnboardingLesson(@NotNull Project project, @NotNull String configPropertyName, @NotNull String reportTitle, @NotNull String feedbackReportId, @NotNull LangSupport primaryLanguage, @NotNull LessonEndInfo lessonEndInfo, @NotNull String usedInterpreterAtStart) {
        Object usedInterpreter;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)configPropertyName, (String)"configPropertyName");
        Intrinsics.checkNotNullParameter((Object)reportTitle, (String)"reportTitle");
        Intrinsics.checkNotNullParameter((Object)feedbackReportId, (String)"feedbackReportId");
        Intrinsics.checkNotNullParameter((Object)primaryLanguage, (String)"primaryLanguage");
        Intrinsics.checkNotNullParameter((Object)lessonEndInfo, (String)"lessonEndInfo");
        Intrinsics.checkNotNullParameter((Object)usedInterpreterAtStart, (String)"usedInterpreterAtStart");
        if (!OnboardingFeedbackFormKt.shouldCollectFeedbackResults()) {
            return;
        }
        if (PropertiesComponent.getInstance().getBoolean(configPropertyName, false)) {
            return;
        }
        Sdk[] sdkArray = PyConfigurableInterpreterList.getInstance(null).getModel().getSdks();
        List allExistingSdks = CollectionsKt.listOf((Object[])Arrays.copyOf(sdkArray, sdkArray.length));
        List<Sdk> list = DeprecatedUtils.getValidPythonSdks(allExistingSdks);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValidPythonSdks(...)");
        List<Sdk> existingSdks = list;
        CompletableFuture<List<String>> interpreterVersions = new CompletableFuture<List<String>>();
        ApplicationManager.getApplication().executeOnPooledThread(() -> PythonLessonsUtil.prepareFeedbackDataForOnboardingLesson$lambda$5(existingSdks, interpreterVersions));
        Object object = PySdkExtKt.getPythonSdk(project);
        if (object == null || (object = object.getVersionString()) == null) {
            object = "none";
        }
        String startInterpreter = Intrinsics.areEqual((Object)usedInterpreterAtStart, (Object)(usedInterpreter = object)) ? "same" : usedInterpreterAtStart;
        primaryLanguage.setOnboardingFeedbackData(new OnboardingFeedbackData(feedbackReportId, reportTitle, lessonEndInfo, interpreterVersions, (String)usedInterpreter, startInterpreter, configPropertyName){
            private final String feedbackReportId;
            private final int additionalFeedbackFormatVersion;
            private final Lazy interpreters$delegate;
            private final Function1<JsonObjectBuilder, Unit> addAdditionalSystemData;
            private final Function1<Panel, Unit> addRowsForUserAgreement;
            final /* synthetic */ String $configPropertyName;
            {
                this.$configPropertyName = $configPropertyName;
                super($reportTitle, $lessonEndInfo);
                this.feedbackReportId = $feedbackReportId;
                this.additionalFeedbackFormatVersion = 1;
                this.interpreters$delegate = LazyKt.lazy(() -> prepareFeedbackDataForOnboardingLesson.2.interpreters_delegate$lambda$0($interpreterVersions));
                this.addAdditionalSystemData = arg_0 -> prepareFeedbackDataForOnboardingLesson.2.addAdditionalSystemData$lambda$2($usedInterpreter, $startInterpreter, this, arg_0);
                this.addRowsForUserAgreement = arg_0 -> prepareFeedbackDataForOnboardingLesson.2.addRowsForUserAgreement$lambda$6(this, $usedInterpreter, $startInterpreter, arg_0);
            }

            public String getFeedbackReportId() {
                return this.feedbackReportId;
            }

            public int getAdditionalFeedbackFormatVersion() {
                return this.additionalFeedbackFormatVersion;
            }

            public final List<String> getInterpreters() {
                Lazy lazy = this.interpreters$delegate;
                return (List)lazy.getValue();
            }

            public Function1<JsonObjectBuilder, Unit> getAddAdditionalSystemData() {
                return this.addAdditionalSystemData;
            }

            public Function1<Panel, Unit> getAddRowsForUserAgreement() {
                return this.addRowsForUserAgreement;
            }

            public void feedbackHasBeenProposed() {
                PropertiesComponent.getInstance().setValue(this.$configPropertyName, true, false);
            }

            private static final List interpreters_delegate$lambda$0(CompletableFuture $interpreterVersions) {
                return $interpreterVersions.isDone() ? (List)$interpreterVersions.get() : null;
            }

            /*
             * WARNING - void declaration
             */
            private static final Unit addAdditionalSystemData$lambda$2(String $usedInterpreter, String $startInterpreter, prepareFeedbackDataForOnboardingLesson.2 this$0, JsonObjectBuilder jsonObjectBuilder) {
                JsonArrayBuilder builder$iv;
                Intrinsics.checkNotNullParameter((Object)jsonObjectBuilder, (String)"<this>");
                JsonElementBuildersKt.put((JsonObjectBuilder)jsonObjectBuilder, (String)"current_interpreter", (String)$usedInterpreter);
                JsonElementBuildersKt.put((JsonObjectBuilder)jsonObjectBuilder, (String)"start_interpreter", (String)$startInterpreter);
                boolean $i$f$buildJsonArray = false;
                JsonArrayBuilder jsonArrayBuilder = builder$iv = new JsonArrayBuilder();
                String string = "found_interpreters";
                JsonObjectBuilder jsonObjectBuilder2 = jsonObjectBuilder;
                boolean bl = false;
                List list = this$0.getInterpreters();
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                for (String i : list) {
                    void $this$addAdditionalSystemData_u24lambda_u242_u24lambda_u241;
                    $this$addAdditionalSystemData_u24lambda_u242_u24lambda_u241.add((JsonElement)JsonElementKt.JsonPrimitive((String)i));
                }
                Unit unit = Unit.INSTANCE;
                jsonObjectBuilder2.put(string, (JsonElement)builder$iv.build());
                return Unit.INSTANCE;
            }

            private static final Unit addRowsForUserAgreement$lambda$6$lambda$3(prepareFeedbackDataForOnboardingLesson.2 this$0, Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                List<String> list = this$0.getInterpreters();
                String interpreters = list != null ? list.toString() : null;
                String string = interpreters;
                if (string == null) {
                    string = PythonLessonsBundle.INSTANCE.message("python.onboarding.feedback.system.no.interpreters", new Object[0]);
                }
                $this$row.label(string);
                return Unit.INSTANCE;
            }

            private static final Unit addRowsForUserAgreement$lambda$6$lambda$4(String $usedInterpreter, Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                $this$row.label($usedInterpreter);
                return Unit.INSTANCE;
            }

            private static final Unit addRowsForUserAgreement$lambda$6$lambda$5(String $startInterpreter, Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                $this$row.label($startInterpreter);
                return Unit.INSTANCE;
            }

            private static final Unit addRowsForUserAgreement$lambda$6(prepareFeedbackDataForOnboardingLesson.2 this$0, String $usedInterpreter, String $startInterpreter, Panel panel2) {
                Intrinsics.checkNotNullParameter((Object)panel2, (String)"<this>");
                panel2.row(PythonLessonsBundle.INSTANCE.message("python.onboarding.feedback.system.found.interpreters", new Object[0]), arg_0 -> prepareFeedbackDataForOnboardingLesson.2.addRowsForUserAgreement$lambda$6$lambda$3(this$0, arg_0));
                panel2.row(PythonLessonsBundle.INSTANCE.message("python.onboarding.feedback.system.used.interpreter", new Object[0]), arg_0 -> prepareFeedbackDataForOnboardingLesson.2.addRowsForUserAgreement$lambda$6$lambda$4($usedInterpreter, arg_0));
                panel2.row(PythonLessonsBundle.INSTANCE.message("python.onboarding.feedback.system.start.interpreter", new Object[0]), arg_0 -> prepareFeedbackDataForOnboardingLesson.2.addRowsForUserAgreement$lambda$6$lambda$5($startInterpreter, arg_0));
                return Unit.INSTANCE;
            }
        });
    }

    private static final Unit showWarningIfPython3NotFound$lambda$3$lambda$0(TaskContext $this_task) {
        PyInterpreterInspection.InterpreterSettingsQuickFix.showPythonInterpreterSettings($this_task.getProject(), (Module)ArraysKt.first((Object[])PyStatisticToolsKt.getModules($this_task.getProject())));
        return Unit.INSTANCE;
    }

    private static final boolean showWarningIfPython3NotFound$lambda$3$lambda$1(TaskRuntimeContext $this$stateCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        return INSTANCE.isPython3Installed($this$stateCheck.getProject());
    }

    private static final boolean showWarningIfPython3NotFound$lambda$3$lambda$2(TaskRuntimeContext $this$showWarning) {
        Intrinsics.checkNotNullParameter((Object)$this$showWarning, (String)"$this$showWarning");
        return !INSTANCE.isPython3Installed($this$showWarning.getProject());
    }

    private static final Unit showWarningIfPython3NotFound$lambda$3(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        String callbackId = LearningUiManager.INSTANCE.addCallback(() -> PythonLessonsUtil.showWarningIfPython3NotFound$lambda$3$lambda$0($this$task));
        $this$task.stateCheck(PythonLessonsUtil::showWarningIfPython3NotFound$lambda$3$lambda$1);
        Object[] objectArray = new Object[]{callbackId};
        TaskContext.showWarning$default((TaskContext)$this$task, (String)PythonLessonsBundle.INSTANCE.message("python.3.required.warning.message", objectArray), (boolean)false, null, PythonLessonsUtil::showWarningIfPython3NotFound$lambda$3$lambda$2, (int)6, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final void prepareFeedbackDataForOnboardingLesson$lambda$5(List $existingSdks, CompletableFuture $interpreterVersions) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        UserDataHolderBase context = new UserDataHolderBase();
        List<Sdk> baseSdks = PySdkExtKt.findBaseSdks($existingSdks, null, (UserDataHolder)context);
        Iterable iterable = baseSdks;
        CompletableFuture completableFuture = $interpreterVersions;
        boolean $i$f$mapNotNull = false;
        void var6_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Sdk it = (Sdk)element$iv$iv;
            boolean bl2 = false;
            if (it.getSdkType().getVersionString(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        completableFuture.complete(CollectionsKt.distinct((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv))));
    }
}

