/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;

public class HgBranchesCommand {
    private static final Pattern BRANCH_LINE = Pattern.compile("(.+)\\s([0-9]+):([0-9a-f]+).*");
    private static final int NAME_INDEX = 1;
    private final Project project;
    private final VirtualFile repo;

    public HgBranchesCommand(Project project, @NotNull VirtualFile repo) {
        if (repo == null) {
            HgBranchesCommand.$$$reportNull$$$0(0);
        }
        this.project = project;
        this.repo = repo;
    }

    @Nullable
    public HgCommandResult collectBranches() {
        return new HgCommandExecutor(this.project).executeInCurrentThread(this.repo, "branches", null);
    }

    @NotNull
    public static Set<String> collectNames(@NotNull HgCommandResult result) {
        if (result == null) {
            HgBranchesCommand.$$$reportNull$$$0(1);
        }
        TreeSet<String> branches = new TreeSet<String>();
        for (String line : result.getOutputLines()) {
            Matcher matcher = BRANCH_LINE.matcher(line);
            if (!matcher.matches()) continue;
            branches.add(matcher.group(1).trim());
        }
        TreeSet<String> treeSet = branches;
        if (treeSet == null) {
            HgBranchesCommand.$$$reportNull$$$0(2);
        }
        return treeSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/command/HgBranchesCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/command/HgBranchesCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectNames";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

