/*
 * Copyright (C) 1998 Francois Gouget
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __WINE_TCHAR_H
#define __WINE_TCHAR_H

#ifdef __WINESRC__
#error Wine should not include tchar.h internally
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*****************************************************************************
 * tchar routines
 */
#define _strdec(start,current)  ((start)<(current) ? ((char*)(current))-1 : NULL)
#define _strinc(current)        (((char*)(current))+1)
#define _strncnt(str,max)       (__strncnt(str,max))
#define _strnextc(str)          ((unsigned int)*(str))
#define _strninc(str,n)         (((char*)(str))+(n))
#define _strspnp(s1,s2)         (*((s1)+strspn((s1),(s2))) ? (s1)+strspn((s1),(s2)) : NULL)

#define _wcsdec(start,current)  ((start)<(current) ? (current)-1 : NULL)
#define _wcsinc(current)        ((current)+1)
#define _wcsncnt(str,max)       (__wcsncnt(str,max))
#define _wcsnextc(str)          ((unsigned int)*(str))
#define _wcsninc(str,n)         ((str)+(n))
#define _wcsspnp(s1,s2)         (*((s1)+wcsspn((s1),(s2))) ? (s1)+wcsspn((s1),(s2)) : NULL)


/*****************************************************************************
 * tchar mappings
 */
#ifndef _UNICODE
#  ifndef _MBCS
#    include <string.h>
#    define WINE_tchar_routine(std,mbcs,unicode) std
#  else
#    include <mbstring.h>
#    define WINE_tchar_routine(std,mbcs,unicode) mbcs
#  endif
#else /* _UNICODE */
#  include <wchar.h>
#  define WINE_tchar_routine(std,mbcs,unicode) unicode
#endif

#define WINE_tchar_true(a) (1)
#define WINE_tchar_false(a) (0)
#define WINE_tchar_tclen(a) (1)
#define WINE_tchar_tccpy(a,b) do { *(a)=*(b); } while (0)

#define __targv       WINE_tchar_routine(__argv,          __argv,      __wargv)
#define __tcserror    WINE_tchar_routine(_strerror,       _strerror,   __wcserror)
#define __tcserror_s  WINE_tchar_routine(_strerror_s,     _strerror_s, __wcserror_s)
#define _cgetts_s     WINE_tchar_routine(_cgets_s,        _cgets_s,    _cgetws_s)
#define _cputts       WINE_tchar_routine(_cputs,          _cputs,      _cputws)
#define _fgettc       WINE_tchar_routine(fgetc,           fgetc,       fgetwc)
#define _fgettc_nolock WINE_tchar_routine(_fgetc_nolock,  _fgetc_nolock,_fgetwc_nolock)
#define _fgettchar    WINE_tchar_routine(fgetchar,        fgetchar,    _fgetwchar)
#define _fgetts       WINE_tchar_routine(fgets,           fgets,       fgetws)
#define _fputtc       WINE_tchar_routine(fputc,           fputc,       fputwc)
#define _fputtc_nolock WINE_tchar_routine(_fputc_nolock,  _fputc_nolock,_fputwc_nolock)
#define _fputtchar    WINE_tchar_routine(fputchar,        fputchar,    _fputwchar)
#define _fputts       WINE_tchar_routine(fputs,           fputs,       fputws)
#define _ftprintf     WINE_tchar_routine(fprintf,         fprintf,     fwprintf)
#define _ftprintf_l   WINE_tchar_routine(_fprintf_l,      _fprintf_l,  _fwprintf_l)
#define _ftprintf_p   WINE_tchar_routine(_fprintf_p,      _fprintf_p,  _fwprintf_p)
#define _ftprintf_p_l WINE_tchar_routine(_fprintf_p_l,    _fprintf_p_l,_fwprintf_p_l)
#define _ftprintf_s   WINE_tchar_routine(fprintf_s,       fprintf_s,   fwprintf_s)
#define _ftprintf_s_l WINE_tchar_routine(_fprintf_s_l,    _fprintf_s_l,_fwprintf_s_l)
#define _ftscanf      WINE_tchar_routine(fscanf,          fscanf,      fwscanf)
#define _ftscanf_l    WINE_tchar_routine(_fscanf_l,       _fscanf_l,   _fwscanf_l)
#define _ftscanf_s    WINE_tchar_routine(fscanf_s,        fscanf_s,    fwscanf_s)
#define _ftscanf_s_l  WINE_tchar_routine(_fscanf_s_l,     _fscanf_s_l, _fwscanf_s_l)
#define _get_tpgmptr  WINE_tchar_routine(_get_pgmptr,     _get_pgmptr, _get_wpgmptr)
#define _gettc        WINE_tchar_routine(getc,            getc,        getwc)
#define _gettc_nolock WINE_tchar_routine(_getc_nolock,    _getc_nolock,_getwc_nolock)
#define _gettch       WINE_tchar_routine(_getch,          _getch,      _getwch)
#define _gettch_nolock WINE_tchar_routine(_getch_nolock,  _getch_nolock,_getwch_nolock)
#define _gettchar     WINE_tchar_routine(getchar,         getchar,     getwchar)
#define _gettchar_nolock WINE_tchar_routine(_getchar_nolock,_getchar_nolock,_getwchar_nolock)
#define _gettche      WINE_tchar_routine(_getche,         _getche,     _getwche)
#define _gettche_nolock WINE_tchar_routine(_getche_nolock,_getche_nolock,_getwche_nolock)
#define _getts        WINE_tchar_routine(gets,            gets,        getws)
#define _getts_s      WINE_tchar_routine(gets_s,          gets_s,      _getws_s)
#define _i64tot       WINE_tchar_routine(_i64toa,         _i64toa,     _i64tow)
#define _i64tot_s     WINE_tchar_routine(_i64toa_s,       _i64toa_s,   _i64tow_s)
#define _istalnum     WINE_tchar_routine(isalnum,         _ismbcalnum, iswalnum)
#define _istalnum_l   WINE_tchar_routine(_isalnum_l,      _ismbcalnum_l,_iswalnum_l)
#define _istalpha     WINE_tchar_routine(isalpha,         _ismbcalpha, iswalpha)
#define _istalpha_l   WINE_tchar_routine(_isalpha_l,      _ismbcalpha_l,_iswalpha_l)
#define _istascii     WINE_tchar_routine(isascii,         __isascii,   iswascii)
#define _istblank     WINE_tchar_routine(isblank,         _ismbcblank, iswblank)
#define _istblank_l   WINE_tchar_routine(_isblank_l,      _ismbcblank_l,_iswblank_l)
#define _istcntrl     WINE_tchar_routine(iscntrl,         iscntrl,     iswcntrl)
#define _istcntrl_l   WINE_tchar_routine(_iscntrl_l,      _iscntrl_l,  _iswcntrl_l)
#define _istdigit     WINE_tchar_routine(isdigit,         _ismbcdigit, iswdigit)
#define _istdigit_l   WINE_tchar_routine(_isdigit_l,      _ismbcdigit_l,_iswdigit_l)
#define _istgraph     WINE_tchar_routine(isgraph,         _ismbcgraph, iswgraph)
#define _istgraph_l   WINE_tchar_routine(_isgraph_l,      _ismbcgraph_l,_iswgraph_l)
#define _istlead      WINE_tchar_routine(WINE_tchar_false,_ismbblead,  WINE_tchar_false)
#define _istleadbyte  WINE_tchar_routine(WINE_tchar_false,isleadbyte,  WINE_tchar_false)
#define _istlegal     WINE_tchar_routine(WINE_tchar_true, _ismbclegal, WINE_tchar_true)
#define _istlower     WINE_tchar_routine(islower,         _ismbclower, iswlower)
#define _istlower_l   WINE_tchar_routine(_islower_l,      _ismbclower_l,_iswlower_l)
#define _istprint     WINE_tchar_routine(isprint,         _ismbcprint, iswprint)
#define _istprint_l   WINE_tchar_routine(_isprint_l,      _ismbcprint_l,_iswprint_l)
#define _istpunct     WINE_tchar_routine(ispunct,         _ismbcpunct, iswpunct)
#define _istpunct_l   WINE_tchar_routine(_ispunct_l,      _ismbcpunct_l,_iswpunct_l)
#define _istspace     WINE_tchar_routine(isspace,         _ismbcspace, iswspace)
#define _istspace_l   WINE_tchar_routine(_isspace_l,      _ismbcspace_l,_iswspace_l)
#define _istupper     WINE_tchar_routine(isupper,         _ismbcupper, iswupper)
#define _istupper_l   WINE_tchar_routine(_isupper_l,      _ismbcupper_l,_iswupper_l)
#define _istxdigit    WINE_tchar_routine(isxdigit,        isxdigit,    iswxdigit)
#define _istxdigit_l  WINE_tchar_routine(_isxdigit_l,     _isxdigit_l, _iswxdigit_l)
#define _itot         WINE_tchar_routine(_itoa,           _itoa,       _itow)
#define _itot_s       WINE_tchar_routine(_itoa_s,         _itoa_s,     _itow_s)
#define _ltot         WINE_tchar_routine(_ltoa,           _ltoa,       _ltow)
#define _ltot_s       WINE_tchar_routine(_ltoa_s,         _ltoa_s,     _ltow_s)
#define _puttc        WINE_tchar_routine(putc,            putc,        putwc)
#define _puttc_nolock WINE_tchar_routine(_fputc_nolock,   _fputc_nolock,_fputwc_nolock)
#define _puttch       WINE_tchar_routine(_putch,          _putch,      _putwch)
#define _puttch_nolock WINE_tchar_routine(_putch_nolock,   _putch_nolock,_putwch_nolock)
#define _puttchar     WINE_tchar_routine(putchar,         putchar,     putwchar)
#define _puttchar_nolock WINE_tchar_routine(_putchar_nolock,_putchar_nolock,_putwchar_nolock)
#define _putts        WINE_tchar_routine(puts,            puts,        _putws)
#define _sctprintf    WINE_tchar_routine(_scprintf,       _scprintf,   _scwprintf)
#define _sctprintf_l  WINE_tchar_routine(_scprintf_l,     _scprintf_l, _scwprintf_l)
#define _sctprintf_p  WINE_tchar_routine(_scprintf_p,     _scprintf_p, _scwprintf_p)
#define _sctprintf_p_l WINE_tchar_routine(_scprintf_p_l,   _scprintf_p_l,_scwprintf_p_l)
#define _sntprintf    WINE_tchar_routine(snprintf,        snprintf,    _snwprintf)
#define _sntprintf_l  WINE_tchar_routine(_snprintf_l,     _snprintf_l, _snwprintf_l)
#define _sntprintf_s  WINE_tchar_routine(_snprintf_s,     _snprintf_s, _snwprintf_s)
#define _sntprintf_s_l WINE_tchar_routine(_snprintf_s_l,   _snprintf_s_l,_snwprintf_s_l)
#define _sntscanf     WINE_tchar_routine(_snscanf,        _snscanf,    _snwscanf)
#define _sntscanf_l   WINE_tchar_routine(_snscanf_l,      _snscanf_l,  _snwscanf_l)
#define _sntscanf_s   WINE_tchar_routine(_snscanf_s,      _snscanf_s,  _snwscanf_s)
#define _sntscanf_s_l WINE_tchar_routine(_snscanf_s_l,    _snscanf_s_l,_snwscanf_s_l)
#define _stprintf     WINE_tchar_routine(sprintf,         sprintf,     swprintf)
#define _stprintf_l   WINE_tchar_routine(_sprintf_l,      _sprintf_l,  __swprintf_l)
#define _stprintf_p   WINE_tchar_routine(_sprintf_p,      _sprintf_p,  _swprintf_p)
#define _stprintf_p_l WINE_tchar_routine(_sprintf_p_l,    _sprintf_p_l,_swprintf_p_l)
#define _stprintf_s   WINE_tchar_routine(sprintf_s,       sprintf_s,   swprintf_s)
#define _stprintf_s_l WINE_tchar_routine(_sprintf_s_l,    _sprintf_s_l,_swprintf_s_l)
#define _stscanf      WINE_tchar_routine(sscanf,          sscanf,      swscanf)
#define _stscanf_l    WINE_tchar_routine(_sscanf_l,       _sscanf_l,   _swscanf_l)
#define _stscanf_s    WINE_tchar_routine(sscanf_s,        sscanf_s,    swscanf_s)
#define _stscanf_s_l  WINE_tchar_routine(_sscanf_s_l,     _sscanf_s_l, _swscanf_s_l)
#define _taccess      WINE_tchar_routine(access,          _access,     _waccess)
#define _taccess_s    WINE_tchar_routine(_access_s,       _access_s,   _waccess_s)
#define _tasctime     WINE_tchar_routine(asctime,         asctime,     _wasctime)
#define _tasctime_s   WINE_tchar_routine(asctime_s,       asctime_s,   _wasctime_s)
#define _tccpy        WINE_tchar_routine(WINE_tchar_tccpy,_mbccpy,     WINE_tchar_tccpy)
#define _tchdir       WINE_tchar_routine(chdir,           _chdir,      _wchdir)
#define _tchmod       WINE_tchar_routine(chmod,           _chmod,      _wchmod)
#define _tclen        WINE_tchar_routine(WINE_tchar_tclen,_mbclen,     WINE_tchar_tclen)
#define _tcprintf     WINE_tchar_routine(_cprintf,        _cprintf,    _cwprintf)
#define _tcprintf_l   WINE_tchar_routine(_cprintf_l,      _cprintf_l,  _cwprintf_l)
#define _tcprintf_p   WINE_tchar_routine(_cprintf_p,      _cprintf_p,  _cwprintf_p)
#define _tcprintf_p_l WINE_tchar_routine(_cprintf_p_l,    _cprintf_p_l,_cwprintf_p_l)
#define _tcprintf_s   WINE_tchar_routine(_cprintf_s,      _cprintf_s,  _cwprintf_s)
#define _tcprintf_s_l WINE_tchar_routine(_cprintf_s_l,    _cprintf_s_l,_cwprintf_s_l)
#define _tcreat       WINE_tchar_routine(creat,           _creat,      _wcreat)
#define _tcscanf      WINE_tchar_routine(_cscanf,         _cscanf,     _cwscanf)
#define _tcscanf_l    WINE_tchar_routine(_cscanf_l,       _cscanf_l,   _cwscanf_l)
#define _tcscanf_s    WINE_tchar_routine(_cscanf_s,       _cscanf_s,   _cwscanf_s)
#define _tcscanf_s_l  WINE_tchar_routine(_cscanf_s_l,     _cscanf_s_l, _cwscanf_s_l)
#define _tcscat       WINE_tchar_routine(strcat,          strcat,      wcscat)
#define _tcscat_s     WINE_tchar_routine(strcat_s,        strcat_s,    wcscat_s)
#define _tcschr       WINE_tchar_routine(strchr,          _mbschr,     wcschr)
#define _tcsclen      WINE_tchar_routine(strlen,          _mbslen,     wcslen)
#define _tcscmp       WINE_tchar_routine(strcmp,          _mbscmp,     wcscmp)
#define _tcscnlen     WINE_tchar_routine(strnlen,         _mbsnlen,    wcsnlen)
#define _tcscoll      WINE_tchar_routine(strcoll,         _mbscoll,    wcscoll)
#define _tcscoll_l    WINE_tchar_routine(_strcoll_l,      _mbscoll_l,  _wcscoll_l)
#define _tcscpy       WINE_tchar_routine(strcpy,          _mbscpy,     wcscpy)
#define _tcscpy_s     WINE_tchar_routine(strcpy_s,        _mbscpy_s,   wcscpy_s)
#define _tcscspn      WINE_tchar_routine(strcspn,         _mbscspn,    wcscspn)
#define _tcsdec       WINE_tchar_routine(_strdec,         _mbsdec,     _wcsdec)
#define _tcsdup       WINE_tchar_routine(strdup,          _mbsdup,     _wcsdup)
#define _tcserror     WINE_tchar_routine(strerror,        strerror,    _wcserror)
#define _tcserror_s   WINE_tchar_routine(strerror_s,      strerror_s,  _wcserror_s)
#define _tcsftime     WINE_tchar_routine(strftime,        strftime,    wcsftime)
#define _tcsftime_l   WINE_tchar_routine(_strftime_l,     _strftime_l, _wcsftime_l)
#define _tcsicmp      WINE_tchar_routine(_stricmp,        _mbsicmp,    _wcsicmp)
#define _tcsicmp_l    WINE_tchar_routine(_stricmp_l,      _mbsicmp_l,  _wcsicmp_l)
#define _tcsicoll     WINE_tchar_routine(_stricoll,       _mbsicoll,   _wcsicoll)
#define _tcsicoll_l   WINE_tchar_routine(_stricoll_l,     _mbsicoll_l, _wcsicoll_l)
#define _tcsinc       WINE_tchar_routine(_strinc,         _mbsinc,     _wcsinc)
#define _tcslen       WINE_tchar_routine(strlen,          strlen,      wcslen)
#define _tcslwr       WINE_tchar_routine(_strlwr,         _mbslwr,     _wcslwr)
#define _tcslwr_l     WINE_tchar_routine(_strlwr_l,       _mbslwr_l,   _wcslwr_l)
#define _tcslwr_s     WINE_tchar_routine(_strlwr_s,       _mbslwr_s,   _wcslwr_s)
#define _tcslwr_s_l   WINE_tchar_routine(_strlwr_s_l,     _mbslwr_s_l, _wcslwr_s_l)
#define _tcsnbcnt     WINE_tchar_routine(_strncnt,        _mbsnbcnt,   _wcsncnt)
#define _tcsncat      WINE_tchar_routine(strncat,         _mbsnbcat,   wcsncat)
#define _tcsncat_l    WINE_tchar_routine(_strncat_l,      _mbsnbcat_l, _wcsncat_l)
#define _tcsncat_s    WINE_tchar_routine(strncat_s,       _mbsnbcat_s, wcsncat_s)
#define _tcsncat_s_l  WINE_tchar_routine(_strncat_s_l,    _mbsnbcat_s_l,_wcsncat_s_l)
#define _tcsnccat     WINE_tchar_routine(strncat,         _mbsncat,    wcsncat)
#define _tcsnccat_l   WINE_tchar_routine(_strncat_l,      _mbsncat_l,  _wcsncat_l)
#define _tcsnccat_s   WINE_tchar_routine(strncat_s,       _mbsncat_s,  wcsncat_s)
#define _tcsnccat_s_l WINE_tchar_routine(_strncat_s_l,    _mbsncat_s_l,_wcsncat_s_l)
#define _tcsnccmp     WINE_tchar_routine(strncmp,         _mbsncmp,    wcsncmp)
#define _tcsnccnt     WINE_tchar_routine(_strncnt,        _mbsnccnt,   _wcsncnt)
#define _tcsnccoll    WINE_tchar_routine(_strncoll,       _mbsncoll,   _wcsncoll)
#define _tcsnccoll_l  WINE_tchar_routine(_strncoll_l,     _mbsncoll_l, _wcsncoll_l)
#define _tcsnccpy     WINE_tchar_routine(strncpy,         _mbsncpy,    wcsncpy)
#define _tcsnccpy_l   WINE_tchar_routine(_strncpy_l,      _mbsncpy_l,  _wcsncpy_l)
#define _tcsnccpy_s   WINE_tchar_routine(strncpy_s,       _mbsncpy_s,  wcsncpy_s)
#define _tcsnccpy_s_l WINE_tchar_routine(_strncpy_s_l,    _mbsncpy_s_l,_wcsncpy_s_l)
#define _tcsncicmp    WINE_tchar_routine(_strnicmp,       _mbsnicmp,   _wcsnicmp)
#define _tcsncicmp_l  WINE_tchar_routine(_strnicmp_l,     _mbsnicmp_l, _wcsnicmp_l)
#define _tcsncicoll   WINE_tchar_routine(_strnicoll,      _mbsnicoll,  _wcsnicoll)
#define _tcsncicoll_l WINE_tchar_routine(_strnicoll_l,    _mbsnicoll_l,_wcsnicoll_l)
#define _tcsncmp      WINE_tchar_routine(strncmp,         _mbsnbcmp,   wcsncmp)
#define _tcsncoll     WINE_tchar_routine(_strncoll,       _mbsnbcoll,  _wcsncoll)
#define _tcsncoll_l   WINE_tchar_routine(_strncoll_l,     _mbsnbcoll_l,_wcsncoll_l)
#define _tcsncpy      WINE_tchar_routine(strncpy,         _mbsnbcpy,   wcsncpy)
#define _tcsncpy_l    WINE_tchar_routine(_strncpy_l,      _mbsnbcpy_l, _wcsncpy_l)
#define _tcsncpy_s    WINE_tchar_routine(strncpy_s,       _mbsnbcpy_s, wcsncpy_s)
#define _tcsncpy_s_l  WINE_tchar_routine(_strncpy_s_l,    _mbsnbcpy_s_l,_wcsncpy_s_l)
#define _tcsncset     WINE_tchar_routine(_strnset,        _mbsnset,    _wcsnset)
#define _tcsncset_l   WINE_tchar_routine(_strnset_l,      _mbsnset_l,  _wcsnset_l)
#define _tcsncset_s   WINE_tchar_routine(_strnset_s,      _mbsnset_s,  _wcsnset_s)
#define _tcsncset_s_l WINE_tchar_routine(_strnset_s_l,    _mbsnset_s_l,_wcsnset_s_l)
#define _tcsnextc     WINE_tchar_routine(_strnextc,       _mbsnextc,   _wcsnextc)
#define _tcsnicmp     WINE_tchar_routine(_strnicmp,       _mbsnbicmp,  _wcsnicmp)
#define _tcsnicmp_l   WINE_tchar_routine(_strnicmp_l,     _mbsnbicmp_l,_wcsnicmp_l)
#define _tcsnicoll    WINE_tchar_routine(_strnicoll,      _mbsnbicoll, _wcsnicoll)
#define _tcsnicoll_l  WINE_tchar_routine(_strnicoll_l,    _mbsnbicoll_l,_wcsnicoll_l)
#define _tcsninc      WINE_tchar_routine(_strninc,        _mbsninc,    _wcsninc)
#define _tcsnlen      WINE_tchar_routine(strnlen,         strnlen,     wcsnlen)
#define _tcsnset      WINE_tchar_routine(_strnset,        _mbsnbset,   _wcsnset)
#define _tcsnset_l    WINE_tchar_routine(_strnset_l,      _mbsnbset_l, _wcsnset_l)
#define _tcsnset_s    WINE_tchar_routine(_strnset_s,      _mbsnbset_s, _wcsnset_s)
#define _tcsnset_s_l  WINE_tchar_routine(_strnset_s_l,    _mbsnbset_s_l,_wcsnset_s_l)
#define _tcspbrk      WINE_tchar_routine(strpbrk,         _mbspbrk,    wcspbrk)
#define _tcsrchr      WINE_tchar_routine(strrchr,         _mbsrchr,    wcsrchr)
#define _tcsrev       WINE_tchar_routine(_strrev,         _mbsrev,     _wcsrev)
#define _tcsset       WINE_tchar_routine(_strset,         _mbsset,     _wcsset)
#define _tcsset_l     WINE_tchar_routine(_strset_l,       _mbsset_l,   _wcsset_l)
#define _tcsset_s     WINE_tchar_routine(_strset_s,       _mbsset_s,   _wcsset_s)
#define _tcsset_s_l   WINE_tchar_routine(_strset_s_l,     _mbsset_s_l, _wcsset_s_l)
#define _tcsspn       WINE_tchar_routine(strspn,          _mbsspn,     wcsspn)
#define _tcsspnp      WINE_tchar_routine(_strspnp,        _mbsspnp,    _wcsspnp)
#define _tcsstr       WINE_tchar_routine(strstr,          _mbsstr,     wcsstr)
#define _tcstod       WINE_tchar_routine(strtod,          strtod,      wcstod)
#define _tcstod_l     WINE_tchar_routine(_strtod_l,       _strtod_l,   _wcstod_l)
#define _tcstof       WINE_tchar_routine(strtof,          strtof,      wcstof)
#define _tcstof_l     WINE_tchar_routine(_strtof_l,       _strtof_l,   _wcstof_l)
#define _tcstoi64     WINE_tchar_routine(_strtoi64,       _strtoi64,   _wcstoi64)
#define _tcstoi64_l   WINE_tchar_routine(_strtoi64_l,     _strtoi64_l, _wcstoi64_l)
#define _tcstoimax    WINE_tchar_routine(strtoimax,       strtoimax,   wcstoimax)
#define _tcstoimax_l  WINE_tchar_routine(_strtoimax_l,    _strtoimax_l,_wcstoimax_l)
#define _tcstok       WINE_tchar_routine(strtok,          _mbstok,     _wcstok)
#define _tcstok_l     WINE_tchar_routine(_strtok_l,       _mbstok_l,   _wcstok_l)
#define _tcstok_s     WINE_tchar_routine(strtok_s,        _mbstok_s,   wcstok_s)
#define _tcstok_s_l   WINE_tchar_routine(_strtok_s_l,     _mbstok_s_l, _wcstok_s_l)
#define _tcstol       WINE_tchar_routine(strtol,          strtol,      wcstol)
#define _tcstol_l     WINE_tchar_routine(_strtol_l,       _strtol_l,   _wcstol_l)
#define _tcstold      WINE_tchar_routine(strtold,         strtold,     wcstold)
#define _tcstold_l    WINE_tchar_routine(_strtold_l,      _strtold_l,  _wcstold_l)
#define _tcstoll      WINE_tchar_routine(strtoll,         strtoll,     wcstoll)
#define _tcstoll_l    WINE_tchar_routine(_strtoll_l,      _strtoll_l,  _wcstoll_l)
#define _tcstoui64    WINE_tchar_routine(_strtoui64,      _strtoui64,  _wcstoui64)
#define _tcstoui64_l  WINE_tchar_routine(_strtoui64_l,    _strtoui64_l,_wcstoui64_l)
#define _tcstoul      WINE_tchar_routine(strtoul,         strtoul,     wcstoul)
#define _tcstoul_l    WINE_tchar_routine(_strtoul_l,      _strtoul_l,  _wcstoul_l)
#define _tcstoull     WINE_tchar_routine(strtoull,        strtoull,    wcstoull)
#define _tcstoull_l   WINE_tchar_routine(_strtoull_l,     _strtoull_l, _wcstoull_l)
#define _tcstoumax    WINE_tchar_routine(strtoumax,       strtoumax,   wcstoumax)
#define _tcstoumax_l  WINE_tchar_routine(_strtoumax_l,    _strtoumax_l,_wcstoumax_l)
#define _tcsupr       WINE_tchar_routine(_strupr,         _mbsupr,     _wcsupr)
#define _tcsupr_l     WINE_tchar_routine(_strupr_l,       _mbsupr_l,   _wcsupr_l)
#define _tcsupr_s     WINE_tchar_routine(_strupr_s,       _mbsupr_s,   _wcsupr_s)
#define _tcsupr_s_l   WINE_tchar_routine(_strupr_s_l,     _mbsupr_s_l, _wcsupr_s_l)
#define _tcsxfrm      WINE_tchar_routine(strxfrm,         strxfrm,     wcsxfrm)
#define _tcsxfrm_l    WINE_tchar_routine(_strxfrm_l,      _strxfrm_l,  _wcsxfrm_l)
#define _tctime       WINE_tchar_routine(ctime,           ctime,       _wctime)
#define _tctime32     WINE_tchar_routine(_ctime32,        _ctime32,    _wctime32)
#define _tctime32_s   WINE_tchar_routine(_ctime32_s,      _ctime32_s,  _wctime32_s)
#define _tctime64     WINE_tchar_routine(_ctime64,        _ctime64,    _wctime64)
#define _tctime64_s   WINE_tchar_routine(_ctime64_s,      _ctime64_s,  _wctime64_s)
#define _tctime_s     WINE_tchar_routine(ctime_s,         ctime_s,     _wctime_s)
#define _tdupenv_s    WINE_tchar_routine(_dupenv_s,       _dupenv_s,   _wdupenv_s)
#define _tenviron     WINE_tchar_routine(_environ,        _environ,    _wenviron)
#define _texecl       WINE_tchar_routine(execl,           _execl,      _wexecl)
#define _texecle      WINE_tchar_routine(execle,          _execle,     _wexecle)
#define _texeclp      WINE_tchar_routine(execlp,          _execlp,     _wexeclp)
#define _texeclpe     WINE_tchar_routine(execlpe,         _execlpe,    _wexeclpe)
#define _texecv       WINE_tchar_routine(execv,           _execv,      _wexecv)
#define _texecve      WINE_tchar_routine(execve,          _execve,     _wexecve)
#define _texecvp      WINE_tchar_routine(execvp,          _execvp,     _wexecvp)
#define _texecvpe     WINE_tchar_routine(execvpe,         _execvpe,    _wexecvpe)
#define _tfdopen      WINE_tchar_routine(fdopen,          _fdopen,     _wfdopen)
#define _tfinddata_t  WINE_tchar_routine(_finddata_t,     _finddata_t, _wfinddata_t)
#define _tfinddatai64_t WINE_tchar_routine(_finddatai64_t,_finddatai64_t,_wfinddatai64_t)
#define _tfindfirst   WINE_tchar_routine(_findfirst,      _findfirst,  _wfindfirst)
#define _tfindfirst32 WINE_tchar_routine(_findfirst32,    _findfirst32,_wfindfirst32)
#define _tfindfirst32i64 WINE_tchar_routine(_findfirst32i64,_findfirst32i64,_wfindfirst32i64)
#define _tfindfirst64 WINE_tchar_routine(_findfirst64,    _findfirst64,_wfindfirst64)
#define _tfindfirst64i32 WINE_tchar_routine(_findfirst64i32,_findfirst64i32,_wfindfirst64i32)
#define _tfindfirsti64 WINE_tchar_routine(_findfirsti64,  _findfirsti64,_wfindfirsti64)
#define _tfindnext    WINE_tchar_routine(_findnext,       _findnext,   _wfindnext)
#define _tfindnext32  WINE_tchar_routine(_findnext32,     _findnext32, _wfindnext32)
#define _tfindnext32i64 WINE_tchar_routine(_findnext32i64,_findnext32i64,_wfindnext32i64)
#define _tfindnext64  WINE_tchar_routine(_findnext64,     _findnext64, _wfindnext64)
#define _tfindnext64i32 WINE_tchar_routine(_findnext64i32,_findnext64i32,_wfindnext64i32)
#define _tfindnexti64 WINE_tchar_routine(_findnexti64,    _findnexti64,_wfindnexti64)
#define _tfopen       WINE_tchar_routine(fopen,           fopen,       _wfopen)
#define _tfopen_s     WINE_tchar_routine(fopen_s,         fopen_s,     _wfopen_s)
#define _tfreopen     WINE_tchar_routine(freopen,         freopen,     _wfreopen)
#define _tfreopen_s   WINE_tchar_routine(freopen_s,       freopen_s,   _wfreopen_s)
#define _tfsopen      WINE_tchar_routine(_fsopen,         _fsopen,     _wfsopen)
#define _tfullpath    WINE_tchar_routine(_fullpath,       _fullpath,   _wfullpath)
#define _tgetcwd      WINE_tchar_routine(getcwd,          _getcwd,     _wgetcwd)
#define _tgetdcwd     WINE_tchar_routine(_getdcwd,        _getdcwd,    _wgetdcwd)
#define _tgetdcwd_nolock WINE_tchar_routine(_getdcwd_nolock,_getdcwd_nolock,_wgetdcwd_nolock)
#define _tgetenv      WINE_tchar_routine(getenv,          getenv,      _wgetenv)
#define _tgetenv_s    WINE_tchar_routine(getenv_s,        getenv_s,    _wgetenv_s)
#define _tmain        WINE_tchar_routine(main,            main,        wmain)
#define _tmakepath    WINE_tchar_routine(_makepath,       _makepath,   _wmakepath)
#define _tmakepath_s  WINE_tchar_routine(_makepath_s,     _makepath_s, _wmakepath_s)
#define _tmkdir       WINE_tchar_routine(mkdir,           _mkdir,      _wmkdir)
#define _tmktemp      WINE_tchar_routine(mktemp,          _mktemp,     _wmktemp)
#define _tmktemp_s    WINE_tchar_routine(_mktemp_s,       _mktemp_s,   _wmktemp_s)
#define _topen        WINE_tchar_routine(open,            _open,       _wopen)
#define _totlower     WINE_tchar_routine(tolower,         _mbctolower, towlower)
#define _totlower_l   WINE_tchar_routine(_tolower_l,      _mbctolower_l,_towlower_l)
#define _totupper     WINE_tchar_routine(toupper,         _mbctoupper, towupper)
#define _totupper_l   WINE_tchar_routine(_toupper_l,      _mbctoupper_l,_towupper_l)
#define _tperror      WINE_tchar_routine(perror,          perror,      _wperror)
#define _tpgmptr      WINE_tchar_routine(_pgmptr,         _pgmptr,     _wpgmptr)
#define _tpopen       WINE_tchar_routine(popen,           _popen,      _wpopen)
#define _tprintf      WINE_tchar_routine(printf,          printf,      wprintf)
#define _tprintf_l    WINE_tchar_routine(_printf_l,       _printf_l,   _wprintf_l)
#define _tprintf_p    WINE_tchar_routine(_printf_p,       _printf_p,   _wprintf_p)
#define _tprintf_p_l  WINE_tchar_routine(_printf_p_l,     _printf_p_l, _wprintf_p_l)
#define _tprintf_s    WINE_tchar_routine(printf_s,        printf_s,    wprintf_s)
#define _tprintf_s_l  WINE_tchar_routine(_printf_s_l,     _printf_s_l, _wprintf_s_l)
#define _tputenv      WINE_tchar_routine(_putenv,         _putenv,     _wputenv)
#define _tputenv_s    WINE_tchar_routine(_putenv_s,       _putenv_s,   _wputenv_s)
#define _tremove      WINE_tchar_routine(remove,          remove,      _wremove)
#define _trename      WINE_tchar_routine(rename,          rename,      _wrename)
#define _trmdir       WINE_tchar_routine(rmdir,           _rmdir,      _wrmdir)
#define _tscanf       WINE_tchar_routine(scanf,           scanf,       wscanf)
#define _tscanf_l     WINE_tchar_routine(_scanf_l,        _scanf_l,    _wscanf_l)
#define _tscanf_s     WINE_tchar_routine(scanf_s,         scanf_s,     wscanf_s)
#define _tscanf_s_l   WINE_tchar_routine(_scanf_s_l,      _scanf_s_l,  _wscanf_s_l)
#define _tsearchenv   WINE_tchar_routine(_searchenv,      _searchenv,  _wsearchenv)
#define _tsearchenv_s WINE_tchar_routine(_searchenv_s,    _searchenv_s,_wsearchenv_s)
#define _tsetlocale   WINE_tchar_routine(setlocale,       setlocale,   _wsetlocale)
#define _tsopen       WINE_tchar_routine(_sopen,          _sopen,      _wsopen)
#define _tsopen_s     WINE_tchar_routine(_sopen_s,        _sopen_s,    _wsopen_s)
#define _tspawnl      WINE_tchar_routine(_spawnl,         _spawnl,     _wspawnl)
#define _tspawnle     WINE_tchar_routine(_spawnle,        _spawnle,    _wspawnle)
#define _tspawnlp     WINE_tchar_routine(_spawnlp,        _spawnlp,    _wspawnlp)
#define _tspawnlpe    WINE_tchar_routine(_spawnlpe,       _spawnlpe,   _wspawnlpe)
#define _tspawnv      WINE_tchar_routine(_spawnv,         _spawnv,     _wspawnv)
#define _tspawnve     WINE_tchar_routine(_spawnve,        _spawnve,    _wspawnve)
#define _tspawnvp     WINE_tchar_routine(_spawnvp,        _spawnvp,    _wspawnvp)
#define _tspawnvpe    WINE_tchar_routine(_spawnvpe,       _spawnvpe,   _wspawnvpe)
#define _tsplitpath   WINE_tchar_routine(_splitpath,      _splitpath,  _wsplitpath)
#define _tsplitpath_s WINE_tchar_routine(_splitpath_s,    _splitpath_s,_wsplitpath_s)
#define _tstat        WINE_tchar_routine(_stat,           _stat,       _wstat)
#define _tstat32      WINE_tchar_routine(_stat32,         _stat32,     _wstat32)
#define _tstat32i64   WINE_tchar_routine(_stat32i64,      _stat32i64,  _wstat32i64)
#define _tstat64      WINE_tchar_routine(_stat64,         _stat64,     _wstat64)
#define _tstat64i32   WINE_tchar_routine(_stat64i32,      _stat64i32,  _wstat64i32)
#define _tstati64     WINE_tchar_routine(_stati64,        _stati64,    _wstati64)
#define _tstof        WINE_tchar_routine(atof,            atof,        _wtof)
#define _tstof_l      WINE_tchar_routine(_atof_l,         _atof_l,     _wtof_l)
#define _tstoi        WINE_tchar_routine(atoi,            atoi,        _wtoi)
#define _tstoi64      WINE_tchar_routine(_atoi64,         _atoi64,     _wtoi64)
#define _tstoi64_l    WINE_tchar_routine(_atoi64_l,       _atoi64_l,   _wtoi64_l)
#define _tstoi_l      WINE_tchar_routine(_atoi_l,         _atoi_l,     _wtoi_l)
#define _tstol        WINE_tchar_routine(atol,            atol,        _wtol)
#define _tstol_l      WINE_tchar_routine(_atol_l,         _atol_l,     _wtol_l)
#define _tstoll       WINE_tchar_routine(atoll,           atoll,       _wtoll)
#define _tstoll_l     WINE_tchar_routine(_atoll_l,        _atoll_l,    _wtoll_l)
#define _tstrdate     WINE_tchar_routine(_strdate,        _strdate,    _wstrdate)
#define _tstrdate_s   WINE_tchar_routine(_strdate_s,      _strdate_s,  _wstrdate_s)
#define _tstrtime     WINE_tchar_routine(_strtime,        _strtime,    _wstrtime)
#define _tstrtime_s   WINE_tchar_routine(_strtime_s,      _strtime_s,  _wstrtime_s)
#define _tsystem      WINE_tchar_routine(system,          system,      _wsystem)
#define _ttempnam     WINE_tchar_routine(tempnam,         _tempnam,    _wtempnam)
#define _ttmpnam      WINE_tchar_routine(tmpnam,          tmpnam,      _wtmpnam)
#define _ttmpnam_s    WINE_tchar_routine(tmpnam_s,        tmpnam_s,    _wtmpnam_s)
#define _ttof         WINE_tchar_routine(atof,            atof,        _wtof)
#define _ttoi         WINE_tchar_routine(atoi,            atoi,        _wtoi)
#define _ttoi64       WINE_tchar_routine(_atoi64,         _atoi64,     _wtoi64)
#define _ttol         WINE_tchar_routine(atol,            atol,        _wtol)
#define _ttoll        WINE_tchar_routine(atoll,           atoll,       _wtoll)
#define _tunlink      WINE_tchar_routine(_unlink,         _unlink,     _wunlink)
#define _tutime       WINE_tchar_routine(utime,           _utime,      _wutime)
#define _tutime32     WINE_tchar_routine(_utime32,        _utime32,    _wutime32)
#define _tutime64     WINE_tchar_routine(_utime64,        _utime64,    _wutime64)
#define _tWinMain     WINE_tchar_routine(WinMain,         WinMain,     wWinMain)
#define _ui64tot      WINE_tchar_routine(_ui64toa,        _ui64toa,    _ui64tow)
#define _ui64tot_s    WINE_tchar_routine(_ui64toa_s,      _ui64toa_s,  _ui64tow_s)
#define _ultot        WINE_tchar_routine(_ultoa,          _ultoa,      _ultow)
#define _ultot_s      WINE_tchar_routine(_ultoa_s,        _ultoa_s,    _ultow_s)
#define _ungettc      WINE_tchar_routine(ungetc,          ungetc,      ungetwc)
#define _ungettc_nolock WINE_tchar_routine(_ungetc_nolock,_ungetc_nolock,_ungetwc_nolock)
#define _ungettch     WINE_tchar_routine(_ungetch,        _ungetch,    _ungetwch)
#define _ungettch_nolock WINE_tchar_routine(_ungetch_nolock,_ungetch_nolock,_ungetwch_nolock)
#define _vftprintf    WINE_tchar_routine(vfprintf,        vfprintf,    vfwprintf)
#define _vftprintf_l  WINE_tchar_routine(_vfprintf_l,     _vfprintf_l, _vfwprintf_l)
#define _vftprintf_p  WINE_tchar_routine(_vfprintf_p,     _vfprintf_p, _vfwprintf_p)
#define _vftprintf_p_l WINE_tchar_routine(_vfprintf_p_l,  _vfprintf_p_l,_vfwprintf_p_l)
#define _vftprintf_s  WINE_tchar_routine(vfprintf_s,      vfprintf_s,  vfwprintf_s)
#define _vftprintf_s_l WINE_tchar_routine(_vfprintf_s_l,  _vfprintf_s_l,_vfwprintf_s_l)
#define _vftscanf     WINE_tchar_routine(vfscanf,         vfscanf,     vfwscanf)
#define _vftscanf_s   WINE_tchar_routine(vfscanf_s,       vfscanf_s,   vfwscanf_s)
#define _vsctprintf   WINE_tchar_routine(_vscprintf,      _vscprintf,  _vscwprintf)
#define _vsctprintf_l WINE_tchar_routine(_vscprintf_l,    _vscprintf_l,_vscwprintf_l)
#define _vsctprintf_p WINE_tchar_routine(_vscprintf_p,    _vscprintf_p,_vscwprintf_p)
#define _vsctprintf_p_l WINE_tchar_routine(_vscprintf_p_l,_vscprintf_p_l,_vscwprintf_p_l)
#define _vsntprintf   WINE_tchar_routine(vsnprintf,       _vsnprintf,  _vsnwprintf)
#define _vsntprintf_l WINE_tchar_routine(_vsnprintf_l,    _vsnprintf_l,_vsnwprintf_l)
#define _vsntprintf_s WINE_tchar_routine(_vsnprintf_s,    _vsnprintf_s,_vsnwprintf_s)
#define _vsntprintf_s_l WINE_tchar_routine(_vsnprintf_s_l,_vsnprintf_s_l,_vsnwprintf_s_l)
#define _vstprintf    WINE_tchar_routine(vsprintf,        vsprintf,    vswprintf)
#define _vstprintf_l  WINE_tchar_routine(_vsprintf_l,     _vsprintf_l, _vswprintf_l)
#define _vstprintf_p  WINE_tchar_routine(_vsprintf_p,     _vsprintf_p, _vswprintf_p)
#define _vstprintf_p_l WINE_tchar_routine(_vsprintf_p_l,  _vsprintf_p_l,_vswprintf_p_l)
#define _vstprintf_s  WINE_tchar_routine(vsprintf_s,      vsprintf_s,  vswprintf_s)
#define _vstprintf_s_l WINE_tchar_routine(_vsprintf_s_l,  _vsprintf_s_l,_vswprintf_s_l)
#define _vstscanf     WINE_tchar_routine(vsscanf,         vsscanf,     vswscanf)
#define _vstscanf_s   WINE_tchar_routine(vsscanf_s,       vsscanf_s,   vswscanf_s)
#define _vtcprintf    WINE_tchar_routine(_vcprintf,       _vcprintf,   _vcwprintf)
#define _vtcprintf_l  WINE_tchar_routine(_vcprintf_l,     _vcprintf_l, _vcwprintf_l)
#define _vtcprintf_p  WINE_tchar_routine(_vcprintf_p,     _vcprintf_p, _vcwprintf_p)
#define _vtcprintf_p_l WINE_tchar_routine(_vcprintf_p_l,  _vcprintf_p_l,_vcwprintf_p_l)
#define _vtcprintf_s  WINE_tchar_routine(_vcprintf_s,     _vcprintf_s, _vcwprintf_s)
#define _vtcprintf_s_l WINE_tchar_routine(_vcprintf_s_l,  _vcprintf_s_l,_vcwprintf_s_l)
#define _vtprintf     WINE_tchar_routine(vprintf,         vprintf,     vwprintf)
#define _vtprintf_l   WINE_tchar_routine(_vprintf_l,      _vprintf_l,  _vwprintf_l)
#define _vtprintf_p   WINE_tchar_routine(_vprintf_p,      _vprintf_p,  _vwprintf_p)
#define _vtprintf_p_l WINE_tchar_routine(_vprintf_p_l,    _vprintf_p_l,_vwprintf_p_l)
#define _vtprintf_s   WINE_tchar_routine(vprintf_s,       vprintf_s,   vwprintf_s)
#define _vtprintf_s_l WINE_tchar_routine(_vprintf_s_l,    _vprintf_s_l,_vwprintf_s_l)
#define _vtscanf      WINE_tchar_routine(vscanf,          vscanf,      vwscanf)
#define _vtscanf_s    WINE_tchar_routine(vscanf_s,        vscanf_s,    vwscanf_s)
#define _TEOF         WINE_tchar_routine(EOF,             EOF,         WEOF)

#define __T(x) __TEXT(x)
#define _T(x) __T(x)
#define _TEXT(x) __T(x)

#ifdef _UNICODE
#if !defined(_WINT_T_DEFINED) && !defined(__WINT_TYPE__)
typedef unsigned short wint_t;
#endif

#ifndef _WCTYPE_T_DEFINED
typedef unsigned short wctype_t;
#define _WCTYPE_T_DEFINED
#endif

#ifndef __TCHAR_DEFINED
#if defined(WINE_UNICODE_NATIVE) || defined(__MINGW32__) || defined(_MSC_VER)
typedef wchar_t       _TCHAR;
#elif __cpp_unicode_literals >= 200710
typedef char16_t      _TCHAR;
#else
typedef unsigned short _TCHAR;
#endif
typedef _TCHAR        _TUCHAR;
typedef _TCHAR        _TSCHAR;
typedef _TCHAR        _TXCHAR;
typedef _TCHAR        _TINT;
#define __TCHAR_DEFINED
#endif

#else /* _UNICODE */
#ifndef __TCHAR_DEFINED
typedef char          _TCHAR;
typedef unsigned char _TUCHAR;
typedef signed char   _TSCHAR;
#ifndef _MBCS
typedef unsigned char _TXCHAR;
typedef int           _TINT;
#else
typedef char          _TXCHAR;
typedef unsigned int  _TINT;
#endif
#endif
#endif

#ifndef _TCHAR_DEFINED
typedef _TCHAR        TCHAR, *PTCHAR;
#define _TCHAR_DEFINED
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __WINE_TCHAR_H */
