﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cloudformation/CloudFormation_EXPORTS.h>
#include <aws/cloudformation/CloudFormationRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace CloudFormation
{
namespace Model
{

  /**
   */
  class DescribeTypeRegistrationRequest : public CloudFormationRequest
  {
  public:
    AWS_CLOUDFORMATION_API DescribeTypeRegistrationRequest() = default;

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "DescribeTypeRegistration"; }

    AWS_CLOUDFORMATION_API Aws::String SerializePayload() const override;

  protected:
    AWS_CLOUDFORMATION_API void DumpBodyToUrl(Aws::Http::URI& uri ) const override;

  public:

    ///@{
    /**
     * <p>The identifier for this registration request.</p> <p>This registration token
     * is generated by CloudFormation when you initiate a registration request using
     * <a>RegisterType</a>.</p>
     */
    inline const Aws::String& GetRegistrationToken() const { return m_registrationToken; }
    inline bool RegistrationTokenHasBeenSet() const { return m_registrationTokenHasBeenSet; }
    template<typename RegistrationTokenT = Aws::String>
    void SetRegistrationToken(RegistrationTokenT&& value) { m_registrationTokenHasBeenSet = true; m_registrationToken = std::forward<RegistrationTokenT>(value); }
    template<typename RegistrationTokenT = Aws::String>
    DescribeTypeRegistrationRequest& WithRegistrationToken(RegistrationTokenT&& value) { SetRegistrationToken(std::forward<RegistrationTokenT>(value)); return *this;}
    ///@}
  private:

    Aws::String m_registrationToken;
    bool m_registrationTokenHasBeenSet = false;
  };

} // namespace Model
} // namespace CloudFormation
} // namespace Aws
