﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/elasticache/ElastiCache_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace ElastiCache {
namespace Model {

/**
 * <p>Provides ownership and status information for an Amazon EC2 security
 * group.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/EC2SecurityGroup">AWS
 * API Reference</a></p>
 */
class EC2SecurityGroup {
 public:
  AWS_ELASTICACHE_API EC2SecurityGroup() = default;
  AWS_ELASTICACHE_API EC2SecurityGroup(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_ELASTICACHE_API EC2SecurityGroup& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_ELASTICACHE_API void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
  AWS_ELASTICACHE_API void OutputToStream(Aws::OStream& oStream, const char* location) const;

  ///@{
  /**
   * <p>The status of the Amazon EC2 security group.</p>
   */
  inline const Aws::String& GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  template <typename StatusT = Aws::String>
  void SetStatus(StatusT&& value) {
    m_statusHasBeenSet = true;
    m_status = std::forward<StatusT>(value);
  }
  template <typename StatusT = Aws::String>
  EC2SecurityGroup& WithStatus(StatusT&& value) {
    SetStatus(std::forward<StatusT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the Amazon EC2 security group.</p>
   */
  inline const Aws::String& GetEC2SecurityGroupName() const { return m_eC2SecurityGroupName; }
  inline bool EC2SecurityGroupNameHasBeenSet() const { return m_eC2SecurityGroupNameHasBeenSet; }
  template <typename EC2SecurityGroupNameT = Aws::String>
  void SetEC2SecurityGroupName(EC2SecurityGroupNameT&& value) {
    m_eC2SecurityGroupNameHasBeenSet = true;
    m_eC2SecurityGroupName = std::forward<EC2SecurityGroupNameT>(value);
  }
  template <typename EC2SecurityGroupNameT = Aws::String>
  EC2SecurityGroup& WithEC2SecurityGroupName(EC2SecurityGroupNameT&& value) {
    SetEC2SecurityGroupName(std::forward<EC2SecurityGroupNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon account ID of the Amazon EC2 security group owner.</p>
   */
  inline const Aws::String& GetEC2SecurityGroupOwnerId() const { return m_eC2SecurityGroupOwnerId; }
  inline bool EC2SecurityGroupOwnerIdHasBeenSet() const { return m_eC2SecurityGroupOwnerIdHasBeenSet; }
  template <typename EC2SecurityGroupOwnerIdT = Aws::String>
  void SetEC2SecurityGroupOwnerId(EC2SecurityGroupOwnerIdT&& value) {
    m_eC2SecurityGroupOwnerIdHasBeenSet = true;
    m_eC2SecurityGroupOwnerId = std::forward<EC2SecurityGroupOwnerIdT>(value);
  }
  template <typename EC2SecurityGroupOwnerIdT = Aws::String>
  EC2SecurityGroup& WithEC2SecurityGroupOwnerId(EC2SecurityGroupOwnerIdT&& value) {
    SetEC2SecurityGroupOwnerId(std::forward<EC2SecurityGroupOwnerIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_status;
  bool m_statusHasBeenSet = false;

  Aws::String m_eC2SecurityGroupName;
  bool m_eC2SecurityGroupNameHasBeenSet = false;

  Aws::String m_eC2SecurityGroupOwnerId;
  bool m_eC2SecurityGroupOwnerIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ElastiCache
}  // namespace Aws
