/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.util.SimplifiedVisitor;

public class LineNumberTableAttributeTrimmer
extends SimplifiedVisitor
implements AttributeVisitor {
    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        Object[] lineNumberTable = lineNumberTableAttribute.lineNumberTable;
        int lineNumberTableLength = lineNumberTableAttribute.u2lineNumberTableLength;
        int newIndex = 0;
        for (int index = 0; index < lineNumberTableLength; ++index) {
            LineNumberInfo lineNumberInfo = lineNumberTable[index];
            int startPC = lineNumberInfo.u2startPC;
            int lineNumber = lineNumberInfo.u2lineNumber;
            if (startPC >= codeAttribute.u4codeLength || index != lineNumberTableLength - 1 && startPC >= ((LineNumberInfo)lineNumberTable[index + 1]).u2startPC || index != 0 && lineNumber == ((LineNumberInfo)lineNumberTable[index - 1]).u2lineNumber) continue;
            lineNumberTable[newIndex++] = lineNumberInfo;
        }
        Arrays.fill(lineNumberTable, newIndex, lineNumberTableAttribute.u2lineNumberTableLength, null);
        lineNumberTableAttribute.u2lineNumberTableLength = newIndex;
    }
}

