/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.AbstractPatternFunction;
import com.thaiopensource.relaxng.pattern.ChoicePattern;
import com.thaiopensource.relaxng.pattern.ElementPattern;
import com.thaiopensource.relaxng.pattern.GroupPattern;
import com.thaiopensource.relaxng.pattern.InterleavePattern;
import com.thaiopensource.relaxng.pattern.OneOrMorePattern;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.SchemaPatternBuilder;
import java.util.HashSet;
import java.util.Set;

public class FeasibleTransform {
    public static Pattern transform(SchemaPatternBuilder schemaPatternBuilder, Pattern pattern) {
        return pattern.apply(new FeasiblePatternFunction(schemaPatternBuilder));
    }

    private static class FeasiblePatternFunction
    extends AbstractPatternFunction<Pattern> {
        private final SchemaPatternBuilder spb;
        private final Set<ElementPattern> elementDone = new HashSet<ElementPattern>();

        FeasiblePatternFunction(SchemaPatternBuilder schemaPatternBuilder) {
            this.spb = schemaPatternBuilder;
        }

        @Override
        public Pattern caseChoice(ChoicePattern choicePattern) {
            return this.spb.makeChoice(choicePattern.getOperand1().apply(this), choicePattern.getOperand2().apply(this));
        }

        @Override
        public Pattern caseGroup(GroupPattern groupPattern) {
            return this.spb.makeGroup(groupPattern.getOperand1().apply(this), groupPattern.getOperand2().apply(this));
        }

        @Override
        public Pattern caseInterleave(InterleavePattern interleavePattern) {
            return this.spb.makeInterleave(interleavePattern.getOperand1().apply(this), interleavePattern.getOperand2().apply(this));
        }

        @Override
        public Pattern caseOneOrMore(OneOrMorePattern oneOrMorePattern) {
            return this.spb.makeOneOrMore(oneOrMorePattern.getOperand().apply(this));
        }

        @Override
        public Pattern caseElement(ElementPattern elementPattern) {
            if (!this.elementDone.contains(elementPattern)) {
                this.elementDone.add(elementPattern);
                elementPattern.setContent(elementPattern.getContent().apply(this));
            }
            return this.spb.makeOptional(elementPattern);
        }

        @Override
        public Pattern caseOther(Pattern pattern) {
            return this.spb.makeOptional(pattern);
        }
    }
}

