/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.backend;

import io.cucumber.core.backend.SourceReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class JavaMethodReference
implements SourceReference {
    private final String className;
    private final String methodName;
    private final List<String> methodParameterTypes;

    JavaMethodReference(Class<?> declaringClass, String methodName, Class<?>[] methodParameterTypes) {
        this.className = Objects.requireNonNull(declaringClass).getName();
        this.methodName = Objects.requireNonNull(methodName);
        this.methodParameterTypes = new ArrayList<String>(methodParameterTypes.length);
        for (Class<?> parameterType : methodParameterTypes) {
            this.methodParameterTypes.add(parameterType.getName());
        }
    }

    public String className() {
        return this.className;
    }

    public String methodName() {
        return this.methodName;
    }

    public List<String> methodParameterTypes() {
        return this.methodParameterTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaMethodReference that = (JavaMethodReference)o;
        return this.className.equals(that.className) && this.methodName.equals(that.methodName) && this.methodParameterTypes.equals(that.methodParameterTypes);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.methodName, this.methodParameterTypes);
    }
}

