/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.map;

import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeIterator;
import org.freeplane.plugin.codeexplorer.map.CodeNode;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;

public class CodeNodeStream {
    static Stream<CodeNode> selectedNodes(IMapSelection selection) {
        return selection.getSelection().stream().map(CodeNode.class::cast);
    }

    static Stream<CodeNode> visibleNodes(MapView mapView) {
        Stream<NodeView> nodeViews = CodeNodeStream.nodeViews(mapView);
        return nodeViews.filter(NodeView::isContentVisible).map(NodeView::getNode).map(CodeNode.class::cast);
    }

    static Stream<NodeView> nodeViews(MapView mapView) {
        NodeIterator nodeViewIterator = NodeIterator.of((Object)mapView.getRoot(), NodeView::getChildrenViews);
        Stream<NodeView> nodeViews = StreamSupport.stream(Spliterators.spliteratorUnknownSize(nodeViewIterator, 16), false);
        return nodeViews;
    }
}

