/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.task;

import com.tngtech.archunit.core.domain.JavaClass;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import org.freeplane.plugin.codeexplorer.map.CodeNode;
import org.freeplane.plugin.codeexplorer.task.ClassNameMatcher;
import org.freeplane.plugin.codeexplorer.task.GroupIdentifier;
import org.freeplane.plugin.codeexplorer.task.GroupMatcher;

public class DirectoryMatcher
implements GroupMatcher {
    private final SortedMap<String, String> coreLocationsByPaths;
    private final Collection<File> locations;
    private final Collection<String> subpaths;
    private final Collection<ClassNameMatcher> groupMatchers;
    private final Map<String, String> groupNamesByLocation;
    private final boolean groupsClassesByName;

    private static String toGroupName(String location) {
        String[] segments;
        if (location.endsWith(".jar!/")) {
            int lastSlashIndex = location.lastIndexOf(47, location.length() - ".jar!/".length());
            return location.substring(lastSlashIndex + 1, location.length() - 2);
        }
        int lastPossibleGroupNameIndex = location.endsWith("/") ? location.length() - 1 : location.length();
        for (String segment : segments = new String[]{"/target/", "/build/", "/bin/", "/out/"}) {
            int segmentIndex = location.lastIndexOf(segment);
            if (segmentIndex <= 0) continue;
            int lastSlashIndex = location.lastIndexOf(47, segmentIndex - 1);
            return location.substring(lastSlashIndex + 1, lastPossibleGroupNameIndex);
        }
        int lastSlashIndex = lastPossibleGroupNameIndex > 0 ? location.lastIndexOf(47, lastPossibleGroupNameIndex - 1) : -1;
        return location.substring(lastSlashIndex + 1, lastPossibleGroupNameIndex);
    }

    public DirectoryMatcher(Collection<File> locations, Collection<String> subpaths, Collection<ClassNameMatcher> groupMatchers) {
        this.locations = locations;
        this.subpaths = subpaths;
        this.groupMatchers = groupMatchers;
        this.groupsClassesByName = !groupMatchers.stream().allMatch(ClassNameMatcher::ignoresClasses);
        this.coreLocationsByPaths = new TreeMap<String, String>();
        this.groupNamesByLocation = new HashMap<String, String>();
        this.findDirectories((directory, location) -> this.coreLocationsByPaths.put(directory.toURI().getRawPath(), location.toURI().getRawPath()));
    }

    private Optional<String> coreLocationOf(JavaClass javaClass) {
        return CodeNode.classSourceLocationOf(javaClass).map(path -> this.coreLocationsByPaths.getOrDefault(path, (String)path));
    }

    private void findDirectories(BiConsumer<File, File> consumer) {
        for (File location : this.locations) {
            if (location.isDirectory()) {
                for (String subPath : this.subpaths.isEmpty() ? this.defaultSubpaths(location) : this.subpaths) {
                    File directory = subPath.equals(".") ? location : new File(location, subPath);
                    if (!directory.isDirectory()) continue;
                    consumer.accept(directory, location);
                }
                continue;
            }
            consumer.accept(location, location);
        }
    }

    private List<String> defaultSubpaths(File location) {
        if (new File(location, "pom.xml").exists()) {
            return Collections.singletonList("target/classes");
        }
        if (new File(location, "build.gradle").exists() || new File(location, "build.gradle.kts").exists()) {
            return Arrays.asList("build/classes/java/main", "build/classes/kotlin/main", "build/intermediates/javac/debug/classes", "build/tmp/kotlin-classes/debug");
        }
        return Collections.singletonList(".");
    }

    private Optional<String> identifierByClass(JavaClass javaClass) {
        for (ClassNameMatcher groupMatcher : this.groupMatchers) {
            if (groupMatcher.isIgnored(javaClass)) {
                return Optional.empty();
            }
            Optional<String> groupResult = groupMatcher.toGroup(javaClass);
            if (!groupResult.isPresent()) continue;
            return groupResult;
        }
        return Optional.of("");
    }

    @Override
    public Optional<GroupIdentifier> groupIdentifier(JavaClass javaClass) {
        Optional<String> optionalCoreLocation = this.coreLocationOf(javaClass);
        if (!optionalCoreLocation.isPresent()) {
            return Optional.empty();
        }
        String coreLocation = optionalCoreLocation.get();
        if (this.groupMatchers.isEmpty() || !this.groupsClassesByName && this.identifierByClass(javaClass).isPresent()) {
            return Optional.of(new GroupIdentifier(coreLocation, this.groupNamesByLocation.computeIfAbsent(coreLocation, DirectoryMatcher::toGroupName)));
        }
        if (this.groupsClassesByName) {
            return this.identifierByClass(javaClass).map(id -> id.isEmpty() ? "*" : id).map(id -> new GroupIdentifier((String)id, (String)id));
        }
        return Optional.empty();
    }

    public Collection<File> getImportedLocations() {
        ArrayList<File> importedLocations = new ArrayList<File>();
        this.findDirectories((importedLocation, location) -> importedLocations.add((File)importedLocation));
        return importedLocations;
    }

    public List<String> getFoundLocations(String location) {
        ArrayList<String> foundLocations = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.coreLocationsByPaths.tailMap(location).entrySet()) {
            if (!entry.getValue().equals(location)) break;
            foundLocations.add(entry.getKey());
        }
        return foundLocations;
    }
}

