/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.base;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.thirdparty.com.google.common.base.MoreObjects;
import java.util.function.Function;

@PublicAPI(usage=PublicAPI.Usage.INHERITANCE)
public abstract class DescribedFunction<F, T>
implements Function<F, T>,
HasDescription {
    private final String description;

    protected DescribedFunction(String description, Object ... args) {
        this.description = String.format(description, args);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("description", this.description).toString();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <F, T> DescribedFunction<F, T> describe(String description, final Function<F, T> function) {
        return new DescribedFunction<F, T>(description, new Object[0]){

            @Override
            public T apply(F input) {
                return function.apply(input);
            }
        };
    }
}

