/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ChainableFunction;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.properties.CanBeAnnotated;
import com.tngtech.archunit.core.domain.properties.HasAnnotations;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.core.domain.properties.HasOwner;
import com.tngtech.archunit.core.domain.properties.HasType;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class JavaParameter
implements HasType,
HasOwner<JavaCodeUnit>,
HasAnnotations<JavaParameter> {
    private static final ChainableFunction<HasType, String> GET_ANNOTATION_TYPE_NAME = HasType.Functions.GET_RAW_TYPE.then(HasName.Functions.GET_NAME);
    private final JavaCodeUnit owner;
    private final int index;
    private final JavaType type;
    private final JavaClass rawType;
    private final Map<String, JavaAnnotation<JavaParameter>> annotations;

    JavaParameter(JavaCodeUnit owner, DomainBuilders.JavaCodeUnitBuilder.ParameterAnnotationsBuilder builder, int index, JavaType type) {
        this.owner = owner;
        this.index = index;
        this.type = type;
        this.rawType = type.toErasure();
        this.annotations = this.buildIndexedByTypeName(builder);
    }

    private Map<String, JavaAnnotation<JavaParameter>> buildIndexedByTypeName(DomainBuilders.JavaCodeUnitBuilder.ParameterAnnotationsBuilder builder) {
        Set<JavaAnnotation<JavaParameter>> annotations = builder.build(this);
        return Maps.uniqueIndex(annotations, GET_ANNOTATION_TYPE_NAME::apply);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaCodeUnit getOwner() {
        return this.owner;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public int getIndex() {
        return this.index;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaType getType() {
        return this.type;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getRawType() {
        return this.rawType;
    }

    @Override
    public boolean isAnnotatedWith(Class<? extends Annotation> annotationType) {
        return this.annotations.containsKey(annotationType.getName());
    }

    @Override
    public boolean isAnnotatedWith(String annotationTypeName) {
        return this.annotations.containsKey(annotationTypeName);
    }

    @Override
    public boolean isAnnotatedWith(DescribedPredicate<? super JavaAnnotation<?>> predicate) {
        return DescribedPredicate.anyElementThat(predicate).test(this.annotations.values());
    }

    @Override
    public boolean isMetaAnnotatedWith(Class<? extends Annotation> annotationType) {
        return this.isMetaAnnotatedWith(HasType.Functions.GET_RAW_TYPE.is(JavaClass.Predicates.equivalentTo(annotationType)));
    }

    @Override
    public boolean isMetaAnnotatedWith(String annotationTypeName) {
        return this.isMetaAnnotatedWith(GET_ANNOTATION_TYPE_NAME.is(DescribedPredicate.equalTo(annotationTypeName)));
    }

    @Override
    public boolean isMetaAnnotatedWith(DescribedPredicate<? super JavaAnnotation<?>> predicate) {
        return CanBeAnnotated.Utils.isMetaAnnotatedWith(this.annotations.values(), predicate);
    }

    @Override
    public Set<JavaAnnotation<JavaParameter>> getAnnotations() {
        return ImmutableSet.copyOf(this.annotations.values());
    }

    @Override
    public <A extends Annotation> A getAnnotationOfType(Class<A> type) {
        return this.getAnnotationOfType(type.getName()).as(type);
    }

    @Override
    public JavaAnnotation<JavaParameter> getAnnotationOfType(String typeName) {
        Optional<JavaAnnotation<JavaParameter>> annotation = this.tryGetAnnotationOfType(typeName);
        if (!annotation.isPresent()) {
            throw new IllegalArgumentException(String.format("%s is not annotated with @%s", this.getDescription(), typeName));
        }
        return annotation.get();
    }

    @Override
    public <A extends Annotation> Optional<A> tryGetAnnotationOfType(Class<A> type) {
        return this.tryGetAnnotationOfType(type.getName()).map(CanBeAnnotated.Utils.toAnnotationOfType(type));
    }

    @Override
    public Optional<JavaAnnotation<JavaParameter>> tryGetAnnotationOfType(String typeName) {
        return Optional.ofNullable(this.annotations.get(typeName));
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getDescription() {
        return "Parameter <" + this.type.getName() + "> of " + JavaParameter.startWithLowercase(this.owner.getDescription());
    }

    public String toString() {
        return "JavaParameter{owner='" + this.owner.getFullName() + "', index='" + this.index + "', type='" + this.type.getName() + "'}";
    }

    static String startWithLowercase(String string) {
        return Character.toLowerCase(string.charAt(0)) + string.substring(1);
    }
}

