/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class Source {
    private final URI uri;
    private final Optional<String> fileName;
    private final Md5sum md5sum;

    Source(URI uri, Optional<String> fileName, boolean md5InClassSourcesEnabled) {
        this.uri = Preconditions.checkNotNull(uri);
        this.fileName = Preconditions.checkNotNull(fileName);
        this.md5sum = md5InClassSourcesEnabled ? Md5sum.of(uri) : Md5sum.DISABLED;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public URI getUri() {
        return this.uri;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<String> getFileName() {
        return this.fileName;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Md5sum getMd5sum() {
        return this.md5sum;
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.md5sum);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Source other = (Source)obj;
        return Objects.equals(this.uri, other.uri) && Objects.equals(this.md5sum, other.md5sum);
    }

    public String toString() {
        return this.uri + " [md5='" + this.md5sum + "']";
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class Md5sum {
        static final Md5sum NOT_SUPPORTED = new Md5sum("NOT_SUPPORTED");
        static final Md5sum UNDETERMINED = new Md5sum("UNDETERMINED");
        static final Md5sum DISABLED = new Md5sum("DISABLED");
        private static final MessageDigest MD5_DIGEST = Md5sum.getMd5Digest();
        private final byte[] md5Bytes;
        private final String text;
        private static final char[] hexDigits = "0123456789abcdef".toCharArray();

        private Md5sum(String text) {
            this.md5Bytes = new byte[0];
            this.text = text;
        }

        private Md5sum(byte[] input, MessageDigest md5Digest) {
            this.md5Bytes = md5Digest.digest(input);
            this.text = Md5sum.toHex(this.md5Bytes);
        }

        static String toHex(byte[] bytes) {
            StringBuilder sb = new StringBuilder(2 * bytes.length);
            for (byte b : bytes) {
                sb.append(hexDigits[b >> 4 & 0xF]).append(hexDigits[b & 0xF]);
            }
            return sb.toString();
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public byte[] asBytes() {
            return Arrays.copyOf(this.md5Bytes, this.md5Bytes.length);
        }

        public int hashCode() {
            return Arrays.hashCode(this.md5Bytes) + 31 * this.text.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Md5sum other = (Md5sum)obj;
            return Arrays.equals(this.md5Bytes, other.md5Bytes) && Objects.equals(this.text, other.text);
        }

        public String toString() {
            return this.text;
        }

        private static MessageDigest getMd5Digest() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                return null;
            }
        }

        private static Md5sum of(URI uri) {
            if (MD5_DIGEST == null) {
                return NOT_SUPPORTED;
            }
            Optional<byte[]> bytesFromUri = Md5sum.read(uri);
            return bytesFromUri.map(bytes -> new Md5sum((byte[])bytes, MD5_DIGEST)).orElse(UNDETERMINED);
        }

        private static Optional<byte[]> read(URI uri) {
            Optional<byte[]> optional;
            block8: {
                InputStream in = uri.toURL().openStream();
                try {
                    optional = Optional.of(ByteStreams.toByteArray(in));
                    if (in == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | RuntimeException e) {
                        return Optional.empty();
                    }
                }
                in.close();
            }
            return optional;
        }
    }
}

