/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.metrics;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ForwardingCollection;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaPackage;
import com.tngtech.archunit.library.metrics.MetricsComponent;
import com.tngtech.archunit.thirdparty.com.google.common.collect.HashMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class MetricsComponents<T>
extends ForwardingCollection<MetricsComponent<T>> {
    private final Map<String, MetricsComponent<T>> componentsByIdentifier;

    private MetricsComponents(Collection<MetricsComponent<T>> components) {
        this.componentsByIdentifier = Maps.uniqueIndex(components, MetricsComponent::getIdentifier);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<MetricsComponent<T>> tryGetComponent(String identifier) {
        return Optional.ofNullable(this.componentsByIdentifier.get(identifier));
    }

    @Override
    protected Collection<MetricsComponent<T>> delegate() {
        return this.componentsByIdentifier.values();
    }

    @SafeVarargs
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> MetricsComponents<T> of(MetricsComponent<T> ... components) {
        return MetricsComponents.of(ImmutableSet.copyOf(components));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> MetricsComponents<T> of(Collection<MetricsComponent<T>> metricsComponents) {
        return new MetricsComponents<T>(ImmutableSet.copyOf(metricsComponents));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> MetricsComponents<T> from(Collection<T> elements, Function<? super T, String> identifierFunction) {
        HashMultimap<String, T> partitioned = HashMultimap.create();
        for (T element : elements) {
            partitioned.put(identifierFunction.apply(element), element);
        }
        ImmutableSet.Builder components = ImmutableSet.builder();
        for (Map.Entry entry : partitioned.asMap().entrySet()) {
            components.add(MetricsComponent.of((String)entry.getKey(), entry.getValue()));
        }
        return MetricsComponents.of(components.build());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static MetricsComponents<JavaClass> fromPackages(Collection<JavaPackage> packages) {
        ImmutableSet.Builder components = ImmutableSet.builder();
        for (JavaPackage javaPackage : packages) {
            components.add(MetricsComponent.of(javaPackage.getName(), javaPackage.getClassesInPackageTree()));
        }
        return MetricsComponents.of(components.build());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static MetricsComponents<JavaClass> fromClasses(Collection<JavaClass> classes) {
        ImmutableSet.Builder components = ImmutableSet.builder();
        for (JavaClass javaClass : classes) {
            components.add(MetricsComponent.of(javaClass.getName(), javaClass));
        }
        return MetricsComponents.of(components.build());
    }
}

