/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.plugin.script.NodeScript;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.UniqueStack;

public class FormulaThreadLocalStacks {
    private final ThreadLocal<UniqueStack> stack = new ThreadLocal<UniqueStack>(){

        @Override
        protected UniqueStack initialValue() {
            return new UniqueStack();
        }
    };
    public static final FormulaThreadLocalStacks INSTANCE = new FormulaThreadLocalStacks();

    private FormulaThreadLocalStacks() {
    }

    private UniqueStack stack() {
        return this.stack.get();
    }

    public ScriptContext getCurrentContext() {
        return this.stack().getCurrentContext();
    }

    public boolean push(ScriptContext scriptContext) {
        boolean success = this.stack().push(scriptContext);
        if (!success && !this.ignoresCycles()) {
            LogUtils.warn((String)("Circular reference detected! Traceback (innermost last):\n " + this.stackTrace(scriptContext.getNodeScript())));
        }
        return success;
    }

    public void pop() {
        this.stack().pop();
    }

    private String stackTrace(NodeScript nodeScript) {
        ArrayList<String> entries = new ArrayList<String>(this.stack().size());
        for (NodeScript node : this.stack()) {
            entries.add(node.format(nodeScript));
        }
        entries.add(nodeScript.format(nodeScript));
        return StringUtils.join(entries.iterator(), (String)"\n -> ");
    }

    public List<NodeScript> findCycle(NodeScript nodeScript) {
        return this.stack().findCycle(nodeScript);
    }

    public <T> T ignoreCycles(Supplier<T> closure) {
        return this.stack().ignoreCycles(closure);
    }

    public boolean ignoresCycles() {
        return this.stack().ignoreCycles();
    }
}

