/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.bookmarks.mindmapmode.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import javax.swing.JButton;
import org.freeplane.features.bookmarks.mindmapmode.ui.BookmarkButton;
import org.freeplane.features.bookmarks.mindmapmode.ui.BookmarkToolbar;

class BookmarkIndexCalculator {
    private final BookmarkToolbar toolbar;

    BookmarkIndexCalculator(BookmarkToolbar toolbar) {
        this.toolbar = toolbar;
    }

    int calculateBookmarkMoveIndex(int sourceIndex, JButton targetButton, Point dropPoint) {
        if (!(targetButton instanceof BookmarkButton)) {
            return -1;
        }
        int targetIndex = this.getBookmarkButtonIndex(targetButton);
        if (targetIndex < 0) {
            return -1;
        }
        boolean movesAfter = this.isDropAfter(targetButton, dropPoint);
        return movesAfter ? (sourceIndex < targetIndex ? targetIndex : targetIndex + 1) : (sourceIndex < targetIndex ? targetIndex - 1 : targetIndex);
    }

    boolean isValidBookmarkMove(int sourceIndex, JButton targetButton, Point dropPoint) {
        if (!(targetButton instanceof BookmarkButton)) {
            return false;
        }
        Container parent = targetButton.getParent();
        if (!(parent instanceof BookmarkToolbar) || parent != this.toolbar) {
            return false;
        }
        int targetIndex = this.getBookmarkButtonIndex(targetButton);
        if (targetIndex < 0 || targetIndex == sourceIndex) {
            return false;
        }
        if (!this.isInInsertionZone(targetButton, dropPoint)) {
            return false;
        }
        int finalTargetIndex = this.calculateBookmarkMoveIndex(sourceIndex, targetButton, dropPoint);
        return finalTargetIndex >= 0 && sourceIndex != finalTargetIndex;
    }

    boolean isInInsertionZone(JButton targetButton, Point dropPoint) {
        int buttonWidth = targetButton.getWidth();
        int leftThird = buttonWidth / 3;
        int rightThird = buttonWidth * 2 / 3;
        return dropPoint.x <= leftThird || dropPoint.x >= rightThird;
    }

    boolean isDropAfter(JButton targetButton, Point dropPoint) {
        int rightThird = targetButton.getWidth() * 2 / 3;
        return dropPoint.x >= rightThird;
    }

    ToolbarDropPosition calculateToolbarDropPosition(Point dropPoint) {
        int buttonIndex;
        BookmarkButton button;
        Component[] components;
        for (Component component : components = this.toolbar.getComponents()) {
            int buttonLeft;
            if (!(component instanceof BookmarkButton) || dropPoint.x < (buttonLeft = (button = (BookmarkButton)component).getX()) - BookmarkToolbar.GAP || dropPoint.x > buttonLeft + BookmarkToolbar.GAP || (buttonIndex = this.getBookmarkButtonIndex(component)) < 0) continue;
            return new ToolbarDropPosition(ToolbarDropPosition.Type.BEFORE_BUTTON, buttonIndex);
        }
        for (Component component : components) {
            int buttonRight;
            if (!(component instanceof BookmarkButton) || dropPoint.x < (buttonRight = (button = (BookmarkButton)component).getX() + button.getWidth()) - BookmarkToolbar.GAP || dropPoint.x > buttonRight + BookmarkToolbar.GAP || (buttonIndex = this.getBookmarkButtonIndex(component)) < 0) continue;
            return new ToolbarDropPosition(ToolbarDropPosition.Type.AFTER_BUTTON, buttonIndex);
        }
        return new ToolbarDropPosition(ToolbarDropPosition.Type.AT_END, this.getBookmarkButtonCount());
    }

    private int getBookmarkButtonIndex(Component component) {
        int bookmarkIndex = 0;
        for (int i = 0; i < this.toolbar.getComponentCount(); ++i) {
            Component comp = this.toolbar.getComponent(i);
            if (comp == component) {
                return bookmarkIndex;
            }
            if (!(comp instanceof BookmarkButton)) continue;
            ++bookmarkIndex;
        }
        return -1;
    }

    private int getBookmarkButtonCount() {
        int count = 0;
        for (Component component : this.toolbar.getComponents()) {
            if (!(component instanceof BookmarkButton)) continue;
            ++count;
        }
        return count;
    }

    static class ToolbarDropPosition {
        final Type type;
        final int buttonIndex;

        ToolbarDropPosition(Type type, int buttonIndex) {
            this.type = type;
            this.buttonIndex = buttonIndex;
        }

        int getInsertionIndex() {
            switch (this.type.ordinal()) {
                case 0: {
                    return this.buttonIndex;
                }
                case 1: {
                    return this.buttonIndex + 1;
                }
            }
            return this.buttonIndex;
        }

        static enum Type {
            BEFORE_BUTTON,
            AFTER_BUTTON,
            AT_END;

        }
    }
}

