/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.bookmarks.mindmapmode.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.freeplane.features.bookmarks.mindmapmode.BookmarksController;
import org.freeplane.features.bookmarks.mindmapmode.MapBookmarks;
import org.freeplane.features.bookmarks.mindmapmode.NodeBookmark;
import org.freeplane.features.bookmarks.mindmapmode.ui.BookmarkButton;
import org.freeplane.features.bookmarks.mindmapmode.ui.BookmarkToolbar;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.clipboard.MindMapNodesSelection;

class DropExecutor {
    private final BookmarksController bookmarksController;
    private final BookmarkToolbar toolbar;

    DropExecutor(BookmarkToolbar toolbar, BookmarksController bookmarksController) {
        this.toolbar = toolbar;
        this.bookmarksController = bookmarksController;
    }

    void moveBookmark(int sourceIndex, int targetIndex) {
        MapModel map = this.toolbar.getMap();
        MapBookmarks bookmarks = this.bookmarksController.getBookmarks(map);
        NodeBookmark bookmarkToMove = bookmarks.getBookmarks().get(sourceIndex);
        SwingUtilities.invokeLater(() -> this.bookmarksController.moveBookmark(bookmarkToMove.getNode(), targetIndex));
    }

    boolean createBookmarkFromNode(Transferable transferable, NodeBookmark targetBookmark, boolean dropAfter, JButton targetButton) {
        try {
            MapModel map = this.getMapFromButton(targetButton);
            BookmarkToolbar toolbar = (BookmarkToolbar)((Object)targetButton.getParent());
            NodeModel draggedNode = this.extractSingleNode(transferable, toolbar);
            if (draggedNode == null) {
                return false;
            }
            int insertionIndex = this.calculateInsertionIndex(targetBookmark, dropAfter, map);
            return this.bookmarksController.createBookmarkFromNode(draggedNode, map, insertionIndex);
        }
        catch (Exception e) {
            return false;
        }
    }

    boolean createBookmarkFromNodeAtEnd(Transferable transferable, BookmarkToolbar toolbar) {
        try {
            NodeModel draggedNode = this.extractSingleNode(transferable, toolbar);
            if (draggedNode == null) {
                return false;
            }
            MapModel map = toolbar.getMap();
            List<NodeBookmark> currentBookmarks = this.bookmarksController.getBookmarks(map).getBookmarks();
            int insertionIndex = currentBookmarks.size();
            return this.bookmarksController.createBookmarkFromNode(draggedNode, map, insertionIndex);
        }
        catch (Exception e) {
            return false;
        }
    }

    boolean createBookmarkFromNodeAtPosition(Transferable transferable, BookmarkToolbar toolbar, int insertionIndex) {
        try {
            NodeModel draggedNode = this.extractSingleNode(transferable, toolbar);
            if (draggedNode == null) {
                return false;
            }
            MapModel map = toolbar.getMap();
            return this.bookmarksController.createBookmarkFromNode(draggedNode, map, insertionIndex);
        }
        catch (Exception e) {
            return false;
        }
    }

    boolean createBookmarkFromNodeAtPosition(DropTargetDropEvent dtde, int insertionIndex) {
        try {
            NodeModel draggedNode = this.extractSingleNode(dtde);
            if (draggedNode == null) {
                return false;
            }
            BookmarkToolbar toolbar = this.getToolbarFromEvent(dtde);
            MapModel map = toolbar.getMap();
            return this.bookmarksController.createBookmarkFromNode(draggedNode, map, insertionIndex);
        }
        catch (Exception e) {
            return false;
        }
    }

    private NodeModel extractSingleNode(DropTargetDropEvent dtde) throws Exception {
        BookmarkToolbar toolbar = this.getToolbarFromEvent(dtde);
        return this.extractSingleNode(dtde.getTransferable(), toolbar);
    }

    private BookmarkToolbar getToolbarFromEvent(DropTargetEvent dte) {
        Component component = dte.getDropTargetContext().getComponent();
        if (component instanceof BookmarkToolbar) {
            return (BookmarkToolbar)((Object)component);
        }
        if (component instanceof BookmarkButton) {
            return (BookmarkToolbar)((Object)component.getParent());
        }
        Container parent = component.getParent();
        if (parent instanceof BookmarkToolbar) {
            return (BookmarkToolbar)((Object)parent);
        }
        throw new IllegalArgumentException("Event target is not associated with a BookmarkToolbar");
    }

    private NodeModel extractSingleNode(Transferable transferable, BookmarkToolbar toolbar) throws Exception {
        Collection draggedNodesCollection = (Collection)transferable.getTransferData(MindMapNodesSelection.mindMapNodeObjectsFlavor);
        ArrayList draggedNodes = new ArrayList(draggedNodesCollection);
        if (draggedNodes.size() != 1) {
            return null;
        }
        NodeModel draggedNode = (NodeModel)draggedNodes.get(0);
        MapModel nodeMap = draggedNode.getMap();
        MapModel toolbarMap = toolbar.getMap();
        return nodeMap != null && nodeMap.equals(toolbarMap) ? draggedNode : null;
    }

    private MapModel getMapFromButton(JButton targetButton) {
        BookmarkToolbar toolbar = (BookmarkToolbar)((Object)targetButton.getParent());
        return toolbar.getMap();
    }

    private int calculateInsertionIndex(NodeBookmark targetBookmark, boolean dropAfter, MapModel map) {
        List<NodeBookmark> currentBookmarks = this.bookmarksController.getBookmarks(map).getBookmarks();
        int targetIndex = this.bookmarksController.findBookmarkPosition(currentBookmarks, targetBookmark);
        return dropAfter ? targetIndex + 1 : targetIndex;
    }
}

