/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode.styleeditorpanel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.freeplane.api.LengthUnit;
import org.freeplane.core.resources.components.BooleanProperty;
import org.freeplane.core.resources.components.ComboProperty;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.QuantityProperty;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.nodestyle.NodeGeometryModel;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.nodestyle.NodeStyleShape;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroupChangeListener;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.RevertingProperty;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.StylePropertyAdjuster;

class NodeShapeControlGroup
implements ControlGroup {
    private static final String NODE_SHAPE = "nodeshape";
    private static final String SHAPE_HORIZONTAL_MARGIN = "shape_horizontal_margin";
    private static final String SHAPE_VERTICAL_MARGIN = "shape_vertical_margin";
    private static final String UNIFORM_SHAPE = "uniform_shape";
    private RevertingProperty mSetNodeShape;
    private ComboProperty mNodeShape;
    private QuantityProperty<LengthUnit> mShapeHorizontalMargin;
    private QuantityProperty<LengthUnit> mShapeVerticalMargin;
    private BooleanProperty mUniformShape;
    private NodeShapeChangeListener propertyChangeListener;
    private boolean canEdit;

    NodeShapeControlGroup() {
    }

    @Override
    public void addControlGroup(DefaultFormBuilder formBuilder) {
        this.mSetNodeShape = new RevertingProperty();
        this.mNodeShape = ComboProperty.of((String)NODE_SHAPE, NodeStyleShape.class);
        this.mShapeHorizontalMargin = new QuantityProperty(SHAPE_HORIZONTAL_MARGIN, 0.0, 1000.0, 0.1, (Enum)LengthUnit.pt);
        this.mShapeVerticalMargin = new QuantityProperty(SHAPE_VERTICAL_MARGIN, 0.0, 1000.0, 0.1, (Enum)LengthUnit.pt);
        this.mUniformShape = new BooleanProperty(UNIFORM_SHAPE);
        this.propertyChangeListener = new NodeShapeChangeListener(this.mSetNodeShape, new IPropertyControl[]{this.mNodeShape, this.mShapeHorizontalMargin, this.mShapeVerticalMargin, this.mUniformShape});
        this.mSetNodeShape.addPropertyChangeListener(this.propertyChangeListener);
        this.mNodeShape.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
        this.mShapeHorizontalMargin.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
        this.mShapeVerticalMargin.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
        this.mUniformShape.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
        this.mNodeShape.appendToForm(formBuilder);
        this.mSetNodeShape.appendToForm(formBuilder);
        this.mShapeHorizontalMargin.appendToForm(formBuilder);
        formBuilder.nextLine();
        this.mShapeVerticalMargin.appendToForm(formBuilder);
        formBuilder.nextLine();
        this.mUniformShape.appendToForm(formBuilder);
        formBuilder.nextLine();
    }

    @Override
    public void setStyle(NodeModel node, boolean canEdit) {
        this.canEdit = canEdit;
        this.propertyChangeListener.setStyle(node);
    }

    private void enableShapeConfigurationProperties(boolean enabled, NodeStyleShape shape) {
        boolean enableConfigurationProperties = enabled && shape.hasConfiguration && this.canEdit;
        this.mShapeHorizontalMargin.setEnabled(enableConfigurationProperties);
        this.mShapeVerticalMargin.setEnabled(enableConfigurationProperties);
        this.mUniformShape.setEnabled(enableConfigurationProperties);
    }

    private class NodeShapeChangeListener
    extends ControlGroupChangeListener {
        public NodeShapeChangeListener(RevertingProperty mSet, IPropertyControl ... mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            if (enabled) {
                styleController.setShapeConfiguration(node, NodeGeometryModel.NULL_SHAPE.withShape(NodeStyleShape.valueOf((String)NodeShapeControlGroup.this.mNodeShape.getValue())).withHorizontalMargin(NodeShapeControlGroup.this.mShapeHorizontalMargin.getQuantifiedValue()).withVerticalMargin(NodeShapeControlGroup.this.mShapeVerticalMargin.getQuantifiedValue()).withUniform(NodeShapeControlGroup.this.mUniformShape.getBooleanValue()));
            } else {
                styleController.setShapeConfiguration(node, NodeGeometryModel.NULL_SHAPE);
            }
            NodeStyleShape shape = styleController.getShape(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            NodeShapeControlGroup.this.enableShapeConfigurationProperties(enabled, shape);
        }

        @Override
        void setStyleOnExternalChange(NodeModel node) {
            NodeStyleController styleController = NodeStyleController.getController();
            NodeStyleShape shape = NodeStyleModel.getShape((NodeModel)node);
            boolean enabled = shape != null;
            NodeShapeControlGroup.this.mSetNodeShape.setValue(enabled);
            NodeGeometryModel viewShape = styleController.getShapeConfiguration(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            NodeShapeControlGroup.this.mNodeShape.setValue(viewShape.getShape().toString());
            NodeShapeControlGroup.this.mShapeHorizontalMargin.setQuantifiedValue(viewShape.getHorizontalMargin());
            NodeShapeControlGroup.this.mShapeVerticalMargin.setQuantifiedValue(viewShape.getVerticalMargin());
            NodeShapeControlGroup.this.mUniformShape.setValue(viewShape.isUniform());
        }

        @Override
        void adjustForStyle(NodeModel node) {
            NodeStyleController styleController = (NodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            NodeStyleShape shape = styleController.getShape(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            StylePropertyAdjuster.adjustPropertyControl(node, NodeShapeControlGroup.this.mSetNodeShape);
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)NodeShapeControlGroup.this.mNodeShape);
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)NodeShapeControlGroup.this.mShapeHorizontalMargin);
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)NodeShapeControlGroup.this.mShapeVerticalMargin);
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)NodeShapeControlGroup.this.mUniformShape);
            if (NodeShapeControlGroup.this.mNodeShape.isEnabled()) {
                NodeShapeControlGroup.this.enableShapeConfigurationProperties(true, shape);
            }
        }
    }
}

