/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.descriptor;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.commons.util.ToStringBuilder;

@API(status=API.Status.STABLE, since="1.0")
public class FilePosition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(FilePosition.class);
    private final int line;
    private final Integer column;

    public static FilePosition from(int line) {
        return new FilePosition(line);
    }

    public static FilePosition from(int line, int column) {
        return new FilePosition(line, column);
    }

    public static Optional<FilePosition> fromQuery(String query) {
        FilePosition result = null;
        Integer line = null;
        Integer column = null;
        if (StringUtils.isNotBlank((String)query)) {
            try {
                for (String pair : query.split("&")) {
                    String[] data = pair.split("=");
                    if (data.length == 2) {
                        String key = data[0];
                        if (line == null && "line".equals(key)) {
                            line = Integer.valueOf(data[1]);
                        } else if (column == null && "column".equals(key)) {
                            column = Integer.valueOf(data[1]);
                        }
                    }
                    if (line == null || column == null) {
                        continue;
                    }
                    break;
                }
            }
            catch (IllegalArgumentException ex) {
                logger.debug((Throwable)ex, () -> "Failed to parse 'line' and/or 'column' from query string: " + query);
            }
            if (line != null) {
                result = column == null ? new FilePosition(line) : new FilePosition(line, column);
            }
        }
        return Optional.ofNullable(result);
    }

    private FilePosition(int line) {
        Preconditions.condition((line > 0 ? 1 : 0) != 0, (String)"line number must be greater than zero");
        this.line = line;
        this.column = null;
    }

    private FilePosition(int line, int column) {
        Preconditions.condition((line > 0 ? 1 : 0) != 0, (String)"line number must be greater than zero");
        Preconditions.condition((column > 0 ? 1 : 0) != 0, (String)"column number must be greater than zero");
        this.line = line;
        this.column = column;
    }

    public int getLine() {
        return this.line;
    }

    public Optional<Integer> getColumn() {
        return Optional.ofNullable(this.column);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilePosition that = (FilePosition)o;
        return this.line == that.line && Objects.equals(this.column, that.column);
    }

    public int hashCode() {
        return Objects.hash(this.line, this.column);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("line", (Object)this.line).append("column", (Object)this.getColumn().orElse(-1)).toString();
    }
}

