/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Window;
import java.awt.dnd.DragSource;
import java.awt.event.MouseEvent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.FloatingWindow;
import net.infonode.docking.FocusManager;
import net.infonode.docking.RootWindow;
import net.infonode.docking.drag.DockingWindowDragger;
import net.infonode.docking.internalutil.DropAction;

class WindowDragger
implements DockingWindowDragger {
    private DockingWindow dragWindow;
    private DropAction dropAction;
    private RootWindow rootWindow;

    WindowDragger(DockingWindow dragWindow) {
        this(dragWindow, dragWindow.getRootWindow());
    }

    WindowDragger(DockingWindow dragWindow, RootWindow rootWindow) {
        this.dragWindow = dragWindow;
        this.rootWindow = rootWindow;
        rootWindow.internalStartDrag(dragWindow);
    }

    @Override
    public DockingWindow getDragWindow() {
        return this.dragWindow;
    }

    @Override
    public RootWindow getDropTarget() {
        return this.rootWindow;
    }

    void undoDrag(DropAction newAction) {
        if (this.dropAction != null) {
            this.dropAction.clear(this.dragWindow, newAction);
            this.dropAction = null;
        }
    }

    private void stopDrag() {
        this.rootWindow.stopDrag();
    }

    @Override
    public void abortDrag() {
        this.stopDrag();
        this.undoDrag(null);
    }

    @Override
    public void dropWindow(MouseEvent mouseEvent) {
        this.stopDrag();
        if (this.dropAction == null) {
            this.dropAction = this.dragWindow.getDefaultDropAction();
        }
        if (this.dragWindow != null && this.dropAction != null) {
            this.dropAction.execute(this.dragWindow, mouseEvent);
            Container c = this.dragWindow.getTopLevelAncestor();
            if (c != null && c instanceof Window) {
                ((Window)c).toFront();
            }
            FocusManager.focusWindow(this.dragWindow);
        }
    }

    @Override
    public void dragWindow(MouseEvent mouseEvent) {
        JRootPane root = this.rootWindow.getCurrentDragRootPane();
        Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), root);
        if (root != this.rootWindow.getRootPane() && !root.contains(point)) {
            this.rootWindow.setCurrentDragRootPane(null);
            root = this.rootWindow.getCurrentDragRootPane();
            point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), root);
        }
        DockingWindow dropWindow = this.getDeepestWindowAt(root, point.x, point.y);
        while (dropWindow != null && dropWindow.getWindowParent() != null && !(dropWindow instanceof FloatingWindow)) {
            Point p2 = SwingUtilities.convertPoint(root, point, dropWindow.getWindowParent());
            if (!dropWindow.getWindowParent().contains(p2)) break;
            dropWindow = dropWindow.getWindowParent();
        }
        DropAction da = dropWindow != null ? dropWindow.acceptDrop(SwingUtilities.convertPoint(root, point, dropWindow), this.dragWindow) : null;
        this.undoDrag(da);
        Cursor cursor = DragSource.DefaultMoveDrop;
        if (da == null) {
            cursor = DragSource.DefaultMoveNoDrop;
        }
        if (dropWindow == null && this.dragWindow.getWindowProperties().getUndockOnDropEnabled()) {
            cursor = DragSource.DefaultMoveDrop;
        }
        this.rootWindow.setDragCursor(cursor);
        this.rootWindow.setDragText(da == null || da.showTitle() ? point : null, this.dragWindow.getTitle());
        this.dropAction = da;
        if (this.dropAction == null) {
            this.rootWindow.setDragRectangle(null);
        }
    }

    private DockingWindow getDeepestWindowAt(Component component, int x, int y) {
        if (component == null || !component.isVisible() || !component.contains(x, y)) {
            return null;
        }
        if (component instanceof Container) {
            Component[] components = ((Container)component).getComponents();
            int i = 0;
            while (i < components.length) {
                DockingWindow w = this.getDeepestWindowAt(components[i], x - components[i].getX(), y - components[i].getY());
                if (w != null) {
                    return w;
                }
                ++i;
            }
        }
        if (component instanceof DockingWindow) {
            DockingWindow w = (DockingWindow)component;
            return w.getRootWindow() == this.rootWindow ? w : null;
        }
        return null;
    }
}

