/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.border;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import net.infonode.gui.UIManagerUtil;

public class FocusBorder
implements Border,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Insets INSETS = new Insets(1, 1, 1, 1);
    private final Component component;
    private boolean enabled = true;

    public FocusBorder(final Component focusComponent) {
        this.component = focusComponent;
        focusComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (FocusBorder.this.enabled) {
                    focusComponent.repaint();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (FocusBorder.this.enabled) {
                    focusComponent.repaint();
                }
            }
        });
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return INSETS;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.enabled) {
            this.enabled = enabled;
        }
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.enabled && this.component.hasFocus()) {
            g.setColor(UIManagerUtil.getColor("Button.focus", "TabbedPane.focus"));
            if (UIManager.getLookAndFeel().getClass().getName().equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel")) {
                BasicGraphicsUtils.drawDashedRect(g, x, y, width, height);
            } else {
                g.drawRect(x, y, width - 1, height - 1);
            }
        }
    }
}

