/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources;

import java.awt.event.ActionEvent;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.SelectableAction;
import org.freeplane.core.util.TextUtils;

@SelectableAction
public class SetStringPropertyAction
extends AFreeplaneAction {
    private String propertyName;
    private String propertyValue;
    private String property;

    public SetStringPropertyAction(String property) {
        super("SetStringPropertyAction." + property, TextUtils.getRawText("OptionPanel." + property), null);
        this.property = property;
        int separator = property.indexOf(46);
        this.propertyName = property.substring(0, separator);
        this.propertyValue = property.substring(separator + 1);
        this.setIcon(property + ".icon");
        this.setTooltip(this.getTooltipKey());
        this.setSelected();
        ResourceController.getResourceController().addPropertyChangeListener((String name, String newValue, String oldValue) -> {
            if (this.propertyName.equals(name)) {
                this.setSelected();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ResourceController.getResourceController().setProperty(this.propertyName, this.propertyValue);
    }

    @Override
    public String getTextKey() {
        return "OptionPanel." + this.property;
    }

    @Override
    public String getTooltipKey() {
        return this.getTextKey() + ".tooltip";
    }

    @Override
    public void setSelected() {
        this.setSelected(this.isPropertySelected());
    }

    public boolean isPropertySelected() {
        return this.propertyValue.equals(ResourceController.getResourceController().getProperty(this.propertyName, null));
    }
}

