/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.freeplane.core.ui.KeyAlreadyUsedException;
import org.freeplane.core.util.LogUtils;

public class IndexedTree {
    public static final int APPEND = 2;
    public static final int AFTER = 1;
    public static final int AS_CHILD = 0;
    public static final int BEFORE = -1;
    public static final int PREPEND = -2;
    private final HashMap<Object, Node> string2Element;

    public IndexedTree(Object root) {
        Node rootNode = new Node(root);
        this.string2Element = new HashMap();
        this.string2Element.put(this, rootNode);
    }

    public DefaultMutableTreeNode addElement(Object relativeKey, Object element, int position) {
        DefaultMutableTreeNode relativeNode = this.getNode(relativeKey);
        Node node = new Node(element);
        if (relativeNode == null) {
            return node;
        }
        this.addNode(relativeNode, node, position);
        return node;
    }

    public DefaultMutableTreeNode addElement(Object relativeKey, Object element, Object key, int position) {
        DefaultMutableTreeNode existingNode = this.get(key);
        if (existingNode != null) {
            throw new KeyAlreadyUsedException(key.toString() + " added twice");
        }
        DefaultMutableTreeNode relativeNode = this.getNode(relativeKey);
        if (relativeNode == null) {
            return null;
        }
        Node node = new Node(element, key);
        this.addNode(relativeNode, node, position);
        this.string2Element.put(key, node);
        return node;
    }

    protected void addNode(DefaultMutableTreeNode relativeNode, DefaultMutableTreeNode node, int position) {
        switch (position) {
            case 0: {
                relativeNode.add(node);
                break;
            }
            case -1: {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)relativeNode.getParent();
                if (parent == null) {
                    throw new RuntimeException("relative node has no parent element");
                }
                int index = parent.getIndex(relativeNode);
                parent.insert(node, index);
                break;
            }
            case 1: {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)relativeNode.getParent();
                if (parent == null) {
                    throw new RuntimeException("relative node has no parent element");
                }
                int index = parent.getIndex(relativeNode);
                parent.insert(node, index + 1);
                break;
            }
            case -2: {
                relativeNode.insert(node, 0);
                break;
            }
            case 2: {
                int idx = relativeNode.getChildCount() - 1;
                relativeNode.insert(node, idx + 1);
                break;
            }
            default: {
                throw new RuntimeException("wrong position");
            }
        }
    }

    public boolean contains(Object key) {
        return this.string2Element.containsKey(key);
    }

    public String dump() {
        return this.string2Element.toString();
    }

    public DefaultMutableTreeNode get(Object key) {
        Node object = this.string2Element.get(key);
        if (object == null) {
            return null;
        }
        return object;
    }

    public Object getKeyByUserObject(Object object) {
        Collection<Node> values = this.string2Element.values();
        for (Node node : values) {
            if (object == null || !object.equals(node.getUserObject())) continue;
            return node.getKey();
        }
        return null;
    }

    protected DefaultMutableTreeNode getNode(Object key) {
        DefaultMutableTreeNode node = this.string2Element.get(key);
        if (node == null) {
            LogUtils.warn(key + " not found");
        }
        return node;
    }

    public DefaultMutableTreeNode getRoot() {
        return this.string2Element.get(this);
    }

    public Collection<Object> getUserObjects() {
        return Collections.unmodifiableCollection(new UserObjects());
    }

    public Iterator<Object> newObjectIterator() {
        return new Iterator<Object>(){
            private final Iterator<Node> nodeIterator;
            {
                this.nodeIterator = IndexedTree.this.string2Element.values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.nodeIterator.hasNext();
            }

            @Override
            public Object next() {
                return this.nodeIterator.next().getUserObject();
            }

            @Override
            public void remove() {
                this.nodeIterator.remove();
            }
        };
    }

    public void removeChildElements(Object key) {
        DefaultMutableTreeNode node = this.getNode(key);
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            Node child = (Node)children.nextElement();
            Object childKey = child.getKey();
            if (childKey == null) continue;
            this.removeChildElements(childKey);
            this.string2Element.remove(childKey);
        }
        node.removeAllChildren();
    }

    protected void removeChildKeys(Node node) {
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            Node child = (Node)children.nextElement();
            this.string2Element.remove(child.getKey());
            this.removeChildKeys(child);
        }
    }

    public DefaultMutableTreeNode removeElement(Object key) {
        DefaultMutableTreeNode node = this.string2Element.remove(key);
        if (node != null) {
            this.removeChildKeys((Node)node);
        }
        return node;
    }

    public static class Node
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        private Object key;

        Node(Object userObject) {
            super(userObject);
        }

        Node(Object userObject, Object key) {
            this(userObject);
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }
    }

    private final class UserObjects
    extends AbstractCollection<Object> {
        private UserObjects() {
        }

        @Override
        public void clear() {
            IndexedTree.this.string2Element.clear();
        }

        @Override
        public boolean contains(Object o) {
            for (Object next : this) {
                if (o != null && o.equals(next)) {
                    return true;
                }
                if (next != null) continue;
                return true;
            }
            return false;
        }

        @Override
        public Iterator<Object> iterator() {
            return IndexedTree.this.newObjectIterator();
        }

        @Override
        public int size() {
            return IndexedTree.this.string2Element.size();
        }
    }
}

