/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.link.NodeLinkModel;
import org.freeplane.features.map.MapModel;

public class MapLinks
implements IExtension {
    private final HashMap<String, Set<NodeLinkModel>> links = new HashMap();

    public boolean add(NodeLinkModel link) {
        String targetID = link.getTargetID();
        Set<NodeLinkModel> set = this.links.get(targetID);
        if (set == null) {
            set = new HashSet<NodeLinkModel>();
            set.add(link);
            this.links.put(targetID, set);
            return true;
        }
        if (set.contains(link)) {
            return false;
        }
        set.add(link);
        return true;
    }

    public boolean containsTarget(String targetID) {
        return this.links.containsKey(targetID);
    }

    public Set<NodeLinkModel> get(String targetID) {
        if (targetID == null) {
            return null;
        }
        Set<NodeLinkModel> set = this.links.get(targetID);
        return set == null ? null : Collections.unmodifiableSet(set);
    }

    public boolean remove(NodeLinkModel link) {
        String targetID = link.getTargetID();
        Set<NodeLinkModel> set = this.links.get(targetID);
        if (set == null) {
            return false;
        }
        if (set.remove(link)) {
            if (set.isEmpty()) {
                this.links.remove(targetID);
            }
            return true;
        }
        return false;
    }

    public void set(String targetID, Set<NodeLinkModel> set) {
        this.links.put(targetID, set);
    }

    public static MapLinks getLinks(MapModel map) {
        return map.getExtension(MapLinks.class);
    }

    public static boolean hasLinks(MapModel map) {
        MapLinks mapLinks = map.getExtension(MapLinks.class);
        return mapLinks != null && mapLinks.getSize() > 0;
    }

    private int getSize() {
        return this.links.size();
    }
}

