/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.link;

import java.awt.Point;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.ConnectorShape;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.link.ConnectorView;

public class InclinationRecommender {
    private static final int LOOP_INCLINE_OFFSET = 45;
    private final LinkController linkController;
    private ConnectorModel connector;
    private final int recommendedLength;
    private final int recommendedHeight;
    private boolean selfLink;

    public InclinationRecommender(LinkController linkController, ConnectorView connectorView) {
        this.linkController = linkController;
        this.connector = connectorView.getConnector();
        NodeView source = connectorView.getSource();
        NodeView target = connectorView.getTarget();
        this.recommendedLength = !connectorView.isSourceVisible() || !connectorView.isTargetVisible() || source.equals(target) ? (int)(UITools.FONT_SCALE_FACTOR * 100.0f) : Math.max(40, (int)(source.getLinkPoint(null).distance(target.getLinkPoint(null)) / connectorView.getZoom()));
        this.recommendedHeight = (source != null && source.isContentVisible() ? source : target).getMainView().getHeight();
        this.selfLink = source == target;
    }

    public Point calcStartInclination() {
        Point startInclinationByStyle = this.linkController.getStartInclination(this.connector);
        if (startInclinationByStyle != null) {
            return startInclinationByStyle;
        }
        if (MapStyleModel.isStyleNode(this.connector.getSource())) {
            boolean hasLineShape = this.linkController.getShape(this.connector) == ConnectorShape.LINE;
            int y = hasLineShape ? 0 : -this.recommendedHeight / 2;
            return new Point(this.recommendedLength, y);
        }
        return new Point(this.recommendedLength, 0);
    }

    private void fixInclineIfLoopNode(Point endIncline) {
        if (!MapStyleModel.isStyleNode(this.connector.getSource())) {
            endIncline.y += 45;
        }
    }

    public Point calcEndInclination() {
        Point endInclinationByStyle = this.linkController.getEndInclination(this.connector);
        if (endInclinationByStyle != null) {
            return endInclinationByStyle;
        }
        Point startInclination = this.calcStartInclination();
        Point endInclination = new Point(startInclination.x, -startInclination.y);
        if (this.selfLink) {
            this.fixInclineIfLoopNode(endInclination);
        }
        return endInclination;
    }
}

