import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Box, Text } from 'ink';
import { theme } from '../semantic-colors.js';
import {} from '@google/gemini-cli-core';
import { useTerminalSize } from '../hooks/useTerminalSize.js';
import { isNarrowWidth } from '../utils/isNarrowWidth.js';
export const ContextSummaryDisplay = ({ geminiMdFileCount, contextFileNames, mcpServers, blockedMcpServers, showToolDescriptions, ideContext, }) => {
    const { columns: terminalWidth } = useTerminalSize();
    const isNarrow = isNarrowWidth(terminalWidth);
    const mcpServerCount = Object.keys(mcpServers || {}).length;
    const blockedMcpServerCount = blockedMcpServers?.length || 0;
    const openFileCount = ideContext?.workspaceState?.openFiles?.length ?? 0;
    if (geminiMdFileCount === 0 &&
        mcpServerCount === 0 &&
        blockedMcpServerCount === 0 &&
        openFileCount === 0) {
        return _jsx(Text, { children: " " }); // Render an empty space to reserve height
    }
    const openFilesText = (() => {
        if (openFileCount === 0) {
            return '';
        }
        return `${openFileCount} open file${openFileCount > 1 ? 's' : ''} (ctrl+g to view)`;
    })();
    const geminiMdText = (() => {
        if (geminiMdFileCount === 0) {
            return '';
        }
        const allNamesTheSame = new Set(contextFileNames).size < 2;
        const name = allNamesTheSame ? contextFileNames[0] : 'context';
        return `${geminiMdFileCount} ${name} file${geminiMdFileCount > 1 ? 's' : ''}`;
    })();
    const mcpText = (() => {
        if (mcpServerCount === 0 && blockedMcpServerCount === 0) {
            return '';
        }
        const parts = [];
        if (mcpServerCount > 0) {
            parts.push(`${mcpServerCount} MCP server${mcpServerCount > 1 ? 's' : ''}`);
        }
        if (blockedMcpServerCount > 0) {
            let blockedText = `${blockedMcpServerCount} Blocked`;
            if (mcpServerCount === 0) {
                blockedText += ` MCP server${blockedMcpServerCount > 1 ? 's' : ''}`;
            }
            parts.push(blockedText);
        }
        let text = parts.join(', ');
        // Add ctrl+t hint when MCP servers are available
        if (mcpServers && Object.keys(mcpServers).length > 0) {
            if (showToolDescriptions) {
                text += ' (ctrl+t to toggle)';
            }
            else {
                text += ' (ctrl+t to view)';
            }
        }
        return text;
    })();
    const summaryParts = [openFilesText, geminiMdText, mcpText].filter(Boolean);
    if (isNarrow) {
        return (_jsxs(Box, { flexDirection: "column", children: [_jsx(Text, { color: theme.text.secondary, children: "Using:" }), summaryParts.map((part, index) => (_jsxs(Text, { color: theme.text.secondary, children: ['  ', "- ", part] }, index)))] }));
    }
    return (_jsx(Box, { children: _jsxs(Text, { color: theme.text.secondary, children: ["Using: ", summaryParts.join(' | ')] }) }));
};
//# sourceMappingURL=ContextSummaryDisplay.js.map