/*
 * Decompiled with CFR 0.152.
 */
package io.sf.jclf.text.format;

import io.sf.jclf.text.format.ObjectFormat;
import io.sf.jclf.text.format.SpecParsingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;

public class TemplateDateFormat
extends ObjectFormat {
    private static final DateFormat DEFAULT_FORMAT = new SimpleDateFormat("dd/MMM/yyyy");
    private DateFormat df = DEFAULT_FORMAT;
    private String formatSpec = "dd/MMM/yyyy";

    public TemplateDateFormat() {
        this.precision = 0;
    }

    @Override
    protected char setFormat(String string) throws SpecParsingException {
        char c = super.setFormat(string);
        this.formatSpec = string;
        return c;
    }

    @Override
    protected void setFlags(char[] cArray) {
        if (cArray != null) {
            String string;
            if (cArray[0] == '-') {
                this.ralign = false;
                string = new String(cArray, 1, cArray.length - 1);
            } else {
                string = new String(cArray);
            }
            this.df = new SimpleDateFormat(string);
        }
    }

    @Override
    public String format(Object object) {
        if (!(object instanceof Date)) {
            throw new IllegalArgumentException("Argument must be a Date");
        }
        return this.df.format((Date)object);
    }

    public DateFormat getDateFormat() {
        return this.df;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(20);
        stringBuilder.append(this.formatSpec).append("D");
        return stringBuilder.toString();
    }

    @Override
    public Object sample() {
        return new Date(new Random().nextLong());
    }
}

