/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.KernSubtableFormat0;
import jogamp.graph.font.typecast.ot.table.KernSubtableFormat2;
import jogamp.graph.font.typecast.ot.table.KerningPair;

public abstract class KernSubtable {
    private final int version;
    private final int length;
    private final int coverage;

    KernSubtable(int n, int n2, int n3) {
        this.version = n;
        this.length = n2;
        this.coverage = n3;
    }

    public final int getVersion() {
        return this.version;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getCoverage() {
        return this.coverage;
    }

    public final int getSubtableFormat() {
        return this.coverage >> 8;
    }

    public final boolean isHorizontal() {
        return 0 != (this.coverage & 1);
    }

    public final boolean areKerningValues() {
        return 0 == (this.coverage & 2);
    }

    public final boolean isCrossstream() {
        return 0 != (this.coverage & 4);
    }

    public final boolean isOverride() {
        return 0 != (this.coverage & 8);
    }

    public abstract int getKerningPairCount();

    public abstract KerningPair getKerningPair(int var1);

    public abstract void clearKerningPairs();

    public static KernSubtable read(DataInput dataInput) throws IOException {
        KernSubtable kernSubtable = null;
        int n = dataInput.readUnsignedShort();
        int n2 = dataInput.readUnsignedShort();
        int n3 = dataInput.readUnsignedShort();
        int n4 = n3 >> 8;
        switch (n4) {
            case 0: {
                kernSubtable = new KernSubtableFormat0(n, n2, n3, dataInput);
                break;
            }
            case 2: {
                kernSubtable = new KernSubtableFormat2(n, n2, n3, dataInput);
                break;
            }
        }
        return kernSubtable;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("'kern' Sub-Table\n--------------------------").append("\n    version:  ").append(this.version).append("\n    length:   ").append(this.length).append("\n    coverage: 0x").append(Integer.toHexString(this.coverage)).append("[").append("\n      format: ").append(this.getSubtableFormat()).append("\n      horizontal: ").append(this.isHorizontal()).append("\n      kerningVal: ").append(this.areKerningValues()).append("\n      crossstream: ").append(this.isCrossstream()).append("\n      override: ").append(this.isOverride()).append("]");
        return stringBuilder.toString();
    }
}

