/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInputStream;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.Coverage;
import jogamp.graph.font.typecast.ot.table.SingleSubst;

public class SingleSubstFormat2
extends SingleSubst {
    private final int _coverageOffset;
    private final int _glyphCount;
    private final int[] _substitutes;
    private final Coverage _coverage;

    SingleSubstFormat2(DataInputStream dataInputStream, int n) throws IOException {
        this._coverageOffset = dataInputStream.readUnsignedShort();
        this._glyphCount = dataInputStream.readUnsignedShort();
        this._substitutes = new int[this._glyphCount];
        for (int i = 0; i < this._glyphCount; ++i) {
            this._substitutes[i] = dataInputStream.readUnsignedShort();
        }
        dataInputStream.reset();
        dataInputStream.skipBytes(n + this._coverageOffset);
        this._coverage = Coverage.read(dataInputStream);
    }

    @Override
    public int getFormat() {
        return 2;
    }

    @Override
    public int substitute(int n) {
        int n2 = this._coverage.findGlyph(n);
        if (n2 > -1) {
            return this._substitutes[n2];
        }
        return n;
    }

    @Override
    public String getTypeAsString() {
        return "SingleSubstFormat2";
    }

    public String toString() {
        int[] nArray;
        StringBuilder stringBuilder = new StringBuilder();
        for (int n : nArray = this._coverage.getGlyphIds()) {
            int n2 = this._coverage.findGlyph(n);
            if (n2 <= -1) continue;
            stringBuilder.append(String.format("%d = %d\n", n, this._substitutes[n2]));
        }
        return stringBuilder.toString();
    }
}

