/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.anim.dom;

import io.sf.carte.echosvg.anim.dom.SVGOMElement;
import io.sf.carte.echosvg.dom.AbstractDocument;
import io.sf.carte.echosvg.dom.util.DOMUtilities;
import io.sf.carte.echosvg.util.XBLConstants;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public abstract class XBLOMElement
extends SVGOMElement
implements XBLConstants {
    private static final long serialVersionUID = 1L;

    protected XBLOMElement() {
    }

    protected XBLOMElement(String string, AbstractDocument abstractDocument) {
        this.ownerDocument = abstractDocument;
        this.setPrefix(string);
    }

    @Override
    public String getNodeName() {
        if (this.prefix == null || this.prefix.equals("")) {
            return this.getLocalName();
        }
        return this.prefix + ':' + this.getLocalName();
    }

    @Override
    public String getNamespaceURI() {
        return "http://www.w3.org/2004/xbl";
    }

    @Override
    public void setPrefix(String string) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{(int)this.getNodeType(), this.getNodeName()});
        }
        if (string != null && !string.equals("") && !DOMUtilities.isValidName((String)string)) {
            throw this.createDOMException((short)5, "prefix", new Object[]{(int)this.getNodeType(), this.getNodeName(), string});
        }
        this.prefix = string;
    }

    @Override
    protected Node export(Node node, AbstractDocument abstractDocument) {
        super.export(node, abstractDocument);
        XBLOMElement xBLOMElement = (XBLOMElement)((Object)node);
        xBLOMElement.prefix = this.prefix;
        return node;
    }

    @Override
    protected Node deepExport(Node node, AbstractDocument abstractDocument) {
        super.deepExport(node, abstractDocument);
        XBLOMElement xBLOMElement = (XBLOMElement)((Object)node);
        xBLOMElement.prefix = this.prefix;
        return node;
    }

    @Override
    protected Node copyInto(Node node) {
        super.copyInto(node);
        XBLOMElement xBLOMElement = (XBLOMElement)((Object)node);
        xBLOMElement.prefix = this.prefix;
        return node;
    }

    @Override
    protected Node deepCopyInto(Node node) {
        super.deepCopyInto(node);
        XBLOMElement xBLOMElement = (XBLOMElement)((Object)node);
        xBLOMElement.prefix = this.prefix;
        return node;
    }
}

