/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.util;

import io.sf.carte.echosvg.util.ApplicationSecurityEnforcer;
import io.sf.carte.echosvg.util.EchoSVGSecurityManager;
import io.sf.carte.echosvg.util.Messages;
import java.net.URL;
import java.security.Policy;
import java.util.StringTokenizer;

@Deprecated
class SMApplicationSecurityEnforcer
extends ApplicationSecurityEnforcer {
    private static final String EXCEPTION_ALIEN_SECURITY_MANAGER = "ApplicationSecurityEnforcer.message.security.exception.alien.security.manager";
    private static final String PROPERTY_JAVA_SECURITY_POLICY = "java.security.policy";
    private static final String JAR_PROTOCOL = "jar:";
    private static final String JAR_URL_FILE_SEPARATOR = "!/";
    private static final String DEV_GRADLE_CLASS_DIR = "/build/classes/java/main/";
    private static final String DEV_GRADLE_TEST_CLASS_DIR = "/build/classes/java/test/";
    private static final String DEV_ECLIPSE_CLASS_DIR = "/bin/main/";
    private static final String DEV_ECLIPSE_TEST_CLASS_DIR = "/bin/test/";
    private String appMainClassRelativeURL;
    private EchoSVGSecurityManager lastSecurityManagerInstalled;
    private SecurityManager previousSecurityManagerInstalled = null;

    public SMApplicationSecurityEnforcer(Class<?> clazz, String string) {
        super(clazz, string);
        this.appMainClassRelativeURL = clazz.getName().replace('.', '/') + ".class";
    }

    @Override
    public void enforceSecurity(boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (!bl && securityManager != null && securityManager != this.lastSecurityManagerInstalled && securityManager != this.previousSecurityManagerInstalled) {
            throw new SecurityException(Messages.getString(EXCEPTION_ALIEN_SECURITY_MANAGER));
        }
        if (bl) {
            System.setSecurityManager(null);
            this.previousSecurityManagerInstalled = securityManager;
            this.installSecurityManager();
        } else if (securityManager != null) {
            System.setSecurityManager(this.previousSecurityManagerInstalled);
            this.lastSecurityManagerInstalled = null;
            this.previousSecurityManagerInstalled = null;
        }
    }

    @Override
    public URL getPolicyURL() {
        ClassLoader classLoader = this.getApplicationMainClass().getClassLoader();
        URL uRL = classLoader.getResource(this.getSecurityPolicy());
        if (uRL == null) {
            throw new NullPointerException(Messages.formatMessage("ApplicationSecurityEnforcer.message.null.pointer.exception.no.policy.file", new Object[]{this.getSecurityPolicy()}));
        }
        return uRL;
    }

    @Override
    public void installSecurityManager() {
        URL uRL;
        Policy policy = Policy.getPolicy();
        EchoSVGSecurityManager echoSVGSecurityManager = new EchoSVGSecurityManager();
        ClassLoader classLoader = this.getApplicationMainClass().getClassLoader();
        String string = System.getProperty(PROPERTY_JAVA_SECURITY_POLICY);
        if (string == null || string.equals("")) {
            uRL = this.getPolicyURL();
            System.setProperty(PROPERTY_JAVA_SECURITY_POLICY, uRL.toString());
        }
        if ((uRL = classLoader.getResource(this.appMainClassRelativeURL)) == null) {
            throw new RuntimeException(this.appMainClassRelativeURL);
        }
        String string2 = uRL.toString();
        if (string2.startsWith(JAR_PROTOCOL)) {
            this.setJarBase(string2);
        } else {
            this.setDevProperties(string2);
        }
        String string3 = System.getenv("GRADLE_USER_HOME");
        if (string3 == null) {
            string3 = System.getProperty("user.home") + "/.gradle";
        }
        System.setProperty("gradle.user.home", string3);
        System.setSecurityManager(echoSVGSecurityManager);
        this.lastSecurityManagerInstalled = echoSVGSecurityManager;
        policy.refresh();
        if (string == null || string.equals("")) {
            System.setProperty(PROPERTY_JAVA_SECURITY_POLICY, "");
        }
    }

    private void setJarBase(String string) {
        String string2 = System.getProperty("app.jar.base");
        if (string2 == null) {
            int n = (string = string.substring(JAR_PROTOCOL.length())).indexOf(JAR_URL_FILE_SEPARATOR + this.appMainClassRelativeURL);
            if (n == -1) {
                throw new RuntimeException("Unable to derive app.jar.base from: " + string);
            }
            String string3 = string.substring(0, n);
            string3 = (n = string3.lastIndexOf(47)) == -1 ? "" : string3.substring(0, n);
            System.setProperty("app.jar.base", string3);
        }
    }

    private void setDevProperties(String string) {
        String string2 = System.getProperty("app.dev.base");
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (string2 == null) {
            int n = string.lastIndexOf(DEV_GRADLE_CLASS_DIR + this.appMainClassRelativeURL);
            if (n == -1) {
                n = string.lastIndexOf(DEV_GRADLE_TEST_CLASS_DIR + this.appMainClassRelativeURL);
            }
            if (n == -1) {
                n = string.lastIndexOf(DEV_ECLIPSE_CLASS_DIR + this.appMainClassRelativeURL);
                if (n == -1) {
                    n = string.lastIndexOf(DEV_ECLIPSE_TEST_CLASS_DIR + this.appMainClassRelativeURL);
                }
                string3 = DEV_ECLIPSE_CLASS_DIR;
                string4 = DEV_ECLIPSE_TEST_CLASS_DIR;
                string5 = SMApplicationSecurityEnforcer.getIDEClassDir();
            } else {
                string3 = DEV_GRADLE_CLASS_DIR;
                string4 = DEV_GRADLE_TEST_CLASS_DIR;
            }
            if (n == -1 || (n = string.substring(0, n).lastIndexOf(47)) == -1) {
                throw new RuntimeException("Unable to derive app.dev.base from: " + string);
            }
            String string6 = string.substring(5, n);
            if (string5 != null) {
                System.setProperty("app.ide.classdir", string5);
            }
            System.setProperty("app.dev.base", string6);
            System.setProperty("app.dev.classdir", string3);
            System.setProperty("app.dev.testdir", string4);
        }
    }

    private static String getIDEClassDir() {
        String string = System.getProperty("java.class.path");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf("org.eclipse.osgi");
            if (n == -1) continue;
            return string2.substring(0, n + 16);
        }
        return null;
    }
}

