/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Closeable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class IteratorLikeIterable
implements Iterable<Object>,
Closeable {
    private final Context cx;
    private final Scriptable scope;
    private final Callable next;
    private final Callable returnFunc;
    private final Scriptable iterator;
    private boolean closed;

    public IteratorLikeIterable(Context context, Scriptable scriptable, Object object) {
        this.cx = context;
        this.scope = scriptable;
        this.next = ScriptRuntime.getPropFunctionAndThis(object, "next", context, scriptable);
        this.iterator = ScriptRuntime.lastStoredScriptable(context);
        Object object2 = ScriptRuntime.getObjectPropNoWarn(object, "return", context, scriptable);
        if (object2 != null && !Undefined.isUndefined(object2)) {
            if (!(object2 instanceof Callable)) {
                throw ScriptRuntime.notFunctionError(object, object2, "return");
            }
            this.returnFunc = (Callable)object2;
        } else {
            this.returnFunc = null;
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.returnFunc != null) {
                this.returnFunc.call(this.cx, this.scope, this.iterator, ScriptRuntime.emptyArgs);
            }
        }
    }

    public Itr iterator() {
        return new Itr();
    }

    public final class Itr
    implements Iterator<Object> {
        private Object nextVal;
        private boolean isDone;

        @Override
        public boolean hasNext() {
            if (this.isDone) {
                return false;
            }
            Object object = IteratorLikeIterable.this.next.call(IteratorLikeIterable.this.cx, IteratorLikeIterable.this.scope, IteratorLikeIterable.this.iterator, ScriptRuntime.emptyArgs);
            Object object2 = ScriptableObject.getProperty(ScriptableObject.ensureScriptable(object), "done");
            if (object2 == Scriptable.NOT_FOUND) {
                object2 = Undefined.instance;
            }
            if (ScriptRuntime.toBoolean(object2)) {
                this.isDone = true;
                return false;
            }
            this.nextVal = ScriptRuntime.getObjectPropNoWarn(object, "value", IteratorLikeIterable.this.cx, IteratorLikeIterable.this.scope);
            return true;
        }

        @Override
        public Object next() {
            if (this.isDone) {
                throw new NoSuchElementException();
            }
            return this.nextVal;
        }

        public boolean isDone() {
            return this.isDone;
        }

        public void setDone(boolean bl) {
            this.isDone = bl;
        }
    }
}

