/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSMediaException;
import io.sf.carte.doc.style.css.CSSRule;
import io.sf.carte.doc.style.css.CSSStyleSheet;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.AbstractErrorHandler;
import java.util.WeakHashMap;
import org.w3c.dom.Node;

class StandAloneErrorHandler
extends AbstractErrorHandler {
    private static final long serialVersionUID = 1L;
    private static final WeakHashMap<AbstractCSSStyleSheet, StandAloneErrorHandler> handlerMap = new WeakHashMap(4);
    private boolean errors = false;
    private boolean warnings = false;

    static StandAloneErrorHandler getInstance(AbstractCSSStyleSheet abstractCSSStyleSheet) {
        StandAloneErrorHandler standAloneErrorHandler = handlerMap.get(abstractCSSStyleSheet);
        if (standAloneErrorHandler == null) {
            standAloneErrorHandler = new StandAloneErrorHandler();
            handlerMap.put(abstractCSSStyleSheet, standAloneErrorHandler);
        }
        return standAloneErrorHandler;
    }

    private StandAloneErrorHandler() {
    }

    @Override
    public boolean hasComputedStyleErrors(CSSElement cSSElement) {
        return false;
    }

    @Override
    public boolean hasErrors() {
        return this.errors || super.hasErrors();
    }

    @Override
    public boolean hasWarnings() {
        return this.warnings || super.hasWarnings();
    }

    @Override
    public void linkedStyleError(Node node, String string) {
        this.errors = true;
    }

    @Override
    public void mediaQueryError(Node node, CSSMediaException cSSMediaException) {
        this.errors = true;
        throw new IllegalStateException("Media query error.", cSSMediaException);
    }

    @Override
    public void linkedSheetError(Exception exception, CSSStyleSheet<? extends CSSRule> cSSStyleSheet) {
        this.errors = true;
        throw new IllegalStateException(exception);
    }

    @Override
    public StyleDeclarationErrorHandler getInlineStyleErrorHandler(CSSElement cSSElement) {
        return null;
    }

    @Override
    public void inlineStyleError(CSSElement cSSElement, Exception exception, String string) {
        this.errors = true;
        IllegalStateException illegalStateException = new IllegalStateException("Error in context: " + string, exception);
        throw illegalStateException;
    }

    @Override
    public void reset() {
        this.errors = true;
        this.warnings = false;
        super.reset();
    }

    @Override
    protected AbstractCSSStyleSheetFactory getStyleSheetFactory() {
        return null;
    }
}

