/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.DOMNullCharacterException;
import io.sf.carte.doc.style.css.BooleanCondition;
import io.sf.carte.doc.style.css.BooleanConditionFactory;
import io.sf.carte.doc.style.css.CSSRule;
import io.sf.carte.doc.style.css.CSSUnit;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.MediaFeaturePredicate;
import io.sf.carte.doc.style.css.MediaQueryFactory;
import io.sf.carte.doc.style.css.MediaQueryHandler;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.SupportsConditionFactory;
import io.sf.carte.doc.style.css.UnitStringToId;
import io.sf.carte.doc.style.css.impl.CSSUtil;
import io.sf.carte.doc.style.css.nsac.AttributeCondition;
import io.sf.carte.doc.style.css.nsac.CSSBudgetException;
import io.sf.carte.doc.style.css.nsac.CSSErrorHandler;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.CSSHandler;
import io.sf.carte.doc.style.css.nsac.CSSMediaParseException;
import io.sf.carte.doc.style.css.nsac.CSSNamespaceParseException;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.CombinatorCondition;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.ConditionalSelector;
import io.sf.carte.doc.style.css.nsac.DeclarationPredicate;
import io.sf.carte.doc.style.css.nsac.InputSource;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.nsac.Locator;
import io.sf.carte.doc.style.css.nsac.PageSelectorList;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.nsac.ParserControl;
import io.sf.carte.doc.style.css.nsac.Selector;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.nsac.SheetContext;
import io.sf.carte.doc.style.css.nsac.SimpleSelector;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.parser.AbstractPageSelector;
import io.sf.carte.doc.style.css.parser.AnBExpression;
import io.sf.carte.doc.style.css.parser.CombinatorConditionImpl;
import io.sf.carte.doc.style.css.parser.ConditionalSelectorImpl;
import io.sf.carte.doc.style.css.parser.FunctionFactories;
import io.sf.carte.doc.style.css.parser.LangConditionImpl;
import io.sf.carte.doc.style.css.parser.LexicalUnitImpl;
import io.sf.carte.doc.style.css.parser.LocatorImpl;
import io.sf.carte.doc.style.css.parser.MediaQueryDatabase;
import io.sf.carte.doc.style.css.parser.NSACMediaQueryFactory;
import io.sf.carte.doc.style.css.parser.NSACSelectorFactory;
import io.sf.carte.doc.style.css.parser.PageSelectorListImpl;
import io.sf.carte.doc.style.css.parser.PageTypeSelector;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.parser.PositionalConditionImpl;
import io.sf.carte.doc.style.css.parser.PseudoConditionImpl;
import io.sf.carte.doc.style.css.parser.PseudoPageSelector;
import io.sf.carte.doc.style.css.parser.SelectorArgumentConditionImpl;
import io.sf.carte.doc.style.css.parser.SelectorListImpl;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.parser.SyntaxUnitImpl;
import io.sf.carte.doc.style.css.property.ShorthandDatabase;
import io.sf.carte.uparser.TokenControl;
import io.sf.carte.uparser.TokenHandler2;
import io.sf.carte.uparser.TokenHandler3;
import io.sf.carte.uparser.TokenProducer;
import io.sf.carte.util.agent.AgentUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.StringTokenizer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class CSSParser
implements Parser,
Cloneable {
    private CSSHandler handler;
    private CSSErrorHandler errorHandler;
    private final EnumSet<Parser.Flag> parserFlags;
    private int streamSizeLimit = 0x6000000;

    public CSSParser() {
        this.parserFlags = EnumSet.noneOf(Parser.Flag.class);
        this.handler = null;
        this.errorHandler = null;
    }

    public CSSParser(EnumSet<Parser.Flag> enumSet) {
        this.parserFlags = enumSet;
    }

    protected CSSParser(CSSParser cSSParser) {
        this.parserFlags = cSSParser.parserFlags;
        this.handler = cSSParser.handler;
        this.errorHandler = cSSParser.errorHandler;
    }

    @Override
    public void setDocumentHandler(CSSHandler cSSHandler) {
        this.handler = cSSHandler;
    }

    @Override
    public void setErrorHandler(CSSErrorHandler cSSErrorHandler) {
        this.errorHandler = cSSErrorHandler;
    }

    @Override
    public void setFlag(Parser.Flag flag) {
        this.parserFlags.add(flag);
    }

    @Override
    public void unsetFlag(Parser.Flag flag) {
        this.parserFlags.remove((Object)flag);
    }

    public void setStreamSizeLimit(int n) {
        if (n < 65536) {
            throw new IllegalArgumentException("Limit too low.");
        }
        this.streamSizeLimit = n;
    }

    @Override
    public void parseStyleSheet(Reader reader) throws CSSParseException, IOException, IllegalStateException {
        int[] nArray = new int[]{45, 95};
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        Parser.NamespaceMap namespaceMap = null;
        if (this.handler instanceof Parser.NamespaceMap) {
            namespaceMap = (Parser.NamespaceMap)((Object)this.handler);
        }
        SheetTokenHandler sheetTokenHandler = new SheetTokenHandler(namespaceMap, true);
        TokenProducer tokenProducer = new TokenProducer((TokenHandler2)sheetTokenHandler, nArray, this.streamSizeLimit);
        tokenProducer.setAcceptEofEndingQuoted(true);
        this.handler.parseStart(sheetTokenHandler);
        tokenProducer.parse(reader, "/*", "*/");
    }

    @Override
    public void parseStyleSheet(String string) throws CSSParseException, IOException, IllegalStateException {
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        URL uRL = new URL(string);
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setConnectTimeout(15000);
        uRLConnection.connect();
        InputStream inputStream = uRLConnection.getInputStream();
        inputStream = new BufferedInputStream(inputStream);
        String string2 = uRLConnection.getContentEncoding();
        String string3 = uRLConnection.getContentType();
        if (CSSUtil.isInvalidCSSContentType(uRL, string3) && !this.isRedirect(uRLConnection)) {
            String string4;
            if (string3 != null) {
                string3 = string3.replaceAll("\\p{Cc}", "*CTRL*");
                string4 = "Style sheet at " + uRL.toExternalForm() + " served with invalid type (" + string3 + ").";
            } else {
                string4 = "Style sheet at " + uRL.toExternalForm() + " has no valid content type.";
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new IOException(string4);
        }
        Parser.NamespaceMap namespaceMap = null;
        if (this.handler instanceof Parser.NamespaceMap) {
            namespaceMap = (Parser.NamespaceMap)((Object)this.handler);
        }
        SheetTokenHandler sheetTokenHandler = new SheetTokenHandler(namespaceMap, false);
        int[] nArray = new int[]{45, 95};
        TokenProducer tokenProducer = new TokenProducer((TokenHandler2)sheetTokenHandler, nArray, this.streamSizeLimit);
        tokenProducer.setAcceptEofEndingQuoted(true);
        try (Reader reader = AgentUtil.inputStreamToReader((InputStream)inputStream, (String)string3, (String)string2, (Charset)StandardCharsets.UTF_8);){
            this.handler.parseStart(sheetTokenHandler);
            tokenProducer.parse(reader, "/*", "*/");
        }
    }

    private boolean isRedirect(URLConnection uRLConnection) {
        if (uRLConnection instanceof HttpURLConnection) {
            try {
                int n = ((HttpURLConnection)uRLConnection).getResponseCode();
                return n > 300 && n < 400 && n != 304;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void parseStyleSheet(InputSource inputSource) throws CSSParseException, IOException, IllegalStateException, IllegalArgumentException {
        Object object;
        Object object2;
        if (inputSource == null) {
            throw new NullPointerException("Null source.");
        }
        Reader reader = inputSource.getCharacterStream();
        if (reader == null) {
            object2 = inputSource.getByteStream();
            if (object2 == null) {
                String string = inputSource.getURI();
                if (string == null) {
                    throw new IllegalArgumentException("Null character stream");
                }
                this.parseStyleSheet(string);
                return;
            }
            object = inputSource.getEncoding();
            if (object == null) {
                object = "UTF-8";
            }
            reader = new InputStreamReader((InputStream)object2, (String)object);
        }
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        object2 = new int[]{45, 95};
        object = null;
        if (this.handler instanceof Parser.NamespaceMap) {
            object = (Parser.NamespaceMap)((Object)this.handler);
        }
        SheetTokenHandler sheetTokenHandler = new SheetTokenHandler((Parser.NamespaceMap)object, true);
        TokenProducer tokenProducer = new TokenProducer((TokenHandler2)sheetTokenHandler, (int[])object2, this.streamSizeLimit);
        tokenProducer.setAcceptEofEndingQuoted(true);
        this.handler.parseStart(sheetTokenHandler);
        tokenProducer.parse(reader, "/*", "*/");
    }

    @Override
    public void parseStyleDeclaration(Reader reader) throws CSSParseException, IOException, IllegalStateException {
        int[] nArray = new int[]{45, 95};
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        DeclarationTokenHandler declarationTokenHandler = new DeclarationTokenHandler(ShorthandDatabase.getInstance());
        TokenProducer tokenProducer = new TokenProducer((TokenHandler2)declarationTokenHandler, nArray, this.streamSizeLimit);
        this.handler.parseStart(declarationTokenHandler);
        tokenProducer.parse(reader, "/*", "*/");
    }

    public void parseStyleDeclaration(InputSource inputSource) throws CSSException, IOException, IllegalStateException {
        int[] nArray = new int[]{45, 95};
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        DeclarationTokenHandler declarationTokenHandler = new DeclarationTokenHandler(ShorthandDatabase.getInstance());
        TokenProducer tokenProducer = new TokenProducer((TokenHandler2)declarationTokenHandler, nArray, this.streamSizeLimit);
        Reader reader = this.getReaderFromSource(inputSource);
        this.handler.parseStart(declarationTokenHandler);
        tokenProducer.parse(reader, "/*", "*/");
    }

    private Reader getReaderFromSource(InputSource inputSource) throws IOException {
        if (inputSource == null) {
            throw new NullPointerException("Null source.");
        }
        Reader reader = inputSource.getCharacterStream();
        if (reader == null) {
            InputStream inputStream = inputSource.getByteStream();
            if (inputStream != null) {
                String string = inputSource.getEncoding();
                Charset charset = string == null ? StandardCharsets.UTF_8 : Charset.forName(string);
                reader = new InputStreamReader(inputStream, charset);
            } else {
                String string = inputSource.getURI();
                if (string != null) {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    uRLConnection.setConnectTimeout(30000);
                    uRLConnection.connect();
                    inputStream = uRLConnection.getInputStream();
                    inputStream = new BufferedInputStream(inputStream);
                    String string2 = uRLConnection.getContentEncoding();
                    String string3 = uRLConnection.getContentType();
                    String string4 = inputSource.getEncoding();
                    Charset charset = string4 == null ? StandardCharsets.UTF_8 : Charset.forName(string4);
                    reader = AgentUtil.inputStreamToReader((InputStream)inputStream, (String)string3, (String)string2, (Charset)charset);
                }
            }
        }
        return reader;
    }

    public void parseDeclarationRule(Reader reader) throws CSSParseException, IOException {
        int[] nArray = new int[]{45, 95};
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        if (!(this.handler instanceof DeclarationRuleHandler)) {
            throw new IllegalStateException("Document handler needs to implement DeclarationRuleHandler.");
        }
        DeclarationRuleTokenHandler declarationRuleTokenHandler = new DeclarationRuleTokenHandler(ShorthandDatabase.getInstance());
        TokenProducer tokenProducer = new TokenProducer((TokenHandler2)declarationRuleTokenHandler, nArray, this.streamSizeLimit);
        this.handler.parseStart(declarationRuleTokenHandler);
        tokenProducer.parse(reader, "/*", "*/");
    }

    public PageSelectorList parsePageSelectorList(String string) throws DOMException {
        if (string == null) {
            throw new NullPointerException("Null page selector");
        }
        PageSelectorListImpl pageSelectorListImpl = new PageSelectorListImpl();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            string2 = ParseHelper.unescapeStringValue(string2, true, false);
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
            while (stringTokenizer2.hasMoreTokens()) {
                String string3 = stringTokenizer2.nextToken().trim();
                AbstractPageSelector abstractPageSelector = this.parsePageSelector(string3);
                if (abstractPageSelector != null) {
                    pageSelectorListImpl.add(abstractPageSelector);
                    continue;
                }
                throw new DOMException(12, "Bad page selector: " + string3);
            }
        }
        return pageSelectorListImpl;
    }

    private AbstractPageSelector parsePageSelector(String string) {
        AbstractPageSelector abstractPageSelector = null;
        AbstractPageSelector abstractPageSelector2 = null;
        int n = string.indexOf(58);
        if (n == -1) {
            return new PageTypeSelector(string);
        }
        if (n != 0) {
            String string2 = string.substring(0, n);
            if (!CSSParser.isValidIdentifier(string2)) {
                return null;
            }
            abstractPageSelector = abstractPageSelector2 = new PageTypeSelector(string2);
        }
        ++n;
        int n2 = string.length();
        while (n < n2) {
            String string3;
            int n3 = string.indexOf(58, n);
            if (n3 == n) {
                return null;
            }
            if (n3 == -1) {
                string3 = string.substring(n).toLowerCase(Locale.ROOT);
                n = n2;
            } else {
                string3 = string.substring(n, n3).toLowerCase(Locale.ROOT);
                n = n3 + 1;
            }
            if (this.containsOnlyLcLetters(string3)) {
                PseudoPageSelector pseudoPageSelector = new PseudoPageSelector(string3);
                if (abstractPageSelector2 != null) {
                    abstractPageSelector2.setNextSelector(pseudoPageSelector);
                } else {
                    abstractPageSelector = pseudoPageSelector;
                }
                abstractPageSelector2 = pseudoPageSelector;
                continue;
            }
            return null;
        }
        return abstractPageSelector;
    }

    private boolean containsOnlyLcLetters(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= 'a' && c <= 'z') continue;
            return false;
        }
        return true;
    }

    @Override
    public void parseRule(Reader reader) throws CSSParseException, IOException, IllegalStateException {
        int[] nArray = new int[]{45, 95};
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        RuleTokenHandler ruleTokenHandler = new RuleTokenHandler(null);
        TokenProducer tokenProducer = new TokenProducer((TokenHandler2)ruleTokenHandler, nArray, this.streamSizeLimit);
        this.handler.parseStart(ruleTokenHandler);
        tokenProducer.parse(reader, "/*", "*/");
    }

    @Override
    public void parseRule(Reader reader, Parser.NamespaceMap namespaceMap) throws CSSParseException, IOException, IllegalStateException {
        int[] nArray = new int[]{45, 95};
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        RuleTokenHandler ruleTokenHandler = new RuleTokenHandler(namespaceMap);
        TokenProducer tokenProducer = new TokenProducer((TokenHandler2)ruleTokenHandler, nArray, this.streamSizeLimit);
        this.handler.parseStart(ruleTokenHandler);
        tokenProducer.parse(reader, "/*", "*/");
    }

    public void parseRule(InputSource inputSource) throws CSSParseException, IOException {
        int[] nArray = new int[]{45, 95};
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        RuleTokenHandler ruleTokenHandler = new RuleTokenHandler(null);
        TokenProducer tokenProducer = new TokenProducer((TokenHandler2)ruleTokenHandler, nArray, this.streamSizeLimit);
        Reader reader = this.getReaderFromSource(inputSource);
        this.handler.parseStart(ruleTokenHandler);
        tokenProducer.parse(reader, "/*", "*/");
    }

    public void parsePageRuleBody(String string) throws CSSParseException {
        int[] nArray = new int[]{45, 95};
        PageTokenHandler pageTokenHandler = new PageTokenHandler();
        TokenProducer tokenProducer = new TokenProducer((TokenHandler2)pageTokenHandler, nArray);
        this.handler.parseStart(pageTokenHandler);
        tokenProducer.parse(string, "/*", "*/");
    }

    public void parseKeyFramesBody(String string) throws CSSParseException {
        int[] nArray = new int[]{45, 95};
        KeyFrameBlockListTH keyFrameBlockListTH = new KeyFrameBlockListTH();
        TokenProducer tokenProducer = new TokenProducer((TokenHandler2)keyFrameBlockListTH, nArray);
        this.handler.parseStart(keyFrameBlockListTH);
        tokenProducer.parse(string, "/*", "*/");
    }

    public void parseFontFeatureValuesBody(String string) throws CSSParseException {
        int[] nArray = new int[]{45, 95};
        FontFeatureValuesTH fontFeatureValuesTH = new FontFeatureValuesTH();
        TokenProducer tokenProducer = new TokenProducer((TokenHandler2)fontFeatureValuesTH, nArray);
        this.handler.parseStart(fontFeatureValuesTH);
        tokenProducer.parse(string, "/*", "*/");
    }

    public BooleanCondition parseSupportsCondition(String string, CSSRule cSSRule) throws CSSParseException, CSSBudgetException {
        AbstractCSSStyleSheet abstractCSSStyleSheet = null;
        if (cSSRule != null) {
            abstractCSSStyleSheet = (AbstractCSSStyleSheet)cSSRule.getParentStyleSheet();
        }
        return this.parseSupportsCondition(string, cSSRule, abstractCSSStyleSheet);
    }

    public BooleanCondition parseSupportsCondition(String string, CSSRule cSSRule, SheetContext sheetContext) throws CSSParseException, CSSBudgetException {
        int[] nArray = new int[]{45, 46};
        SupportsTokenHandler supportsTokenHandler = new SupportsTokenHandler(cSSRule, sheetContext);
        TokenProducer tokenProducer = new TokenProducer((TokenHandler2)supportsTokenHandler, nArray);
        try {
            tokenProducer.parse(string, "/*", "*/");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new CSSBudgetException("Nested conditions exceed limit", indexOutOfBoundsException);
        }
        if (supportsTokenHandler.errorCode == 0) {
            return supportsTokenHandler.getCondition();
        }
        return null;
    }

    protected SupportsConditionFactory createSupportsConditionFactory(SheetContext sheetContext) {
        return new io.sf.carte.doc.style.css.om.SupportsConditionFactory(sheetContext);
    }

    @Override
    public void parseMediaQueryList(String string, MediaQueryFactory mediaQueryFactory, MediaQueryHandler mediaQueryHandler) throws CSSBudgetException {
        int[] nArray = new int[]{45, 46};
        MediaQueryTokenHandler mediaQueryTokenHandler = new MediaQueryTokenHandler(mediaQueryFactory, mediaQueryHandler);
        TokenProducer tokenProducer = new TokenProducer((TokenHandler2)mediaQueryTokenHandler, nArray);
        mediaQueryHandler.startQuery();
        try {
            tokenProducer.parse(string, "/*", "*/");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            CSSParseException cSSParseException = mediaQueryTokenHandler.createException(0, (byte)127, "Nested queries exceed limit.");
            cSSParseException.initCause(indexOutOfBoundsException);
            mediaQueryHandler.invalidQuery(cSSParseException);
            throw new CSSBudgetException("Nested queries exceed limit", indexOutOfBoundsException);
        }
    }

    @Override
    public MediaQueryList parseMediaQueryList(String string, Node node) throws CSSBudgetException {
        int[] nArray = new int[]{45, 46};
        MediaQueryFactory mediaQueryFactory = this.getMediaQueryFactory();
        MediaQueryHandler mediaQueryHandler = mediaQueryFactory.createMediaQueryHandler(node);
        MediaQueryTokenHandler mediaQueryTokenHandler = new MediaQueryTokenHandler(mediaQueryFactory, mediaQueryHandler);
        TokenProducer tokenProducer = new TokenProducer((TokenHandler2)mediaQueryTokenHandler, nArray);
        mediaQueryHandler.startQuery();
        try {
            tokenProducer.parse(string, "/*", "*/");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            CSSParseException cSSParseException = mediaQueryTokenHandler.createException(0, (byte)127, "Nested queries exceed limit.");
            cSSParseException.initCause(indexOutOfBoundsException);
            mediaQueryHandler.invalidQuery(cSSParseException);
            throw new CSSBudgetException("Nested queries exceed limit", indexOutOfBoundsException);
        }
        return mediaQueryHandler.getMediaQueryList();
    }

    protected MediaQueryFactory getMediaQueryFactory() {
        return new NSACMediaQueryFactory();
    }

    private MediaQueryList parseMediaQueryList(String string) {
        MediaQueryHandler mediaQueryHandler;
        block2: {
            int[] nArray = new int[]{45, 46};
            MediaQueryFactory mediaQueryFactory = this.getMediaQueryFactory();
            mediaQueryHandler = mediaQueryFactory.createMediaQueryHandler(null);
            MediaQueryTokenHandler mediaQueryTokenHandler = new MediaQueryTokenHandler(mediaQueryFactory, mediaQueryHandler);
            TokenProducer tokenProducer = new TokenProducer((TokenHandler2)mediaQueryTokenHandler, nArray);
            mediaQueryHandler.startQuery();
            try {
                tokenProducer.parse(string, "/*", "*/");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                CSSParseException cSSParseException = mediaQueryTokenHandler.createException(0, (byte)127, "Nested queries exceed limit.");
                mediaQueryHandler.invalidQuery(cSSParseException);
                if (this.errorHandler == null) break block2;
                this.errorHandler.error(cSSParseException);
            }
        }
        return mediaQueryHandler.getMediaQueryList();
    }

    private static boolean isKnownFeature(String string) {
        return string.startsWith("min-") || string.startsWith("max-") || MediaQueryDatabase.isMediaFeature(string) || string.startsWith("device-");
    }

    private static boolean isValidFeatureSyntax(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetter(c) || c == '-') continue;
            return false;
        }
        return true;
    }

    @Override
    public SelectorList parseSelectors(Reader reader) throws CSSParseException, CSSBudgetException, IOException {
        int[] nArray = new int[]{45, 95};
        SelectorTokenHandler selectorTokenHandler = new SelectorTokenHandler();
        TokenProducer tokenProducer = new TokenProducer((TokenHandler2)selectorTokenHandler, nArray, this.streamSizeLimit);
        tokenProducer.parse(reader, "/*", "*/");
        return selectorTokenHandler.getTrimmedSelectorList();
    }

    @Override
    public SelectorList parseSelectors(String string, Parser.NamespaceMap namespaceMap) throws CSSParseException {
        int[] nArray = new int[]{45, 95};
        SelectorTokenHandler selectorTokenHandler = new SelectorTokenHandler(namespaceMap);
        TokenProducer tokenProducer = new TokenProducer((TokenHandler2)selectorTokenHandler, nArray);
        tokenProducer.parse(string);
        return selectorTokenHandler.getTrimmedSelectorList();
    }

    public SelectorList parseSelectors(InputSource inputSource) throws CSSParseException, IOException {
        int[] nArray = new int[]{45, 95};
        Reader reader = this.getReaderFromSource(inputSource);
        SelectorTokenHandler selectorTokenHandler = new SelectorTokenHandler(null);
        TokenProducer tokenProducer = new TokenProducer((TokenHandler2)selectorTokenHandler, nArray, this.streamSizeLimit);
        tokenProducer.parse(reader, "/*", "*/");
        return selectorTokenHandler.getTrimmedSelectorList();
    }

    public SelectorList parseSelectors(String string) throws CSSException {
        int[] nArray = new int[]{45, 95};
        SelectorTokenHandler selectorTokenHandler = new SelectorTokenHandler();
        TokenProducer tokenProducer = new TokenProducer((TokenHandler2)selectorTokenHandler, nArray);
        tokenProducer.parse(string, "/*", "*/");
        return selectorTokenHandler.getTrimmedSelectorList();
    }

    private SelectorList parseSelectors(String string, NSACSelectorFactory nSACSelectorFactory) throws CSSParseException {
        int[] nArray = new int[]{45, 95};
        SelectorTokenHandler selectorTokenHandler = new SelectorTokenHandler(nSACSelectorFactory);
        TokenProducer tokenProducer = new TokenProducer((TokenHandler2)selectorTokenHandler, nArray);
        tokenProducer.parse(string);
        return selectorTokenHandler.getTrimmedSelectorList();
    }

    private SelectorList parseSelectorArgument(String string, NSACSelectorFactory nSACSelectorFactory) throws CSSParseException {
        int[] nArray = new int[]{45, 95};
        SelectorArgumentTokenHandler selectorArgumentTokenHandler = new SelectorArgumentTokenHandler(nSACSelectorFactory);
        TokenProducer tokenProducer = new TokenProducer((TokenHandler2)selectorArgumentTokenHandler, nArray);
        tokenProducer.parse(string);
        return selectorArgumentTokenHandler.getTrimmedSelectorList();
    }

    @Override
    public Condition parsePseudoElement(String string) throws CSSException {
        Selector selector;
        SelectorList selectorList = this.parseSelectors(string);
        if (selectorList.getLength() == 1 && (selector = selectorList.item(0)).getSelectorType() == Selector.SelectorType.CONDITIONAL) {
            Condition condition = ((ConditionalSelector)selector).getCondition();
            Condition.ConditionType conditionType = condition.getConditionType();
            if (conditionType == Condition.ConditionType.PSEUDO_ELEMENT) {
                return condition;
            }
            if (conditionType == Condition.ConditionType.AND) {
                CombinatorCondition combinatorCondition = (CombinatorCondition)condition;
                Condition condition2 = combinatorCondition.getFirstCondition();
                Condition condition3 = combinatorCondition.getSecondCondition();
                if (condition2.getConditionType() == Condition.ConditionType.PSEUDO_ELEMENT && condition3.getConditionType() == Condition.ConditionType.PSEUDO_ELEMENT) {
                    return condition;
                }
            }
        }
        throw new CSSException("No pseudo-element in: " + string);
    }

    @Override
    public LexicalUnit parsePropertyValue(Reader reader) throws CSSParseException, IOException {
        int[] nArray = new int[]{45, 95};
        PropertyTokenHandler propertyTokenHandler = new PropertyTokenHandler();
        TokenProducer tokenProducer = new TokenProducer((TokenHandler2)propertyTokenHandler, nArray, this.streamSizeLimit);
        tokenProducer.parse(reader, "/*", "*/");
        return propertyTokenHandler.getLexicalUnit();
    }

    private LexicalUnit parsePropertyValue(Reader reader, int n, int n2) throws CSSParseException, IOException {
        int[] nArray = new int[]{45, 95};
        PropertyTokenHandler propertyTokenHandler = new PropertyTokenHandler(n, n2);
        TokenProducer tokenProducer = new TokenProducer((TokenHandler2)propertyTokenHandler, nArray, this.streamSizeLimit);
        tokenProducer.parse(reader, "/*", "*/");
        return propertyTokenHandler.getLexicalUnit();
    }

    public LexicalUnit parsePropertyValue(String string, Reader reader) throws CSSParseException, IOException {
        int[] nArray = new int[]{45, 95};
        PropertyTokenHandler propertyTokenHandler = new PropertyTokenHandler(string);
        TokenProducer tokenProducer = new TokenProducer((TokenHandler2)propertyTokenHandler, nArray, this.streamSizeLimit);
        tokenProducer.parse(reader, "/*", "*/");
        return propertyTokenHandler.getLexicalUnit();
    }

    public LexicalUnit parsePropertyValue(InputSource inputSource) throws CSSParseException, IOException {
        int[] nArray = new int[]{45, 95};
        Reader reader = this.getReaderFromSource(inputSource);
        PropertyTokenHandler propertyTokenHandler = new PropertyTokenHandler();
        TokenProducer tokenProducer = new TokenProducer((TokenHandler2)propertyTokenHandler, nArray, this.streamSizeLimit);
        tokenProducer.parse(reader, "/*", "*/");
        return propertyTokenHandler.getLexicalUnit();
    }

    @Override
    public boolean parsePriority(Reader reader) throws IOException {
        if (reader == null) {
            throw new NullPointerException("Null character stream");
        }
        int n = reader.read();
        if (n != -1) {
            int n2 = 0;
            StringBuilder stringBuilder = new StringBuilder(9);
            int n3 = 0;
            if (CSSParser.isNotSeparator(n)) {
                stringBuilder.appendCodePoint(n);
                n3 = 1;
                n2 = 1;
            }
            while ((n = reader.read()) != -1 && n3 != 2) {
                if (CSSParser.isNotSeparator(n)) {
                    stringBuilder.appendCodePoint(n);
                    n2 = (short)(n2 + 1);
                    if (n2 == 10) {
                        return false;
                    }
                    n3 = 1;
                    continue;
                }
                if (n3 != 1) continue;
                n3 = 2;
            }
            return "important".equals(stringBuilder.toString().toLowerCase(Locale.ROOT));
        }
        return false;
    }

    static boolean bufferEndsWithEscapedCharOrWS(StringBuilder stringBuilder) {
        int n;
        int n2 = stringBuilder.length();
        if (n2 > 1 && (ParseHelper.isHexCodePoint(n = stringBuilder.codePointAt(n2 - 1)) || n == 32)) {
            for (int i = 2; i <= Math.min(n2, 6); ++i) {
                n = stringBuilder.codePointAt(n2 - i);
                if (ParseHelper.isHexCodePoint(n)) continue;
                if (n != 92) break;
                return true;
            }
        }
        return false;
    }

    static boolean bufferEndsWithEscapedChar(StringBuilder stringBuilder) {
        int n;
        int n2 = stringBuilder.length();
        if (n2 > 1 && ParseHelper.isHexCodePoint(n = stringBuilder.codePointAt(n2 - 1))) {
            for (int i = 2; i <= Math.min(n2, 6); ++i) {
                n = stringBuilder.codePointAt(n2 - i);
                if (ParseHelper.isHexCodePoint(n)) continue;
                if (n != 92) break;
                return true;
            }
        }
        return false;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isNotSeparator(int n) {
        return n != 32 && n != 9 && n != 10 && n != 12 && n != 13;
    }

    static boolean isValidIdentifier(String string) {
        int n;
        int n2 = string.length();
        char c = string.charAt(0);
        if (c != '-') {
            if (!CSSParser.isNameStartChar(c) && c != '\\') {
                return false;
            }
            n = 1;
        } else if (n2 > 1) {
            c = string.charAt(1);
            if (!CSSParser.isNameStartChar(c) && c != '-' && c != '\\') {
                return false;
            }
            n = 2;
        } else {
            return false;
        }
        while (n < n2) {
            c = string.charAt(n);
            if (!CSSParser.isNameChar(c)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static boolean isNameChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c > '\u0080' || c == '\\';
    }

    private static boolean isNameStartChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c > '\u0080';
    }

    private static boolean equalSequences(CharSequence charSequence, CharSequence charSequence2) {
        int n = charSequence.length();
        if (n != charSequence2.length()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (charSequence.charAt(i) == charSequence2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public CSSParser clone() {
        CSSParser cSSParser = new CSSParser(this);
        return cSSParser;
    }

    private class CDOTokenHandler
    extends CSSTokenHandler {
        private final TokenControl parserctl;
        private final CSSTokenHandler parent;

        CDOTokenHandler(TokenControl tokenControl) {
            this.prevcp = 60;
            this.parserctl = tokenControl;
            this.parent = (CSSTokenHandler)tokenControl.getTokenHandler();
        }

        public void word(int n, CharSequence charSequence) {
            if (!CSSParser.equalSequences("--", charSequence) || this.prevcp != 33) {
                this.parent.unexpectedTokenError(n, charSequence);
            }
            this.yieldHandling();
        }

        public void character(int n, int n2) {
            if (n2 == 33 && this.prevcp == 60) {
                this.prevcp = n2;
                return;
            }
            this.parent.unexpectedCharError(n, n2);
            this.yieldHandling();
        }

        void yieldHandling() {
            this.parserctl.setTokenHandler((TokenHandler3)this.parent);
        }

        @Override
        public void commented(int n, int n2, String string) {
            this.parent.unexpectedTokenError(n, string);
            this.yieldHandling();
        }

        @Override
        public void control(int n, int n2) {
            this.parent.control(n, n2);
            this.parent.unexpectedCharError(n, n2);
            this.yieldHandling();
        }

        public void endOfStream(int n) {
            this.parent.handleError(n, (byte)10, "EOF while processing CDO/CDC.");
            this.parent.endOfStream(n);
        }

        public void separator(int n, int n2) {
            this.parent.unexpectedCharError(n, n2);
            this.yieldHandling();
        }

        public void quoted(int n, CharSequence charSequence, int n2) {
            char c = (char)n2;
            StringBuilder stringBuilder = new StringBuilder(charSequence.length() + 2);
            stringBuilder.append(c).append(charSequence).append(c);
            this.parent.unexpectedTokenError(n, stringBuilder);
            this.yieldHandling();
        }

        public void quotedWithControl(int n, CharSequence charSequence, int n2) {
            this.quoted(n, charSequence, n2);
        }

        public void leftParenthesis(int n) {
            this.parent.unexpectedCharError(n, 40);
            this.yieldHandling();
        }

        public void leftSquareBracket(int n) {
            this.parent.unexpectedCharError(n, 91);
            this.yieldHandling();
        }

        public void leftCurlyBracket(int n) {
            this.parent.unexpectedCharError(n, 123);
            this.yieldHandling();
        }

        public void rightParenthesis(int n) {
            this.parent.unexpectedCharError(n, 41);
            this.yieldHandling();
        }

        public void rightSquareBracket(int n) {
            this.parent.unexpectedCharError(n, 93);
            this.yieldHandling();
        }

        public void rightCurlyBracket(int n) {
            this.parent.unexpectedCharError(n, 125);
            this.yieldHandling();
        }

        public void escaped(int n, int n2) {
            this.parent.unexpectedCharError(n, n2);
            this.yieldHandling();
        }
    }

    abstract class CSSTokenHandler
    implements TokenHandler2,
    ParserControl {
        private int line;
        private int prevlinelength;
        private boolean foundCp13andNotYet10or12 = false;
        private int column;
        int prevcp = 32;
        int endcp = -1;
        short parendepth = 0;
        StringBuilder buffer;
        int escapedTokenIndex = -1;
        boolean parseError = false;

        CSSTokenHandler() {
            this.line = 1;
            this.prevlinelength = -1;
        }

        CSSTokenHandler(int n, int n2) {
            this.line = n;
            this.prevlinelength = n2;
        }

        boolean isTopLevel() {
            return false;
        }

        @Override
        public CSSErrorHandler getErrorHandler() {
            return CSSParser.this.errorHandler;
        }

        @Override
        public void setDocumentHandler(CSSHandler cSSHandler) {
            CSSParser.this.setDocumentHandler(cSSHandler);
        }

        @Override
        public void setErrorHandler(CSSErrorHandler cSSErrorHandler) {
            CSSParser.this.setErrorHandler(cSSErrorHandler);
        }

        @Override
        public Locator createLocator() {
            return new LocatorImpl(this.line, this.column);
        }

        int getCurrentLine() {
            return this.line;
        }

        int getPrevLineLength() {
            return this.prevlinelength;
        }

        void setCurrentLocation(int n) {
            this.column = n - this.prevlinelength;
        }

        public void tokenStart(TokenControl tokenControl) {
        }

        public void control(int n, int n2) {
            if (n2 == 10) {
                this.separator(n, 10);
                if (!this.foundCp13andNotYet10or12) {
                    ++this.line;
                    this.prevlinelength = n;
                } else {
                    this.foundCp13andNotYet10or12 = false;
                    ++this.prevlinelength;
                }
                this.setHandlerPreviousCp(10);
            } else if (n2 == 12) {
                this.separator(n, 10);
                this.setHandlerPreviousCp(10);
                if (!this.foundCp13andNotYet10or12) {
                    ++this.line;
                } else {
                    this.foundCp13andNotYet10or12 = false;
                }
                this.prevlinelength = n;
            } else if (n2 == 13) {
                ++this.line;
                this.prevlinelength = n;
                this.foundCp13andNotYet10or12 = true;
            } else if (n2 == 9) {
                this.separator(n, 9);
            } else if (n2 < 128) {
                this.unexpectedCharError(n, n2);
            } else {
                this.highControl(n, n2);
            }
        }

        protected void setHandlerPreviousCp(int n) {
            this.prevcp = n;
        }

        protected void highControl(int n, int n2) {
            if (!this.parseError) {
                this.handleError(n, (byte)4, "Unexpected control: " + n2);
            }
        }

        void decrParenDepth(int n) {
            this.parendepth = (short)(this.parendepth - 1);
            if (this.parendepth < 0 && !this.parseError) {
                this.handleError(n, (byte)4, "Unexpected character: ')'");
            }
        }

        boolean isPrevCpWhitespace() {
            return this.prevcp == 32 || this.prevcp == 10;
        }

        void setWhitespacePrevCp() {
            if (this.prevcp != 10) {
                this.prevcp = 32;
            }
        }

        public void quotedNewlineChar(int n, int n2) {
            if (n2 == 10) {
                if (this.prevcp != 13) {
                    ++this.line;
                    this.prevlinelength = n;
                }
            } else if (n2 == 12) {
                ++this.line;
                this.prevlinelength = n;
            } else if (n2 == 13) {
                ++this.line;
                this.prevlinelength = n;
                this.prevcp = n2;
            }
        }

        public void commented(int n, int n2, String string) {
            if (n2 == 0) {
                CSSParser.this.handler.comment(string, this.isPreviousCpLF());
            }
            this.prevcp = 12;
        }

        protected boolean isPreviousCpLF() {
            return this.prevcp == 10;
        }

        void setEscapedTokenStart(int n) {
            if (this.escapedTokenIndex == -1) {
                this.escapedTokenIndex = n - 1;
            }
        }

        void bufferAppend(int n) {
            this.buffer.appendCodePoint(n);
        }

        String rawBuffer() {
            this.escapedTokenIndex = -1;
            String string = this.buffer.toString();
            this.buffer.setLength(0);
            return string;
        }

        String unescapeBuffer(int n) {
            String string = this.unescapeStringValue(n);
            this.buffer.setLength(0);
            this.escapedTokenIndex = -1;
            return string;
        }

        String unescapeStringValue(int n) {
            String string;
            if (this.escapedTokenIndex != -1) {
                int n2 = n - this.escapedTokenIndex;
                int n3 = this.buffer.length() - n2;
                if (n3 <= 0) {
                    string = this.safeUnescapeIdentifier(n, this.buffer.toString());
                } else {
                    CharSequence charSequence = this.buffer.subSequence(0, n3);
                    string = charSequence + this.safeUnescapeIdentifier(n, this.buffer.substring(n3));
                }
            } else {
                string = this.buffer.toString();
            }
            return string;
        }

        String safeUnescapeIdentifier(int n, String string) {
            return ParseHelper.unescapeStringValue(string, true, true);
        }

        String unescapeIdentifier(int n, String string) throws DOMNullCharacterException {
            return ParseHelper.unescapeStringValue(string, true, false);
        }

        boolean isNotForbiddenIdentStart(String string) {
            char c = string.charAt(0);
            if (c != '-') {
                return !CSSParser.isDigit(c) && c != '+';
            }
            return string.length() > 1 && !CSSParser.isDigit(c = string.charAt(1)) || c == '\\';
        }

        boolean isValidPseudoName(String string) {
            int n;
            int n2 = string.length();
            char c = string.charAt(0);
            if (c != '-') {
                if (!CSSParser.isNameStartChar(c)) {
                    return false;
                }
                n = 1;
            } else if (n2 > 1) {
                c = string.charAt(1);
                if (!CSSParser.isNameStartChar(c)) {
                    return false;
                }
                n = 2;
            } else {
                return false;
            }
            while (n < n2) {
                c = string.charAt(n);
                if (!CSSParser.isNameChar(c)) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        void resetHandler() {
            this.prevcp = 32;
            this.parendepth = 0;
            this.parseError = false;
        }

        public void error(int n, byte by, CharSequence charSequence) {
            this.handleError(n, by, "Syntax error near " + charSequence);
        }

        protected void handleError(int n, byte by, String string) throws CSSParseException {
            if (!this.parseError) {
                CSSParseException cSSParseException = this.prevcp == this.endcp ? this.createException(n, by, "Unexpected end of file") : this.createException(n, by, string);
                this.handleError(cSSParseException);
            }
        }

        protected void handleError(int n, byte by, String string, Throwable throwable) throws CSSParseException {
            if (!this.parseError) {
                CSSParseException cSSParseException = this.createException(n, by, string);
                cSSParseException.initCause(throwable);
                this.handleError(cSSParseException);
            }
        }

        protected void handleError(CSSParseException cSSParseException) throws CSSParseException {
            if (CSSParser.this.errorHandler == null) {
                throw cSSParseException;
            }
            CSSParser.this.errorHandler.error(cSSParseException);
            this.parseError = true;
        }

        void unexpectedCharError(int n, int n2) {
            this.handleError(n, (byte)4, "Unexpected '" + new String(Character.toChars(n2)) + "'");
        }

        void unexpectedTokenError(int n, CharSequence charSequence) {
            this.handleError(n, (byte)9, "Unexpected: " + charSequence);
        }

        final void handleWarning(int n, byte by, String string) {
            this.handleWarning(n, by, string, null);
        }

        void handleWarning(int n, byte by, String string, Throwable throwable) {
            if (!this.parseError && CSSParser.this.errorHandler != null) {
                CSSParseException cSSParseException = this.createException(n, by, string);
                if (throwable != null) {
                    cSSParseException.initCause(throwable);
                }
                if (CSSParser.this.errorHandler != null) {
                    CSSParser.this.errorHandler.warning(cSSParseException);
                }
            }
        }

        CSSParseException createException(int n, byte by, String string) {
            this.setCurrentLocation(n);
            Locator locator = this.createLocator();
            if (by == 15) {
                return new CSSNamespaceParseException(string, locator);
            }
            return new CSSParseException(string, locator);
        }

        void endDocument() {
            if (CSSParser.this.handler != null) {
                CSSParser.this.handler.endOfStream();
            }
        }

        class MySelectorListImpl
        extends SelectorListImpl {
            private static final long serialVersionUID = 1L;

            MySelectorListImpl() {
            }

            public boolean add(Selector selector, int n) {
                if (this.add(selector)) {
                    return true;
                }
                if (CSSParser.this.errorHandler != null) {
                    int n2;
                    try {
                        n2 = selector.toString().length();
                    }
                    catch (RuntimeException runtimeException) {
                        n2 = 1;
                    }
                    String string = "Duplicate selector in list";
                    try {
                        string = string + ": " + selector.toString();
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    CSSParser.this.errorHandler.warning(CSSTokenHandler.this.createException(n - n2, (byte)-1, string));
                }
                return false;
            }
        }
    }

    private class CallbackIgnoredDeclarationTH
    extends IgnoredDeclarationTokenHandler {
        private final TokenControl parserctl;
        private final TokenHandler2 parent;

        CallbackIgnoredDeclarationTH(TokenControl tokenControl) {
            this.parserctl = tokenControl;
            this.parent = (TokenHandler2)tokenControl.getTokenHandler();
        }

        @Override
        protected void endDeclarationBlock() {
            this.parserctl.setTokenHandler((TokenHandler3)this.parent);
        }

        @Override
        public void control(int n, int n2) {
            this.parent.control(n, n2);
        }

        public void endOfStream(int n) {
            this.parent.endOfStream(n);
        }
    }

    private static class ConditionTokenHandler<F extends BooleanConditionFactory>
    extends CSSTokenHandler {
        final F conditionFactory;
        BooleanCondition currentCond = null;
        private int opDepthIndex = 0;
        private final short[] opParenDepth = new short[32];
        private boolean topLevel = true;
        private DelegateHandler predicateHandler;
        boolean readingPredicate = false;
        final /* synthetic */ CSSParser this$0;

        ConditionTokenHandler(F f) {
            this.this$0 = var1_1;
            this.conditionFactory = f;
            this.buffer = new StringBuilder(64);
        }

        DelegateHandler getPredicateHandler() {
            return this.predicateHandler;
        }

        void setPredicateHandler(DelegateHandler delegateHandler) {
            this.predicateHandler = delegateHandler;
        }

        public void word(int n, CharSequence charSequence) {
            if (!this.parseError) {
                if (!this.readingPredicate) {
                    if (this.buffer.length() == 0) {
                        this.processWord(n, charSequence.toString());
                    } else {
                        this.unexpectedTokenError(n, charSequence);
                    }
                } else if (this.getCurrentParenDepth() > 1 || this.predicateHandler.isAllowedTopLevel()) {
                    this.predicateHandler.word(n, charSequence);
                } else {
                    this.processWord(n, charSequence.toString());
                }
                this.prevcp = 65;
            }
        }

        private void processWord(int n, String string) {
            String string2 = string.toLowerCase(Locale.ROOT);
            if ("not".equals(string2)) {
                this.predicateHandler.preBooleanHandling(n, BooleanCondition.Type.NOT);
                BooleanCondition booleanCondition = this.conditionFactory.createNotCondition();
                if (this.currentCond != null) {
                    this.currentCond.addCondition(booleanCondition);
                }
                this.setNestedCondition(booleanCondition);
            } else if ("and".equals(string2)) {
                this.predicateHandler.preBooleanHandling(n, BooleanCondition.Type.AND);
                if (this.currentCond != null) {
                    this.processOperation(n, BooleanCondition.Type.AND, string);
                } else {
                    this.processImplicitAnd(n);
                }
            } else if ("or".equals(string2)) {
                if (this.currentCond != null) {
                    this.predicateHandler.preBooleanHandling(n, BooleanCondition.Type.OR);
                    this.processOperation(n, BooleanCondition.Type.OR, string);
                } else {
                    this.unexpectedTokenError(n, string);
                }
            } else {
                this.readingPredicate = true;
                this.predicateHandler.word(n, string);
            }
        }

        void processOperation(int n, BooleanCondition.Type type, String string) {
            BooleanCondition booleanCondition = this.currentCond.getParentCondition();
            BooleanCondition.Type type2 = this.currentCond.getType();
            if (type2 == BooleanCondition.Type.PREDICATE || type2 == BooleanCondition.Type.SELECTOR_FUNCTION) {
                if (booleanCondition == null) {
                    BooleanCondition booleanCondition2 = this.createOperation(n, type);
                    booleanCondition2.addCondition(this.currentCond);
                    this.setNestedCondition(booleanCondition2);
                } else if (booleanCondition.getType() == type) {
                    this.currentCond = booleanCondition;
                } else {
                    BooleanCondition booleanCondition3 = this.createOperation(n, type);
                    if (this.getCurrentParenDepth() != 0) {
                        BooleanCondition booleanCondition4 = booleanCondition.replaceLast(booleanCondition3);
                        booleanCondition3.addCondition(booleanCondition4);
                    } else {
                        booleanCondition3.addCondition(booleanCondition);
                    }
                    this.setNestedCondition(booleanCondition3);
                }
            } else if (type2 == BooleanCondition.Type.NOT) {
                if (booleanCondition != null) {
                    BooleanCondition booleanCondition5 = this.createOperation(n, type);
                    BooleanCondition booleanCondition6 = booleanCondition.replaceLast(booleanCondition5);
                    booleanCondition5.addCondition(booleanCondition6);
                    this.setNestedCondition(booleanCondition5);
                } else if (type == BooleanCondition.Type.AND || type == BooleanCondition.Type.OR) {
                    BooleanCondition booleanCondition7 = this.createOperation(n, type);
                    booleanCondition7.addCondition(this.currentCond);
                    this.setNestedCondition(booleanCondition7);
                } else {
                    this.unexpectedTokenError(n, string);
                }
            } else if (type2 != type) {
                if (this.getCurrentParenDepth() != 0 || !this.topLevel) {
                    this.unexpectedTokenError(n, string);
                } else {
                    BooleanCondition booleanCondition8 = this.createOperation(n, type);
                    booleanCondition8.addCondition(this.currentCond);
                    this.setNestedCondition(booleanCondition8);
                }
            }
        }

        BooleanCondition createOperation(int n, BooleanCondition.Type type) throws CSSParseException {
            if (type == BooleanCondition.Type.AND) {
                return this.conditionFactory.createAndCondition();
            }
            return this.conditionFactory.createOrCondition();
        }

        private void setNestedCondition(BooleanCondition booleanCondition) {
            this.currentCond = booleanCondition;
            ++this.opDepthIndex;
        }

        void processImplicitAnd(int n) {
            this.unexpectedTokenError(n, "and");
        }

        public void leftParenthesis(int n) {
            int n2 = this.opDepthIndex;
            this.opParenDepth[n2] = (short)(this.opParenDepth[n2] + 1);
            this.predicateHandler.leftParenthesis(n);
            this.readingPredicate = true;
            this.prevcp = 40;
        }

        public void leftSquareBracket(int n) {
            this.predicateHandler.leftSquareBracket(n);
            this.readingPredicate = true;
            this.prevcp = 91;
        }

        public void leftCurlyBracket(int n) {
            this.predicateHandler.leftCurlyBracket(n);
            this.readingPredicate = true;
            this.prevcp = 123;
        }

        void handleLeftCurlyBracket(int n) {
            this.unexpectedCharError(n, 123);
        }

        public void rightParenthesis(int n) {
            int n2 = this.opDepthIndex;
            this.opParenDepth[n2] = (short)(this.opParenDepth[n2] - 1);
            if (this.opParenDepth[this.opDepthIndex] < 0) {
                this.unexpectedCharError(n, 41);
            } else if (this.readingPredicate) {
                this.predicateHandler.rightParenthesis(n);
            } else if (this.buffer.length() != 0) {
                this.unexpectedCharError(n, 41);
            }
            this.topLevel = true;
            if (this.opParenDepth[this.opDepthIndex] == 0 && this.currentCond != null && this.opDepthIndex != 0) {
                --this.opDepthIndex;
                if (this.currentCond.getParentCondition() != null) {
                    this.currentCond = this.currentCond.getParentCondition();
                    this.topLevel = false;
                }
            }
            this.prevcp = 41;
        }

        public void rightSquareBracket(int n) {
            if (this.readingPredicate) {
                this.predicateHandler.rightSquareBracket(n);
                this.prevcp = 93;
            } else {
                this.unexpectedCharError(n, 93);
            }
        }

        public void rightCurlyBracket(int n) {
            if (this.readingPredicate) {
                this.predicateHandler.rightCurlyBracket(n);
                this.prevcp = 125;
            } else {
                this.unexpectedCharError(n, 125);
            }
        }

        short getCurrentParenDepth() {
            return this.opParenDepth[this.opDepthIndex];
        }

        public void character(int n, int n2) {
            if (!this.parseError) {
                if (!this.readingPredicate) {
                    if (n2 == 44) {
                        this.predicateHandler.character(n, n2);
                    } else {
                        this.unexpectedCharError(n, n2);
                    }
                } else {
                    this.predicateHandler.character(n, n2);
                }
            } else if (n2 == 44) {
                this.predicateHandler.character(n, n2);
            }
        }

        public void quoted(int n, CharSequence charSequence, int n2) {
            if (!this.parseError) {
                if (this.readingPredicate) {
                    this.predicateHandler.quoted(n, charSequence, n2);
                    this.prevcp = 65;
                } else {
                    this.handleError(n, (byte)9, "Unexpected: '" + charSequence + '\'');
                }
            }
        }

        public void quotedWithControl(int n, CharSequence charSequence, int n2) {
            this.quoted(n, charSequence, n2);
        }

        public void escaped(int n, int n2) {
            if (!this.parseError) {
                if (this.readingPredicate) {
                    this.predicateHandler.escaped(n, n2);
                } else if (this.prevcp == 40) {
                    this.readingPredicate = true;
                    this.predicateHandler.escaped(n, n2);
                } else {
                    this.handleError(n, (byte)9, "Unexpected escaped character: \\u" + Integer.toHexString(n2));
                }
                this.prevcp = n2;
            }
        }

        public void separator(int n, int n2) {
            if (!this.parseError) {
                if (this.readingPredicate) {
                    this.predicateHandler.separator(n, n2);
                }
                this.setWhitespacePrevCp();
            }
        }

        @Override
        public void control(int n, int n2) {
            super.control(n, n2);
            if (this.escapedTokenIndex != -1 && CSSParser.bufferEndsWithEscapedCharOrWS(this.buffer)) {
                this.escapedTokenIndex = -1;
                this.buffer.append(' ');
            }
        }

        @Override
        public void commented(int n, int n2, String string) {
            this.separator(n, 32);
            this.prevcp = 32;
        }

        public void endOfStream(int n) {
            this.endOfCondition(n);
        }

        void endOfCondition(int n) {
            if (this.opParenDepth[this.opDepthIndex] != 0) {
                this.handleError(n, (byte)6, "Unmatched parenthesis");
            } else if (!this.parseError) {
                this.predicateHandler.endOfStream(n);
            }
        }

        @Override
        protected void handleError(int n, byte by, String string) throws CSSParseException {
            throw this.createException(n, by, string);
        }

        @Override
        void resetHandler() {
            this.prevcp = 32;
            this.parseError = false;
            this.currentCond = null;
            this.buffer.setLength(0);
        }
    }

    private static class ConditionWrapper {
        private final Object condition;
        private final ConditionWrapper parent;
        private final boolean mediaCondition;

        ConditionWrapper(MediaQueryList mediaQueryList, ConditionWrapper conditionWrapper) {
            this.condition = mediaQueryList;
            this.parent = conditionWrapper;
            this.mediaCondition = true;
        }

        ConditionWrapper(BooleanCondition booleanCondition, ConditionWrapper conditionWrapper) {
            this.condition = booleanCondition;
            this.parent = conditionWrapper;
            this.mediaCondition = false;
        }

        MediaQueryList getMediaList() {
            return (MediaQueryList)this.condition;
        }

        BooleanCondition getCondition() {
            return (BooleanCondition)this.condition;
        }

        ConditionWrapper getParent() {
            return this.parent;
        }

        boolean isMediaCondition() {
            return this.mediaCondition;
        }

        public String toString() {
            return this.condition != null ? this.condition.toString() : "";
        }
    }

    abstract class ControlTokenHandler
    extends CSSTokenHandler {
        private TokenControl parserctl;

        ControlTokenHandler() {
            this.parserctl = null;
        }

        ControlTokenHandler(int n, int n2) {
            super(n, n2);
            this.parserctl = null;
        }

        @Override
        public void tokenStart(TokenControl tokenControl) {
            this.parserctl = tokenControl;
        }

        TokenControl getTokenControl() {
            return this.parserctl;
        }
    }

    public static interface DeclarationRuleHandler
    extends CSSHandler {
        public void startAtRule(String var1, String var2);

        public void endAtRule();
    }

    class DeclarationRuleTokenHandler
    extends DeclarationTokenHandler {
        private String ruleFirstPart;
        private byte stage;
        static final byte STAGE_FOUND_AT_CHAR = 1;
        static final byte STAGE_RULE_NAME_SELECTOR = 2;
        static final byte STAGE_RULE_BODY = 3;
        static final byte STAGE_RULE_END = 4;
        static final byte INVALID_RULE = 127;

        DeclarationRuleTokenHandler(ShorthandDatabase shorthandDatabase) {
            super(shorthandDatabase, 0);
            this.ruleFirstPart = null;
            this.stage = 0;
        }

        void setRuleName(String string) {
            this.ruleFirstPart = string;
        }

        void setStage(byte by) {
            this.stage = by;
        }

        @Override
        void addWord(int n, CharSequence charSequence) {
            if (this.prevcp == 64 && this.stage == 1) {
                this.ruleFirstPart = charSequence.toString().toLowerCase(Locale.ROOT);
                this.buffer.setLength(0);
                this.stage = (byte)2;
            } else if (this.stage != 127) {
                super.addWord(n, charSequence);
                if (this.stage < 2) {
                    this.stage = (byte)2;
                }
            }
        }

        @Override
        protected void handleAtKeyword(int n) {
            if (this.propertyName != null || this.buffer.length() != 0 || this.stage != 0) {
                this.unexpectedCharError(n, 64);
            } else if (this.stage != 127) {
                this.buffer.append('@');
                this.stage = 1;
                this.prevcp = 64;
            }
        }

        @Override
        protected void handleLeftCurlyBracket(int n) {
            ++this.curlyBracketDepth;
            if (this.stage != 127) {
                if (this.stage == 2) {
                    String string = null;
                    if (this.buffer.length() != 0) {
                        string = this.unescapeBuffer(n);
                    }
                    this.prevcp = 32;
                    this.stage = (byte)3;
                    this.startAtRule(n, this.ruleFirstPart, string);
                    if (this.stage == 127) {
                        this.skipDeclarationBlock();
                    }
                } else {
                    this.unexpectedCharError(n, 123);
                }
            } else {
                this.skipDeclarationBlock();
            }
        }

        void skipDeclarationBlock() {
            this.getTokenControl().setTokenHandler((TokenHandler3)new IgnoredDeclarationRuleTokenHandler());
        }

        protected void startAtRule(int n, String string, String string2) {
            ((DeclarationRuleHandler)CSSParser.this.handler).startAtRule(string, string2);
        }

        @Override
        protected void handleRightCurlyBracket(int n) {
            if (this.stage == 3) {
                this.endAtRule(n);
                this.resetHandler();
                this.ruleFirstPart = null;
                this.stage = (byte)4;
            } else if (this.stage != 127) {
                this.unexpectedCharError(n, 125);
            }
        }

        protected void endAtRule(int n) {
            ((DeclarationRuleHandler)CSSParser.this.handler).endAtRule();
        }

        @Override
        public void character(int n, int n2) {
            if (this.stage != 127) {
                if (this.getCurlyBracketDepth() != 0) {
                    super.character(n, n2);
                } else if (n2 == 64) {
                    this.handleAtKeyword(n);
                } else {
                    this.bufferAppend(n2);
                    this.prevcp = n2;
                }
            }
        }

        @Override
        protected void processBuffer(int n) {
            if (this.getCurlyBracketDepth() != 0) {
                super.processBuffer(n);
            }
        }

        @Override
        public void commented(int n, int n2, String string) {
            if (!(this.parseError || this.buffer.length() != 0 || this.propertyName != null || this.curlyBracketDepth != 1 && this.ruleFirstPart != null || this.parendepth != 0 || n2 != 0)) {
                CSSParser.this.handler.comment(string, this.isPreviousCpLF());
                this.prevcp = 12;
            } else {
                this.separator(n, 32);
                this.prevcp = 32;
            }
        }

        @Override
        public void endOfStream(int n) {
            super.endOfStream(n);
            if (this.stage != 4) {
                if (this.stage == 3) {
                    this.handleWarning(n, (byte)-6, "Unexpected end of stream");
                    this.endAtRule(n);
                } else if (!this.parseError) {
                    this.handleError(n, (byte)10, "Unexpected end of stream");
                }
            }
        }

        private class IgnoredDeclarationRuleTokenHandler
        extends IgnoredDeclarationTokenHandler {
            IgnoredDeclarationRuleTokenHandler() {
            }

            @Override
            protected void endDeclarationBlock() {
            }

            @Override
            public void control(int n, int n2) {
                DeclarationRuleTokenHandler.this.control(n, n2);
            }

            public void endOfStream(int n) {
                DeclarationRuleTokenHandler.this.endOfStream(n);
            }
        }
    }

    class DeclarationTokenHandler
    extends ControlTokenHandler {
        private LexicalUnitImpl lunit;
        private LexicalUnitImpl currentlu;
        String propertyName;
        private final ShorthandDatabase propertyDatabase;
        private boolean hexColor;
        private boolean unicodeRange;
        private boolean readPriority;
        private boolean priorityImportant;
        int curlyBracketDepth;
        private int squareBracketDepth;
        private boolean functionToken;
        private final boolean flagIEValues;

        DeclarationTokenHandler(ShorthandDatabase shorthandDatabase) {
            this(shorthandDatabase, 1);
        }

        DeclarationTokenHandler(int n, int n2) {
            super(n, n2);
            this.lunit = null;
            this.currentlu = null;
            this.propertyName = null;
            this.hexColor = false;
            this.unicodeRange = false;
            this.readPriority = false;
            this.priorityImportant = false;
            this.functionToken = false;
            this.curlyBracketDepth = 1;
            this.flagIEValues = CSSParser.this.parserFlags.contains((Object)Parser.Flag.IEVALUES);
            this.buffer = new StringBuilder(128);
            this.propertyDatabase = null;
        }

        DeclarationTokenHandler(ShorthandDatabase shorthandDatabase, int n) {
            this.lunit = null;
            this.currentlu = null;
            this.propertyName = null;
            this.hexColor = false;
            this.unicodeRange = false;
            this.readPriority = false;
            this.priorityImportant = false;
            this.functionToken = false;
            this.curlyBracketDepth = n;
            this.flagIEValues = CSSParser.this.parserFlags.contains((Object)Parser.Flag.IEVALUES);
            this.buffer = new StringBuilder(128);
            this.propertyDatabase = shorthandDatabase;
        }

        LexicalUnit getLexicalUnit() {
            return this.parseError ? null : this.lunit;
        }

        int getCurlyBracketDepth() {
            return this.curlyBracketDepth;
        }

        boolean allowSemicolonArgument() {
            return "switch".equalsIgnoreCase(this.currentlu.value);
        }

        public void word(int n, CharSequence charSequence) {
            if (!this.parseError) {
                this.addWord(n, charSequence);
            }
            this.prevcp = 65;
        }

        void addWord(int n, CharSequence charSequence) {
            if (this.prevcp == 92) {
                this.buffer.append('\\');
            }
            this.buffer.append(charSequence);
        }

        public void leftParenthesis(int n) {
            this.parendepth = (short)(this.parendepth + 1);
            if (this.hexColor || this.unicodeRange) {
                this.unexpectedCharError(n, 40);
            } else if (!this.parseError) {
                if (this.prevcp != 65) {
                    if (!this.functionToken) {
                        this.unexpectedCharError(n, 40);
                        this.prevcp = 40;
                    } else if (this.buffer.length() == 0) {
                        this.newLexicalUnit(LexicalUnit.LexicalType.SUB_EXPRESSION, true);
                    } else {
                        this.handleError(n, (byte)9, "Unexpected token: " + this.buffer.toString());
                        this.buffer.setLength(0);
                    }
                    this.prevcp = 40;
                } else {
                    this.newFunction(n);
                    this.prevcp = 32;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void newFunction(int n) {
            if (this.functionToken && this.currentlu.getLexicalUnitType() == LexicalUnit.LexicalType.URI) {
                this.buffer.setLength(0);
                this.escapedTokenIndex = -1;
                this.unexpectedCharError(n, 40);
                return;
            }
            String string = this.unescapeStringValue(n);
            String string2 = string.toLowerCase(Locale.ROOT);
            LexicalUnitFactory lexicalUnitFactory = FunctionFactories.getFactory(string2);
            if (lexicalUnitFactory == null) {
                if (string.isEmpty()) {
                    this.handleError(n, (byte)5, "Unexpected character '('.");
                    this.buffer.setLength(0);
                    this.escapedTokenIndex = -1;
                    return;
                }
                String string3 = this.buffer.toString();
                if (!this.isNotForbiddenIdentStart(string3)) {
                    this.handleError(n, (byte)5, "Unexpected: " + string3);
                    this.buffer.setLength(0);
                    this.escapedTokenIndex = -1;
                    return;
                }
                LexicalUnitImpl lexicalUnitImpl = this.newLexicalUnit(LexicalUnit.LexicalType.FUNCTION, true);
                lexicalUnitImpl.value = string;
                this.functionToken = true;
            } else {
                LexicalUnitImpl lexicalUnitImpl = lexicalUnitFactory.createUnit();
                if (this.functionToken) {
                    this.currentlu.addFunctionParameter(lexicalUnitImpl);
                    this.currentlu = lexicalUnitImpl;
                } else {
                    if (this.currentlu != null) {
                        this.currentlu.nextLexicalUnit = lexicalUnitImpl;
                        lexicalUnitImpl.previousLexicalUnit = this.currentlu;
                    }
                    this.currentlu = lexicalUnitImpl;
                    if (this.lunit == null) {
                        this.lunit = lexicalUnitImpl;
                    }
                    this.functionToken = true;
                }
                if (lexicalUnitImpl.getLexicalUnitType() != LexicalUnit.LexicalType.URI && lexicalUnitImpl.getLexicalUnitType() != LexicalUnit.LexicalType.ELEMENT_REFERENCE) {
                    lexicalUnitImpl.value = string;
                }
            }
            this.buffer.setLength(0);
            this.escapedTokenIndex = -1;
        }

        public void leftCurlyBracket(int n) {
            if (this.hexColor || this.unicodeRange) {
                this.unexpectedCharError(n, 123);
            } else if (!this.parseError) {
                this.handleLeftCurlyBracket(n);
            } else {
                this.skipDeclaration(n);
            }
            this.prevcp = 123;
        }

        protected void handleLeftCurlyBracket(int n) {
            this.handleError(n, (byte)4, "Unexpected '{'");
            this.skipDeclaration(n);
        }

        protected void skipDeclaration(int n) {
            CallbackIgnoredDeclarationTH callbackIgnoredDeclarationTH = new CallbackIgnoredDeclarationTH(this.getTokenControl());
            this.getTokenControl().setTokenHandler((TokenHandler3)callbackIgnoredDeclarationTH);
        }

        public void leftSquareBracket(int n) {
            ++this.squareBracketDepth;
            if (this.hexColor || this.unicodeRange) {
                this.unexpectedCharError(n, 91);
            } else if (!this.parseError) {
                if (this.propertyName != null) {
                    this.processBuffer(n);
                    this.newLexicalUnit(LexicalUnit.LexicalType.LEFT_BRACKET, false);
                    this.prevcp = 32;
                } else {
                    this.unexpectedCharError(n, 91);
                }
            }
        }

        private LexicalUnitImpl newLexicalUnit(LexicalUnit.LexicalType lexicalType, boolean bl) {
            LexicalUnitImpl lexicalUnitImpl;
            if (this.functionToken) {
                if (this.currentlu.getLexicalUnitType() == LexicalUnit.LexicalType.URI && lexicalType != LexicalUnit.LexicalType.VAR) {
                    lexicalUnitImpl = this.currentlu;
                } else {
                    lexicalUnitImpl = new LexicalUnitImpl(lexicalType);
                    this.currentlu.addFunctionParameter(lexicalUnitImpl);
                    if (bl) {
                        this.currentlu = lexicalUnitImpl;
                    }
                }
            } else {
                lexicalUnitImpl = new LexicalUnitImpl(lexicalType);
                if (this.currentlu != null) {
                    this.currentlu.nextLexicalUnit = lexicalUnitImpl;
                    lexicalUnitImpl.previousLexicalUnit = this.currentlu;
                }
                this.currentlu = lexicalUnitImpl;
                if (this.lunit == null) {
                    this.lunit = lexicalUnitImpl;
                }
            }
            return lexicalUnitImpl;
        }

        private SyntaxUnitImpl newSyntaxUnit() {
            assert (this.functionToken);
            SyntaxUnitImpl syntaxUnitImpl = new SyntaxUnitImpl();
            this.currentlu.addFunctionParameter(syntaxUnitImpl);
            return syntaxUnitImpl;
        }

        public void rightParenthesis(int n) {
            this.processBuffer(n);
            this.decrParenDepth(n);
            if (this.functionToken) {
                this.checkFunction(n);
                if (this.currentlu.ownerLexicalUnit != null) {
                    this.currentlu = this.currentlu.ownerLexicalUnit;
                } else {
                    this.functionToken = false;
                }
            }
            this.prevcp = 41;
        }

        private void checkFunction(int n) {
            String string;
            LexicalUnit.LexicalType lexicalType = this.currentlu.getLexicalUnitType();
            if (this.currentlu.parameters == null) {
                switch (lexicalType) {
                    case FUNCTION: 
                    case ELEMENT_REFERENCE: {
                        break;
                    }
                    case URI: {
                        if (this.currentlu.isParameter() || this.parendepth == 0) break;
                    }
                    default: {
                        this.unexpectedCharError(n, 41);
                    }
                }
                return;
            }
            if (!this.isVarOrLastParamIsOperand()) {
                this.unexpectedCharError(n, 41);
                return;
            }
            switch (lexicalType) {
                case RGBCOLOR: {
                    if (!this.isValidRGBColor(n)) break;
                    return;
                }
                case HSLCOLOR: {
                    if (!this.isValidHSLColor(n)) break;
                    return;
                }
                case LABCOLOR: {
                    if (!this.isValidLABColor(n, 100, 100.0f)) break;
                    return;
                }
                case OKLABCOLOR: {
                    if (!this.isValidLABColor(n, 1, 1.0f)) break;
                    return;
                }
                case LCHCOLOR: {
                    if (!this.isValidLCHColor(n, 100, 100.0f)) break;
                    return;
                }
                case OKLCHCOLOR: {
                    if (!this.isValidLCHColor(n, 1, 1.0f)) break;
                    return;
                }
                case HWBCOLOR: {
                    if (!this.isValidHWBColor(n)) break;
                    return;
                }
                case COLOR_FUNCTION: {
                    if (!this.isValidColorFunction(n)) break;
                    return;
                }
                case COLOR_MIX: {
                    if (!this.isValidColorMixFunction()) break;
                    return;
                }
                case VAR: {
                    string = this.currentlu.parameters.getStringValue();
                    if (string == null) break;
                    if (string.length() < 3 || string.charAt(0) != '-' || string.charAt(1) != '-') {
                        n -= string.length();
                        break;
                    }
                    LexicalUnit.LexicalType lexicalType2 = this.findLastValue(this.currentlu.parameters).getLexicalUnitType();
                    if (lexicalType2 == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        LexicalUnitImpl lexicalUnitImpl = this.newLexicalUnit(LexicalUnit.LexicalType.EMPTY, false);
                        lexicalUnitImpl.value = "";
                    }
                    return;
                }
                default: {
                    return;
                }
            }
            try {
                string = "Wrong color: " + this.currentlu.toString();
            }
            catch (Exception exception) {
                string = "Wrong color.";
            }
            this.handleError(n, (byte)5, string);
        }

        private boolean isVarOrLastParamIsOperand() {
            if (this.currentlu.getLexicalUnitType() == LexicalUnit.LexicalType.VAR) {
                return true;
            }
            LexicalUnit.LexicalType lexicalType = this.findLastValue(this.currentlu.parameters).getLexicalUnitType();
            return lexicalType != LexicalUnit.LexicalType.OPERATOR_COMMA && !this.typeIsAlgebraicOperator(lexicalType);
        }

        private boolean lastParamIsAlgebraicOperator() {
            LexicalUnit.LexicalType lexicalType = this.findLastValue(this.currentlu.parameters).getLexicalUnitType();
            return this.typeIsAlgebraicOperator(lexicalType);
        }

        private boolean typeIsAlgebraicOperator(LexicalUnit.LexicalType lexicalType) {
            return lexicalType == LexicalUnit.LexicalType.OPERATOR_PLUS || lexicalType == LexicalUnit.LexicalType.OPERATOR_MINUS || lexicalType == LexicalUnit.LexicalType.OPERATOR_MULTIPLY || lexicalType == LexicalUnit.LexicalType.OPERATOR_SLASH;
        }

        private boolean lastParamIsMultOrSlashOperator() {
            LexicalUnit.LexicalType lexicalType = this.findLastValue(this.currentlu.parameters).getLexicalUnitType();
            return lexicalType == LexicalUnit.LexicalType.OPERATOR_MULTIPLY || lexicalType == LexicalUnit.LexicalType.OPERATOR_SLASH;
        }

        private boolean isValidRGBColor(int n) {
            LexicalUnitImpl lexicalUnitImpl = this.currentlu.parameters;
            int n2 = 0;
            LexicalUnit.LexicalType lexicalType = LexicalUnit.LexicalType.UNKNOWN;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            do {
                LexicalUnit.LexicalType lexicalType2;
                if ((lexicalType2 = lexicalUnitImpl.getLexicalUnitType()) == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    if (lexicalType == LexicalUnit.LexicalType.OPERATOR_COMMA || lexicalType == LexicalUnit.LexicalType.UNKNOWN || bl2) {
                        return false;
                    }
                    bl = true;
                } else if (this.isComponentType(lexicalType2)) {
                    if (lexicalType2 == LexicalUnit.LexicalType.VAR) {
                        bl3 = true;
                    }
                    if (lexicalType2 == LexicalUnit.LexicalType.INTEGER) {
                        int n3 = lexicalUnitImpl.getIntegerValue();
                        if (n3 < 0) {
                            lexicalUnitImpl.intValue = 0;
                            this.handleWarning(n, (byte)-5, "Color component has value under 0.");
                        } else if (n2 == 3 && n3 > 1) {
                            lexicalUnitImpl.intValue = 1;
                            this.handleWarning(n, (byte)-5, "Color alpha has value over 1.");
                        }
                        if (n3 > 255) {
                            this.handleWarning(n, (byte)-5, "Color component has value over 255.");
                        }
                    } else if (lexicalType2 == LexicalUnit.LexicalType.REAL) {
                        float f = lexicalUnitImpl.getFloatValue();
                        if (f < 0.0f) {
                            lexicalUnitImpl.floatValue = 0.0f;
                            this.handleWarning(n, (byte)-5, "Color component has value under 0.");
                        }
                        if (n2 == 3) {
                            if (f > 1.0f) {
                                lexicalUnitImpl.floatValue = 1.0f;
                                this.handleWarning(n, (byte)-5, "Color alpha has value over 1.");
                            }
                        } else if (lexicalType != LexicalUnit.LexicalType.OPERATOR_SLASH) {
                            lexicalType2 = LexicalUnit.LexicalType.INTEGER;
                        }
                        if (f > 255.0f) {
                            this.handleWarning(n, (byte)-5, "Color component has value over 255.");
                        }
                    } else if (lexicalType2 == LexicalUnit.LexicalType.PERCENTAGE) {
                        float f = lexicalUnitImpl.getFloatValue();
                        if (f < 0.0f) {
                            lexicalUnitImpl.floatValue = 0.0f;
                            this.handleWarning(n, (byte)-5, "Color component has percentage under 0%.");
                        } else if (f > 100.0f) {
                            lexicalUnitImpl.floatValue = 100.0f;
                            this.handleWarning(n, (byte)-5, "Color component has percentage over 100%.");
                        }
                    } else if (lexicalType2 == LexicalUnit.LexicalType.IDENT) {
                        if (!"none".equalsIgnoreCase(lexicalUnitImpl.getStringValue())) {
                            return false;
                        }
                        lexicalType2 = LexicalUnit.LexicalType.PERCENTAGE;
                    }
                    if (bl) {
                        if (lexicalType != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                            return false;
                        }
                    } else if (lexicalType != lexicalType2) {
                        if (n2 == 3 && lexicalType != LexicalUnit.LexicalType.OPERATOR_SLASH) {
                            return false;
                        }
                    } else {
                        bl2 = true;
                    }
                    n2 = (short)(n2 + 1);
                } else if (lexicalType2 == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                    if (bl3 && n2 < 3) {
                        n2 = 3;
                    }
                    if (n2 == 4 || n2 < 3 || !this.isComponentType(lexicalType) || bl) {
                        return false;
                    }
                    bl2 = true;
                } else {
                    return false;
                }
                lexicalType = lexicalType2;
            } while ((lexicalUnitImpl = lexicalUnitImpl.nextLexicalUnit) != null);
            return n2 == 3 || n2 == 4 || n2 < 3 && bl3;
        }

        private boolean isComponentType(LexicalUnit.LexicalType lexicalType) {
            return lexicalType == LexicalUnit.LexicalType.INTEGER || lexicalType == LexicalUnit.LexicalType.PERCENTAGE || lexicalType == LexicalUnit.LexicalType.REAL || lexicalType == LexicalUnit.LexicalType.VAR || lexicalType == LexicalUnit.LexicalType.CALC || lexicalType == LexicalUnit.LexicalType.IDENT || lexicalType == LexicalUnit.LexicalType.MATH_FUNCTION || lexicalType == LexicalUnit.LexicalType.FUNCTION || lexicalType == LexicalUnit.LexicalType.ATTR;
        }

        private boolean isValidHSLColor(int n) {
            LexicalUnitImpl lexicalUnitImpl = this.currentlu.parameters;
            int n2 = 0;
            LexicalUnit.LexicalType lexicalType = LexicalUnit.LexicalType.UNKNOWN;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            do {
                LexicalUnit.LexicalType lexicalType2;
                if ((lexicalType2 = lexicalUnitImpl.getLexicalUnitType()) == LexicalUnit.LexicalType.PERCENTAGE || (lexicalType2 == LexicalUnit.LexicalType.MATH_FUNCTION || lexicalType2 == LexicalUnit.LexicalType.FUNCTION || lexicalType2 == LexicalUnit.LexicalType.ATTR) && this.isPercentageUnit(lexicalUnitImpl)) {
                    if (lexicalType == LexicalUnit.LexicalType.UNKNOWN) {
                        return false;
                    }
                    if (bl) {
                        if (lexicalType != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                            return false;
                        }
                    } else {
                        boolean bl4 = bl2 = bl2 || lexicalType == LexicalUnit.LexicalType.REAL || lexicalType == LexicalUnit.LexicalType.PERCENTAGE || lexicalType == LexicalUnit.LexicalType.INTEGER || lexicalType == LexicalUnit.LexicalType.EXT1;
                    }
                    if (lexicalType2 == LexicalUnit.LexicalType.PERCENTAGE) {
                        float f = lexicalUnitImpl.getFloatValue();
                        if (f < 0.0f) {
                            lexicalUnitImpl.floatValue = 0.0f;
                            this.handleWarning(n, (byte)-5, "Color component has value under 0%.");
                        } else if (f > 100.0f) {
                            lexicalUnitImpl.floatValue = 100.0f;
                            this.handleWarning(n, (byte)-5, "Color component has value over 100%.");
                        }
                    } else {
                        lexicalType2 = LexicalUnit.LexicalType.PERCENTAGE;
                    }
                    n2 = (short)(n2 + 1);
                } else if (lexicalType2 == LexicalUnit.LexicalType.REAL) {
                    if (lexicalType != LexicalUnit.LexicalType.UNKNOWN) {
                        n2 = (short)(n2 + 1);
                        float f = lexicalUnitImpl.getFloatValue();
                        if (f < 0.0f) {
                            lexicalUnitImpl.floatValue = 0.0f;
                            this.handleWarning(n, (byte)-5, "Color component has value under 0.");
                        } else if (lexicalType == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                            if (f > 1.0f) {
                                lexicalUnitImpl.floatValue = 1.0f;
                                this.handleWarning(n, (byte)-5, "Color alpha has value over 1.");
                            }
                        } else if (f > 100.0f) {
                            lexicalUnitImpl.floatValue = 100.0f;
                            this.handleWarning(n, (byte)-5, "Color component has value over 100%.");
                        }
                        if (bl) {
                            if (lexicalType != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                                return false;
                            }
                        } else {
                            bl2 = bl2 || lexicalType == LexicalUnit.LexicalType.REAL || lexicalType == LexicalUnit.LexicalType.PERCENTAGE || lexicalType == LexicalUnit.LexicalType.INTEGER || lexicalType == LexicalUnit.LexicalType.EXT1;
                        }
                    }
                } else if (lexicalType2 == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    if (lexicalType == LexicalUnit.LexicalType.OPERATOR_COMMA || lexicalType == LexicalUnit.LexicalType.UNKNOWN || bl2) {
                        return false;
                    }
                    bl = true;
                } else if (lexicalType2 == LexicalUnit.LexicalType.INTEGER) {
                    if (lexicalType != LexicalUnit.LexicalType.UNKNOWN) {
                        int n3 = lexicalUnitImpl.getIntegerValue();
                        if (n3 < 0) {
                            lexicalUnitImpl.intValue = 0;
                            this.handleWarning(n, (byte)-5, "Color component has value under 0%.");
                        } else if (n3 > 100) {
                            lexicalUnitImpl.intValue = 100;
                            this.handleWarning(n, (byte)-5, "Color component has value over 100%.");
                        }
                        if (n3 > 1 && lexicalType == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                            lexicalUnitImpl.intValue = 1;
                        }
                        n2 = (short)(n2 + 1);
                        lexicalType2 = LexicalUnit.LexicalType.PERCENTAGE;
                        if (bl) {
                            if (lexicalType != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                                return false;
                            }
                        } else {
                            bl2 = bl2 || lexicalType == LexicalUnit.LexicalType.REAL || lexicalType == LexicalUnit.LexicalType.PERCENTAGE || lexicalType == LexicalUnit.LexicalType.INTEGER || lexicalType == LexicalUnit.LexicalType.EXT1;
                        }
                    }
                } else if (this.isAngleUnit(lexicalUnitImpl)) {
                    if (lexicalType != LexicalUnit.LexicalType.UNKNOWN) {
                        return false;
                    }
                    lexicalType2 = LexicalUnit.LexicalType.EXT1;
                } else if (lexicalType2 == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                    if (n2 != 2 && !bl3 || bl3 && n2 > 2 || lexicalType != LexicalUnit.LexicalType.PERCENTAGE && lexicalType != LexicalUnit.LexicalType.REAL && lexicalType != LexicalUnit.LexicalType.VAR || bl) {
                        return false;
                    }
                } else if (lexicalType2 == LexicalUnit.LexicalType.CALC || lexicalType2 == LexicalUnit.LexicalType.MATH_FUNCTION || lexicalType2 == LexicalUnit.LexicalType.FUNCTION || lexicalType2 == LexicalUnit.LexicalType.ATTR) {
                    if (lexicalType == LexicalUnit.LexicalType.UNKNOWN) {
                        lexicalType2 = LexicalUnit.LexicalType.INTEGER;
                    } else if (lexicalType == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                        lexicalType2 = LexicalUnit.LexicalType.REAL;
                        n2 = (short)(n2 + 1);
                    } else {
                        if (bl) {
                            if (lexicalType != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                                return false;
                            }
                        } else {
                            bl2 = bl2 || lexicalType == LexicalUnit.LexicalType.REAL || lexicalType == LexicalUnit.LexicalType.PERCENTAGE || lexicalType == LexicalUnit.LexicalType.INTEGER || lexicalType == LexicalUnit.LexicalType.EXT1;
                        }
                        n2 = (short)(n2 + 1);
                        lexicalType2 = LexicalUnit.LexicalType.PERCENTAGE;
                    }
                } else if (lexicalType2 == LexicalUnit.LexicalType.VAR) {
                    bl3 = true;
                } else if (lexicalType2 == LexicalUnit.LexicalType.IDENT) {
                    if (!"none".equalsIgnoreCase(lexicalUnitImpl.getStringValue())) {
                        return false;
                    }
                    n2 = (short)(n2 + 1);
                    lexicalType2 = LexicalUnit.LexicalType.PERCENTAGE;
                } else {
                    return false;
                }
                lexicalType = lexicalType2;
            } while ((lexicalUnitImpl = lexicalUnitImpl.nextLexicalUnit) != null);
            return n2 == 2 || n2 == 3 || bl3 && n2 < 2;
        }

        private boolean isValidHWBColor(int n) {
            LexicalUnitImpl lexicalUnitImpl = this.currentlu.parameters;
            int n2 = 0;
            LexicalUnit.LexicalType lexicalType = LexicalUnit.LexicalType.UNKNOWN;
            boolean bl = false;
            do {
                float f;
                LexicalUnit.LexicalType lexicalType2;
                if ((lexicalType2 = lexicalUnitImpl.getLexicalUnitType()) == LexicalUnit.LexicalType.PERCENTAGE) {
                    if (lexicalType == LexicalUnit.LexicalType.UNKNOWN) {
                        return false;
                    }
                    n2 = (short)(n2 + 1);
                    f = lexicalUnitImpl.getFloatValue();
                    if (f < 0.0f) {
                        lexicalUnitImpl.floatValue = 0.0f;
                        this.handleWarning(n, (byte)-5, "Color component has value under 0%.");
                    } else if (f > 100.0f) {
                        lexicalUnitImpl.floatValue = 100.0f;
                        this.handleWarning(n, (byte)-5, "Color component has value over 100%.");
                    }
                } else if (lexicalType2 == LexicalUnit.LexicalType.INTEGER) {
                    if (lexicalType != LexicalUnit.LexicalType.UNKNOWN) {
                        if (lexicalType != LexicalUnit.LexicalType.OPERATOR_SLASH || n2 < 2 && !bl) {
                            return false;
                        }
                        int n3 = lexicalUnitImpl.getIntegerValue();
                        if (n3 < 0) {
                            lexicalUnitImpl.intValue = 0;
                            this.handleWarning(n, (byte)-5, "Color alpha has value under 0.");
                        } else if (n3 > 1) {
                            lexicalUnitImpl.intValue = 1;
                            this.handleWarning(n, (byte)-5, "Color alpha has value over 1.");
                        }
                    }
                } else if (this.isAngleUnit(lexicalUnitImpl)) {
                    if (lexicalType != LexicalUnit.LexicalType.UNKNOWN) {
                        return false;
                    }
                    lexicalType2 = LexicalUnit.LexicalType.EXT1;
                } else if (lexicalType2 == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                    if (n2 != 2 && !bl || bl && n2 > 2 || lexicalType != LexicalUnit.LexicalType.PERCENTAGE && lexicalType != LexicalUnit.LexicalType.VAR) {
                        return false;
                    }
                } else if (lexicalType2 == LexicalUnit.LexicalType.REAL) {
                    if (lexicalType != LexicalUnit.LexicalType.UNKNOWN) {
                        if (lexicalType != LexicalUnit.LexicalType.OPERATOR_SLASH || n2 != 2 && !bl || bl && n2 > 2) {
                            return false;
                        }
                        n2 = 3;
                        f = lexicalUnitImpl.getFloatValue();
                        if (f < 0.0f) {
                            lexicalUnitImpl.floatValue = 0.0f;
                            this.handleWarning(n, (byte)-5, "Color alpha has value under 0.");
                        } else if (f > 1.0f) {
                            lexicalUnitImpl.floatValue = 1.0f;
                            this.handleWarning(n, (byte)-5, "Color alpha has value over 1.");
                        }
                    }
                } else if (lexicalType2 == LexicalUnit.LexicalType.CALC || lexicalType2 == LexicalUnit.LexicalType.MATH_FUNCTION || lexicalType2 == LexicalUnit.LexicalType.FUNCTION || lexicalType2 == LexicalUnit.LexicalType.ATTR) {
                    if (lexicalType == LexicalUnit.LexicalType.UNKNOWN) {
                        lexicalType2 = LexicalUnit.LexicalType.INTEGER;
                    } else if (lexicalType == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                        lexicalType2 = LexicalUnit.LexicalType.REAL;
                        n2 = 3;
                    } else {
                        n2 = (short)(n2 + 1);
                        lexicalType2 = LexicalUnit.LexicalType.PERCENTAGE;
                    }
                } else if (lexicalType2 == LexicalUnit.LexicalType.VAR) {
                    bl = true;
                } else if (lexicalType2 == LexicalUnit.LexicalType.IDENT) {
                    if (!"none".equalsIgnoreCase(lexicalUnitImpl.getStringValue())) {
                        return false;
                    }
                    n2 = (short)(n2 + 1);
                    lexicalType2 = LexicalUnit.LexicalType.PERCENTAGE;
                } else {
                    return false;
                }
                lexicalType = lexicalType2;
            } while ((lexicalUnitImpl = lexicalUnitImpl.nextLexicalUnit) != null);
            return n2 >= 2 || bl && n2 <= 1;
        }

        private boolean isAngleUnit(LexicalUnit lexicalUnit) {
            short s = lexicalUnit.getCssUnit();
            if (!CSSUnit.isAngleUnitType(s)) {
                if (lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.VAR) {
                    return false;
                }
                LexicalUnit lexicalUnit2 = lexicalUnit.getNextLexicalUnit() == null ? lexicalUnit : lexicalUnit.shallowClone();
                return lexicalUnit2.matches(SyntaxParser.createSimpleSyntax("angle")) == CSSValueSyntax.Match.TRUE;
            }
            return true;
        }

        private boolean isPercentageUnit(LexicalUnit lexicalUnit) {
            LexicalUnit lexicalUnit2 = lexicalUnit.getNextLexicalUnit() == null ? lexicalUnit : lexicalUnit.shallowClone();
            return lexicalUnit2.matches(SyntaxParser.createSimpleSyntax("percentage")) == CSSValueSyntax.Match.TRUE;
        }

        private boolean isValidLABColor(int n, int n2, float f) {
            LexicalUnitImpl lexicalUnitImpl = this.currentlu.parameters;
            boolean bl = false;
            if (lexicalUnitImpl == null) {
                return false;
            }
            LexicalUnit.LexicalType lexicalType = lexicalUnitImpl.getLexicalUnitType();
            if (lexicalType == LexicalUnit.LexicalType.PERCENTAGE) {
                float f2 = lexicalUnitImpl.getFloatValue();
                if (f2 < 0.0f) {
                    lexicalUnitImpl.floatValue = 0.0f;
                    this.handleWarning(n, (byte)-5, "Color lightness has percentage under 0%.");
                } else if (f2 > 100.0f) {
                    lexicalUnitImpl.floatValue = 100.0f;
                    this.handleWarning(n, (byte)-5, "Color lightness has percentage over 100%.");
                }
            } else if (lexicalType == LexicalUnit.LexicalType.REAL) {
                float f3 = lexicalUnitImpl.getFloatValue();
                if (f3 < 0.0f) {
                    lexicalUnitImpl.floatValue = 0.0f;
                    this.handleWarning(n, (byte)-5, "Color lightness has value under 0.");
                } else if (f3 > f) {
                    lexicalUnitImpl.floatValue = f;
                    this.handleWarning(n, (byte)-5, "Color lightness has value over " + f);
                }
            } else if (lexicalType == LexicalUnit.LexicalType.INTEGER) {
                int n3 = lexicalUnitImpl.getIntegerValue();
                if (n3 < 0) {
                    lexicalUnitImpl.intValue = 0;
                    this.handleWarning(n, (byte)-5, "Color lightness has value under 0.");
                } else if (n3 > n2) {
                    lexicalUnitImpl.intValue = n2;
                    this.handleWarning(n, (byte)-5, "Color lightness has value over " + n2);
                }
            } else if (lexicalType == LexicalUnit.LexicalType.VAR) {
                bl = true;
            } else if (!(lexicalType == LexicalUnit.LexicalType.CALC || lexicalType == LexicalUnit.LexicalType.MATH_FUNCTION || lexicalType == LexicalUnit.LexicalType.FUNCTION || lexicalType == LexicalUnit.LexicalType.ATTR || lexicalType == LexicalUnit.LexicalType.IDENT && "none".equalsIgnoreCase(lexicalUnitImpl.getStringValue()))) {
                return false;
            }
            lexicalUnitImpl = lexicalUnitImpl.nextLexicalUnit;
            if (lexicalUnitImpl == null) {
                return bl;
            }
            int n4 = 1;
            block7: do {
                lexicalType = lexicalUnitImpl.getLexicalUnitType();
                switch (lexicalType) {
                    case IDENT: {
                        if (!"none".equalsIgnoreCase(lexicalUnitImpl.getStringValue())) {
                            return false;
                        }
                    }
                    case FUNCTION: 
                    case REAL: 
                    case INTEGER: 
                    case CALC: 
                    case MATH_FUNCTION: 
                    case ATTR: {
                        if (++n4 <= 3) continue block7;
                        if (!bl || n4 > 4) {
                            return false;
                        }
                        return this.isValidAlpha(n, lexicalUnitImpl);
                    }
                    case OPERATOR_SLASH: {
                        lexicalUnitImpl = lexicalUnitImpl.nextLexicalUnit;
                        if (lexicalUnitImpl == null || n4 > 3 || n4 < 3 && !bl) {
                            return false;
                        }
                        return this.isValidAlpha(n, lexicalUnitImpl);
                    }
                    case PERCENTAGE: {
                        if (++n4 > 3) {
                            if (!bl || n4 > 4) {
                                return false;
                            }
                            return this.isValidAlpha(n, lexicalUnitImpl);
                        }
                        if (bl) continue block7;
                        float f4 = lexicalUnitImpl.getFloatValue();
                        if (f4 < -100.0f) {
                            lexicalUnitImpl.floatValue = -100.0f;
                            this.handleWarning(n, (byte)-5, "Color component has percentage under -100%.");
                            break;
                        }
                        if (!(f4 > 100.0f)) continue block7;
                        lexicalUnitImpl.floatValue = 100.0f;
                        this.handleWarning(n, (byte)-5, "Color component has percentage over 100%.");
                        break;
                    }
                    case VAR: {
                        bl = true;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            } while ((lexicalUnitImpl = lexicalUnitImpl.nextLexicalUnit) != null);
            return n4 == 3 || n4 == 4 || bl && n4 < 3;
        }

        private boolean isValidLCHColor(int n, int n2, float f) {
            LexicalUnitImpl lexicalUnitImpl = this.currentlu.parameters;
            boolean bl = false;
            if (lexicalUnitImpl == null) {
                return false;
            }
            LexicalUnit.LexicalType lexicalType = lexicalUnitImpl.getLexicalUnitType();
            if (lexicalType == LexicalUnit.LexicalType.PERCENTAGE) {
                float f2 = lexicalUnitImpl.getFloatValue();
                if (f2 < 0.0f) {
                    lexicalUnitImpl.floatValue = 0.0f;
                    this.handleWarning(n, (byte)-5, "Color lightness has percentage under 0%.");
                } else if (f2 > 100.0f) {
                    lexicalUnitImpl.floatValue = 100.0f;
                    this.handleWarning(n, (byte)-5, "Color lightness has percentage over 100%.");
                }
            } else if (lexicalType == LexicalUnit.LexicalType.REAL) {
                float f3 = lexicalUnitImpl.getFloatValue();
                if (f3 < 0.0f) {
                    lexicalUnitImpl.floatValue = 0.0f;
                    this.handleWarning(n, (byte)-5, "Color lightness has value under 0.");
                } else if (f3 > f) {
                    lexicalUnitImpl.floatValue = f;
                    this.handleWarning(n, (byte)-5, "Color lightness has value over " + f);
                }
            } else if (lexicalType == LexicalUnit.LexicalType.INTEGER) {
                int n3 = lexicalUnitImpl.getIntegerValue();
                if (n3 < 0) {
                    lexicalUnitImpl.intValue = 0;
                    this.handleWarning(n, (byte)-5, "Color lightness has value under 0.");
                } else if (n3 > n2) {
                    lexicalUnitImpl.intValue = n2;
                    this.handleWarning(n, (byte)-5, "Color lightness has value over " + n2);
                }
            } else if (lexicalType == LexicalUnit.LexicalType.VAR) {
                bl = true;
            } else if (!(lexicalType == LexicalUnit.LexicalType.CALC || lexicalType == LexicalUnit.LexicalType.MATH_FUNCTION || lexicalType == LexicalUnit.LexicalType.FUNCTION || lexicalType == LexicalUnit.LexicalType.ATTR || lexicalType == LexicalUnit.LexicalType.IDENT && "none".equalsIgnoreCase(lexicalUnitImpl.getStringValue()))) {
                return false;
            }
            lexicalUnitImpl = lexicalUnitImpl.nextLexicalUnit;
            if (lexicalUnitImpl == null) {
                return bl;
            }
            lexicalType = lexicalUnitImpl.getLexicalUnitType();
            if (lexicalType == LexicalUnit.LexicalType.PERCENTAGE) {
                float f4 = lexicalUnitImpl.getFloatValue();
                if (f4 < 0.0f) {
                    lexicalUnitImpl.floatValue = 0.0f;
                    this.handleWarning(n, (byte)-5, "Color chroma has percentage under 0.");
                } else if (f4 > 100.0f) {
                    lexicalUnitImpl.floatValue = 100.0f;
                    this.handleWarning(n, (byte)-5, "Color chroma has percentage over 100.");
                }
            } else if (lexicalType == LexicalUnit.LexicalType.REAL) {
                float f5;
                if (!bl && (f5 = lexicalUnitImpl.getFloatValue()) < 0.0f) {
                    lexicalUnitImpl.floatValue = 0.0f;
                    this.handleWarning(n, (byte)-5, "Color component has value under 0.");
                }
            } else if (lexicalType == LexicalUnit.LexicalType.INTEGER) {
                int n4;
                if (!bl && (n4 = lexicalUnitImpl.getIntegerValue()) < 0) {
                    lexicalUnitImpl.intValue = 0;
                    this.handleWarning(n, (byte)-5, "Color component has value under 0.");
                }
            } else if (!(lexicalType == LexicalUnit.LexicalType.CALC || lexicalType == LexicalUnit.LexicalType.MATH_FUNCTION || lexicalType == LexicalUnit.LexicalType.FUNCTION || lexicalType == LexicalUnit.LexicalType.ATTR || lexicalType == LexicalUnit.LexicalType.IDENT && "none".equalsIgnoreCase(lexicalUnitImpl.getStringValue()))) {
                if (lexicalType == LexicalUnit.LexicalType.VAR) {
                    bl = true;
                } else if (bl) {
                    if (!CSSUnit.isAngleUnitType(lexicalUnitImpl.getCssUnit())) {
                        if (lexicalType == LexicalUnit.LexicalType.OPERATOR_SLASH && (lexicalUnitImpl = lexicalUnitImpl.nextLexicalUnit) == null) {
                            return false;
                        }
                        return this.isValidAlpha(n, lexicalUnitImpl);
                    }
                } else {
                    return false;
                }
            }
            lexicalUnitImpl = lexicalUnitImpl.nextLexicalUnit;
            if (lexicalUnitImpl == null) {
                return bl;
            }
            lexicalType = lexicalUnitImpl.getLexicalUnitType();
            if (!(lexicalType == LexicalUnit.LexicalType.REAL || lexicalType == LexicalUnit.LexicalType.INTEGER || this.isAngleUnit(lexicalUnitImpl) || lexicalType == LexicalUnit.LexicalType.CALC || lexicalType == LexicalUnit.LexicalType.MATH_FUNCTION || lexicalType == LexicalUnit.LexicalType.FUNCTION || lexicalType == LexicalUnit.LexicalType.ATTR || lexicalType == LexicalUnit.LexicalType.IDENT && "none".equalsIgnoreCase(lexicalUnitImpl.getStringValue()))) {
                if (lexicalType == LexicalUnit.LexicalType.VAR) {
                    bl = true;
                } else {
                    if (bl) {
                        if (lexicalType == LexicalUnit.LexicalType.OPERATOR_SLASH && (lexicalUnitImpl = lexicalUnitImpl.nextLexicalUnit) == null) {
                            return false;
                        }
                        return this.isValidAlpha(n, lexicalUnitImpl);
                    }
                    return false;
                }
            }
            if ((lexicalUnitImpl = lexicalUnitImpl.nextLexicalUnit) != null) {
                lexicalType = lexicalUnitImpl.getLexicalUnitType();
                if (lexicalType == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                    lexicalUnitImpl = lexicalUnitImpl.nextLexicalUnit;
                    if (lexicalUnitImpl == null) {
                        return false;
                    }
                } else {
                    if (lexicalType == LexicalUnit.LexicalType.VAR) {
                        lexicalUnitImpl = lexicalUnitImpl.nextLexicalUnit;
                        while (lexicalUnitImpl != null) {
                            if (lexicalUnitImpl.getLexicalUnitType() != LexicalUnit.LexicalType.VAR) {
                                return this.isValidAlpha(n, lexicalUnitImpl);
                            }
                            lexicalUnitImpl = lexicalUnitImpl.nextLexicalUnit;
                        }
                        return true;
                    }
                    if (!bl) {
                        return false;
                    }
                }
                return this.isValidAlpha(n, lexicalUnitImpl);
            }
            return true;
        }

        private boolean isValidColorFunction(int n) {
            LexicalUnitImpl lexicalUnitImpl = this.currentlu.parameters;
            if (lexicalUnitImpl == null) {
                return false;
            }
            boolean bl = false;
            LexicalUnit.LexicalType lexicalType = lexicalUnitImpl.getLexicalUnitType();
            if (lexicalType != LexicalUnit.LexicalType.IDENT) {
                if (lexicalType == LexicalUnit.LexicalType.VAR) {
                    bl = true;
                } else {
                    return false;
                }
            }
            if ((lexicalUnitImpl = lexicalUnitImpl.nextLexicalUnit) == null) {
                return bl;
            }
            boolean bl2 = false;
            do {
                lexicalType = lexicalUnitImpl.getLexicalUnitType();
                switch (lexicalType) {
                    case IDENT: {
                        if (!"none".equalsIgnoreCase(lexicalUnitImpl.getStringValue())) {
                            return false;
                        }
                    }
                    case VAR: 
                    case REAL: 
                    case INTEGER: 
                    case CALC: 
                    case PERCENTAGE: {
                        bl2 = true;
                        break;
                    }
                    case OPERATOR_SLASH: {
                        if (!bl2 && !bl) {
                            return false;
                        }
                        lexicalUnitImpl = lexicalUnitImpl.nextLexicalUnit;
                        if (lexicalUnitImpl == null) {
                            return false;
                        }
                        return this.isValidAlpha(n, lexicalUnitImpl);
                    }
                    case FUNCTION: 
                    case MATH_FUNCTION: 
                    case ATTR: {
                        LexicalUnitImpl lexicalUnitImpl2 = lexicalUnitImpl.getNextLexicalUnit() == null ? lexicalUnitImpl : lexicalUnitImpl.shallowClone();
                        CSSValueSyntax cSSValueSyntax = new SyntaxParser().parseSyntax("<number> | <percentage>");
                        bl2 = lexicalUnitImpl2.matches(cSSValueSyntax) != CSSValueSyntax.Match.FALSE;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            } while ((lexicalUnitImpl = lexicalUnitImpl.nextLexicalUnit) != null);
            return true;
        }

        private boolean isValidAlpha(int n, LexicalUnitImpl lexicalUnitImpl) {
            LexicalUnit.LexicalType lexicalType = lexicalUnitImpl.getLexicalUnitType();
            switch (lexicalType) {
                case INTEGER: {
                    int n2 = lexicalUnitImpl.getIntegerValue();
                    if (n2 < 0) {
                        lexicalUnitImpl.intValue = 0;
                        this.handleWarning(n, (byte)-5, "Color alpha has value under 0.");
                        break;
                    }
                    if (n2 <= 1) break;
                    lexicalUnitImpl.intValue = 1;
                    this.handleWarning(n, (byte)-5, "Color alpha has value over 1.");
                    break;
                }
                case REAL: {
                    float f = lexicalUnitImpl.getFloatValue();
                    if (f < 0.0f) {
                        lexicalUnitImpl.floatValue = 0.0f;
                        this.handleWarning(n, (byte)-5, "Color alpha has value under 0.");
                        break;
                    }
                    if (!(f > 1.0f)) break;
                    lexicalUnitImpl.floatValue = 1.0f;
                    this.handleWarning(n, (byte)-5, "Color alpha has value over 1.");
                    break;
                }
                case PERCENTAGE: {
                    float f = lexicalUnitImpl.getFloatValue();
                    if (f < 0.0f) {
                        lexicalUnitImpl.floatValue = 0.0f;
                        this.handleWarning(n, (byte)-5, "Color alpha has value under 0%.");
                        break;
                    }
                    if (!(f > 100.0f)) break;
                    lexicalUnitImpl.floatValue = 100.0f;
                    this.handleWarning(n, (byte)-5, "Color alpha has value over 100%.");
                    break;
                }
                case IDENT: {
                    if ("none".equalsIgnoreCase(lexicalUnitImpl.getStringValue())) break;
                    return false;
                }
                case FUNCTION: 
                case VAR: 
                case CALC: 
                case MATH_FUNCTION: 
                case ATTR: {
                    break;
                }
                default: {
                    return false;
                }
            }
            lexicalUnitImpl = lexicalUnitImpl.nextLexicalUnit;
            while (lexicalUnitImpl != null) {
                if (lexicalUnitImpl.getLexicalUnitType() != LexicalUnit.LexicalType.VAR) {
                    return false;
                }
                lexicalUnitImpl = lexicalUnitImpl.nextLexicalUnit;
            }
            return true;
        }

        private boolean isValidColorMixFunction() {
            boolean bl;
            LexicalUnit lexicalUnit = this.currentlu.parameters;
            if (lexicalUnit == null) {
                return false;
            }
            boolean bl2 = false;
            LexicalUnit.LexicalType lexicalType = lexicalUnit.getLexicalUnitType();
            if (lexicalType != LexicalUnit.LexicalType.IDENT) {
                if (lexicalType == LexicalUnit.LexicalType.VAR) {
                    bl2 = true;
                } else if (lexicalType != LexicalUnit.LexicalType.ATTR) {
                    return false;
                }
            } else if (!"in".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return false;
            }
            lexicalUnit = lexicalUnit.getNextLexicalUnit();
            if (lexicalUnit == null) {
                return bl2;
            }
            lexicalType = lexicalUnit.getLexicalUnitType();
            if (lexicalType != LexicalUnit.LexicalType.IDENT) {
                if (lexicalType == LexicalUnit.LexicalType.VAR) {
                    bl2 = true;
                } else if (lexicalType != LexicalUnit.LexicalType.ATTR) {
                    return bl2;
                }
            }
            if ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) == null) {
                return bl2;
            }
            lexicalType = lexicalUnit.getLexicalUnitType();
            boolean bl3 = bl = lexicalType == LexicalUnit.LexicalType.OPERATOR_COMMA;
            if (!bl) {
                if (lexicalType == LexicalUnit.LexicalType.IDENT || lexicalType == LexicalUnit.LexicalType.ATTR) {
                    if ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) == null) {
                        return bl2;
                    }
                    lexicalType = lexicalUnit.getLexicalUnitType();
                    if (lexicalType == LexicalUnit.LexicalType.IDENT) {
                        if (!bl2 && !"hue".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                            return false;
                        }
                        if ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) == null) {
                            return bl2;
                        }
                        lexicalType = lexicalUnit.getLexicalUnitType();
                    }
                    bl = lexicalType == LexicalUnit.LexicalType.OPERATOR_COMMA;
                } else if (lexicalType == LexicalUnit.LexicalType.VAR) {
                    bl2 = true;
                } else if (!bl2) {
                    return false;
                }
            }
            if (bl) {
                lexicalUnit = lexicalUnit.getNextLexicalUnit();
            }
            if (lexicalUnit == null) {
                return !bl && bl2;
            }
            CSSValueSyntax cSSValueSyntax = new SyntaxParser().parseSyntax("<color>");
            LexicalUnit.LexicalType lexicalType2 = lexicalUnit.getLexicalUnitType();
            if (lexicalType2 == LexicalUnit.LexicalType.PERCENTAGE || lexicalType2 == LexicalUnit.LexicalType.CALC || lexicalType2 == LexicalUnit.LexicalType.MATH_FUNCTION || lexicalType2 == LexicalUnit.LexicalType.FUNCTION) {
                if ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) == null || this.cannotBeColor(lexicalUnit, cSSValueSyntax)) {
                    return false;
                }
                lexicalUnit = lexicalUnit.getNextLexicalUnit();
            } else if (lexicalType2 == LexicalUnit.LexicalType.VAR) {
                bl2 = true;
                lexicalUnit = lexicalUnit.getNextLexicalUnit();
            } else {
                if (this.cannotBeColor(lexicalUnit, cSSValueSyntax)) {
                    return false;
                }
                if ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) == null) {
                    return bl2;
                }
                lexicalType2 = lexicalUnit.getLexicalUnitType();
                if (lexicalType2 != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    switch (lexicalType2) {
                        case VAR: {
                            bl2 = true;
                        }
                        case FUNCTION: 
                        case CALC: 
                        case MATH_FUNCTION: 
                        case ATTR: 
                        case PERCENTAGE: {
                            lexicalUnit = lexicalUnit.getNextLexicalUnit();
                            break;
                        }
                        default: {
                            return false;
                        }
                    }
                }
            }
            if (lexicalUnit == null) {
                return bl2;
            }
            lexicalType2 = lexicalUnit.getLexicalUnitType();
            if (lexicalType2 != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                return bl2 && (!this.cannotBeColor(lexicalUnit, cSSValueSyntax) || lexicalType2 == LexicalUnit.LexicalType.PERCENTAGE || lexicalType2 == LexicalUnit.LexicalType.CALC || lexicalType2 == LexicalUnit.LexicalType.MATH_FUNCTION || lexicalType2 == LexicalUnit.LexicalType.FUNCTION || lexicalType2 == LexicalUnit.LexicalType.VAR);
            }
            lexicalType2 = (lexicalUnit = lexicalUnit.getNextLexicalUnit()).getLexicalUnitType();
            if (lexicalType2 == LexicalUnit.LexicalType.PERCENTAGE || lexicalType2 == LexicalUnit.LexicalType.CALC || lexicalType2 == LexicalUnit.LexicalType.MATH_FUNCTION || lexicalType2 == LexicalUnit.LexicalType.FUNCTION) {
                if ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) == null || this.cannotBeColor(lexicalUnit, cSSValueSyntax)) {
                    return false;
                }
                lexicalUnit = lexicalUnit.getNextLexicalUnit();
            } else if (lexicalType2 == LexicalUnit.LexicalType.VAR) {
                bl2 = true;
                lexicalUnit = lexicalUnit.getNextLexicalUnit();
            } else {
                if (this.cannotBeColor(lexicalUnit, cSSValueSyntax)) {
                    return false;
                }
                if ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) == null) {
                    return true;
                }
                lexicalType2 = lexicalUnit.getLexicalUnitType();
                if (lexicalType2 == LexicalUnit.LexicalType.PERCENTAGE || lexicalType2 == LexicalUnit.LexicalType.CALC || lexicalType2 == LexicalUnit.LexicalType.MATH_FUNCTION || lexicalType2 == LexicalUnit.LexicalType.FUNCTION || lexicalType2 == LexicalUnit.LexicalType.VAR || lexicalType2 == LexicalUnit.LexicalType.ATTR) {
                    lexicalUnit = lexicalUnit.getNextLexicalUnit();
                } else {
                    return false;
                }
            }
            while (lexicalUnit != null) {
                if (lexicalUnit.getLexicalUnitType() != LexicalUnit.LexicalType.VAR) {
                    return false;
                }
                lexicalUnit = lexicalUnit.getNextLexicalUnit();
            }
            return true;
        }

        private boolean cannotBeColor(LexicalUnit lexicalUnit, CSSValueSyntax cSSValueSyntax) {
            LexicalUnit lexicalUnit2 = lexicalUnit.getNextLexicalUnit() == null ? lexicalUnit : lexicalUnit.shallowClone();
            return lexicalUnit2.matches(cSSValueSyntax) == CSSValueSyntax.Match.FALSE;
        }

        public void rightCurlyBracket(int n) {
            if (this.parendepth != 0 || this.squareBracketDepth != 0) {
                this.parseError = true;
                this.parendepth = 0;
                this.squareBracketDepth = 0;
            }
            if (this.curlyBracketDepth == 1) {
                this.endOfPropertyDeclaration(n);
                this.handleRightCurlyBracket(n);
            } else if (this.curlyBracketDepth == 2) {
                int n2 = this.buffer.length();
                if (n2 != 0) {
                    this.unexpectedTokenError(n - n2, this.buffer);
                    this.buffer.setLength(0);
                }
            } else {
                this.parseError = true;
            }
            --this.curlyBracketDepth;
            this.prevcp = 125;
        }

        protected void handleRightCurlyBracket(int n) {
            this.handleError(n, (byte)4, "Unexpected '}'");
        }

        public void rightSquareBracket(int n) {
            --this.squareBracketDepth;
            if (!this.parseError) {
                if (this.propertyName != null) {
                    this.processBuffer(n);
                    this.newLexicalUnit(LexicalUnit.LexicalType.RIGHT_BRACKET, false);
                } else {
                    this.unexpectedCharError(n, 93);
                }
                this.prevcp = 93;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void character(int n, int n2) {
            block45: {
                block54: {
                    block56: {
                        block68: {
                            block69: {
                                block67: {
                                    block63: {
                                        block65: {
                                            block66: {
                                                char c;
                                                block64: {
                                                    block62: {
                                                        block60: {
                                                            block61: {
                                                                block59: {
                                                                    block58: {
                                                                        block57: {
                                                                            block55: {
                                                                                block53: {
                                                                                    block52: {
                                                                                        block51: {
                                                                                            String string;
                                                                                            block48: {
                                                                                                block50: {
                                                                                                    block49: {
                                                                                                        block47: {
                                                                                                            block46: {
                                                                                                                if (!this.functionToken || this.currentlu.getLexicalUnitType() != LexicalUnit.LexicalType.URI) break block46;
                                                                                                                this.bufferAppend(n2);
                                                                                                                break block45;
                                                                                                            }
                                                                                                            if (n2 != 59) break block47;
                                                                                                            this.handleSemicolon(n);
                                                                                                            break block45;
                                                                                                        }
                                                                                                        if (this.parseError) break block45;
                                                                                                        if (this.propertyName != null) break block48;
                                                                                                        if (n2 != 45) break block49;
                                                                                                        this.buffer.append('-');
                                                                                                        n2 = 65;
                                                                                                        break block45;
                                                                                                    }
                                                                                                    if (n2 != 95) break block50;
                                                                                                    this.buffer.append('_');
                                                                                                    n2 = 65;
                                                                                                    break block45;
                                                                                                }
                                                                                                if (n2 == 58) {
                                                                                                    if (this.buffer.length() != 0) {
                                                                                                        this.setPropertyName(n);
                                                                                                        n2 = 32;
                                                                                                        break block45;
                                                                                                    } else {
                                                                                                        this.handleError(n, (byte)4, "Unexpected ':'");
                                                                                                    }
                                                                                                    break block45;
                                                                                                } else {
                                                                                                    if (n2 != 64) {
                                                                                                        this.badPropertyName(n, n2);
                                                                                                        return;
                                                                                                    }
                                                                                                    this.handleAtKeyword(n);
                                                                                                }
                                                                                                break block45;
                                                                                            }
                                                                                            if (!this.readPriority) break block51;
                                                                                            this.processBuffer(n);
                                                                                            if (n2 == 33 && this.priorityImportant && CSSParser.this.parserFlags.contains((Object)Parser.Flag.IEPRIOCHAR) && (string = this.setFullIdentCompat()) != null) {
                                                                                                this.warnIdentCompat(n, string);
                                                                                                this.lunit.setUnitType(LexicalUnit.LexicalType.COMPAT_PRIO);
                                                                                                this.lunit.setCssUnit((short)255);
                                                                                                break block45;
                                                                                            } else {
                                                                                                this.unexpectedCharError(n, n2);
                                                                                            }
                                                                                            break block45;
                                                                                        }
                                                                                        if (n2 != 44) break block52;
                                                                                        if (!this.functionToken || this.currentlu.parameters == null || !this.addToIdentCompat()) {
                                                                                            this.processBuffer(n);
                                                                                        }
                                                                                        this.newLexicalUnit(LexicalUnit.LexicalType.OPERATOR_COMMA, false);
                                                                                        break block45;
                                                                                    }
                                                                                    if (n2 != 33) break block53;
                                                                                    if (!this.functionToken) {
                                                                                        this.processBuffer(n);
                                                                                        this.readPriority = true;
                                                                                        break block45;
                                                                                    } else {
                                                                                        this.unexpectedCharError(n, n2);
                                                                                    }
                                                                                    break block45;
                                                                                }
                                                                                if (this.hexColor) break block54;
                                                                                if (n2 != 45) break block55;
                                                                                if (!this.unicodeRange && this.prevcp != 65) {
                                                                                    this.processBuffer(n);
                                                                                }
                                                                                this.buffer.append('-');
                                                                                n2 = 65;
                                                                                break block45;
                                                                            }
                                                                            if (this.unicodeRange) break block56;
                                                                            if (n2 != 95) break block57;
                                                                            this.buffer.append('_');
                                                                            n2 = 65;
                                                                            break block45;
                                                                        }
                                                                        if (n2 != 46) break block58;
                                                                        this.handleFullStop(n);
                                                                        break block45;
                                                                    }
                                                                    if (n2 != 37) break block59;
                                                                    if (this.prevcp == 65 && CSSParser.isDigit(this.buffer.charAt(this.buffer.length() - 1))) {
                                                                        this.buffer.append('%');
                                                                        break block45;
                                                                    } else {
                                                                        this.processBuffer(n);
                                                                        this.newLexicalUnit(LexicalUnit.LexicalType.OPERATOR_MOD, false);
                                                                    }
                                                                    break block45;
                                                                }
                                                                if (n2 != 35) break block60;
                                                                if (this.buffer.length() == 0) break block61;
                                                                if (this.functionToken && this.currentlu.getLexicalUnitType() != LexicalUnit.LexicalType.ELEMENT_REFERENCE) {
                                                                    this.buffer.append('#');
                                                                    break block45;
                                                                } else {
                                                                    this.unexpectedCharError(n, n2);
                                                                }
                                                                break block45;
                                                            }
                                                            if (this.currentlu == null || this.currentlu.getLexicalUnitType() != LexicalUnit.LexicalType.ELEMENT_REFERENCE) {
                                                                this.hexColor = true;
                                                                break block45;
                                                            } else if (this.currentlu.value == null) {
                                                                this.buffer.append('#');
                                                                break block45;
                                                            } else {
                                                                this.unexpectedCharError(n, n2);
                                                            }
                                                            break block45;
                                                        }
                                                        if (n2 != 58) break block62;
                                                        this.handleColon(n);
                                                        break block45;
                                                    }
                                                    if (n2 != 43) break block63;
                                                    if (this.buffer.length() != 1 || (c = this.buffer.charAt(0)) != 'U' && c != 'u') break block64;
                                                    this.buffer.setLength(0);
                                                    this.unicodeRange = true;
                                                    break block45;
                                                }
                                                if (this.buffer.length() != 0 && ((c = this.buffer.charAt(this.buffer.length() - 1)) == 'E' || c == 'e')) break block65;
                                                if (!this.functionToken) break block66;
                                                this.processBuffer(n);
                                                boolean bl = this.isPrevCpWhitespace();
                                                if ((bl && this.currentlu.getLexicalUnitType() == LexicalUnit.LexicalType.CALC || this.flagIEValues) && this.currentlu.parameters != null && !this.lastParamIsAlgebraicOperator()) {
                                                    this.newLexicalUnit(LexicalUnit.LexicalType.OPERATOR_PLUS, false);
                                                    break block45;
                                                } else if (bl || this.currentlu.parameters == null || this.lastParamIsMultOrSlashOperator()) {
                                                    this.buffer.append('+');
                                                    n2 = 65;
                                                    break block45;
                                                } else {
                                                    this.unexpectedCharError(n, n2);
                                                }
                                                break block45;
                                            }
                                            if (this.isPrevCpWhitespace()) {
                                                this.buffer.append('+');
                                                n2 = 65;
                                                break block45;
                                            } else if (this.isCustomProperty()) {
                                                this.processBuffer(n);
                                                this.newCustomPropertyOperator(n, n2, LexicalUnit.LexicalType.OPERATOR_PLUS);
                                                break block45;
                                            } else {
                                                this.unexpectedCharError(n, n2);
                                            }
                                            break block45;
                                        }
                                        this.buffer.append('+');
                                        n2 = 65;
                                        break block45;
                                    }
                                    if (n2 != 47) break block67;
                                    this.processBuffer(n);
                                    if (!this.functionToken || this.currentlu.parameters != null && (this.isVarOrLastParamIsOperand() || this.currentlu.getLexicalUnitType() == LexicalUnit.LexicalType.ATTR)) {
                                        this.newLexicalUnit(LexicalUnit.LexicalType.OPERATOR_SLASH, false);
                                        break block45;
                                    } else {
                                        this.unexpectedCharError(n, n2);
                                    }
                                    break block45;
                                }
                                if (!this.functionToken) break block68;
                                if (n2 != 42) break block69;
                                this.processBuffer(n);
                                if (this.currentlu.parameters != null && this.isVarOrLastParamIsOperand()) {
                                    this.newLexicalUnit(LexicalUnit.LexicalType.OPERATOR_MULTIPLY, false);
                                    break block45;
                                } else {
                                    this.unexpectedCharError(n, n2);
                                }
                                break block45;
                            }
                            if (this.currentlu.getLexicalUnitType() == LexicalUnit.LexicalType.TYPE_FUNCTION) {
                                if (n2 == 60 || n2 == 62) {
                                    this.bufferAppend(n2);
                                    break block45;
                                } else {
                                    this.unexpectedCharError(n, n2);
                                }
                                break block45;
                            } else if (n2 == 61 && this.handleEqualsSignInsideFunction(n)) {
                                n2 = 65;
                                break block45;
                            } else {
                                this.unexpectedCharError(n, n2);
                            }
                            break block45;
                        }
                        if (this.isCustomProperty()) {
                            if (n2 == 42) {
                                this.processBuffer(n);
                                this.newCustomPropertyOperator(n, n2, LexicalUnit.LexicalType.OPERATOR_MULTIPLY);
                                break block45;
                            } else {
                                this.unexpectedCharError(n, n2);
                            }
                            break block45;
                        } else if (n2 != 64 && n2 != 63 && n2 != 42) {
                            this.bufferAppend(n2);
                            break block45;
                        } else {
                            this.unexpectedCharError(n, n2);
                        }
                        break block45;
                    }
                    if (n2 == 63 && this.buffer.length() < 6) {
                        this.bufferAppend(n2);
                        break block45;
                    } else {
                        this.unexpectedCharError(n, n2);
                    }
                    break block45;
                }
                this.unexpectedCharError(n, n2);
            }
            this.prevcp = n2;
        }

        private void setPropertyName(int n) {
            String string = this.buffer.toString();
            if (this.escapedTokenIndex == -1) {
                if (this.isNotForbiddenIdentStart(string) || string.charAt(0) == '*' && CSSParser.this.parserFlags.contains((Object)Parser.Flag.STARHACK)) {
                    this.propertyName = string;
                    this.buffer.setLength(0);
                    return;
                }
            } else if (this.isNotForbiddenIdentStart(string)) {
                this.propertyName = this.unescapeBuffer(n);
                if (!this.parseError && !CSSParser.isValidIdentifier(this.propertyName)) {
                    this.handleWarning(n - this.buffer.length(), (byte)-4, "Suspicious property name: " + string);
                }
                return;
            }
            this.handleError(n - this.buffer.length(), (byte)7, "Invalid property name: '" + string + '\'');
        }

        private void newCustomPropertyOperator(int n, int n2, LexicalUnit.LexicalType lexicalType) {
            if (this.currentlu == null) {
                this.newLexicalUnit(lexicalType, false);
                return;
            }
            assert (this.currentlu.parameters == null);
            LexicalUnit.LexicalType lexicalType2 = this.currentlu.getLexicalUnitType();
            if (!this.typeIsAlgebraicOperator(lexicalType2) && lexicalType2 != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                this.newLexicalUnit(lexicalType, false);
                return;
            }
            this.unexpectedCharError(n, n2);
        }

        private boolean handleEqualsSignInsideFunction(int n) {
            if (this.flagIEValues && (this.propertyName.length() == 0 || this.propertyName.endsWith("filter") || "expression".equalsIgnoreCase(this.currentlu.getFunctionName())) && (this.prevcp == 65 || this.isPrevCpWhitespace() || this.prevcp == 93)) {
                int n2 = this.buffer.length();
                if (n2 != 0) {
                    if (this.escapedTokenIndex == -1) {
                        String string;
                        this.buffer.append('=');
                        this.newLexicalUnit((LexicalUnit.LexicalType)LexicalUnit.LexicalType.COMPAT_IDENT, (boolean)false).value = string = this.buffer.toString();
                        this.buffer.setLength(0);
                        this.hexColor = false;
                        this.warnIdentCompat(n - n2, string);
                        return true;
                    }
                } else {
                    LexicalUnitImpl lexicalUnitImpl = this.currentlu.parameters;
                    if (lexicalUnitImpl != null) {
                        LexicalUnit.LexicalType lexicalType = (lexicalUnitImpl = this.findLastValue(lexicalUnitImpl)).getLexicalUnitType();
                        if (lexicalType == LexicalUnit.LexicalType.IDENT) {
                            lexicalUnitImpl.setUnitType(LexicalUnit.LexicalType.COMPAT_IDENT);
                            String string = lexicalUnitImpl.getStringValue();
                            lexicalUnitImpl.value = lexicalUnitImpl.value + '=';
                            this.warnIdentCompat(n - string.length(), string);
                            return true;
                        }
                        if (lexicalType == LexicalUnit.LexicalType.COMPAT_IDENT) {
                            lexicalUnitImpl.value = lexicalUnitImpl.value + '=';
                            return true;
                        }
                        if (lexicalType == LexicalUnit.LexicalType.RIGHT_BRACKET) {
                            this.newLexicalUnit((LexicalUnit.LexicalType)LexicalUnit.LexicalType.COMPAT_IDENT, (boolean)false).value = "=";
                            this.warnIdentCompat(n, "=");
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        private LexicalUnitImpl findLastValue(LexicalUnitImpl lexicalUnitImpl) {
            LexicalUnitImpl lexicalUnitImpl2;
            while ((lexicalUnitImpl2 = lexicalUnitImpl.nextLexicalUnit) != null) {
                lexicalUnitImpl = lexicalUnitImpl2;
            }
            return lexicalUnitImpl;
        }

        private boolean isCustomProperty() {
            return this.propertyName.startsWith("--");
        }

        private boolean addToIdentCompat() {
            LexicalUnitImpl lexicalUnitImpl;
            LexicalUnit.LexicalType lexicalType;
            if (this.escapedTokenIndex == -1 && (lexicalType = (lexicalUnitImpl = this.findLastValue(this.currentlu.parameters)).getLexicalUnitType()) == LexicalUnit.LexicalType.COMPAT_IDENT) {
                if (this.hexColor) {
                    lexicalUnitImpl.value = lexicalUnitImpl.value + '#';
                    this.hexColor = false;
                }
                if (this.buffer.length() != 0) {
                    lexicalUnitImpl.value = lexicalUnitImpl.value + this.buffer;
                    this.buffer.setLength(0);
                }
                this.prevcp = 65;
                return true;
            }
            return false;
        }

        private boolean checkLastIdentCompat() {
            LexicalUnitImpl lexicalUnitImpl = this.currentlu.parameters;
            if (lexicalUnitImpl != null && (lexicalUnitImpl = this.findLastValue(lexicalUnitImpl)).getLexicalUnitType() == LexicalUnit.LexicalType.COMPAT_IDENT) {
                if (this.hexColor) {
                    lexicalUnitImpl.value = lexicalUnitImpl.value + '#';
                    this.hexColor = false;
                }
                lexicalUnitImpl.value = lexicalUnitImpl.value + this.buffer;
                this.buffer.setLength(0);
                return true;
            }
            return false;
        }

        private void handleFullStop(int n) {
            if (this.prevcp == 65) {
                this.buffer.append('.');
            } else if (this.buffer.length() == 0) {
                LexicalUnitImpl lexicalUnitImpl;
                if (this.prevcp == 45 && this.functionToken && this.escapedTokenIndex == -1 && this.currentlu.parameters != null && (lexicalUnitImpl = this.findLastValue(this.currentlu.parameters)).getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_MINUS) {
                    LexicalUnitImpl lexicalUnitImpl2 = lexicalUnitImpl.previousLexicalUnit;
                    if (lexicalUnitImpl2 != null) {
                        lexicalUnitImpl2.nextLexicalUnit = null;
                    } else {
                        this.currentlu.parameters = null;
                    }
                    this.buffer.append('-');
                }
                this.buffer.append('0').append('.');
            } else {
                this.handleError(n, (byte)4, "Unexpected '.'");
            }
        }

        private void handleColon(int n) {
            int n2 = this.buffer.length();
            if (n2 != 0) {
                if (n2 != 6 || !this.flagIEValues || !ParseHelper.equalsIgnoreCase(this.buffer, "progid")) {
                    this.handleError(n, (byte)4, "Unexpected ':'");
                } else {
                    this.buffer.append(':');
                    this.handleWarning(n, (byte)-3, "Progid hack applied");
                }
            }
        }

        protected void handleAtKeyword(int n) {
            this.unexpectedCharError(n, 64);
        }

        private void handleSemicolon(int n) {
            if (this.isDeclarationContext() && this.squareBracketDepth == 0) {
                if (this.parendepth == 0) {
                    this.endOfPropertyDeclaration(n);
                    return;
                }
                if (this.parendepth == 1 && this.functionToken && this.allowSemicolonArgument()) {
                    this.processBuffer(n);
                    this.newLexicalUnit(LexicalUnit.LexicalType.OPERATOR_SEMICOLON, false);
                    return;
                }
            }
            this.handleError(n, (byte)4, "Unexpected ';'");
        }

        protected boolean isDeclarationContext() {
            return this.curlyBracketDepth == 1;
        }

        protected void badPropertyName(int n, int n2) {
            if (this.buffer.length() == 0 && n2 == 42 && CSSParser.this.parserFlags.contains((Object)Parser.Flag.STARHACK)) {
                if (CSSParser.this.errorHandler != null) {
                    CSSParser.this.errorHandler.warning(this.createException(n, (byte)4, "Unexpected character: * (IE hack)"));
                }
                this.buffer.append('*');
            } else {
                this.unexpectedCharError(n, n2);
            }
        }

        protected void endOfPropertyDeclaration(int n) {
            if (this.propertyName != null) {
                this.processBuffer(n);
                if (!this.parseError) {
                    if (!this.isCustomProperty()) {
                        if (this.lunit != null) {
                            this.handleProperty(n, this.propertyName, this.lunit, this.priorityImportant);
                        } else {
                            this.handleError(n, (byte)32, "Found property name (" + this.propertyName + ") but no value");
                        }
                    } else {
                        if (this.lunit == null) {
                            this.lunit = new LexicalUnitImpl(LexicalUnit.LexicalType.EMPTY);
                            this.lunit.value = "";
                        }
                        this.handleLexicalProperty(n, this.propertyName, this.lunit, this.priorityImportant);
                    }
                }
                this.propertyName = null;
            } else if (this.buffer.length() != 0) {
                this.unexpectedTokenError(n, this.buffer);
            }
            this.resetHandler();
        }

        protected void handleProperty(int n, String string, LexicalUnitImpl lexicalUnitImpl, boolean bl) {
            this.setCurrentLocation(n);
            CSSParser.this.handler.property(string, lexicalUnitImpl, bl);
        }

        void handleLexicalProperty(int n, String string, LexicalUnitImpl lexicalUnitImpl, boolean bl) {
            this.setCurrentLocation(n);
            CSSParser.this.handler.lexicalProperty(string, lexicalUnitImpl, bl);
        }

        @Override
        void resetHandler() {
            super.resetHandler();
            this.lunit = null;
            this.currentlu = null;
            this.priorityImportant = false;
            this.readPriority = false;
            this.functionToken = false;
            this.hexColor = false;
            this.unicodeRange = false;
            this.buffer.setLength(0);
        }

        protected void processBuffer(int n) {
            if (this.parseError) {
                this.buffer.setLength(0);
                return;
            }
            int n2 = this.buffer.length();
            if (n2 != 0) {
                if (this.propertyName == null) {
                    this.setPropertyName(n);
                } else if (this.readPriority) {
                    String string = this.unescapeBuffer(n);
                    if ("important".equalsIgnoreCase(string)) {
                        this.priorityImportant = true;
                    } else {
                        this.checkIEPrioHack(n - n2, string);
                    }
                } else if (this.functionToken) {
                    switch (this.currentlu.getLexicalUnitType()) {
                        case URI: {
                            if (this.currentlu.value == null) {
                                this.currentlu.value = this.rawBuffer();
                                break;
                            }
                            this.handleError(n, (byte)5, "Unexpected token in url: '" + this.rawBuffer() + '\'');
                            break;
                        }
                        case ELEMENT_REFERENCE: {
                            String string = this.unescapeStringValue(n);
                            if (string.length() > 1 && string.charAt(0) == '#') {
                                this.currentlu.value = string.substring(1);
                            } else {
                                this.handleError(n - n2, (byte)5, "Wrong element reference: " + string);
                                this.functionToken = false;
                            }
                            this.buffer.setLength(0);
                            break;
                        }
                        case TYPE_FUNCTION: {
                            String string = this.unescapeStringValue(n);
                            this.buffer.setLength(0);
                            SyntaxUnitImpl syntaxUnitImpl = this.newSyntaxUnit();
                            try {
                                syntaxUnitImpl.syntax = new SyntaxParser().parseSyntax(string);
                            }
                            catch (CSSException cSSException) {
                                this.handleError(n - n2, (byte)5, "Invalid syntax: " + string);
                            }
                            break;
                        }
                        default: {
                            if (this.escapedTokenIndex != -1 || !this.checkLastIdentCompat()) {
                                if (!this.hexColor) {
                                    this.parseNonHexcolorValue(n);
                                    break;
                                }
                                if (!this.parseHexColor(n2)) {
                                    this.handleError(n - n2, (byte)5, "Wrong color value #" + this.buffer);
                                }
                                this.buffer.setLength(0);
                                this.hexColor = false;
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                } else if (this.hexColor) {
                    if (!this.parseHexColor(n2)) {
                        this.handleError(n - n2, (byte)5, "Wrong color value #" + this.buffer);
                    }
                    this.buffer.setLength(0);
                    this.hexColor = false;
                } else if (this.unicodeRange) {
                    this.parseUnicodeRange(n, n2);
                } else {
                    this.parseNonHexcolorValue(n);
                }
            } else if (this.hexColor) {
                this.handleError(n, (byte)5, "Empty hex color value");
            } else if (this.unicodeRange) {
                this.handleError(n, (byte)9, "Bad unicode range");
            }
        }

        private void parseNonHexcolorValue(int n) {
            String string = this.buffer.toString();
            int n2 = string.length();
            if (this.escapedTokenIndex != -1) {
                String string2;
                String string3;
                int n3 = n - this.escapedTokenIndex;
                int n4 = n2 - n3;
                if (n4 <= 0) {
                    try {
                        string3 = this.unescapeIdentifier(n, string);
                        string2 = ParseHelper.safeEscape(string3, true, true);
                    }
                    catch (DOMNullCharacterException dOMNullCharacterException) {
                        if (this.flagIEValues) {
                            this.setIdentCompat(n - n2, string);
                            this.escapedTokenIndex = -1;
                            this.buffer.setLength(0);
                            return;
                        }
                        string3 = this.safeUnescapeIdentifier(n, string);
                        string2 = this.safeNullEscape(string);
                    }
                } else {
                    CharSequence charSequence = this.buffer.subSequence(0, n4);
                    string2 = this.buffer.substring(n4);
                    try {
                        string3 = this.unescapeIdentifier(n, string2);
                        string2 = ParseHelper.safeEscape(string3, true, true);
                    }
                    catch (DOMNullCharacterException dOMNullCharacterException) {
                        if (this.flagIEValues) {
                            this.setIdentCompat(n - n2, string);
                            this.escapedTokenIndex = -1;
                            this.buffer.setLength(0);
                            return;
                        }
                        string3 = this.safeUnescapeIdentifier(n, string2);
                        string2 = this.safeNullEscape(string2);
                    }
                    string3 = charSequence + string3;
                    charSequence = ParseHelper.escapeAllBackslash(charSequence);
                    string2 = ParseHelper.escapeCssCharsAndFirstChar(charSequence) + string2;
                }
                this.escapedTokenIndex = -1;
                if (!this.createIdentifierOrKeyword(n, string, string3, string2)) {
                    this.checkForIEValue(n, string);
                }
            } else {
                String string4 = this.buffer.toString();
                String string5 = ParseHelper.escapeCssCharsAndFirstChar(string).toString();
                this.createIdentifierOrNumberOrKeyword(n, string, string4, string5);
            }
            this.buffer.setLength(0);
        }

        private void createIdentifierOrNumberOrKeyword(int n, String string, String string2, String string3) {
            int n2 = string2.codePointAt(0);
            if (n2 != 32) {
                int n3;
                int n4 = string2.length();
                for (n3 = n4 - 1; n3 >= 0; --n3) {
                    n2 = string2.codePointAt(n3);
                    if (Character.isLetter(n2) || n2 == 37) continue;
                    if (n2 >= 48 && n2 <= 57 && this.parseNumber(n, string2, n3 + 1) || this.newIdentifier(string, string2, string3)) break;
                    if (string.length() == 1) {
                        char c = string.charAt(0);
                        if (c == '+') {
                            this.newOperator(n, 43, LexicalUnit.LexicalType.OPERATOR_PLUS);
                            return;
                        }
                        if (c != '-') break;
                        this.newOperator(n, 45, LexicalUnit.LexicalType.OPERATOR_MINUS);
                        return;
                    }
                    this.checkForIEValue(n, string);
                    break;
                }
                if (n3 != -1) {
                    return;
                }
            }
            if (!this.createIdentifierOrKeyword(n, string, string2, string3)) {
                this.handleError(n - string.length(), (byte)7, "Invalid identifier: " + string);
            }
        }

        private boolean parseNumber(int n, String string, int n2) {
            String string2 = null;
            if (n2 != string.length()) {
                float f;
                String string3 = string.substring(0, n2);
                try {
                    f = Float.parseFloat(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                string2 = string.substring(n2);
                string2 = string2.trim().toLowerCase(Locale.ROOT);
                short s = UnitStringToId.unitFromString(string2);
                LexicalUnit.LexicalType lexicalType = s == 2 ? LexicalUnit.LexicalType.PERCENTAGE : LexicalUnit.LexicalType.DIMENSION;
                LexicalUnitImpl lexicalUnitImpl = this.newLexicalUnit(lexicalType, false);
                lexicalUnitImpl.floatValue = f;
                lexicalUnitImpl.dimensionUnitText = string2;
                lexicalUnitImpl.setCssUnit(s);
            } else if (string.lastIndexOf(46, n2) == -1) {
                int n3;
                try {
                    n3 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    float f;
                    try {
                        f = Float.parseFloat(string);
                    }
                    catch (NumberFormatException numberFormatException2) {
                        return false;
                    }
                    LexicalUnitImpl lexicalUnitImpl = this.newNumberUnit(LexicalUnit.LexicalType.REAL);
                    lexicalUnitImpl.floatValue = f;
                    return true;
                }
                LexicalUnitImpl lexicalUnitImpl = this.newNumberUnit(LexicalUnit.LexicalType.INTEGER);
                lexicalUnitImpl.intValue = n3;
            } else {
                float f;
                try {
                    f = Float.parseFloat(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                if (f == 0.0f) {
                    LexicalUnitImpl lexicalUnitImpl = this.newNumberUnit(LexicalUnit.LexicalType.INTEGER);
                    lexicalUnitImpl.intValue = (int)f;
                } else {
                    LexicalUnitImpl lexicalUnitImpl = this.newNumberUnit(LexicalUnit.LexicalType.REAL);
                    lexicalUnitImpl.floatValue = f;
                }
            }
            return true;
        }

        private void newOperator(int n, int n2, LexicalUnit.LexicalType lexicalType) {
            LexicalUnit.LexicalType lexicalType2;
            if (this.currentlu == null) {
                if (this.isCustomProperty()) {
                    this.newLexicalUnit(lexicalType, false);
                    return;
                }
            } else if (this.currentlu.parameters != null) {
                if (this.isVarOrLastParamIsOperand()) {
                    this.newLexicalUnit(lexicalType, false);
                    return;
                }
            } else if (this.isCustomProperty() && !this.typeIsAlgebraicOperator(lexicalType2 = this.currentlu.getLexicalUnitType()) && lexicalType2 != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                this.newLexicalUnit(lexicalType, false);
                return;
            }
            this.unexpectedCharError(n, n2);
        }

        private boolean createIdentifierOrKeyword(int n, String string, String string2, String string3) {
            if (string2.equalsIgnoreCase("inherit")) {
                this.newLexicalUnit(LexicalUnit.LexicalType.INHERIT, false);
            } else if (string2.equalsIgnoreCase("initial")) {
                this.newLexicalUnit(LexicalUnit.LexicalType.INITIAL, false);
            } else if (string2.equalsIgnoreCase("unset")) {
                this.newLexicalUnit(LexicalUnit.LexicalType.UNSET, false);
            } else if (string2.equalsIgnoreCase("revert")) {
                this.newLexicalUnit(LexicalUnit.LexicalType.REVERT, false);
            } else {
                return this.newIdentifier(string, string2, string3);
            }
            return true;
        }

        private boolean newIdentifier(String string, String object, String string2) {
            if (this.isNotForbiddenIdentStart(string)) {
                Object object2;
                if (this.propertyDatabase != null && (object2 = ((String)object).toLowerCase(Locale.ROOT)) != object) {
                    if (this.propertyDatabase.isShorthand(this.propertyName)) {
                        if (!this.isPreviousValueCustomIdent()) {
                            String[] stringArray;
                            for (String string3 : stringArray = this.propertyDatabase.getLonghandProperties(this.propertyName)) {
                                if (!this.isIdentifierValueOf(string3, (String)object2)) continue;
                                object = object2;
                            }
                        }
                    } else if (this.isIdentifierValueOf(this.propertyName, (String)object2)) {
                        object = object2;
                    }
                }
                object2 = this.newLexicalUnit(LexicalUnit.LexicalType.IDENT, false);
                ((LexicalUnitImpl)object2).value = object;
                ((LexicalUnitImpl)object2).identCssText = string2;
                return true;
            }
            return false;
        }

        private boolean isIdentifierValueOf(String string, String string2) {
            return this.propertyDatabase.isIdentifierValue(string, string2) || "none".equals(string2);
        }

        private boolean isPreviousValueCustomIdent() {
            String string;
            return this.currentlu != null && this.currentlu.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && (string = this.currentlu.getStringValue()) != string.toLowerCase(Locale.ROOT);
        }

        private String safeNullEscape(String string) {
            String string2;
            int n;
            CharSequence charSequence = ParseHelper.escapeCssChars(ParseHelper.escapeBackslash(string));
            if (charSequence.charAt((n = charSequence.length()) - 1) == '0') {
                StringBuilder stringBuilder = new StringBuilder(n + 1);
                stringBuilder.append(charSequence).append(' ');
                string2 = stringBuilder.toString();
            } else {
                string2 = charSequence.toString();
            }
            return string2;
        }

        private void checkForIEValue(int n, String string) {
            int n2 = string.length();
            if (!(this.flagIEValues && n2 > 2 && string.charAt(n2 - 2) == '\\' && this.isIEHackSuffix(string.codePointAt(n2 - 1)) && this.setIdentCompat(n - n2, string))) {
                this.handleError(n - n2, (byte)7, "Invalid identifier: " + string);
            }
        }

        private boolean isIEHackSuffix(int n) {
            return n == 57 || n == 48;
        }

        private void checkIEPrioHack(int n, String string) {
            String string2;
            this.buffer.append('!').append(string);
            if (CSSParser.this.parserFlags.contains((Object)Parser.Flag.IEPRIO) && "ie".equals(string) && (string2 = this.setFullIdentCompat()) != null) {
                this.warnIdentCompat(n, string2);
            } else {
                this.handleError(n, (byte)9, "Invalid priority: " + string);
            }
        }

        private boolean setIdentCompat(int n, String string) {
            if (this.currentlu != null) {
                String string2;
                try {
                    string2 = this.currentlu.toString();
                }
                catch (RuntimeException runtimeException) {
                    this.lunit.reset();
                    return false;
                }
                this.currentlu.reset();
                this.currentlu.value = string2 + ' ' + string;
                this.currentlu.setUnitType(LexicalUnit.LexicalType.COMPAT_IDENT);
                this.currentlu.setCssUnit((short)255);
            } else {
                this.newLexicalUnit((LexicalUnit.LexicalType)LexicalUnit.LexicalType.COMPAT_IDENT, (boolean)false).value = string;
            }
            this.warnIdentCompat(n, string);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String setFullIdentCompat() {
            String string;
            if (!this.hexColor) {
                string = this.rawBuffer();
            } else {
                this.hexColor = false;
                string = '#' + this.rawBuffer();
            }
            if (this.lunit != null) {
                try {
                    string = this.lunit.toString() + string;
                }
                catch (RuntimeException runtimeException) {
                    String string2 = null;
                    return string2;
                }
                finally {
                    this.lunit.reset();
                }
                this.lunit.value = string;
                this.lunit.setUnitType(LexicalUnit.LexicalType.COMPAT_IDENT);
                this.lunit.setCssUnit((short)255);
            } else {
                this.newLexicalUnit((LexicalUnit.LexicalType)LexicalUnit.LexicalType.COMPAT_IDENT, (boolean)false).value = string;
            }
            return string;
        }

        private void warnIdentCompat(int n, String string) {
            this.handleWarning(n, (byte)-2, "Found compat ident: " + string);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void parseUnicodeRange(int n, int n2) {
            LexicalUnitImpl lexicalUnitImpl;
            LexicalUnitImpl lexicalUnitImpl2 = null;
            String string = this.rawBuffer();
            int n3 = string.indexOf(45);
            if (n3 == -1) {
                byte by = this.rangeLengthCheck(string);
                if (by == 1) {
                    lexicalUnitImpl = new LexicalUnitImpl(LexicalUnit.LexicalType.INTEGER);
                    lexicalUnitImpl.intValue = Integer.parseInt(string, 16);
                } else {
                    if (by != 2) {
                        this.handleError(n - n2, (byte)9, "Invalid unicode range: " + string);
                        return;
                    }
                    lexicalUnitImpl = new LexicalUnitImpl(LexicalUnit.LexicalType.UNICODE_WILDCARD);
                    lexicalUnitImpl.value = string;
                }
            } else if (n3 > 0 && n3 < string.length() - 1) {
                String string2 = string.substring(0, n3);
                String string3 = string.substring(n3 + 1);
                byte by = this.rangeLengthCheck(string2);
                if (by != 1) {
                    this.handleError(n - n2, (byte)9, "Invalid unicode range: " + string);
                    return;
                }
                lexicalUnitImpl = new LexicalUnitImpl(LexicalUnit.LexicalType.INTEGER);
                lexicalUnitImpl.intValue = Integer.parseInt(string2, 16);
                by = this.rangeLengthCheck(string3);
                if (by != 1) {
                    this.handleError(n - n2, (byte)9, "Invalid unicode range: " + string);
                    return;
                }
                lexicalUnitImpl2 = new LexicalUnitImpl(LexicalUnit.LexicalType.INTEGER);
                lexicalUnitImpl2.intValue = Integer.parseInt(string3, 16);
            } else {
                this.handleError(n - n2, (byte)9, "Invalid unicode range: " + string);
                return;
            }
            LexicalUnitImpl lexicalUnitImpl3 = this.newLexicalUnit(LexicalUnit.LexicalType.UNICODE_RANGE, false);
            lexicalUnitImpl3.addFunctionParameter(lexicalUnitImpl);
            if (lexicalUnitImpl2 != null) {
                lexicalUnitImpl3.addFunctionParameter(lexicalUnitImpl2);
            }
            this.unicodeRange = false;
        }

        private byte rangeLengthCheck(String string) {
            int n = 0;
            int n2 = string.length();
            if (n2 < 7) {
                for (int i = 0; i < n2; ++i) {
                    if (string.charAt(i) == '?') {
                        n = (byte)(n + 1);
                        continue;
                    }
                    if (n == 0) continue;
                    return 0;
                }
                if (n == 0) {
                    return 1;
                }
                if (n != 6) {
                    return 2;
                }
            }
            return 0;
        }

        private boolean parseHexColor(int n) {
            block6: {
                try {
                    if (n == 3) {
                        this.newLexicalUnit(LexicalUnit.LexicalType.RGBCOLOR, true);
                        this.currentlu.value = "rgb";
                        boolean bl = this.functionToken;
                        this.functionToken = true;
                        this.parseHexComponent(0, 1, true);
                        this.parseHexComponent(1, 2, true);
                        this.parseHexComponent(2, 3, true);
                        this.recoverOwnerUnit();
                        this.functionToken = bl;
                        break block6;
                    }
                    if (n == 6) {
                        this.newLexicalUnit(LexicalUnit.LexicalType.RGBCOLOR, true);
                        this.currentlu.value = "rgb";
                        boolean bl = this.functionToken;
                        this.functionToken = true;
                        this.parseHexComponent(0, 2, false);
                        this.parseHexComponent(2, 4, false);
                        this.parseHexComponent(4, 6, false);
                        this.recoverOwnerUnit();
                        this.functionToken = bl;
                        break block6;
                    }
                    if (n == 8) {
                        this.newLexicalUnit(LexicalUnit.LexicalType.RGBCOLOR, true);
                        this.currentlu.value = "rgb";
                        boolean bl = this.functionToken;
                        this.functionToken = true;
                        this.parseHexComponent(0, 2, false);
                        this.parseHexComponent(2, 4, false);
                        this.parseHexComponent(4, 6, false);
                        int n2 = this.hexComponent(6, 8, false);
                        this.newLexicalUnit(LexicalUnit.LexicalType.OPERATOR_SLASH, false);
                        this.newNumberUnit((LexicalUnit.LexicalType)LexicalUnit.LexicalType.REAL).floatValue = (float)n2 / 255.0f;
                        this.recoverOwnerUnit();
                        this.functionToken = bl;
                        break block6;
                    }
                    if (n == 4) {
                        this.newLexicalUnit(LexicalUnit.LexicalType.RGBCOLOR, true);
                        this.currentlu.value = "rgb";
                        boolean bl = this.functionToken;
                        this.functionToken = true;
                        this.parseHexComponent(0, 1, true);
                        this.parseHexComponent(1, 2, true);
                        this.parseHexComponent(2, 3, true);
                        int n3 = this.hexComponent(3, 4, true);
                        this.newLexicalUnit(LexicalUnit.LexicalType.OPERATOR_SLASH, false);
                        this.newNumberUnit((LexicalUnit.LexicalType)LexicalUnit.LexicalType.REAL).floatValue = (float)n3 / 255.0f;
                        this.recoverOwnerUnit();
                        this.functionToken = bl;
                        break block6;
                    }
                    return false;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            return true;
        }

        private void parseHexComponent(int n, int n2, boolean bl) {
            int n3;
            this.newNumberUnit((LexicalUnit.LexicalType)LexicalUnit.LexicalType.INTEGER).intValue = n3 = this.hexComponent(n, n2, bl);
        }

        private LexicalUnitImpl newNumberUnit(LexicalUnit.LexicalType lexicalType) {
            LexicalUnitImpl lexicalUnitImpl = this.newLexicalUnit(lexicalType, false);
            lexicalUnitImpl.setCssUnit((short)0);
            return lexicalUnitImpl;
        }

        private int hexComponent(int n, int n2, boolean bl) {
            String string;
            if (bl) {
                CharSequence charSequence = this.buffer.subSequence(n, n2);
                string = new StringBuilder(2).append(charSequence).append(charSequence).toString();
            } else {
                string = this.buffer.substring(n, n2);
            }
            return Integer.parseInt(string, 16);
        }

        private void recoverOwnerUnit() {
            this.currentlu.identCssText = "#" + this.buffer;
            if (this.currentlu.ownerLexicalUnit != null) {
                this.currentlu = this.currentlu.ownerLexicalUnit;
            }
        }

        public void quoted(int n, CharSequence charSequence, int n2) {
            if (!(this.hexColor || this.unicodeRange || this.readPriority || this.propertyName == null)) {
                this.processBuffer(n);
                if (!this.parseError) {
                    String string = charSequence.toString();
                    LexicalUnitImpl lexicalUnitImpl = this.newLexicalUnit(LexicalUnit.LexicalType.STRING, false);
                    if (lexicalUnitImpl.value != null) {
                        this.handleError(n, (byte)5, "Unexpected string: " + n2 + charSequence + n2);
                    }
                    lexicalUnitImpl.value = this.safeUnescapeIdentifier(n, string);
                    char c = (char)n2;
                    StringBuilder stringBuilder = new StringBuilder(string.length() + 2);
                    stringBuilder.append(c).append(string).append(c);
                    lexicalUnitImpl.identCssText = stringBuilder.toString();
                    this.prevcp = 65;
                }
            } else {
                char c = (char)n2;
                StringBuilder stringBuilder = new StringBuilder(charSequence.length() + 2);
                stringBuilder.append(c).append(charSequence).append(c);
                this.unexpectedTokenError(n, stringBuilder.toString());
            }
        }

        public void quotedWithControl(int n, CharSequence charSequence, int n2) {
            if (!(this.hexColor || this.unicodeRange || this.readPriority || this.propertyName == null)) {
                this.processBuffer(n);
                if (!this.parseError) {
                    String string = charSequence.toString();
                    LexicalUnitImpl lexicalUnitImpl = this.newLexicalUnit(LexicalUnit.LexicalType.STRING, false);
                    if (lexicalUnitImpl.value != null) {
                        this.handleError(n, (byte)5, "Unexpected string: " + n2 + charSequence + n2);
                    }
                    lexicalUnitImpl.value = this.safeUnescapeIdentifier(n, string);
                    char c = (char)n2;
                    lexicalUnitImpl.identCssText = c + ParseHelper.escapeControl(string) + c;
                    this.prevcp = 65;
                }
            } else {
                char c = (char)n2;
                StringBuilder stringBuilder = new StringBuilder(charSequence.length() + 2);
                stringBuilder.append(c).append(charSequence).append(c);
                this.unexpectedTokenError(n, stringBuilder.toString());
            }
        }

        public void escaped(int n, int n2) {
            if (!this.parseError && (this.unicodeRange || this.isEscapedContentError(n, n2))) {
                this.unexpectedCharError(n, n2);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isEscapedContentError(int n, int n2) {
            if (this.isEscapedContext(this.prevcp) && !this.hexColor) {
                if (ParseHelper.isHexCodePoint(n2) || n2 == 92 || n2 == 43 || n2 == 45 || n2 == 32) {
                    this.setEscapedTokenStart(n);
                    this.buffer.append('\\');
                }
                this.prevcp = 65;
                this.bufferAppend(n2);
                return false;
            } else {
                if (!this.flagIEValues || !this.isIEHackSuffix(n2) || this.lunit == null && this.buffer.length() == 0) return true;
                this.buffer.append('\\');
                this.bufferAppend(n2);
                String string = this.setFullIdentCompat();
                this.escapedTokenIndex = -1;
                if (string == null) return true;
                this.warnIdentCompat(n, string);
                this.prevcp = n2;
            }
            return false;
        }

        private boolean isEscapedContext(int n) {
            return n == 65 || this.isPrevCpWhitespace() || n == 58 || n == 44 || n == 59 || n == 123 || this.readPriority && n == 33;
        }

        public void separator(int n, int n2) {
            if (!this.parseError) {
                if (this.escapedTokenIndex != -1 && CSSParser.bufferEndsWithEscapedChar(this.buffer)) {
                    this.buffer.append(' ');
                    return;
                }
                this.processBuffer(n);
            }
            this.setWhitespacePrevCp();
        }

        @Override
        protected void highControl(int n, int n2) {
            if (!this.parseError) {
                if (!(this.hexColor || this.unicodeRange || this.readPriority || this.propertyName == null)) {
                    this.bufferAppend(n2);
                } else {
                    this.handleError(n, (byte)4, "Unexpected control: " + n2);
                }
            }
        }

        @Override
        public void commented(int n, int n2, String string) {
            if (!this.parseError && this.buffer.length() == 0 && this.propertyName == null && this.curlyBracketDepth == 1 && this.parendepth == 0 && this.squareBracketDepth == 0) {
                super.commented(n, n2, string);
                this.prevcp = 12;
            } else {
                this.separator(n, 32);
                this.prevcp = 32;
            }
        }

        public void endOfStream(int n) {
            if (this.parendepth != 0) {
                this.handleError(n, (byte)6, "Unmatched parenthesis");
            } else if (this.propertyName != null) {
                this.processBuffer(n);
                this.endOfPropertyDeclaration(n);
            } else if (this.buffer.length() != 0) {
                this.handleError(n, (byte)9, "Unexpected token: " + this.buffer);
            }
            this.endDeclarationList();
        }

        protected void endDeclarationList() {
            this.endDocument();
        }

        @Override
        public void error(int n, byte by, CharSequence charSequence) {
            super.error(n, by, charSequence);
            this.lunit = null;
        }
    }

    private static abstract class DelegateHandler
    implements TokenHandler2 {
        private DelegateHandler() {
        }

        public void preBooleanHandling(int n, BooleanCondition.Type type) {
        }

        public void tokenStart(TokenControl tokenControl) {
        }

        public void quotedWithControl(int n, CharSequence charSequence, int n2) {
        }

        public void quotedNewlineChar(int n, int n2) {
        }

        public void control(int n, int n2) {
        }

        public void commented(int n, int n2, String string) {
        }

        public void error(int n, byte by, CharSequence charSequence) {
        }

        boolean isAllowedTopLevel() {
            return false;
        }
    }

    private class FontFeatureValuesTH
    extends NestedRuleTH {
        FontFeatureValuesTH() {
            super(32, "@font-feature-values");
        }

        @Override
        boolean processNestedSelector(int n) {
            String string = this.unescapeBuffer(n);
            if (string.length() <= 1 || string.charAt(0) != '@') {
                this.handleError(n, (byte)33, "Bad feature name: " + string);
                return false;
            }
            CSSParser.this.handler.startFeatureMap(string.substring(1).trim());
            return true;
        }

        @Override
        void processSelector(int n, String string) {
            String[] stringArray;
            for (String string2 : stringArray = string.split("\\s*,\\s*")) {
                super.processSelector(n, string2);
            }
            if (!this.parseError) {
                CSSParser.this.handler.startFontFeatures(stringArray);
            }
        }

        @Override
        protected void endBlock() {
            super.endBlock();
            CSSParser.this.handler.endFeatureMap();
        }

        @Override
        void endBlockList(int n) {
            CSSParser.this.handler.endFontFeatures();
        }

        @Override
        boolean isValidNestedSelectorCharacter(int n) {
            return n == 64;
        }

        @Override
        boolean isValidSelectorCharacter(int n) {
            return n == 45 || n == 44;
        }
    }

    private abstract class IgnoredDeclarationTokenHandler
    extends CSSTokenHandler {
        private int curlyBracketDepth = 1;

        IgnoredDeclarationTokenHandler() {
        }

        public void word(int n, CharSequence charSequence) {
        }

        public void separator(int n, int n2) {
        }

        public void quoted(int n, CharSequence charSequence, int n2) {
        }

        public void quotedWithControl(int n, CharSequence charSequence, int n2) {
        }

        public void leftParenthesis(int n) {
        }

        public void leftSquareBracket(int n) {
        }

        public void rightParenthesis(int n) {
        }

        public void rightSquareBracket(int n) {
        }

        public void leftCurlyBracket(int n) {
            ++this.curlyBracketDepth;
        }

        public void rightCurlyBracket(int n) {
            --this.curlyBracketDepth;
            if (this.curlyBracketDepth == 0) {
                this.endDeclarationBlock();
            }
        }

        protected abstract void endDeclarationBlock();

        public void character(int n, int n2) {
        }

        public void escaped(int n, int n2) {
        }
    }

    private class KeyFrameBlockListTH
    extends NestedRuleTH {
        KeyFrameBlockListTH() {
            super(64, "@keyframes");
        }

        @Override
        void checkNameSelector() {
            if (this.getStage() == 1 && (this.escapedTokenIndex == -1 || this.isPrevCpWhitespace())) {
                this.setStage((byte)2);
            }
        }

        @Override
        void waitSelectorQuoted(int n, CharSequence charSequence, int n2) {
            if (this.buffer.length() == 0) {
                this.buffer.append(charSequence);
                this.setStage((byte)2);
                this.prevcp = 65;
            } else {
                this.handleError(n, (byte)9, "@keyframes name must be a single identifier or string");
            }
        }

        @Override
        boolean processNestedSelector(int n) {
            String string = this.rawBuffer();
            try {
                LexicalUnit lexicalUnit = CSSParser.this.parsePropertyValue(new StringReader(string));
                CSSParser.this.handler.startKeyframe(lexicalUnit);
            }
            catch (CSSException cSSException) {
                this.handleError(n, (byte)5, cSSException.getMessage());
                this.setStage((byte)9);
                return false;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }

        @Override
        void processSelector(int n, String string) {
            super.processSelector(n, string);
            if (!this.parseError) {
                CSSParser.this.handler.startKeyframes(string);
            }
        }

        @Override
        protected void endBlock() {
            super.endBlock();
            CSSParser.this.handler.endKeyframe();
        }

        @Override
        void endBlockList(int n) {
            CSSParser.this.handler.endKeyframes();
        }

        @Override
        boolean isValidNestedSelectorCharacter(int n) {
            return n == 37 || n == 44 || n == 46;
        }

        @Override
        boolean isValidSelectorCharacter(int n) {
            return false;
        }
    }

    static interface LexicalUnitFactory {
        public LexicalUnitImpl createUnit();
    }

    private class MediaQueryTokenHandler
    extends ConditionTokenHandler<MediaQueryFactory> {
        private final HashSet<String> mediaTypes;

        MediaQueryTokenHandler(MediaQueryFactory mediaQueryFactory, MediaQueryHandler mediaQueryHandler) {
            super(CSSParser.this, (BooleanConditionFactory)mediaQueryFactory);
            this.mediaTypes = new HashSet(10);
            this.setPredicateHandler(new MediaQueryDelegateHandler(mediaQueryHandler));
            String[] stringArray = new String[]{"all", "braille", "embossed", "handheld", "print", "projection", "screen", "speech", "tty", "tv"};
            Collections.addAll(this.mediaTypes, stringArray);
        }

        private boolean isValidMediaType(String string) {
            return this.mediaTypes.contains(string);
        }

        @Override
        MediaQueryDelegateHandler getPredicateHandler() {
            return (MediaQueryDelegateHandler)super.getPredicateHandler();
        }

        @Override
        void processImplicitAnd(int n) {
            MediaQueryDelegateHandler mediaQueryDelegateHandler = this.getPredicateHandler();
            String string = mediaQueryDelegateHandler.mediaType;
            if (string == null) {
                if (this.buffer.length() != 0) {
                    mediaQueryDelegateHandler.processMediaType(n);
                } else {
                    this.unexpectedTokenError(n, "and");
                    return;
                }
            }
            this.currentCond = ((MediaQueryFactory)this.conditionFactory).createMediaTypePredicate(string);
            this.processOperation(n, BooleanCondition.Type.AND, "and");
        }

        @Override
        BooleanCondition createOperation(int n, BooleanCondition.Type type) throws CSSParseException {
            if (type == BooleanCondition.Type.AND) {
                return ((MediaQueryFactory)this.conditionFactory).createAndCondition();
            }
            if (this.getPredicateHandler().mediaType == null) {
                return ((MediaQueryFactory)this.conditionFactory).createOrCondition();
            }
            throw this.createException(n, (byte)9, "Unexpected 'OR'");
        }

        void emptyQuery(int n) {
        }

        @Override
        protected void handleError(int n, byte by, String string) {
            if (!this.parseError) {
                MediaQueryDelegateHandler mediaQueryDelegateHandler = this.getPredicateHandler();
                CSSParseException cSSParseException = this.createException(n, by, string);
                mediaQueryDelegateHandler.handler.invalidQuery(cSSParseException);
                if (!mediaQueryDelegateHandler.handler.reportsErrors() && CSSParser.this.errorHandler != null) {
                    this.handleError(cSSParseException);
                }
                this.parseError = true;
            }
        }

        @Override
        protected void handleError(int n, byte by, String string, Throwable throwable) {
            if (!this.parseError) {
                MediaQueryDelegateHandler mediaQueryDelegateHandler = this.getPredicateHandler();
                CSSParseException cSSParseException = this.createException(n, by, string);
                cSSParseException.initCause(throwable);
                mediaQueryDelegateHandler.handler.invalidQuery(cSSParseException);
                if (!mediaQueryDelegateHandler.handler.reportsErrors() && CSSParser.this.errorHandler != null) {
                    this.handleError(cSSParseException);
                }
                this.parseError = true;
            }
        }

        @Override
        void handleWarning(int n, byte by, String string, Throwable throwable) {
            if (!this.parseError) {
                MediaQueryDelegateHandler mediaQueryDelegateHandler = this.getPredicateHandler();
                CSSParseException cSSParseException = this.createException(n, by, string);
                if (throwable != null) {
                    cSSParseException.initCause(throwable);
                }
                mediaQueryDelegateHandler.handler.compatQuery(cSSParseException);
                if (CSSParser.this.errorHandler != null) {
                    CSSParser.this.errorHandler.warning(cSSParseException);
                }
            }
        }

        @Override
        CSSParseException createException(int n, byte by, String string) {
            this.setCurrentLocation(n);
            Locator locator = this.createLocator();
            return new CSSMediaParseException(string, locator);
        }

        class MediaQueryDelegateHandler
        extends DelegateHandler {
            private final MediaQueryHandler handler;
            private byte stage = 0;
            private boolean negativeQuery = false;
            private boolean spaceFound = false;
            private String mediaType = null;
            private String featureName = null;
            private String firstValue = null;
            private byte rangeType = 0;
            private boolean functionToken = false;
            private static final int WORD_UNQUOTED = 0;

            private MediaQueryDelegateHandler(MediaQueryHandler mediaQueryHandler) {
                this.handler = mediaQueryHandler;
            }

            MediaQueryHandler getMediaQueryHandler() {
                return this.handler;
            }

            public void word(int n, CharSequence charSequence) {
                if (this.stage == 127) {
                    return;
                }
                if (this.functionToken) {
                    if (MediaQueryTokenHandler.this.buffer.length() != 0 && MediaQueryTokenHandler.this.isPrevCpWhitespace()) {
                        MediaQueryTokenHandler.this.buffer.append(' ');
                    }
                    MediaQueryTokenHandler.this.buffer.append(charSequence);
                } else if (ParseHelper.equalsIgnoreCase(charSequence, "not")) {
                    if (this.stage != 0) {
                        MediaQueryTokenHandler.this.handleError(n, (byte)33, "Found 'not' at the wrong parsing stage");
                    } else {
                        this.negativeQuery = true;
                    }
                } else if (ParseHelper.equalsIgnoreCase(charSequence, "only")) {
                    if (this.stage != 0) {
                        MediaQueryTokenHandler.this.handleError(n, (byte)33, "Found 'only' at the wrong parsing stage");
                    } else {
                        this.handler.onlyPrefix();
                    }
                } else if (ParseHelper.equalsIgnoreCase(charSequence, "or")) {
                    MediaQueryTokenHandler.this.handleError(n, (byte)33, "Found 'or'");
                } else if (!this.appendWord(n, charSequence, 0)) {
                    return;
                }
                MediaQueryTokenHandler.this.prevcp = 65;
            }

            private boolean appendWord(int n, CharSequence charSequence, int n2) {
                if (MediaQueryTokenHandler.this.buffer.length() != 0 && MediaQueryTokenHandler.this.escapedTokenIndex == -1 && MediaQueryTokenHandler.this.isPrevCpWhitespace()) {
                    if (this.stage == 1) {
                        MediaQueryTokenHandler.this.handleError(n, (byte)33, "Found white space between media");
                        return false;
                    }
                    this.spaceFound = true;
                    MediaQueryTokenHandler.this.buffer.append(' ');
                }
                if (n2 == 0) {
                    MediaQueryTokenHandler.this.buffer.append(charSequence);
                } else {
                    char c = (char)n2;
                    MediaQueryTokenHandler.this.buffer.append(c).append(charSequence).append(c);
                }
                if (!this.functionToken) {
                    if (this.stage == 0) {
                        this.stage = 1;
                    } else if (this.stage == 5) {
                        this.stage = (byte)6;
                    }
                }
                return true;
            }

            @Override
            public void preBooleanHandling(int n, BooleanCondition.Type type) {
                switch (type) {
                    case AND: {
                        if (this.stage > 1) {
                            MediaQueryTokenHandler.this.handleError(n, (byte)33, "Found 'and' at the wrong parsing stage");
                            return;
                        }
                        if (MediaQueryTokenHandler.this.buffer.length() != 0) {
                            this.processMediaType(n);
                        }
                    }
                    case OR: {
                        this.stage = (byte)2;
                        break;
                    }
                }
            }

            private void processMediaType(int n) {
                if (this.mediaType == null && MediaQueryTokenHandler.this.getCurrentParenDepth() == 0) {
                    this.mediaType = this.rawBuffer().trim();
                    if (MediaQueryTokenHandler.this.currentCond != null && this.isEmptyNotCondition()) {
                        MediaQueryTokenHandler.this.currentCond = null;
                        this.negativeQuery = true;
                        this.handler.negativeQuery();
                    }
                    this.handler.mediaType(this.mediaType);
                }
            }

            private boolean isEmptyNotCondition() {
                return MediaQueryTokenHandler.this.currentCond.getType() == BooleanCondition.Type.NOT && MediaQueryTokenHandler.this.currentCond.getParentCondition() == null && MediaQueryTokenHandler.this.currentCond.getNestedCondition() == null;
            }

            public void leftParenthesis(int n) {
                if (this.functionToken) {
                    MediaQueryTokenHandler.this.buffer.append('(');
                } else if (MediaQueryTokenHandler.this.buffer.length() != 0) {
                    if (!MediaQueryTokenHandler.this.isPrevCpWhitespace()) {
                        this.functionToken = true;
                        MediaQueryTokenHandler.this.buffer.append('(');
                    } else {
                        MediaQueryTokenHandler.this.unexpectedCharError(n, 40);
                    }
                } else if (this.stage == 2 || this.stage == 0) {
                    this.stage = (byte)3;
                }
                MediaQueryTokenHandler.this.prevcp = 40;
            }

            public void leftCurlyBracket(int n) {
                MediaQueryTokenHandler.this.handleLeftCurlyBracket(n);
                MediaQueryTokenHandler.this.prevcp = 123;
            }

            public void leftSquareBracket(int n) {
                MediaQueryTokenHandler.this.prevcp = 123;
                MediaQueryTokenHandler.this.unexpectedCharError(n, MediaQueryTokenHandler.this.prevcp);
            }

            public void rightParenthesis(int n) {
                if (this.functionToken) {
                    MediaQueryTokenHandler.this.buffer.append(')');
                    this.functionToken = false;
                } else {
                    if (this.stage == 6) {
                        Object object;
                        this.processBuffer(n);
                        if (this.firstValue != null && CSSParser.isKnownFeature(this.firstValue)) {
                            object = this.firstValue;
                            this.firstValue = this.featureName;
                            this.featureName = object;
                        } else if (!CSSParser.isKnownFeature(this.featureName)) {
                            if (CSSParser.isValidFeatureSyntax(this.firstValue)) {
                                object = this.firstValue;
                                this.firstValue = this.featureName;
                                this.featureName = object;
                            } else {
                                if (!CSSParser.isValidFeatureSyntax(this.featureName)) {
                                    MediaQueryTokenHandler.this.handleError(n, (byte)33, "Wrong feature expression near " + this.featureName + " " + this.firstValue + ")");
                                    MediaQueryTokenHandler.this.prevcp = 41;
                                    return;
                                }
                                this.reverseRangetype();
                            }
                        } else {
                            this.reverseRangetype();
                        }
                        object = this.parseMediaFeature(n, this.firstValue);
                        this.handlePredicate(n, this.featureName, this.rangeType, (LexicalUnit)object, this.firstValue);
                    } else if (MediaQueryTokenHandler.this.buffer.length() != 0) {
                        if (this.stage == 4) {
                            String string = MediaQueryTokenHandler.this.buffer.toString();
                            LexicalUnit lexicalUnit = this.parseMediaFeature(n, string);
                            this.handlePredicate(n, this.featureName, (byte)0, lexicalUnit, string);
                        } else if (this.stage == 7) {
                            LexicalUnit lexicalUnit = this.parseMediaFeature(n, this.firstValue);
                            LexicalUnit lexicalUnit2 = this.parseMediaFeature(n, MediaQueryTokenHandler.this.buffer.toString());
                            this.handlePredicate(n, this.featureName, this.rangeType, lexicalUnit, lexicalUnit2);
                        } else if (this.stage == 3 && !this.spaceFound) {
                            this.handleMediaPredicate(n, MediaQueryTokenHandler.this.buffer.toString());
                        } else {
                            MediaQueryTokenHandler.this.handleError(n, (byte)32, MediaQueryTokenHandler.this.buffer.toString());
                        }
                        MediaQueryTokenHandler.this.buffer.setLength(0);
                        this.spaceFound = false;
                        MediaQueryTokenHandler.this.escapedTokenIndex = -1;
                    } else {
                        MediaQueryTokenHandler.this.unexpectedCharError(n, 41);
                    }
                    if (this.stage == 5) {
                        MediaQueryTokenHandler.this.unexpectedCharError(n, 41);
                    } else {
                        this.rangeType = 0;
                        this.stage = 1;
                    }
                    MediaQueryTokenHandler.this.readingPredicate = false;
                }
                MediaQueryTokenHandler.this.prevcp = 41;
            }

            private LexicalUnit parseMediaFeature(int n, String string) {
                LexicalUnit lexicalUnit;
                StringReader stringReader = new StringReader(string);
                try {
                    lexicalUnit = CSSParser.this.parsePropertyValue(stringReader, MediaQueryTokenHandler.this.getCurrentLine(), MediaQueryTokenHandler.this.getPrevLineLength() - n);
                }
                catch (CSSException | IOException exception) {
                    return null;
                }
                LexicalUnit lexicalUnit2 = lexicalUnit.getNextLexicalUnit();
                if (lexicalUnit2 != null && (lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_SLASH || lexicalUnit2.getNextLexicalUnit() == null)) {
                    MediaQueryTokenHandler.this.handleError(n, (byte)32, "Invalid feature value: " + string);
                    lexicalUnit = null;
                }
                return lexicalUnit;
            }

            private void handleMediaPredicate(int n, String string) {
                String string2;
                if (MediaQueryTokenHandler.this.currentCond == null && this.mediaType == null && MediaQueryTokenHandler.this.isValidMediaType(string2 = string.toLowerCase(Locale.ROOT))) {
                    this.mediaType = string2;
                    this.handler.mediaType(string2);
                } else {
                    MediaFeaturePredicate mediaFeaturePredicate = ((MediaQueryFactory)MediaQueryTokenHandler.this.conditionFactory).createPredicate(string);
                    mediaFeaturePredicate.setRangeType((byte)0);
                    if (MediaQueryTokenHandler.this.currentCond == null) {
                        MediaQueryTokenHandler.this.currentCond = mediaFeaturePredicate;
                    } else {
                        MediaQueryTokenHandler.this.currentCond.addCondition(mediaFeaturePredicate);
                    }
                }
                this.clearPredicate();
            }

            private void handlePredicate(int n, String string, byte by, LexicalUnit lexicalUnit, String string2) {
                if (lexicalUnit == null) {
                    MediaQueryTokenHandler.this.handleError(n, (byte)5, string2);
                    this.clearPredicate();
                    return;
                }
                if (lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.COMPAT_IDENT) {
                    MediaQueryTokenHandler.this.handleWarning(n, (byte)-2, "Probable hack in media feature.");
                }
                MediaFeaturePredicate mediaFeaturePredicate = ((MediaQueryFactory)MediaQueryTokenHandler.this.conditionFactory).createPredicate(string);
                mediaFeaturePredicate.setRangeType(by);
                try {
                    mediaFeaturePredicate.setValue(lexicalUnit);
                }
                catch (DOMException dOMException) {
                    MediaQueryTokenHandler.this.handleError(n, (byte)5, dOMException.getMessage() + ": " + string2, dOMException);
                    this.clearPredicate();
                    return;
                }
                MediaFeaturePredicate mediaFeaturePredicate2 = mediaFeaturePredicate;
                if (MediaQueryTokenHandler.this.currentCond == null) {
                    MediaQueryTokenHandler.this.currentCond = mediaFeaturePredicate2;
                } else {
                    MediaQueryTokenHandler.this.currentCond.addCondition(mediaFeaturePredicate2);
                }
                this.clearPredicate();
            }

            private void handlePredicate(int n, String string, byte by, LexicalUnit lexicalUnit, LexicalUnit lexicalUnit2) {
                if (lexicalUnit == null) {
                    MediaQueryTokenHandler.this.handleError(n, (byte)5, this.firstValue);
                    this.clearPredicate();
                    return;
                }
                if (lexicalUnit2 == null) {
                    String string2 = MediaQueryTokenHandler.this.buffer.toString();
                    MediaQueryTokenHandler.this.handleError(n, (byte)5, string2);
                    this.clearPredicate();
                    return;
                }
                if (lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.COMPAT_IDENT || lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.COMPAT_IDENT) {
                    MediaQueryTokenHandler.this.handleWarning(n, (byte)-2, "Probable hack in media feature.");
                }
                MediaFeaturePredicate mediaFeaturePredicate = ((MediaQueryFactory)MediaQueryTokenHandler.this.conditionFactory).createPredicate(string);
                mediaFeaturePredicate.setRangeType(by);
                try {
                    mediaFeaturePredicate.setValueRange(lexicalUnit, lexicalUnit2);
                }
                catch (DOMException dOMException) {
                    MediaQueryTokenHandler.this.handleError(n, (byte)5, "Invalid value(s) in range media feature.", dOMException);
                    this.clearPredicate();
                    return;
                }
                MediaFeaturePredicate mediaFeaturePredicate2 = mediaFeaturePredicate;
                if (MediaQueryTokenHandler.this.currentCond == null) {
                    MediaQueryTokenHandler.this.currentCond = mediaFeaturePredicate2;
                } else {
                    MediaQueryTokenHandler.this.currentCond.addCondition(mediaFeaturePredicate2);
                }
                this.clearPredicate();
            }

            private void reverseRangetype() {
                if ((this.rangeType & 2) == 2) {
                    this.rangeType = (byte)(this.rangeType ^ 2);
                    this.rangeType = (byte)(this.rangeType | 4);
                } else if ((this.rangeType & 4) == 4) {
                    this.rangeType = (byte)(this.rangeType ^ 4);
                    this.rangeType = (byte)(this.rangeType | 2);
                }
            }

            public void rightSquareBracket(int n) {
                MediaQueryTokenHandler.this.prevcp = 93;
                MediaQueryTokenHandler.this.unexpectedCharError(n, MediaQueryTokenHandler.this.prevcp);
            }

            public void rightCurlyBracket(int n) {
                MediaQueryTokenHandler.this.prevcp = 125;
                MediaQueryTokenHandler.this.unexpectedCharError(n, MediaQueryTokenHandler.this.prevcp);
            }

            public void character(int n, int n2) {
                if (this.functionToken) {
                    if (MediaQueryTokenHandler.this.isPrevCpWhitespace()) {
                        MediaQueryTokenHandler.this.buffer.append(' ');
                    }
                    MediaQueryTokenHandler.this.bufferAppend(n2);
                } else {
                    if (n2 == 58) {
                        if (MediaQueryTokenHandler.this.buffer.length() != 0) {
                            this.featureName = this.rawBuffer();
                            this.stage = (byte)4;
                        } else {
                            MediaQueryTokenHandler.this.handleError(n, (byte)33, "Empty feature name");
                        }
                    } else if (n2 == 44) {
                        if (!MediaQueryTokenHandler.this.parseError) {
                            if (MediaQueryTokenHandler.this.getCurrentParenDepth() != 0) {
                                MediaQueryTokenHandler.this.handleError(n, (byte)33, "Unmatched parenthesis");
                                return;
                            }
                            if (this.stage == 0) {
                                MediaQueryTokenHandler.this.handleError(n, (byte)33, "No media found");
                            }
                            this.processBuffer(n);
                            this.endQuery(n);
                        } else if (MediaQueryTokenHandler.this.getCurrentParenDepth() == 0) {
                            this.handler.endQuery();
                            this.clearQuery();
                        }
                        this.handler.startQuery();
                    } else if (n2 == 46) {
                        if (this.stage == 4 || this.stage == 3 || this.stage == 7 || this.functionToken) {
                            MediaQueryTokenHandler.this.buffer.append('.');
                        } else {
                            MediaQueryTokenHandler.this.unexpectedCharError(n, 46);
                        }
                    } else if (n2 == 47) {
                        if (this.stage == 4 || this.stage == 3 || this.stage == 6 || this.stage == 7 || this.functionToken) {
                            MediaQueryTokenHandler.this.buffer.append('/');
                        } else {
                            MediaQueryTokenHandler.this.unexpectedCharError(n, n2);
                        }
                    } else if (n2 == 59) {
                        MediaQueryTokenHandler.this.handleError(n, (byte)4, ";");
                    } else if (n2 == 60) {
                        if (this.stage < 3 || this.rangeType > 3 && ((this.rangeType & 0x10) != 0 || (this.rangeType & 4) != 0)) {
                            MediaQueryTokenHandler.this.unexpectedCharError(n, n2);
                        } else if (this.stage != 6 && this.stage != 7) {
                            this.rangeType = (byte)(this.rangeType | 2);
                            this.stage = (byte)5;
                        } else {
                            this.processBuffer(n);
                            this.rangeType = (byte)(this.rangeType | 0x10);
                            this.stage = (byte)7;
                        }
                    } else if (n2 == 61) {
                        if (this.stage < 3 || this.rangeType > 5 && (this.rangeType & 8) != 0) {
                            MediaQueryTokenHandler.this.unexpectedCharError(n, n2);
                        } else if (this.stage != 6 && this.stage != 7) {
                            this.rangeType = (byte)(this.rangeType | 1);
                            this.stage = (byte)5;
                        } else {
                            this.processBuffer(n);
                            this.rangeType = (byte)(this.rangeType | 8);
                            this.stage = (byte)7;
                        }
                    } else if (n2 == 62 || this.rangeType >= 4 && ((this.rangeType & 0x20) != 0 || (this.rangeType & 2) != 0)) {
                        if (this.stage < 3) {
                            MediaQueryTokenHandler.this.unexpectedCharError(n, n2);
                        } else if (this.stage != 6 && this.stage != 7) {
                            this.rangeType = (byte)(this.rangeType | 4);
                            this.stage = (byte)5;
                        } else {
                            this.processBuffer(n);
                            this.rangeType = (byte)(this.rangeType | 0x20);
                            this.stage = (byte)7;
                        }
                    } else {
                        MediaQueryTokenHandler.this.unexpectedCharError(n, n2);
                    }
                    if (this.stage == 5 && this.firstValue == null && MediaQueryTokenHandler.this.buffer.length() != 0) {
                        this.firstValue = this.rawBuffer();
                    }
                }
            }

            private void processBuffer(int n) {
                if (MediaQueryTokenHandler.this.buffer.length() != 0) {
                    if (this.stage == 1) {
                        this.processMediaType(n);
                        if (this.mediaType == null) {
                            MediaQueryTokenHandler.this.unexpectedTokenError(n, MediaQueryTokenHandler.this.buffer.toString());
                            MediaQueryTokenHandler.this.buffer.setLength(0);
                        }
                        MediaQueryTokenHandler.this.readingPredicate = false;
                    } else if (this.stage == 6) {
                        this.featureName = this.rawBuffer();
                    }
                }
            }

            private void endQuery(int n) {
                if (MediaQueryTokenHandler.this.currentCond != null) {
                    while (MediaQueryTokenHandler.this.currentCond.getParentCondition() != null) {
                        MediaQueryTokenHandler.this.currentCond = MediaQueryTokenHandler.this.currentCond.getParentCondition();
                    }
                    this.handler.condition(MediaQueryTokenHandler.this.currentCond);
                } else if (this.negativeQuery && this.mediaType == null) {
                    MediaQueryTokenHandler.this.handleError(n, (byte)32, "Negative query without media.");
                }
                this.handler.endQuery();
                this.clearQuery();
            }

            private void clearQuery() {
                MediaQueryTokenHandler.this.currentCond = null;
                this.mediaType = null;
                this.stage = 0;
                this.negativeQuery = false;
                this.functionToken = false;
                MediaQueryTokenHandler.this.resetHandler();
                this.clearPredicate();
            }

            private void clearPredicate() {
                this.featureName = null;
                this.firstValue = null;
                this.rangeType = 0;
                this.spaceFound = false;
            }

            String rawBuffer() {
                this.spaceFound = false;
                return MediaQueryTokenHandler.this.rawBuffer();
            }

            public void quoted(int n, CharSequence charSequence, int n2) {
                MediaQueryTokenHandler.this.handleError(n, (byte)9, "Unexpected: '" + charSequence + '\'');
            }

            public void escaped(int n, int n2) {
                if (ParseHelper.isHexCodePoint(n2) || n2 == 92) {
                    MediaQueryTokenHandler.this.setEscapedTokenStart(n);
                    MediaQueryTokenHandler.this.buffer.append('\\');
                }
                MediaQueryTokenHandler.this.bufferAppend(n2);
                if (this.stage == 5) {
                    this.stage = (byte)6;
                } else if (this.stage == 0) {
                    this.stage = 1;
                }
            }

            public void separator(int n, int n2) {
                if (MediaQueryTokenHandler.this.escapedTokenIndex != -1 && CSSParser.bufferEndsWithEscapedCharOrWS(MediaQueryTokenHandler.this.buffer)) {
                    MediaQueryTokenHandler.this.buffer.append(' ');
                }
            }

            public void endOfStream(int n) {
                if (this.stage == 1) {
                    this.processBuffer(n);
                }
                if (MediaQueryTokenHandler.this.currentCond == null && this.mediaType == null) {
                    if (MediaQueryTokenHandler.this.buffer.length() != 0) {
                        this.processMediaType(n);
                        if (this.mediaType == null) {
                            MediaQueryTokenHandler.this.unexpectedTokenError(n, MediaQueryTokenHandler.this.buffer.toString());
                            MediaQueryTokenHandler.this.buffer.setLength(0);
                        }
                        this.handler.endQuery();
                        this.clearQuery();
                    } else if (this.stage == 0) {
                        MediaQueryTokenHandler.this.emptyQuery(n);
                    } else {
                        MediaQueryTokenHandler.this.handleError(n, (byte)10, "No valid query found");
                    }
                } else if (MediaQueryTokenHandler.this.readingPredicate || this.stage > 1) {
                    MediaQueryTokenHandler.this.handleError(n, (byte)10, "Unexpected end of file");
                    this.handler.endQuery();
                } else if (MediaQueryTokenHandler.this.buffer.length() != 0) {
                    MediaQueryTokenHandler.this.handleError(n, (byte)9, "Unexpected token: " + MediaQueryTokenHandler.this.buffer);
                    this.handler.endQuery();
                } else if (MediaQueryTokenHandler.this.currentCond != null && this.isEmptyNotCondition()) {
                    MediaQueryTokenHandler.this.handleError(n, (byte)10, "No valid query found");
                    this.handler.endQuery();
                } else {
                    this.endQuery(n);
                }
                this.handler.endQueryList();
            }
        }
    }

    abstract class NestedRuleTH
    extends ControlTokenHandler {
        private final String blockRuleName;
        private byte stage = 1;
        private int curlyBracketDepth = 0;
        private DeclarationTokenHandler declarationHandler;
        static final byte STAGE_WAIT_SELECTOR = 1;
        static final byte STAGE_WAIT_BLOCK_LIST = 2;
        private static final byte STAGE_WAIT_NESTED_SELECTOR = 3;
        private static final byte STAGE_FOUND_NESTED_SELECTOR = 4;
        static final byte STAGE_DECLARATION_LIST = 5;
        private static final byte STAGE_END_BLOCK_LIST = 6;
        static final byte STAGE_SELECTOR_ERROR = 9;
        static final byte STAGE_NESTED_SELECTOR_ERROR = 10;

        NestedRuleTH(int n, String string) {
            this.blockRuleName = string;
            this.declarationHandler = new NestedRuleDeclarationTokenHandler();
            this.buffer = new StringBuilder(n);
        }

        DeclarationTokenHandler getDeclarationHandler() {
            return this.declarationHandler;
        }

        void setDeclarationHandler(DeclarationTokenHandler declarationTokenHandler) {
            this.declarationHandler = declarationTokenHandler;
        }

        byte getStage() {
            return this.stage;
        }

        void setStage(byte by) {
            this.stage = by;
        }

        int getCurlyBracketDepth() {
            return this.curlyBracketDepth;
        }

        public void word(int n, CharSequence charSequence) {
            if (this.stage == 5) {
                this.declarationHandler.word(n, charSequence);
            } else if (this.stage == 2 || this.stage == 6) {
                this.unexpectedTokenError(n, charSequence);
            } else if (!this.parseError) {
                this.buffer.append(charSequence);
                if (this.stage == 3) {
                    this.stage = (byte)4;
                }
                this.prevcp = 65;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void separator(int n, int n2) {
            if (this.stage == 5) {
                this.declarationHandler.separator(n, n2);
                return;
            } else {
                if (this.parseError) return;
                if (this.buffer.length() != 0) {
                    this.checkNameSelector();
                    if (this.prevcp == 32) return;
                    if (this.prevcp == 10) return;
                    this.buffer.append(' ');
                }
                this.prevcp = 32;
            }
        }

        void checkNameSelector() {
        }

        public void quoted(int n, CharSequence charSequence, int n2) {
            if (this.stage == 5) {
                this.declarationHandler.quoted(n, charSequence, n2);
            } else if (this.stage == 1) {
                this.waitSelectorQuoted(n, charSequence, n2);
            } else {
                this.handleError(n, (byte)9, "Expected " + this.blockRuleName + " selector, found '" + charSequence + "'");
            }
        }

        void waitSelectorQuoted(int n, CharSequence charSequence, int n2) {
            this.buffer.append(charSequence);
        }

        public void quotedWithControl(int n, CharSequence charSequence, int n2) {
            this.quoted(n, charSequence, n2);
        }

        public void leftCurlyBracket(int n) {
            if (this.stage == 5) {
                this.declarationHandler.leftCurlyBracket(n);
            } else {
                ++this.curlyBracketDepth;
                if (this.stage == 1 || this.stage == 2) {
                    if (this.buffer.length() != 0) {
                        this.processSelector(n, this.unescapeBuffer(n).trim());
                        if (!this.parseError) {
                            this.prevcp = 123;
                            this.startBlockList(n);
                        }
                    } else {
                        this.emptySelector(n);
                    }
                } else if (this.stage == 4) {
                    if (this.processNestedSelector(n)) {
                        this.prevcp = 123;
                        this.stage = (byte)5;
                        this.declarationHandler.curlyBracketDepth = 1;
                    }
                } else if (!this.parseError) {
                    this.unexpectedCharError(n, 123, (byte)9);
                }
            }
        }

        public void leftParenthesis(int n) {
            if (this.stage == 5) {
                this.declarationHandler.leftParenthesis(n);
            } else {
                this.unexpectedCharError(n, 40, (byte)10);
            }
        }

        public void leftSquareBracket(int n) {
            if (this.stage == 5) {
                this.declarationHandler.leftSquareBracket(n);
            } else {
                this.unexpectedCharError(n, 91, (byte)10);
            }
        }

        protected void startBlockList(int n) {
            this.stage = (byte)3;
        }

        protected void emptySelector(int n) {
            this.handleError(n, (byte)4, this.blockRuleName + " must have a name.");
        }

        void processSelector(int n, String string) {
            if ("initial".equalsIgnoreCase(string) || "inherit".equalsIgnoreCase(string) || "unset".equalsIgnoreCase(string) || "none".equalsIgnoreCase(string) || "reset".equalsIgnoreCase(string)) {
                this.handleError(n, (byte)7, "A CSS keyword is not a valid custom ident.");
            }
        }

        abstract boolean processNestedSelector(int var1);

        abstract void endBlockList(int var1);

        public void rightCurlyBracket(int n) {
            if (this.stage == 5) {
                this.declarationHandler.rightCurlyBracket(n);
                if (this.curlyBracketDepth == 1) {
                    this.endBlock();
                } else if (this.curlyBracketDepth == 0) {
                    this.endBlockList(n);
                    this.stage = (byte)6;
                }
                this.prevcp = 125;
            } else {
                --this.curlyBracketDepth;
                this.handleRightCurlyBracket(n);
            }
        }

        protected void handleRightCurlyBracket(int n) {
            if (this.curlyBracketDepth == 0) {
                this.endBlockList(n);
                this.stage = (byte)6;
                this.prevcp = 125;
            } else if (this.curlyBracketDepth == 1 && this.stage == 10) {
                this.stage = (byte)3;
                this.parseError = false;
            }
        }

        public void rightParenthesis(int n) {
            if (this.stage == 5) {
                this.declarationHandler.rightParenthesis(n);
            } else if (this.stage == 1 || this.stage == 2) {
                this.unexpectedCharError(n, 41, (byte)9);
            } else {
                this.unexpectedCharError(n, 41, (byte)10);
            }
            this.prevcp = 41;
        }

        public void rightSquareBracket(int n) {
            if (this.stage == 5) {
                this.declarationHandler.rightSquareBracket(n);
            } else if (this.stage == 1 || this.stage == 2) {
                this.unexpectedCharError(n, 93, (byte)9);
            } else {
                this.unexpectedCharError(n, 93, (byte)10);
            }
            this.prevcp = 93;
        }

        protected void endBlock() {
            this.stage = (byte)3;
        }

        public void character(int n, int n2) {
            if (this.stage == 5) {
                this.declarationHandler.character(n, n2);
            } else if (!this.parseError) {
                char[] cArray = Character.toChars(n2);
                if (this.stage == 3 || this.stage == 4) {
                    if (this.isValidNestedSelectorCharacter(n2)) {
                        this.buffer.append(cArray);
                        this.prevcp = n2;
                    } else {
                        this.buffer.setLength(0);
                        this.unexpectedCharError(n, n2, (byte)10);
                    }
                    return;
                }
                if (this.stage == 1 && this.isValidSelectorCharacter(n2)) {
                    this.buffer.append(cArray);
                    this.prevcp = n2;
                    return;
                }
                this.unexpectedCharError(n, n2, (byte)9);
            }
        }

        abstract boolean isValidNestedSelectorCharacter(int var1);

        abstract boolean isValidSelectorCharacter(int var1);

        public void escaped(int n, int n2) {
            if (this.stage == 5) {
                this.declarationHandler.escaped(n, n2);
            } else if (!this.parseError) {
                char[] cArray = Character.toChars(n2);
                if (this.stage == 2 || this.stage == 6) {
                    this.unexpectedTokenError(n, new String(cArray));
                } else {
                    if (ParseHelper.isHexCodePoint(n2)) {
                        this.setEscapedTokenStart(n);
                        this.buffer.append('\\');
                    }
                    this.buffer.append(cArray);
                    if (this.stage == 3) {
                        this.stage = (byte)4;
                    }
                    this.prevcp = 65;
                }
            }
        }

        public void endOfStream(int n) {
            if (this.curlyBracketDepth != 0) {
                if (this.stage == 5) {
                    --this.curlyBracketDepth;
                    this.declarationHandler.endOfStream(n);
                    this.endBlock();
                } else if (this.stage == 6) {
                    return;
                }
                this.handleWarning(n, (byte)10, "Unexpected end of " + this.blockRuleName + " rule.");
                this.endBlockList(n);
            } else if (this.stage != 6) {
                this.handleError(n, (byte)10, "Malformed " + this.blockRuleName + " rule.", (byte)9);
                this.endBlockList(n);
            }
        }

        @Override
        public void commented(int n, int n2, String string) {
            if (!this.parseError && this.buffer.length() == 0 && this.curlyBracketDepth == 1 && this.parendepth == 0 && this.stage == 3) {
                super.commented(n, n2, string);
            } else {
                this.separator(n, 12);
                this.prevcp = 12;
            }
        }

        void unexpectedCharError(int n, int n2, byte by) {
            this.handleError(n, (byte)4, "Unexpected '" + new String(Character.toChars(n2)) + "'", by);
        }

        protected void handleError(int n, byte by, String string, byte by2) throws CSSParseException {
            if (!this.parseError && this.stage != 9) {
                super.handleError(n, by, string);
                this.stage = by2;
            }
        }

        @Override
        protected void handleError(CSSParseException cSSParseException) throws CSSParseException {
            super.handleError(cSSParseException);
            if (this.stage <= 2) {
                this.abortRule();
            }
        }

        protected void abortRule() {
        }

        private class NestedRuleDeclarationTokenHandler
        extends DeclarationTokenHandler {
            private NestedRuleDeclarationTokenHandler() {
                super(null);
            }

            @Override
            protected void handleRightCurlyBracket(int n) {
                this.resetHandler();
                NestedRuleTH.this.curlyBracketDepth--;
                NestedRuleTH.this.stage = (byte)3;
                NestedRuleTH.this.prevcp = 125;
            }

            @Override
            TokenControl getTokenControl() {
                return NestedRuleTH.this.getTokenControl();
            }

            @Override
            void setCurrentLocation(int n) {
                NestedRuleTH.this.setCurrentLocation(n);
            }

            @Override
            protected void handleProperty(int n, String string, LexicalUnitImpl lexicalUnitImpl, boolean bl) {
                if (!bl) {
                    super.handleProperty(n, string, lexicalUnitImpl, bl);
                } else {
                    this.handleError(n, (byte)5, "Values with important priority are not accepted (" + string + ':' + lexicalUnitImpl.toString() + "!important).");
                }
            }

            @Override
            public void control(int n, int n2) {
                NestedRuleTH.this.control(n, n2);
            }

            @Override
            CSSParseException createException(int n, byte by, String string) {
                return NestedRuleTH.this.createException(n, by, string);
            }
        }

        class RootDeclarationTokenHandler
        extends DeclarationTokenHandler {
            private final DeclarationTokenHandler nestedDeclarationHandler;

            RootDeclarationTokenHandler(DeclarationTokenHandler declarationTokenHandler) {
                super(ShorthandDatabase.getInstance());
                this.nestedDeclarationHandler = declarationTokenHandler;
            }

            @Override
            protected void handleRightCurlyBracket(int n) {
                NestedRuleTH.this.curlyBracketDepth--;
                NestedRuleTH.this.setStage((byte)6);
            }

            @Override
            protected void handleAtKeyword(int n) {
                if (this.propertyName == null && this.buffer.length() == 0 && this.getCurlyBracketDepth() == 1) {
                    NestedRuleTH.this.declarationHandler = this.nestedDeclarationHandler;
                    NestedRuleTH.this.setStage((byte)3);
                    NestedRuleTH.this.prevcp = 64;
                } else {
                    this.unexpectedCharError(n, 64);
                }
            }

            @Override
            public void endOfStream(int n) {
                super.endOfStream(n);
                NestedRuleTH.this.setStage((byte)6);
                NestedRuleTH.this.endOfStream(n);
            }

            @Override
            protected void endDeclarationList() {
            }

            @Override
            TokenControl getTokenControl() {
                return NestedRuleTH.this.getTokenControl();
            }

            @Override
            void setCurrentLocation(int n) {
                NestedRuleTH.this.setCurrentLocation(n);
            }

            @Override
            public void control(int n, int n2) {
                NestedRuleTH.this.control(n, n2);
            }

            @Override
            CSSParseException createException(int n, byte by, String string) {
                return NestedRuleTH.this.createException(n, by, string);
            }
        }
    }

    private class PageTokenHandler
    extends NestedRuleTH {
        private PageSelectorList pageSelectorList;
        private final DeclarationTokenHandler rootDeclarationHandler;

        private PageTokenHandler() {
            super(64, "@page");
            this.pageSelectorList = null;
            this.rootDeclarationHandler = new NestedRuleTH.RootDeclarationTokenHandler(this.getDeclarationHandler());
            this.setDeclarationHandler(this.rootDeclarationHandler);
        }

        @Override
        boolean processNestedSelector(int n) {
            String string = this.rawBuffer().trim();
            if (!this.isMarginRuleName(string)) {
                this.handleError(n, (byte)7, "Unknown margin rule name.");
                this.setStage((byte)10);
                return false;
            }
            CSSParser.this.handler.startMargin(string);
            return true;
        }

        @Override
        void processSelector(int n, String string) {
            super.processSelector(n, string);
            if (!this.parseError) {
                try {
                    this.pageSelectorList = CSSParser.this.parsePageSelectorList(string);
                }
                catch (DOMException dOMException) {
                    this.handleError(n, (byte)33, dOMException.getMessage());
                    this.setStage((byte)9);
                    return;
                }
                CSSParser.this.handler.startPage(this.pageSelectorList);
            }
        }

        @Override
        protected void emptySelector(int n) {
            CSSParser.this.handler.startPage(null);
            this.setStage((byte)5);
        }

        @Override
        protected void startBlockList(int n) {
            this.setStage((byte)5);
        }

        @Override
        protected void endBlock() {
            CSSParser.this.handler.endMargin();
            this.setDeclarationHandler(this.rootDeclarationHandler);
            this.setStage((byte)5);
        }

        @Override
        void endBlockList(int n) {
            if (this.getStage() != 9) {
                if (this.buffer.length() > 0 || this.prevcp == 64) {
                    this.buffer.setLength(0);
                    this.handleError(n, (byte)33, "Unexpected end of rule.");
                }
                CSSParser.this.handler.endPage(this.pageSelectorList);
            }
            this.pageSelectorList = null;
        }

        @Override
        boolean isValidNestedSelectorCharacter(int n) {
            return false;
        }

        @Override
        boolean isValidSelectorCharacter(int n) {
            return n == 58 || n == 44;
        }

        private boolean isMarginRuleName(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = stringTokenizer.nextToken();
                if ("top".equals(string2) || "left".equals(string2) || "center".equals(string2) || "right".equals(string2) || "corner".equals(string2) || "bottom".equals(string2) || "middle".equals(string2)) continue;
                return false;
            }
            return true;
        }
    }

    class PropertyTokenHandler
    extends DeclarationTokenHandler {
        PropertyTokenHandler() {
            super(null);
            this.propertyName = "";
        }

        PropertyTokenHandler(int n, int n2) {
            super(n, n2);
            this.propertyName = "";
        }

        PropertyTokenHandler(String string) {
            super(ShorthandDatabase.getInstance());
            this.propertyName = string;
        }

        @Override
        protected void handleAtKeyword(int n) {
            throw this.createException(n, (byte)4, "Unexpected '@'");
        }

        @Override
        protected void endOfPropertyDeclaration(int n) {
            this.handleError(n, (byte)4, "Unexpected ';'");
        }

        @Override
        protected boolean isDeclarationContext() {
            return true;
        }

        @Override
        public void endOfStream(int n) {
            if (this.parendepth != 0) {
                this.handleError(n, (byte)6, "Unmatched parenthesis");
            } else {
                this.processBuffer(n);
                if (this.getLexicalUnit() == null) {
                    this.handleError(n, (byte)32, "No value found");
                }
            }
        }

        @Override
        protected void endDeclarationList() {
        }

        @Override
        protected void handleError(int n, byte by, String string) {
            if (this.prevcp == this.endcp && this.endcp != -1) {
                throw this.createException(n, by, "Expected end of file, found " + new String(Character.toChars(this.prevcp)));
            }
            throw this.createException(n, by, string);
        }
    }

    private class RuleTokenHandler
    extends SheetTokenHandler {
        RuleTokenHandler(Parser.NamespaceMap namespaceMap) {
            super(namespaceMap, false);
        }

        @Override
        protected void endRuleBody() {
            if (this.getCurlyBracketDepth() == 0) {
                this.contextHandler = new RuleEndContentHandler();
            } else {
                super.endRuleBody();
            }
        }

        @Override
        protected void resetRuleState() {
            super.resetRuleState();
            this.contextHandler = new RuleEndContentHandler();
        }

        private class RuleEndContentHandler
        extends CSSTokenHandler {
            private boolean foundControl = false;

            RuleEndContentHandler() {
            }

            public void word(int n, CharSequence charSequence) {
                this.reportError(n);
            }

            public void separator(int n, int n2) {
            }

            public void quoted(int n, CharSequence charSequence, int n2) {
                this.reportError(n);
            }

            public void quotedWithControl(int n, CharSequence charSequence, int n2) {
                this.reportError(n);
            }

            public void leftParenthesis(int n) {
                this.reportError(n);
            }

            public void leftSquareBracket(int n) {
                this.reportError(n);
            }

            public void leftCurlyBracket(int n) {
                this.reportError(n);
            }

            public void rightParenthesis(int n) {
                this.reportError(n);
            }

            public void rightSquareBracket(int n) {
                this.reportError(n);
            }

            public void rightCurlyBracket(int n) {
                this.reportError(n);
            }

            public void character(int n, int n2) {
                this.reportError(n);
            }

            public void escaped(int n, int n2) {
                this.reportError(n);
            }

            @Override
            void setCurrentLocation(int n) {
                RuleTokenHandler.this.setCurrentLocation(n);
            }

            @Override
            public void control(int n, int n2) {
                RuleTokenHandler.this.control(n, n2);
                this.foundControl = true;
            }

            @Override
            public void commented(int n, int n2, String string) {
                if (!this.foundControl && !this.parseError && n2 == 0) {
                    CSSParser.this.handler.comment(string, this.isPreviousCpLF());
                }
            }

            public void endOfStream(int n) {
                CSSParser.this.handler.endOfStream();
            }

            @Override
            public void error(int n, byte by, CharSequence charSequence) {
                this.handleError(n, (byte)9, "Found tokens after rule");
            }

            private void reportError(int n) {
                this.handleError(n, (byte)9, "Found tokens after rule");
            }

            @Override
            protected void handleError(int n, byte by, String string) {
                if (!this.parseError && CSSParser.this.errorHandler != null) {
                    this.handleError(this.createException(n, by, string));
                }
                this.parseError = true;
            }

            @Override
            CSSParseException createException(int n, byte by, String string) {
                return RuleTokenHandler.this.createException(n, by, string);
            }
        }
    }

    private class SelectorArgumentTokenHandler
    extends SelectorTokenHandler {
        SelectorArgumentTokenHandler(NSACSelectorFactory nSACSelectorFactory) {
            super(nSACSelectorFactory);
        }

        @Override
        protected void newCombinatorSelector(int n, Selector.SelectorType selectorType, int n2) {
            if (this.currentsel == null) {
                this.currentsel = this.factory.createScopeSelector();
            } else if (!this.isValidCurrentSelector()) {
                this.unexpectedCharError(n, n2);
                return;
            }
            this.newCombinatorSelector(selectorType);
        }
    }

    class SelectorTokenHandler
    extends ControlTokenHandler {
        NSACSelectorFactory factory;
        private Parser.NamespaceMap nsMap;
        CSSTokenHandler.MySelectorListImpl selist = new CSSTokenHandler.MySelectorListImpl();
        Selector currentsel = null;
        private String namespacePrefix = null;
        byte stage = 0;
        private boolean functionToken;
        private static final byte STAGE_COMBINATOR_OR_END = 2;
        private static final byte STAGE_ATTR_START = 4;
        private static final byte STAGE_ATTR_EXPECT_SYMBOL_OR_CLOSE = 7;
        private static final byte STAGE_ATTR_SYMBOL = 5;
        private static final byte STAGE_ATTR_POST_SYMBOL = 6;
        private static final byte STAGE_EXPECT_ID_OR_CLASSNAME = 8;
        private static final byte STAGE_EXPECT_PSEUDOELEM_NAME = 9;
        private static final byte STAGE_EXPECT_PSEUDOCLASS_NAME = 10;
        private static final byte STAGE_EXPECT_PSEUDOCLASS_ARGUMENT = 11;

        SelectorTokenHandler() {
            this(new NSACSelectorFactory());
        }

        SelectorTokenHandler(Parser.NamespaceMap namespaceMap) {
            this.factory = new NSACSelectorFactory();
            this.nsMap = namespaceMap == null ? this.factory : namespaceMap;
            this.buffer = new StringBuilder(64);
        }

        SelectorTokenHandler(NSACSelectorFactory nSACSelectorFactory) {
            this.factory = nSACSelectorFactory;
            this.nsMap = nSACSelectorFactory;
            this.buffer = new StringBuilder(64);
        }

        SelectorListImpl getSelectorList() {
            return this.selist;
        }

        SelectorListImpl getTrimmedSelectorList() {
            this.selist.trimToSize();
            return this.selist;
        }

        public void word(int n, CharSequence charSequence) {
            if (this.buffer.length() != 0 && this.isPrevCpWhitespace()) {
                this.buffer.append(' ');
            }
            if (this.stage == 4 && this.prevcp != 65 && this.prevcp != 124) {
                this.unexpectedTokenError(n, charSequence);
            } else if (this.stage == 0) {
                this.stage = 1;
                this.buffer.append(charSequence);
            } else if (this.stage == 2) {
                this.buffer.append(charSequence);
                this.newCombinatorSelector(Selector.SelectorType.DESCENDANT);
                this.stage = 1;
            } else if (this.stage == 6 && this.isPrevCpWhitespace()) {
                if (charSequence.length() == 1) {
                    char c = charSequence.charAt(0);
                    if (c == 'i' || c == 'I') {
                        this.setAttributeConditionFlag(AttributeCondition.Flag.CASE_I);
                    } else if (c == 's' || c == 'S') {
                        this.setAttributeConditionFlag(AttributeCondition.Flag.CASE_S);
                    } else {
                        this.handleError(n, (byte)4, "Expected 'i', found: '" + c + '\'');
                    }
                    if (this.buffer.length() != 0) {
                        this.handleError(n, (byte)9, "Expected 'i' or 's', found: '" + this.buffer.toString() + '\'');
                        this.buffer.setLength(0);
                    }
                } else {
                    this.handleError(n, (byte)9, "Expected 'i', found: '" + charSequence + "'");
                }
            } else if (this.stage == 1) {
                if (this.prevcp != 42) {
                    this.buffer.append(charSequence);
                } else {
                    this.unexpectedTokenError(n, charSequence);
                }
            } else if (this.stage != 7) {
                this.buffer.append(charSequence);
            } else {
                this.unexpectedTokenError(n, charSequence);
            }
            this.prevcp = 65;
        }

        public void separator(int n, int n2) {
            if (!this.parseError) {
                if (this.escapedTokenIndex != -1 && CSSParser.bufferEndsWithEscapedChar(this.buffer)) {
                    this.buffer.append(' ');
                    return;
                }
                if (this.prevcp == 58 || this.prevcp == 46 || this.prevcp == 35 || this.prevcp == 124 && this.getActiveSelector() == null) {
                    this.unexpectedCharError(n, n2);
                    return;
                }
                if (this.stage == 5) {
                    if (this.buffer.length() != 0) {
                        this.setAttributeSelectorValue(n, this.unescapeBuffer(n));
                        this.stage = (byte)6;
                    }
                } else if (this.stage == 1 || this.stage == 8 || this.stage == 9 || this.stage == 10) {
                    this.processBuffer(n, n2, false);
                    if (this.prevcp == 65 || this.prevcp == 42 || this.prevcp == 41 || this.prevcp == 93) {
                        this.stage = (byte)2;
                    }
                } else if (this.stage == 4) {
                    if (this.buffer.length() != 0) {
                        this.stage = (byte)7;
                    } else if (this.namespacePrefix != null) {
                        this.unexpectedCharError(n, n2);
                    }
                    return;
                }
                if (this.prevcp != 44) {
                    this.setWhitespacePrevCp();
                }
            }
        }

        @Override
        String unescapeBuffer(int n) {
            String string;
            if (this.namespacePrefix == null) {
                string = this.unescapeStringValue(n);
            } else {
                this.handleError(n - this.namespacePrefix.length() - 1, (byte)9, "Unexpected token: " + this.namespacePrefix);
                this.namespacePrefix = null;
                string = "";
            }
            this.buffer.setLength(0);
            this.escapedTokenIndex = -1;
            return string;
        }

        private void processBuffer(int n, int n2, boolean bl) {
            if (this.prevcp == 42) {
                if (this.currentsel == null || this.currentsel.getSelectorType() != Selector.SelectorType.UNIVERSAL) {
                    this.setSimpleSelector(n, this.factory.getUniversalSelector(this.namespacePrefix));
                }
            } else if (this.stage == 2) {
                if (!bl) {
                    this.newCombinatorSelector(Selector.SelectorType.DESCENDANT);
                    if (this.buffer.length() != 0) {
                        NSACSelectorFactory.ElementSelectorImpl elementSelectorImpl = this.newElementSelector(n);
                        String string = this.buffer.toString();
                        if (this.isNotForbiddenIdentStart(string)) {
                            String string2;
                            elementSelectorImpl.localName = string2 = this.unescapeBuffer(n);
                            this.stage = 1;
                        } else {
                            this.handleError(n - string.length(), (byte)7, "Invalid identifier: " + string);
                        }
                    }
                }
            } else if (this.buffer.length() != 0) {
                if (this.stage == 1) {
                    String string;
                    String string3 = this.buffer.toString();
                    NSACSelectorFactory.ElementSelectorImpl elementSelectorImpl = this.newElementSelector(n);
                    if (this.namespacePrefix == null) {
                        string = this.getDefaultNamespaceURI();
                    } else {
                        string = this.getNamespaceURI(n);
                        if (this.parseError) {
                            return;
                        }
                    }
                    elementSelectorImpl.namespaceUri = string;
                    if (this.isNotForbiddenIdentStart(string3)) {
                        String string4;
                        elementSelectorImpl.localName = string4 = this.unescapeBuffer(n);
                    } else {
                        this.handleError(n - string3.length(), (byte)7, "Invalid identifier: " + string3);
                    }
                } else if (this.stage == 8) {
                    String string = this.buffer.toString();
                    if (this.isNotForbiddenIdentStart(string)) {
                        String string5 = this.unescapeBuffer(n).trim();
                        this.setAttributeSelectorValue(n, string5);
                        this.stage = 1;
                    } else {
                        this.handleError(n - string.length(), (byte)7, "Invalid class name: " + string);
                    }
                } else if (this.stage == 10) {
                    this.newConditionalSelector(n, n2, Condition.ConditionType.PSEUDO_CLASS);
                    this.stage = 1;
                } else if (this.stage == 9) {
                    this.newConditionalSelector(n, n2, Condition.ConditionType.PSEUDO_ELEMENT);
                    this.stage = 1;
                } else if (this.stage != 11) {
                    if (this.stage == 6) {
                        this.setAttributeSelectorValue(n, this.unescapeBuffer(n));
                    } else {
                        this.handleError(n, (byte)9, "Unexpected: <" + this.buffer + ">");
                        this.buffer.setLength(0);
                    }
                }
            } else if (this.namespacePrefix != null) {
                this.handleError(n - this.namespacePrefix.length() - 1, (byte)9, "Unexpected: " + this.namespacePrefix + "|");
                this.namespacePrefix = null;
            } else if (this.stage > 1 && this.stage != 11) {
                this.unexpectedCharError(n, n2);
            }
        }

        public void quoted(int n, CharSequence charSequence, int n2) {
            if (this.stage == 5 && this.currentsel != null) {
                this.setAttributeSelectorValue(n, charSequence);
                this.stage = (byte)6;
            } else if (this.stage == 11) {
                if (this.buffer.length() != 0 && this.isPrevCpWhitespace()) {
                    this.buffer.append(' ');
                }
                char c = (char)n2;
                this.buffer.append(c).append(charSequence).append(c);
            } else {
                char c = (char)n2;
                StringBuilder stringBuilder = new StringBuilder(charSequence.length() + 2);
                stringBuilder.append(c).append(charSequence).append(c);
                this.unexpectedTokenError(n, stringBuilder.toString());
            }
            this.prevcp = 65;
        }

        public void quotedWithControl(int n, CharSequence charSequence, int n2) {
            if (this.stage == 5 && this.currentsel != null) {
                this.setAttributeSelectorValue(n, charSequence);
                this.stage = (byte)6;
            } else {
                this.handleError(n, (byte)9, "Quoted string contained unexpected control character: \"" + charSequence + '\"');
            }
            this.prevcp = 65;
        }

        private void setAttributeSelectorValue(int n, CharSequence charSequence) {
            Object object;
            Condition condition = null;
            if (this.currentsel instanceof NSACSelectorFactory.CombinatorSelectorImpl) {
                object = ((NSACSelectorFactory.CombinatorSelectorImpl)this.currentsel).getSecondSelector();
                if (!(object instanceof ConditionalSelectorImpl)) {
                    throw new IllegalStateException("Descendant selector has no conditional simple selector");
                }
                condition = ((ConditionalSelectorImpl)object).condition;
            } else if (this.currentsel instanceof ConditionalSelectorImpl) {
                condition = ((ConditionalSelectorImpl)this.currentsel).condition;
            }
            if (condition instanceof CombinatorConditionImpl) {
                condition = ((CombinatorConditionImpl)condition).getSecondCondition();
            }
            if (condition instanceof NSACSelectorFactory.AttributeConditionImpl && (object = (NSACSelectorFactory.AttributeConditionImpl)condition) != null) {
                String string = ((NSACSelectorFactory.AttributeConditionImpl)object).getValue();
                if (string == null) {
                    ((NSACSelectorFactory.AttributeConditionImpl)object).setValue(charSequence.toString());
                } else {
                    StringBuilder stringBuilder = new StringBuilder(string.length() + charSequence.length() + 1);
                    stringBuilder.append(string);
                    if (this.isPrevCpWhitespace()) {
                        stringBuilder.append(' ');
                    }
                    ((NSACSelectorFactory.AttributeConditionImpl)object).setValue(stringBuilder.append(charSequence).toString());
                }
                return;
            }
            this.handleError(n, (byte)9, "Unexpected token in selector: <" + charSequence + ">");
        }

        private void setAttributeConditionFlag(AttributeCondition.Flag flag) {
            Selector selector = this.getActiveSelector();
            if (selector == null || selector.getSelectorType() != Selector.SelectorType.CONDITIONAL) {
                throw new IllegalStateException("Processing attribute modifier of non-conditional selector");
            }
            Condition condition = ((ConditionalSelectorImpl)selector).getCondition();
            if (condition.getConditionType() == Condition.ConditionType.AND) {
                condition = ((CombinatorCondition)condition).getSecondCondition();
            }
            ((NSACSelectorFactory.AttributeConditionImpl)condition).setFlag(flag);
        }

        private Selector getActiveSelector() {
            Selector selector = this.currentsel instanceof NSACSelectorFactory.CombinatorSelectorImpl ? ((NSACSelectorFactory.CombinatorSelectorImpl)this.currentsel).getSecondSelector() : this.currentsel;
            return selector;
        }

        private Condition getActiveCondition(Condition condition) {
            while (condition.getConditionType() == Condition.ConditionType.AND) {
                condition = ((CombinatorConditionImpl)condition).getSecondCondition();
            }
            return condition;
        }

        public void leftParenthesis(int n) {
            this.parendepth = (short)(this.parendepth + 1);
            if (this.stage == 11) {
                this.buffer.append('(');
                this.prevcp = 40;
            } else if (!this.parseError) {
                if (this.prevcp != 65 || this.buffer.length() == 0 || this.stage != 10) {
                    this.unexpectedCharError(n, 40);
                } else {
                    this.newConditionalSelector(n, 40, Condition.ConditionType.PSEUDO_CLASS);
                    if (!this.parseError) {
                        this.stage = (byte)11;
                        this.functionToken = true;
                    }
                }
            }
            this.prevcp = 40;
        }

        public void leftSquareBracket(int n) {
            if (this.stage == 11) {
                this.buffer.append('[');
                this.prevcp = 91;
            } else if (!this.parseError) {
                if (this.prevcp != 65 && CSSParser.isNotSeparator(this.prevcp) && this.prevcp != 42 && this.prevcp != 44 && this.prevcp != 93 && this.prevcp != 41 && this.prevcp != 43 && this.prevcp != 62 && this.prevcp != 125 && this.prevcp != 126 && this.prevcp != 124) {
                    this.unexpectedCharError(n, 91);
                } else {
                    this.processBuffer(n, 91, false);
                    this.stage = (byte)4;
                    this.prevcp = 65;
                }
            }
        }

        public void leftCurlyBracket(int n) {
            this.handleError(n, (byte)4, "Unexpected '{'");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void rightParenthesis(int n) {
            block18: {
                block19: {
                    block20: {
                        this.decrParenDepth(n);
                        if (this.stage != 11) break block19;
                        if (this.parendepth != 0) {
                            this.buffer.append(')');
                            this.prevcp = 41;
                            return;
                        }
                        Selector selector = this.getActiveSelector();
                        if (selector.getSelectorType() != Selector.SelectorType.CONDITIONAL) break block20;
                        Condition condition = ((ConditionalSelectorImpl)selector).condition;
                        condition = this.getActiveCondition(condition);
                        Condition.ConditionType conditionType = condition.getConditionType();
                        if (this.buffer.length() != 0) {
                            if (conditionType == Condition.ConditionType.SELECTOR_ARGUMENT) {
                                try {
                                    ((SelectorArgumentConditionImpl)condition).arguments = CSSParser.this.parseSelectorArgument(this.rawBuffer(), this.factory);
                                }
                                catch (CSSParseException cSSParseException) {
                                    byte by = cSSParseException.getClass() == CSSNamespaceParseException.class ? (byte)15 : 32;
                                    CSSParseException cSSParseException2 = this.createException(n, by, cSSParseException.getMessage());
                                    this.handleError(cSSParseException2);
                                    this.stage = (byte)127;
                                }
                            } else if (conditionType == Condition.ConditionType.POSITIONAL) {
                                String string;
                                if (((PositionalConditionImpl)condition).hasArgument() && !this.parsePositionalArgument((PositionalConditionImpl)condition, string = this.rawBuffer())) {
                                    this.handleError(n, (byte)32, "Wrong subexpression: " + string);
                                }
                            } else if (conditionType == Condition.ConditionType.LANG) {
                                int n2;
                                String string = this.unescapeBuffer(n);
                                if (string.charAt((n2 = string.length()) - 1) == ',') {
                                    this.handleError(n - 2, (byte)9, "Unexpected functional argument: " + string);
                                    return;
                                }
                                ((LangConditionImpl)condition).lang = string;
                            } else if (conditionType == Condition.ConditionType.PSEUDO_CLASS) {
                                String string = this.unescapeBuffer(n);
                                char c = string.charAt(0);
                                if (c != '\"' && c != '\'' && !this.isValidPseudoName(string)) {
                                    this.handleError(n - string.length() - 1, (byte)9, "Unexpected functional argument: " + string);
                                    return;
                                }
                                ((PseudoConditionImpl)condition).argument = string;
                            }
                            this.buffer.setLength(0);
                            this.stage = 1;
                            break block18;
                        } else if (conditionType == Condition.ConditionType.LANG || conditionType == Condition.ConditionType.SELECTOR_ARGUMENT || conditionType == Condition.ConditionType.POSITIONAL) {
                            this.unexpectedCharError(n, 41);
                            break block18;
                        } else {
                            this.unexpectedCharError(n - 1, 41);
                        }
                        break block18;
                    }
                    this.unexpectedCharError(n, 41);
                    break block18;
                }
                this.unexpectedCharError(n, 41);
            }
            if (this.functionToken) {
                this.functionToken = false;
            }
            this.prevcp = 41;
        }

        public void rightSquareBracket(int n) {
            if (this.stage == 11) {
                this.buffer.append(']');
            } else if (this.stage == 6) {
                if (this.buffer.length() != 0) {
                    this.setAttributeSelectorValue(n, this.unescapeBuffer(n));
                }
                this.stage = 1;
            } else if (this.stage == 4 || this.stage == 7) {
                if (this.buffer.length() != 0) {
                    this.newConditionalSelector(n, 93, Condition.ConditionType.ATTRIBUTE);
                    this.stage = 1;
                } else {
                    this.handleError(n, (byte)4, "Unexpected ']', expected attribute name");
                }
            } else if (this.stage == 5) {
                if (this.buffer.length() != 0) {
                    this.setAttributeSelectorValue(n, this.unescapeBuffer(n));
                    this.stage = 1;
                } else {
                    this.handleError(n, (byte)4, "Unexpected ']', expected attribute value");
                }
            } else {
                this.unexpectedCharError(n, 93);
            }
            this.prevcp = 93;
        }

        public void rightCurlyBracket(int n) {
            this.handleError(n, (byte)4, "Unexpected '}'");
        }

        public void character(int n, int n2) {
            block110: {
                if (!this.skipCharacterHandling()) {
                    if (this.stage == 11) {
                        if (n2 == 44 && (this.prevcp == 44 || this.buffer.length() == 0)) {
                            this.unexpectedCharError(n, n2);
                            return;
                        }
                        if (this.isPrevCpWhitespace() && this.buffer.length() != 0) {
                            this.buffer.append(' ');
                        }
                        this.bufferAppend(n2);
                    } else if (this.stage == 4 || this.stage == 7) {
                        if (n2 == 124) {
                            if (this.stage == 4) {
                                if (this.namespacePrefix == null) {
                                    this.readNamespacePrefix(n, n2);
                                } else {
                                    this.unexpectedCharError(n, n2);
                                }
                            } else if (this.prevcp != 65) {
                                this.unexpectedCharError(n, n2);
                            }
                        } else if (n2 == 61) {
                            if (this.prevcp == 124 && this.namespacePrefix != null && this.buffer.length() == 0) {
                                this.buffer.append(this.namespacePrefix);
                                this.namespacePrefix = null;
                            }
                            if (this.prevcp == 124) {
                                this.newConditionalSelector(n, n2, Condition.ConditionType.BEGIN_HYPHEN_ATTRIBUTE);
                                this.stage = (byte)5;
                            } else if (this.prevcp == 126) {
                                this.newConditionalSelector(n, n2, Condition.ConditionType.ONE_OF_ATTRIBUTE);
                                this.stage = (byte)5;
                            } else if (this.prevcp == 36) {
                                this.newConditionalSelector(n, n2, Condition.ConditionType.ENDS_ATTRIBUTE);
                                this.stage = (byte)5;
                            } else if (this.prevcp == 94) {
                                this.newConditionalSelector(n, n2, Condition.ConditionType.BEGINS_ATTRIBUTE);
                                this.stage = (byte)5;
                            } else if (this.prevcp == 42) {
                                this.newConditionalSelector(n, n2, Condition.ConditionType.SUBSTRING_ATTRIBUTE);
                                this.stage = (byte)5;
                            } else if (this.prevcp == 65) {
                                this.newConditionalSelector(n, n2, Condition.ConditionType.ATTRIBUTE);
                                this.stage = (byte)5;
                            } else {
                                this.unexpectedCharError(n, n2);
                            }
                        } else if (this.buffer.length() == 0) {
                            if (n2 != 126 && n2 != 36 && n2 != 94 && n2 != 42) {
                                if (this.stage == 4 && ParseHelper.isValidXMLStartCharacter(n2)) {
                                    this.bufferAppend(n2);
                                    this.prevcp = 65;
                                    return;
                                }
                                this.unexpectedCharError(n, n2);
                            }
                        } else if (n2 != 126 && n2 != 36 && n2 != 94 && n2 != 42) {
                            if (this.stage == 4 && ParseHelper.isValidXMLCharacter(n2)) {
                                this.bufferAppend(n2);
                                this.prevcp = 65;
                                return;
                            }
                            this.unexpectedCharError(n, n2);
                        }
                    } else if (n2 == 42) {
                        if (this.stage == 0) {
                            this.stage = 1;
                        } else if (this.stage == 2) {
                            this.newCombinatorSelector(Selector.SelectorType.DESCENDANT);
                            ((NSACSelectorFactory.CombinatorSelectorImpl)this.currentsel).simpleSelector = this.factory.getUniversalSelector(this.namespacePrefix);
                            this.namespacePrefix = null;
                            this.stage = 1;
                        } else if (this.stage == 1 && this.namespacePrefix != null && this.prevcp == 124) {
                            this.setSimpleSelector(n, this.factory.createUniversalSelector(this.getNamespaceURI(n)));
                        } else {
                            this.unexpectedCharError(n, n2);
                        }
                    } else {
                        if (this.prevcp == 124) {
                            if (n2 == 124) {
                                this.handleColumnCombinator(n);
                                this.prevcp = 32;
                                return;
                            }
                            this.unexpectedCharError(n, n2);
                            return;
                        }
                        if (n2 == 126) {
                            if (this.stage == 2) {
                                this.stage = 1;
                            } else {
                                this.processBuffer(n, n2, false);
                            }
                            this.newCombinatorSelector(n, Selector.SelectorType.SUBSEQUENT_SIBLING, n2);
                        } else if (n2 == 46) {
                            if (this.stage != 8 || this.buffer.length() != 0) {
                                this.processBuffer(n, n2, false);
                                this.newConditionalSelector(n, n2, Condition.ConditionType.CLASS);
                                this.stage = (byte)8;
                            } else {
                                this.unexpectedCharError(n, n2);
                            }
                        } else if (n2 == 35) {
                            if (this.stage != 8 || this.buffer.length() != 0) {
                                this.processBuffer(n, n2, false);
                                this.newConditionalSelector(n, n2, Condition.ConditionType.ID);
                                this.stage = (byte)8;
                            } else {
                                this.unexpectedCharError(n, n2);
                            }
                        } else if (n2 == 58) {
                            if (this.prevcp == 58) {
                                this.stage = (byte)9;
                            } else {
                                this.processBuffer(n, n2, false);
                                this.stage = (byte)10;
                            }
                        } else if (n2 == 62) {
                            if (this.stage == 2) {
                                this.stage = 1;
                            } else if (this.stage == 1 && CSSParser.equalSequences("--", this.buffer)) {
                                if (this.isTopLevel() && this.prevcp == 65 && this.escapedTokenIndex == -1 && !this.functionToken) {
                                    this.buffer.setLength(0);
                                    this.stage = 0;
                                    this.prevcp = 32;
                                    return;
                                }
                                this.unexpectedCharError(n, n2);
                            }
                            this.processBuffer(n, n2, false);
                            if (this.stage < 2) {
                                this.newCombinatorSelector(n, Selector.SelectorType.CHILD, n2);
                            } else {
                                this.unexpectedCharError(n, n2);
                            }
                        } else if (n2 == 43) {
                            if (this.stage == 2) {
                                this.stage = 1;
                            }
                            this.processBuffer(n, n2, false);
                            this.newCombinatorSelector(n, Selector.SelectorType.DIRECT_ADJACENT, n2);
                        } else if (n2 == 124) {
                            if (this.stage == 8 || this.stage == 10 || this.stage == 9) {
                                this.processBuffer(n, n2, false);
                                try {
                                    int n3 = this.getTokenControl().skipNextCodepoint();
                                    if (n3 != 124) {
                                        if (n3 == -1) {
                                            this.handleError(n + 1, (byte)10, "EOF while processing column combinator selector");
                                        } else {
                                            this.unexpectedCharError(n + 1, n3);
                                        }
                                        break block110;
                                    }
                                    this.newCombinatorSelector(n, Selector.SelectorType.COLUMN_COMBINATOR, 124);
                                    this.prevcp = 32;
                                    return;
                                }
                                catch (IOException iOException) {
                                    this.handleError(n + 1, (byte)11, "I/O Error when processing column combinator selector", iOException);
                                }
                            } else if (this.stage == 2) {
                                this.stage = 1;
                            } else if (this.stage == 1 && this.namespacePrefix == null) {
                                this.readNamespacePrefix(n, n2);
                            } else if (this.stage == 0 && this.namespacePrefix == null && this.buffer.length() == 0) {
                                this.namespacePrefix = "";
                            } else {
                                this.unexpectedCharError(n, n2);
                            }
                        } else if (n2 == 44) {
                            if (this.functionToken) {
                                if (this.prevcp == 44) {
                                    this.unexpectedCharError(n, n2);
                                } else {
                                    this.buffer.append(',');
                                }
                            } else {
                                this.processBuffer(n, n2, true);
                                if (!this.parseError) {
                                    if (this.addCurrentSelector(n)) {
                                        this.stage = 0;
                                    } else {
                                        this.unexpectedCharError(n, n2);
                                    }
                                }
                            }
                        } else if (n2 == 64) {
                            this.handleAtKeyword(n);
                        } else if (n2 == 45) {
                            this.buffer.append('-');
                        } else if (n2 == 95) {
                            this.buffer.append('_');
                        } else {
                            if (this.stage < 8) {
                                if (this.stage == 0) {
                                    if (ParseHelper.isValidXMLStartCharacter(n2)) {
                                        this.bufferAppend(n2);
                                        this.stage = 1;
                                        this.prevcp = 65;
                                        return;
                                    }
                                } else if (ParseHelper.isValidXMLCharacter(n2)) {
                                    this.bufferAppend(n2);
                                    this.prevcp = 65;
                                    return;
                                }
                                if (n2 == 60 && this.isTopLevel()) {
                                    this.processBuffer(n, n2, false);
                                    this.handleCDO();
                                    this.prevcp = 32;
                                    return;
                                }
                            } else if (!this.isUnexpectedCharacter(n2)) {
                                this.bufferAppend(n2);
                                this.prevcp = 65;
                                return;
                            }
                            this.unexpectedCharError(n, n2);
                        }
                    }
                }
            }
            this.prevcp = n2;
        }

        boolean skipCharacterHandling() {
            return this.parseError;
        }

        private void handleColumnCombinator(int n) {
            if (this.stage == 1) {
                if (this.currentsel == null) {
                    NSACSelectorFactory.ElementSelectorImpl elementSelectorImpl = this.newElementSelector(n);
                    if (this.namespacePrefix != null) {
                        elementSelectorImpl.localName = this.namespacePrefix;
                        this.namespacePrefix = null;
                    } else if (this.buffer.length() != 0) {
                        elementSelectorImpl.localName = this.unescapeBuffer(n);
                    } else {
                        this.unexpectedCharError(n, 124);
                        return;
                    }
                }
                this.newCombinatorSelector(n, Selector.SelectorType.COLUMN_COMBINATOR, 124);
            } else if (this.stage == 0 && this.buffer.length() == 0 && this.currentsel == null) {
                this.namespacePrefix = null;
                this.newCombinatorSelector(n, Selector.SelectorType.COLUMN_COMBINATOR, 124);
            } else {
                this.unexpectedCharError(n, 124);
            }
        }

        private boolean isUnexpectedCharacter(int n) {
            return n == 33 || n == 36 || n == 37 || n == 38 || n == 47 || n >= 59 && n <= 63 || n == 94 || n == 96;
        }

        private void handleCDO() {
            CDOTokenHandler cDOTokenHandler = new CDOTokenHandler(this.getTokenControl());
            this.getTokenControl().setTokenHandler((TokenHandler3)cDOTokenHandler);
        }

        private void readNamespacePrefix(int n, int n2) {
            if (this.prevcp == 65) {
                this.namespacePrefix = this.unescapeBuffer(n);
            } else if (this.prevcp == 42 && this.buffer.length() == 0) {
                this.namespacePrefix = "*";
            } else {
                this.unexpectedCharError(n, n2);
            }
        }

        protected void handleAtKeyword(int n) {
            this.unexpectedCharError(n, 64);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void newConditionalSelector(int n, int n2, Condition.ConditionType conditionType) {
            Condition condition;
            String string;
            String string2;
            block26: {
                block27: {
                    block37: {
                        block36: {
                            block35: {
                                block34: {
                                    block33: {
                                        block32: {
                                            block31: {
                                                block30: {
                                                    block29: {
                                                        block28: {
                                                            string2 = this.rawBuffer();
                                                            string = string2.toLowerCase(Locale.ROOT).intern();
                                                            if (conditionType != Condition.ConditionType.PSEUDO_CLASS) break block27;
                                                            if (!"lang".equals(string)) break block28;
                                                            condition = this.factory.createCondition(Condition.ConditionType.LANG);
                                                            break block26;
                                                        }
                                                        if (!"first-child".equals(string)) break block29;
                                                        if (n2 == 40) {
                                                            this.handleError(n, (byte)4, "Positional pseudo-class cannot have argument");
                                                            return;
                                                        }
                                                        condition = this.factory.createPositionalCondition();
                                                        break block26;
                                                    }
                                                    if (!"nth-child".equals(string)) break block30;
                                                    condition = this.factory.createPositionalCondition(true);
                                                    break block26;
                                                }
                                                if (!"last-child".equals(string)) break block31;
                                                if (n2 == 40) {
                                                    this.handleError(n, (byte)4, "Positional pseudo-class cannot have argument");
                                                    return;
                                                }
                                                condition = this.factory.createPositionalCondition();
                                                ((PositionalConditionImpl)condition).offset = 1;
                                                ((PositionalConditionImpl)condition).forwardCondition = false;
                                                break block26;
                                            }
                                            if (!"nth-last-child".equals(string)) break block32;
                                            condition = this.factory.createPositionalCondition(true);
                                            ((PositionalConditionImpl)condition).offset = 1;
                                            ((PositionalConditionImpl)condition).forwardCondition = false;
                                            break block26;
                                        }
                                        if (!"first-of-type".equals(string)) break block33;
                                        condition = this.factory.createPositionalCondition();
                                        ((PositionalConditionImpl)condition).oftype = true;
                                        ((PositionalConditionImpl)condition).offset = 1;
                                        break block26;
                                    }
                                    if (!"last-of-type".equals(string)) break block34;
                                    if (n2 == 40) {
                                        this.handleError(n, (byte)4, "Positional pseudo-class cannot have argument");
                                        return;
                                    }
                                    condition = this.factory.createPositionalCondition();
                                    ((PositionalConditionImpl)condition).oftype = true;
                                    ((PositionalConditionImpl)condition).offset = 1;
                                    ((PositionalConditionImpl)condition).forwardCondition = false;
                                    break block26;
                                }
                                if (!"nth-of-type".equals(string)) break block35;
                                condition = this.factory.createPositionalCondition(true);
                                ((PositionalConditionImpl)condition).oftype = true;
                                break block26;
                            }
                            if (!"nth-last-of-type".equals(string)) break block36;
                            condition = this.factory.createPositionalCondition(true);
                            ((PositionalConditionImpl)condition).oftype = true;
                            ((PositionalConditionImpl)condition).forwardCondition = false;
                            break block26;
                        }
                        if (!"only-child".equals(string)) break block37;
                        if (n2 == 40) {
                            this.handleError(n, (byte)4, "Positional pseudo-class cannot have argument");
                            return;
                        }
                        condition = this.factory.createCondition(Condition.ConditionType.ONLY_CHILD);
                        break block26;
                    }
                    if ("only-of-type".equals(string)) {
                        if (n2 == 40) {
                            this.handleError(n, (byte)4, "Positional pseudo-class cannot have argument");
                            return;
                        }
                        condition = this.factory.createCondition(Condition.ConditionType.ONLY_TYPE);
                        break block26;
                    } else if ("not".equals(string) || "is".equals(string) || "has".equals(string) || "where".equals(string)) {
                        if (n2 != 40) {
                            StringBuilder stringBuilder = new StringBuilder(string2.length() * 2 + 26);
                            stringBuilder.append("Expected ':").append(string2).append("(', found ':").append(string2).appendCodePoint(n2).append('\'');
                            this.handleError(n, (byte)4, stringBuilder.toString());
                            return;
                        }
                        condition = this.factory.createCondition(Condition.ConditionType.SELECTOR_ARGUMENT);
                        ((SelectorArgumentConditionImpl)condition).setName(string);
                        break block26;
                    } else {
                        if ("first-line".equals(string) || "first-letter".equals(string) || "before".equals(string) || "after".equals(string)) {
                            conditionType = Condition.ConditionType.PSEUDO_ELEMENT;
                        }
                        condition = this.factory.createCondition(conditionType);
                    }
                    break block26;
                }
                condition = this.factory.createCondition(conditionType);
            }
            if (condition.getConditionType() == Condition.ConditionType.PSEUDO_CLASS) {
                if (!this.isValidPseudoName(string2)) {
                    this.handleError(n - string2.length(), (byte)7, "Invalid pseudo-class: " + string2);
                    return;
                }
                ((PseudoConditionImpl)condition).name = this.safeUnescapeIdentifier(n, string2);
            } else if (condition.getConditionType() == Condition.ConditionType.PSEUDO_ELEMENT) {
                if (!this.isValidPseudoName(string2)) {
                    this.handleError(n - string2.length(), (byte)7, "Invalid pseudo-element: " + string2);
                    return;
                }
                if (n2 == 40) {
                    this.handleError(n, (byte)4, "Invalid pseudo-element declaration: " + string2 + '(');
                    return;
                }
                ((PseudoConditionImpl)condition).name = this.safeUnescapeIdentifier(n, string2);
            }
            if (string2.length() != 0 && condition instanceof NSACSelectorFactory.AttributeConditionImpl) {
                switch (condition.getConditionType()) {
                    case ATTRIBUTE: 
                    case BEGIN_HYPHEN_ATTRIBUTE: 
                    case ONE_OF_ATTRIBUTE: 
                    case ENDS_ATTRIBUTE: 
                    case SUBSTRING_ATTRIBUTE: 
                    case BEGINS_ATTRIBUTE: {
                        if (this.namespacePrefix != null) {
                            ((NSACSelectorFactory.AttributeConditionImpl)condition).setNamespaceURI(this.getNamespaceURI(n));
                        }
                        if (!this.isNotForbiddenIdentStart(string2)) {
                            this.handleError(n - string2.length(), (byte)7, "Invalid pseudo-class: " + string2);
                            return;
                        }
                        ((NSACSelectorFactory.AttributeConditionImpl)condition).setLocalName(this.safeUnescapeIdentifier(n, string2).trim());
                        break;
                    }
                    default: {
                        ((NSACSelectorFactory.AttributeConditionImpl)condition).setValue(string.trim());
                    }
                }
            }
            if (this.currentsel instanceof NSACSelectorFactory.CombinatorSelectorImpl) {
                SimpleSelector simpleSelector = ((NSACSelectorFactory.CombinatorSelectorImpl)this.currentsel).getSecondSelector();
                if (simpleSelector != null && simpleSelector.getSelectorType() == Selector.SelectorType.CONDITIONAL) {
                    CombinatorConditionImpl combinatorConditionImpl = (CombinatorConditionImpl)this.factory.createCondition(Condition.ConditionType.AND);
                    combinatorConditionImpl.first = ((ConditionalSelectorImpl)simpleSelector).getCondition();
                    combinatorConditionImpl.second = condition;
                    ((NSACSelectorFactory.CombinatorSelectorImpl)this.currentsel).simpleSelector = this.factory.createConditionalSelector(((ConditionalSelectorImpl)simpleSelector).getSimpleSelector(), combinatorConditionImpl);
                    return;
                }
                ((NSACSelectorFactory.CombinatorSelectorImpl)this.currentsel).simpleSelector = this.factory.createConditionalSelector(((NSACSelectorFactory.CombinatorSelectorImpl)this.currentsel).simpleSelector, condition);
                return;
            }
            if (this.currentsel != null && this.currentsel.getSelectorType() == Selector.SelectorType.CONDITIONAL) {
                CombinatorConditionImpl combinatorConditionImpl = (CombinatorConditionImpl)this.factory.createCondition(Condition.ConditionType.AND);
                combinatorConditionImpl.first = ((ConditionalSelectorImpl)this.currentsel).getCondition();
                combinatorConditionImpl.second = condition;
                this.currentsel = this.factory.createConditionalSelector(((ConditionalSelectorImpl)this.currentsel).getSimpleSelector(), combinatorConditionImpl);
                return;
            }
            this.currentsel = this.factory.createConditionalSelector((SimpleSelector)this.currentsel, condition);
        }

        private boolean parsePositionalArgument(PositionalConditionImpl positionalConditionImpl, String string) {
            MyAnBExpression myAnBExpression = new MyAnBExpression();
            try {
                myAnBExpression.parse(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            positionalConditionImpl.offset = myAnBExpression.getOffset();
            positionalConditionImpl.slope = myAnBExpression.getStep();
            positionalConditionImpl.ofList = myAnBExpression.getSelectorList();
            positionalConditionImpl.hasKeyword = myAnBExpression.isKeyword();
            return true;
        }

        private String getDefaultNamespaceURI() {
            String string = this.nsMap.getNamespaceURI("");
            if (string != null && this.factory != this.nsMap) {
                this.factory.registerNamespacePrefix("", string);
            }
            return string;
        }

        private String getNamespaceURI(int n) {
            String string;
            if (this.namespacePrefix.length() != 0) {
                string = this.nsMap.getNamespaceURI(this.namespacePrefix);
                if (string != null) {
                    if (this.factory != this.nsMap) {
                        this.factory.registerNamespacePrefix(this.namespacePrefix, string);
                    }
                } else if (!this.namespacePrefix.equals("*")) {
                    this.handleError(n - this.buffer.length() - this.namespacePrefix.length() - 1, (byte)15, "Unknown namespace prefix: " + this.namespacePrefix);
                }
            } else {
                string = "";
            }
            this.namespacePrefix = null;
            return string;
        }

        private NSACSelectorFactory.ElementSelectorImpl newElementSelector(int n) {
            NSACSelectorFactory.ElementSelectorImpl elementSelectorImpl = this.factory.createElementSelector();
            this.setSimpleSelector(n, elementSelectorImpl);
            return elementSelectorImpl;
        }

        private void setSimpleSelector(int n, SimpleSelector simpleSelector) {
            if (this.currentsel instanceof NSACSelectorFactory.CombinatorSelectorImpl) {
                ((NSACSelectorFactory.CombinatorSelectorImpl)this.currentsel).simpleSelector = simpleSelector;
            } else if (this.currentsel != null) {
                this.handleError(n - this.buffer.length(), (byte)9, "Unexpected token after '" + this.currentsel.toString() + "': " + simpleSelector.toString());
            } else {
                this.currentsel = simpleSelector;
            }
        }

        protected void newCombinatorSelector(int n, Selector.SelectorType selectorType, int n2) {
            if (this.currentsel != null && this.isValidCurrentSelector()) {
                this.newCombinatorSelector(selectorType);
            } else {
                this.unexpectedCharError(n, n2);
            }
        }

        void newCombinatorSelector(Selector.SelectorType selectorType) {
            this.currentsel = this.factory.createCombinatorSelector(selectorType, this.currentsel);
            this.stage = 0;
        }

        public void escaped(int n, int n2) {
            if (this.stage == 4 || this.stage == 5 || this.stage == 8 || this.stage == 11 || this.stage == 0 || this.stage == 2) {
                if (ParseHelper.isHexCodePoint(n2) || n2 == 92) {
                    this.setEscapedTokenStart(n);
                    this.buffer.append('\\');
                } else {
                    Selector selector;
                    if (Character.isISOControl(n2)) {
                        this.unexpectedCharError(n, n2);
                        return;
                    }
                    if (this.stage == 11 && (selector = this.getActiveSelector()).getSelectorType() == Selector.SelectorType.CONDITIONAL) {
                        Condition condition = ((ConditionalSelectorImpl)selector).condition;
                        if ((condition = this.getActiveCondition(condition)).getConditionType() == Condition.ConditionType.SELECTOR_ARGUMENT) {
                            this.buffer.append('\\');
                        }
                    }
                }
                this.bufferAppend(n2);
                if (this.stage == 0) {
                    this.stage = 1;
                }
                this.prevcp = 65;
            } else {
                this.unexpectedCharError(n - 1, 92);
            }
        }

        @Override
        public void commented(int n, int n2, String string) {
            if (this.stage == 0 && this.selist.size() == 0) {
                super.commented(n, n2, string);
            } else {
                this.separator(n, 12);
                if (this.prevcp != 44) {
                    this.prevcp = 12;
                }
            }
        }

        public void endOfStream(int n) {
            if (!this.parseError) {
                this.processBuffer(n, 32, true);
                if (!this.parseError && !this.addCurrentSelector(n)) {
                    this.handleError(n, (byte)10, "Unexpected end of stream");
                }
            }
        }

        boolean addCurrentSelector(int n) {
            if (this.currentsel != null) {
                if (this.isValidCurrentSelector()) {
                    this.selist.add(this.currentsel, n);
                    this.currentsel = null;
                    return true;
                }
                this.selist.clear();
                this.currentsel = null;
            }
            return false;
        }

        boolean isValidCurrentSelector() {
            SimpleSelector simpleSelector = null;
            switch (this.currentsel.getSelectorType()) {
                case CHILD: 
                case DESCENDANT: 
                case COLUMN_COMBINATOR: 
                case DIRECT_ADJACENT: 
                case SUBSEQUENT_SIBLING: {
                    simpleSelector = ((NSACSelectorFactory.CombinatorSelectorImpl)this.currentsel).getSecondSelector();
                    break;
                }
                case CONDITIONAL: {
                    Condition condition = ((ConditionalSelectorImpl)this.currentsel).getCondition();
                    Condition.ConditionType conditionType = condition.getConditionType();
                    while (conditionType == Condition.ConditionType.AND) {
                        if ((condition = ((CombinatorCondition)condition).getSecondCondition()) == null) {
                            return false;
                        }
                        conditionType = condition.getConditionType();
                    }
                    switch (conditionType) {
                        case ATTRIBUTE: {
                            if (((NSACSelectorFactory.AttributeConditionImpl)condition).getLocalName() != null) break;
                            return false;
                        }
                        case PSEUDO_CLASS: 
                        case PSEUDO_ELEMENT: {
                            if (((PseudoConditionImpl)condition).name != null) break;
                            return false;
                        }
                        case BEGIN_HYPHEN_ATTRIBUTE: 
                        case ONE_OF_ATTRIBUTE: 
                        case ENDS_ATTRIBUTE: 
                        case SUBSTRING_ATTRIBUTE: 
                        case BEGINS_ATTRIBUTE: 
                        case CLASS: {
                            if (((NSACSelectorFactory.AttributeConditionImpl)condition).getValue() != null) break;
                            return false;
                        }
                        case LANG: {
                            if (((LangConditionImpl)condition).getLang() != null) break;
                            return false;
                        }
                        case SELECTOR_ARGUMENT: {
                            if (((SelectorArgumentConditionImpl)condition).getSelectors() != null) break;
                            return false;
                        }
                    }
                }
                default: {
                    return true;
                }
            }
            return simpleSelector != null;
        }

        @Override
        void resetHandler() {
            super.resetHandler();
            this.stage = 0;
            this.functionToken = false;
            this.escapedTokenIndex = -1;
            this.buffer.setLength(0);
            this.namespacePrefix = null;
            this.currentsel = null;
        }

        @Override
        public void error(int n, byte by, CharSequence charSequence) {
            if (by == 1) {
                n -= charSequence.length() + 1;
            }
            super.error(n, by, charSequence);
            this.currentsel = null;
            this.selist.clear();
        }

        @Override
        protected void handleError(int n, byte by, String string) {
            if (!this.parseError) {
                this.stage = (byte)127;
                if (this.prevcp == this.endcp && this.endcp != -1) {
                    throw this.createException(n, by, "Expected end of file, found " + new String(Character.toChars(this.prevcp)));
                }
                throw this.createException(n, by, string);
            }
        }

        class MyAnBExpression
        extends AnBExpression {
            private static final long serialVersionUID = 1L;

            MyAnBExpression() {
            }

            @Override
            protected SelectorList parseSelector(String string) {
                CSSParser cSSParser = CSSParser.this.clone();
                return cSSParser.parseSelectors(string, SelectorTokenHandler.this.factory);
            }
        }
    }

    class SheetTokenHandler
    extends ControlTokenHandler {
        CSSTokenHandler contextHandler;
        private final DeclarationTokenHandler declarationHandler;
        private final SelectorTokenHandler selectorHandler;
        private String ruleFirstPart = null;
        private String ruleSecondPart = null;
        private int curlyBracketDepth = 0;
        private byte ruleType = 0;
        private static final byte MEDIA_RULE = 4;
        private static final byte FONT_FACE_RULE = 5;
        private static final byte SUPPORTS_RULE = 12;
        private byte stage = 0;
        private static final byte STAGE_INITIAL = 0;
        private static final byte STAGE_CHARSET_RULE = 32;
        private static final byte STAGE_NS_RULE_EXPECT_FIRST_TOKEN = 34;
        private static final byte STAGE_NS_RULE_EXPECT_SECOND_TOKEN = 35;
        private static final byte STAGE_NS_RULE_EXPECT_SECOND_TOKEN_AS_URL = 36;
        private static final byte STAGE_NS_RULE_RCVD_SECOND_TOKEN_AS_URL = 37;
        private static final byte STAGE_IMPORT_RULE_EXPECT_FIRST_TOKEN = 38;
        private static final byte STAGE_IMPORT_RULE_EXPECT_FIRST_TOKEN_AS_URL = 39;
        private static final byte STAGE_IMPORT_RULE_EXPECT_CLOSING_PAREN = 41;
        private static final byte STAGE_IMPORT_RULE_EXPECT_SECOND_TOKEN_OR_FINAL = 40;
        private static final byte STAGE_GROUPING_OR_FONTFACE_RULE = 2;
        private static final byte STAGE_UNKNOWN_RULE = 5;
        private static final byte STAGE_NESTED_RULE_INSIDE_GROUPING_OR_FONTFACE_EXCEPT_10 = 7;
        private static final byte STAGE_NESTED_FONTFACE_RULE_INSIDE_GROUPING = 10;
        private boolean rulesFound = false;
        private ConditionWrapper currentCondition = null;
        private final boolean topLevel;

        SheetTokenHandler(Parser.NamespaceMap namespaceMap, boolean bl) {
            this.topLevel = bl;
            this.buffer = new StringBuilder(512);
            this.declarationHandler = new MyDeclarationTokenHandler();
            this.selectorHandler = new MySelectorTokenHandler(namespaceMap);
            this.contextHandler = this.selectorHandler;
        }

        int getCurlyBracketDepth() {
            return this.curlyBracketDepth;
        }

        public void word(int n, CharSequence charSequence) {
            if (this.contextHandler != null) {
                this.contextHandler.word(n, charSequence);
            } else if (this.stage == 41) {
                this.handleError(n, (byte)33, "Unexpected token: '" + charSequence + '\'');
            } else {
                this.buffer.append(charSequence);
            }
            this.prevcp = 65;
        }

        public void separator(int n, int n2) {
            if (this.contextHandler != null) {
                this.contextHandler.separator(n, n2);
            } else {
                if (this.stage == 39) {
                    if (this.buffer.length() != 0) {
                        this.stage = (byte)41;
                    }
                } else if (this.stage != 41) {
                    if (this.stage == 38) {
                        if (this.buffer.length() != 0) {
                            this.processFirstPart(n);
                            this.stage = (byte)40;
                        }
                    } else if (this.stage == 34) {
                        if (this.ruleFirstPart == null) {
                            if (this.buffer.length() != 0) {
                                this.ruleFirstPart = this.buffer.toString();
                                this.buffer.setLength(0);
                                this.stage = (byte)35;
                            }
                        } else {
                            this.stage = (byte)35;
                        }
                    } else if (this.buffer.length() != 0 && (!this.isPrevCpWhitespace() || this.escapedTokenIndex != -1 && CSSParser.bufferEndsWithEscapedCharOrWS(this.buffer))) {
                        this.buffer.append(' ');
                    }
                }
                this.setWhitespacePrevCp();
            }
        }

        @Override
        protected void setHandlerPreviousCp(int n) {
            super.setHandlerPreviousCp(n);
            if (this.contextHandler != null) {
                this.contextHandler.setHandlerPreviousCp(n);
            }
        }

        @Override
        protected boolean isPreviousCpLF() {
            if (this.contextHandler != null) {
                return this.contextHandler.isPreviousCpLF();
            }
            return super.isPreviousCpLF();
        }

        public void quoted(int n, CharSequence charSequence, int n2) {
            if (this.contextHandler != null) {
                this.contextHandler.quoted(n, charSequence, n2);
            } else if (this.stage == 5 || this.stage == 7) {
                char c = (char)n2;
                this.buffer.append(c).append(charSequence).append(c);
            } else if (this.stage == 41 || this.stage == 39 && this.prevcp != 40 && !this.isPrevCpWhitespace()) {
                this.handleError(n, (byte)33, "Expected ')', found '" + charSequence + '\'');
            } else {
                if (this.ruleFirstPart == null) {
                    this.ruleFirstPart = charSequence.toString();
                    if (this.stage == 39) {
                        this.stage = (byte)41;
                    } else if (this.stage == 38) {
                        this.stage = (byte)40;
                    }
                } else if (this.ruleSecondPart == null) {
                    this.ruleSecondPart = charSequence.toString();
                } else {
                    this.buffer.append(charSequence);
                }
                this.prevcp = 65;
            }
        }

        public void quotedWithControl(int n, CharSequence charSequence, int n2) {
            this.quoted(n, charSequence, n2);
        }

        public void leftCurlyBracket(int n) {
            if (this.contextHandler != null) {
                this.contextHandler.leftCurlyBracket(n);
            } else {
                this.prevcp = 123;
                ++this.curlyBracketDepth;
                if (this.stage == 2) {
                    if (this.curlyBracketDepth == 1) {
                        if (this.ruleType == 5) {
                            this.startFontFaceRule(n);
                        }
                        this.buffer.setLength(0);
                    }
                } else if (this.stage == 10 && this.curlyBracketDepth >= 2) {
                    this.startFontFaceRule(n);
                } else {
                    this.buffer.append('{');
                }
            }
        }

        public void leftParenthesis(int n) {
            if (this.contextHandler != null) {
                this.contextHandler.leftParenthesis(n);
            } else {
                this.prevcp = 40;
                this.parendepth = (short)(this.parendepth + 1);
                if (this.stage == 38) {
                    if (this.bufferEquals("url")) {
                        this.stage = (byte)39;
                    } else {
                        this.handleError(n, (byte)4, "Unexpected '(' after " + this.buffer);
                    }
                } else if (this.stage == 39) {
                    this.handleError(n, (byte)4, "Unexpected '(' after " + this.buffer);
                } else if (this.stage == 35) {
                    if (this.bufferEquals("url")) {
                        this.stage = (byte)36;
                    } else {
                        this.handleError(n, (byte)4, "Unexpected '(' after " + this.buffer);
                    }
                } else if (this.stage == 34) {
                    if (this.bufferEquals("url")) {
                        this.ruleFirstPart = "";
                        this.stage = (byte)36;
                    } else {
                        this.handleError(n, (byte)4, "Unexpected '(' after " + this.buffer);
                    }
                } else {
                    this.buffer.append('(');
                }
            }
        }

        public void leftSquareBracket(int n) {
            if (this.contextHandler != null) {
                this.contextHandler.leftSquareBracket(n);
            } else {
                this.buffer.append('[');
                this.prevcp = 91;
            }
        }

        private void startFontFaceRule(int n) {
            if (this.buffer.length() != 0) {
                this.handleError(n - this.buffer.length(), (byte)9, "Unexpected token in @font-face rule: " + this.buffer);
            } else {
                CSSParser.this.handler.startFontFace();
                this.declarationHandler.curlyBracketDepth = 1;
                this.contextHandler = this.declarationHandler;
                --this.curlyBracketDepth;
            }
        }

        public void rightParenthesis(int n) {
            if (this.contextHandler != null) {
                this.contextHandler.rightParenthesis(n);
            } else {
                this.decrParenDepth(n);
                if (this.stage == 36) {
                    this.processBuffer(n);
                    if (this.ruleSecondPart != null) {
                        this.stage = (byte)37;
                    } else {
                        this.handleError(n, (byte)33, "Empty URI in namespace rule");
                    }
                } else if (this.stage == 39 || this.stage == 41) {
                    this.processFirstPart(n);
                    this.stage = (byte)40;
                } else {
                    this.buffer.append(')');
                }
                this.prevcp = 41;
            }
        }

        public void rightSquareBracket(int n) {
            if (this.contextHandler != null) {
                this.contextHandler.rightSquareBracket(n);
            } else {
                this.buffer.append(']');
                this.prevcp = 93;
            }
        }

        public void rightCurlyBracket(int n) {
            if (this.contextHandler != null) {
                this.contextHandler.rightCurlyBracket(n);
            } else {
                --this.curlyBracketDepth;
                this.buffer.append('}');
                if (this.curlyBracketDepth == 0) {
                    if (!this.parseError) {
                        CSSParser.this.handler.ignorableAtRule(this.buffer.toString());
                        this.stage = 0;
                    }
                    this.buffer.setLength(0);
                    this.endRuleBody();
                } else if (!this.parseError && this.curlyBracketDepth == 1 && this.stage == 7) {
                    CSSParser.this.handler.ignorableAtRule(this.buffer.toString());
                    this.buffer.setLength(0);
                    this.stage = (byte)2;
                    this.switchContextToStage2();
                }
                this.prevcp = 125;
            }
        }

        protected void endRuleBody() {
            this.setSelectorHandler();
        }

        void setSelectorHandler() {
            this.selectorHandler.resetHandler();
            this.contextHandler = this.selectorHandler;
            this.rulesFound = true;
        }

        private void switchContextToStage2() {
            if (this.ruleType == 4 || this.ruleType == 12) {
                this.contextHandler = this.selectorHandler;
                this.selectorHandler.prevcp = 32;
            } else if (this.ruleType == 5) {
                this.declarationHandler.curlyBracketDepth = 1;
                this.contextHandler = this.declarationHandler;
            }
        }

        public void character(int n, int n2) {
            if (this.contextHandler != null) {
                this.contextHandler.character(n, n2);
            } else {
                this.prevcp = n2;
                if (n2 == 59) {
                    if (this.curlyBracketDepth == 0) {
                        if (this.parendepth == 0) {
                            if (this.stage != 0) {
                                this.endOfAtRule(n);
                            } else {
                                this.handleError(n, (byte)33, "Empty @-rule.");
                                this.resetRuleState();
                            }
                        } else if (this.stage != 39) {
                            this.handleError(n, (byte)6, "Unmatched parentheses in rule.");
                            this.resetRuleState();
                        } else {
                            this.buffer.append(';');
                            this.prevcp = n2;
                            return;
                        }
                        this.setSelectorHandler();
                    } else {
                        this.buffer.append(';');
                    }
                } else if (this.isAllowedChar(n2)) {
                    this.bufferAppend(n2);
                } else {
                    this.unexpectedCharError(n, n2);
                }
            }
        }

        private void endOfAtRule(int n) {
            this.processBuffer(n);
            if (this.buffer.length() != 0) {
                this.handleError(n, (byte)9, "Malformed @-rule, unexpected <" + this.buffer.toString() + ">");
            }
            if (this.stage == 40 || this.stage == 38) {
                this.currentCondition = this.ruleSecondPart != null ? this.newMediaList(this.ruleSecondPart) : null;
                if (this.ruleFirstPart != null) {
                    if (this.currentCondition == null) {
                        this.currentCondition = this.newMediaListAll();
                    }
                    CSSParser.this.handler.importStyle(this.ruleFirstPart, this.currentCondition.getMediaList(), null);
                } else if (!this.parseError) {
                    this.handleError(n, (byte)33, "Malformed @-rule");
                }
            } else if (this.stage == 35 || this.stage == 37) {
                if (this.ruleSecondPart != null) {
                    this.namespaceDeclaration(this.ruleFirstPart, this.ruleSecondPart);
                } else {
                    this.handleError(n, (byte)33, "No URI in namespace rule");
                }
            } else if (this.stage == 34) {
                this.namespaceDeclaration("", this.ruleFirstPart);
            } else if (this.stage == 36) {
                this.handleError(n, (byte)33, "Bad URI in namespace rule");
            }
            this.resetRuleState();
            this.rulesFound = true;
        }

        private ConditionWrapper newMediaListAll() {
            MediaQueryFactory mediaQueryFactory = CSSParser.this.getMediaQueryFactory();
            MediaQueryList mediaQueryList = mediaQueryFactory.createAllMedia();
            return new ConditionWrapper(mediaQueryList, this.currentCondition);
        }

        private ConditionWrapper newMediaList(String string) {
            MediaQueryList mediaQueryList = CSSParser.this.parseMediaQueryList(string);
            return new ConditionWrapper(mediaQueryList, this.currentCondition);
        }

        void namespaceDeclaration(String string, String string2) {
            CSSParser.this.handler.namespaceDeclaration(string, string2);
            this.selectorHandler.factory.registerNamespacePrefix(string, string2);
        }

        void resetRuleState() {
            this.resetHandler();
            if (this.currentCondition != null) {
                this.currentCondition = this.currentCondition.getParent();
                if (this.currentCondition == null) {
                    this.stage = 0;
                } else {
                    this.ruleType = this.currentCondition.isMediaCondition() ? (byte)4 : (byte)12;
                }
            } else {
                this.stage = 0;
            }
            this.ruleFirstPart = null;
            this.ruleSecondPart = null;
            this.buffer.setLength(0);
        }

        private boolean isAllowedChar(int n) {
            switch (this.stage) {
                case 5: 
                case 7: 
                case 36: 
                case 39: {
                    return true;
                }
                case 40: {
                    return n == 58 || this.isImportMediaRuleAllowedChar(n);
                }
            }
            return false;
        }

        private boolean isImportMediaRuleAllowedChar(int n) {
            int[] nArray = new int[]{37, 42, 43, 44, 45, 46, 47, 60, 61, 62};
            return Arrays.binarySearch(nArray, n) >= 0;
        }

        private void processFirstPart(int n) {
            if (this.buffer.length() != 0) {
                this.trimBufferTail();
                if (this.ruleFirstPart == null) {
                    this.ruleFirstPart = this.buffer.toString();
                    this.buffer.setLength(0);
                } else {
                    this.handleError(n, (byte)33, "Unexpected token: " + this.buffer.toString());
                }
            } else if (this.ruleFirstPart == null) {
                this.handleError(n, (byte)33, "Empty rule.");
            }
        }

        private void processBuffer(int n) {
            if (this.buffer.length() != 0) {
                this.trimBufferTail();
                if (this.ruleFirstPart == null) {
                    this.ruleFirstPart = this.buffer.toString();
                    this.buffer.setLength(0);
                } else if (this.ruleSecondPart == null) {
                    this.ruleSecondPart = this.buffer.toString();
                    this.buffer.setLength(0);
                }
            }
        }

        private void trimBufferTail() {
            if (this.buffer.charAt(this.buffer.length() - 1) == ' ') {
                this.buffer.setLength(this.buffer.length() - 1);
            }
        }

        private boolean bufferEquals(String string) {
            if (ParseHelper.equalsIgnoreCase(this.buffer, string)) {
                this.buffer.setLength(0);
                return true;
            }
            return false;
        }

        public void escaped(int n, int n2) {
            if (this.contextHandler != null) {
                this.contextHandler.escaped(n, n2);
            } else if (!this.parseError) {
                if (ParseHelper.isHexCodePoint(n2) || n2 == 92) {
                    this.setEscapedTokenStart(n);
                    this.buffer.append('\\');
                }
                this.bufferAppend(n2);
            }
            this.prevcp = 65;
        }

        public void endOfStream(int n) {
            if (this.contextHandler != null) {
                this.contextHandler.endOfStream(n);
                return;
            }
            if (this.ruleType == 5) {
                CSSParser.this.handler.endFontFace();
                if (this.stage == 10) {
                    this.closeGroupingRules();
                }
            } else if (this.ruleType == 4 || this.ruleType == 12) {
                this.closeGroupingRules();
            } else if (this.stage != 0 && !this.parseError) {
                if (this.curlyBracketDepth == 0) {
                    this.endOfAtRule(n);
                } else if (this.buffer.length() != 0) {
                    do {
                        --this.curlyBracketDepth;
                        this.buffer.append('}');
                    } while (this.curlyBracketDepth > 0);
                    CSSParser.this.handler.ignorableAtRule(this.buffer.toString());
                    this.handleError(n, (byte)10, "Unexpected end of stream");
                    this.endDocument();
                    return;
                }
            }
            if (this.curlyBracketDepth != 0 && !this.parseError) {
                this.handleWarning(n, (byte)10, "Unexpected end of stream");
            }
            this.endDocument();
        }

        private void closeGroupingRules() {
            while (this.currentCondition != null) {
                if (this.currentCondition.isMediaCondition()) {
                    CSSParser.this.handler.endMedia(this.currentCondition.getMediaList());
                } else {
                    CSSParser.this.handler.endSupports(this.currentCondition.getCondition());
                }
                this.currentCondition = this.currentCondition.getParent();
            }
        }

        private void setSelectorHandler(int n) {
            this.contextHandler = this.selectorHandler;
            this.selectorHandler.parseError = false;
            this.selectorHandler.prevcp = 32;
            this.selectorHandler.stage = 0;
            this.prevcp = n;
        }

        @Override
        public void commented(int n, int n2, String string) {
            if (this.stage == 5 || this.stage == 7) {
                if (n2 == 0) {
                    this.buffer.append("/*").append(string).append("*/");
                }
            } else if (this.contextHandler != null) {
                this.contextHandler.commented(n, n2, string);
            } else {
                this.separator(n, 12);
            }
        }

        @Override
        protected void handleError(CSSParseException cSSParseException) throws CSSParseException {
            if (this.contextHandler != null) {
                this.contextHandler.handleError(cSSParseException);
            } else {
                super.handleError(cSSParseException);
                this.buffer.setLength(0);
                this.stage = (byte)127;
            }
        }

        private void startNewRule(int n) {
            String string = this.unescapeBuffer(n);
            if (string.length() > 2) {
                if (this.stage == 0) {
                    this.startRule(n, string);
                } else {
                    this.startNestedRule(n, string);
                }
            } else {
                this.handleError(n, (byte)33, "Malformed @-rule.");
                this.contextHandler = null;
            }
        }

        private void startRule(int n, String string) {
            this.contextHandler = null;
            String string2 = string.substring(1).toLowerCase(Locale.ROOT);
            if ("charset".equals(string2)) {
                if (!this.rulesFound) {
                    this.stage = (byte)32;
                    this.buffer.setLength(0);
                } else {
                    this.handleError(n - 8, (byte)33, "@charset must be the first rule");
                }
            } else if ("import".equals(string2)) {
                this.stage = (byte)38;
                this.buffer.setLength(0);
            } else if ("namespace".equals(string2)) {
                this.stage = (byte)34;
                this.buffer.setLength(0);
            } else if ("media".equals(string2)) {
                this.ruleType = (byte)4;
                this.stage = (byte)2;
                this.buffer.setLength(0);
                this.setMediaQueryHandler();
            } else if ("supports".equals(string2)) {
                this.ruleType = (byte)12;
                this.stage = (byte)2;
                this.buffer.setLength(0);
                this.contextHandler = new MySupportsTokenHandler();
            } else if ("font-face".equals(string2)) {
                this.ruleType = (byte)5;
                this.stage = (byte)2;
                this.buffer.setLength(0);
            } else if ("page".equals(string2)) {
                this.buffer.setLength(0);
                this.contextHandler = new MyPageTH();
            } else if ("viewport".equals(string2)) {
                this.buffer.setLength(0);
                this.contextHandler = new ViewportTokenHandler();
            } else if ("counter-style".equals(string2)) {
                this.buffer.setLength(0);
                this.contextHandler = new CounterStyleTokenHandler();
            } else if ("keyframes".equals(string2)) {
                this.buffer.setLength(0);
                this.contextHandler = new MyKeyFrameBlockListTH();
            } else if ("font-feature-values".equals(string2)) {
                this.buffer.setLength(0);
                this.contextHandler = new MyFontFeatureValuesTH();
            } else if ("property".equals(string2)) {
                this.buffer.setLength(0);
                this.contextHandler = new PropertyRuleTokenHandler();
            } else {
                this.buffer.append(string);
                if (this.isPrevCpWhitespace()) {
                    this.buffer.append(' ');
                }
                this.stage = (byte)5;
            }
        }

        private void startNestedRule(int n, String string) {
            this.contextHandler = null;
            String string2 = string.substring(1).toLowerCase(Locale.ROOT);
            if ("page".equals(string2)) {
                this.buffer.setLength(0);
                this.contextHandler = new MyPageTH();
            } else if ("font-face".equals(string2)) {
                if (this.ruleType == 4 || this.ruleType == 12) {
                    this.ruleType = (byte)5;
                    this.stage = (byte)10;
                    this.buffer.setLength(0);
                } else {
                    this.handleError(n, (byte)9, "Unexpected rule: @font-face.");
                }
            } else if ("media".equals(string2)) {
                if (this.ruleType == 12) {
                    this.ruleType = (byte)4;
                } else if (this.ruleType != 4) {
                    this.handleError(n, (byte)9, "Unexpected: @" + string2);
                    return;
                }
                this.buffer.setLength(0);
                this.setMediaQueryHandler();
            } else if ("supports".equals(string2)) {
                if (this.ruleType == 4) {
                    this.ruleType = (byte)12;
                } else if (this.ruleType != 12) {
                    this.handleError(n, (byte)9, "Unexpected: @" + string2);
                    return;
                }
                this.buffer.setLength(0);
                this.contextHandler = new MySupportsTokenHandler();
            } else if ("viewport".equals(string2)) {
                this.buffer.setLength(0);
                this.contextHandler = new ViewportTokenHandler();
            } else if ("counter-style".equals(string2)) {
                this.buffer.setLength(0);
                this.contextHandler = new CounterStyleTokenHandler();
            } else if ("keyframes".equals(string2)) {
                this.buffer.setLength(0);
                this.contextHandler = new MyKeyFrameBlockListTH();
            } else if ("font-feature-values".equals(string2)) {
                this.buffer.setLength(0);
                this.contextHandler = new MyFontFeatureValuesTH();
            } else if ("charset".equals(string2)) {
                this.handleError(n - 8, (byte)33, "@charset must be the first rule");
            } else if ("property".equals(string2)) {
                this.handleError(n - 9, (byte)33, "@property rules cannot be nested");
            } else {
                this.buffer.append(string);
                if (this.isPrevCpWhitespace()) {
                    this.buffer.append(' ');
                }
                this.stage = (byte)7;
            }
        }

        private void setMediaQueryHandler() {
            MediaQueryFactory mediaQueryFactory = CSSParser.this.getMediaQueryFactory();
            MediaQueryHandler mediaQueryHandler = mediaQueryFactory.createMediaQueryHandler(null);
            this.contextHandler = new MyMediaQueryTokenHandler(mediaQueryFactory, mediaQueryHandler);
        }

        private class AtRuleLauncherTH
        extends ControlTokenHandler {
            private AtRuleLauncherTH() {
            }

            public void word(int n, CharSequence charSequence) {
                SheetTokenHandler.this.buffer.append(charSequence);
                SheetTokenHandler.this.prevcp = 65;
            }

            public void separator(int n, int n2) {
                if (SheetTokenHandler.this.isPrevCpWhitespace()) {
                    if (SheetTokenHandler.this.escapedTokenIndex != -1 && CSSParser.bufferEndsWithEscapedChar(SheetTokenHandler.this.buffer)) {
                        SheetTokenHandler.this.buffer.append(' ');
                    } else {
                        SheetTokenHandler.this.startNewRule(n);
                    }
                } else {
                    SheetTokenHandler.this.setWhitespacePrevCp();
                    if (SheetTokenHandler.this.escapedTokenIndex == -1 || !CSSParser.bufferEndsWithEscapedChar(SheetTokenHandler.this.buffer)) {
                        SheetTokenHandler.this.startNewRule(n);
                    } else {
                        SheetTokenHandler.this.buffer.append(' ');
                    }
                }
            }

            public void quoted(int n, CharSequence charSequence, int n2) {
                this.handleError(n, (byte)9, "Unexpected token: " + n2 + charSequence + n2);
            }

            public void quotedWithControl(int n, CharSequence charSequence, int n2) {
                this.quoted(n, charSequence, n2);
            }

            public void leftParenthesis(int n) {
                SheetTokenHandler.this.startNewRule(n);
                if (SheetTokenHandler.this.contextHandler != null) {
                    SheetTokenHandler.this.contextHandler.leftParenthesis(n);
                } else {
                    SheetTokenHandler.this.leftParenthesis(n);
                }
            }

            public void leftSquareBracket(int n) {
                this.unexpectedCharError(n, 91);
            }

            public void leftCurlyBracket(int n) {
                SheetTokenHandler.this.startNewRule(n);
                if (SheetTokenHandler.this.contextHandler != null) {
                    SheetTokenHandler.this.contextHandler.leftCurlyBracket(n);
                } else {
                    SheetTokenHandler.this.leftCurlyBracket(n);
                }
            }

            public void rightParenthesis(int n) {
                this.unexpectedCharError(n, 41);
            }

            public void rightSquareBracket(int n) {
                this.unexpectedCharError(n, 93);
            }

            public void rightCurlyBracket(int n) {
                this.unexpectedCharError(n, 125);
            }

            public void character(int n, int n2) {
                SheetTokenHandler.this.startNewRule(n);
                if (SheetTokenHandler.this.contextHandler != null) {
                    SheetTokenHandler.this.contextHandler.character(n, n2);
                } else {
                    SheetTokenHandler.this.character(n, n2);
                }
            }

            @Override
            public void commented(int n, int n2, String string) {
                SheetTokenHandler.this.startNewRule(n);
                if (SheetTokenHandler.this.contextHandler != null) {
                    SheetTokenHandler.this.contextHandler.commented(n, n2, string);
                } else {
                    SheetTokenHandler.this.commented(n, n2, string);
                }
            }

            public void escaped(int n, int n2) {
                if (ParseHelper.isHexCodePoint(n2) || n2 == 92) {
                    SheetTokenHandler.this.setEscapedTokenStart(n);
                    SheetTokenHandler.this.buffer.append('\\');
                }
                SheetTokenHandler.this.buffer.appendCodePoint(n2);
                SheetTokenHandler.this.prevcp = 65;
            }

            @Override
            public void control(int n, int n2) {
                SheetTokenHandler.this.control(n, n2);
            }

            public void endOfStream(int n) {
                this.handleError(n, (byte)10, "Unexpected end of stream");
                SheetTokenHandler.this.endOfStream(n);
            }

            @Override
            protected void handleError(CSSParseException cSSParseException) throws CSSParseException {
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.handleError(cSSParseException);
            }

            @Override
            CSSParseException createException(int n, byte by, String string) {
                return SheetTokenHandler.this.createException(n, by, string);
            }
        }

        private class CounterStyleTokenHandler
        extends MyDeclarationRuleTokenHandler {
            private CounterStyleTokenHandler() {
                super(ShorthandDatabase.getInstance());
                this.setRuleName("counter-style");
                this.setStage((byte)2);
            }

            @Override
            protected void startAtRule(int n, String string, String string2) {
                if (string2 != null && CSSParser.isValidIdentifier(string2)) {
                    try {
                        CSSParser.this.handler.startCounterStyle(string2);
                    }
                    catch (DOMException dOMException) {
                        this.handleError(n, (byte)33, "Wrong name for @counter-style rule: " + string2, dOMException);
                        this.setStage((byte)127);
                    }
                } else {
                    this.handleError(n, (byte)33, "Wrong name for @counter-style rule: " + string2);
                    this.setStage((byte)127);
                }
            }

            @Override
            protected void endAtRule(int n) {
                CSSParser.this.handler.endCounterStyle();
                SheetTokenHandler.this.endRuleBody();
            }
        }

        private class MyDeclarationRuleTokenHandler
        extends DeclarationRuleTokenHandler {
            MyDeclarationRuleTokenHandler(ShorthandDatabase shorthandDatabase) {
                super(shorthandDatabase);
                this.setStage((byte)2);
            }

            @Override
            void setCurrentLocation(int n) {
                SheetTokenHandler.this.setCurrentLocation(n);
            }

            @Override
            public void control(int n, int n2) {
                SheetTokenHandler.this.control(n, n2);
            }

            @Override
            public void tokenStart(TokenControl tokenControl) {
                SheetTokenHandler.this.tokenStart(tokenControl);
            }

            @Override
            TokenControl getTokenControl() {
                return SheetTokenHandler.this.getTokenControl();
            }

            @Override
            void skipDeclarationBlock() {
                SheetTokenHandler.this.contextHandler = new MyIgnoredDeclarationTokenHandler();
            }

            @Override
            public void endOfStream(int n) {
                super.endOfStream(n);
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.endOfStream(n);
            }

            @Override
            protected void endDeclarationList() {
            }

            @Override
            CSSParseException createException(int n, byte by, String string) {
                return SheetTokenHandler.this.createException(n, by, string);
            }
        }

        private class MyDeclarationTokenHandler
        extends DeclarationTokenHandler {
            MyDeclarationTokenHandler() {
                super(ShorthandDatabase.getInstance());
            }

            @Override
            protected void handleRightCurlyBracket(int n) {
                SheetTokenHandler.this.setSelectorHandler(125);
                this.closeRule();
                SheetTokenHandler.this.rulesFound = true;
                this.resetHandler();
            }

            private void closeRule() {
                if (SheetTokenHandler.this.ruleType == 5) {
                    CSSParser.this.handler.endFontFace();
                    if (SheetTokenHandler.this.stage == 10) {
                        if (SheetTokenHandler.this.currentCondition.isMediaCondition()) {
                            SheetTokenHandler.this.ruleType = (byte)4;
                        } else {
                            SheetTokenHandler.this.ruleType = (byte)12;
                        }
                        this.buffer.setLength(0);
                        SheetTokenHandler.this.stage = (byte)2;
                    } else {
                        SheetTokenHandler.this.ruleType = (byte)0;
                        SheetTokenHandler.this.stage = (byte)0;
                    }
                } else {
                    CSSParser.this.handler.endSelector(((SheetTokenHandler)SheetTokenHandler.this).selectorHandler.selist);
                    ((SheetTokenHandler)SheetTokenHandler.this).selectorHandler.selist = new CSSTokenHandler.MySelectorListImpl();
                }
            }

            @Override
            protected void handleAtKeyword(int n) {
                if (this.propertyName == null && this.buffer.length() == 0 && this.getCurlyBracketDepth() == 1 && SheetTokenHandler.this.selectorHandler.getSelectorList().getLength() == 0) {
                    SheetTokenHandler.this.contextHandler = new AtRuleLauncherTH();
                    SheetTokenHandler.this.prevcp = 64;
                    SheetTokenHandler.this.buffer.append('@');
                } else {
                    this.unexpectedCharError(n, 64);
                }
            }

            @Override
            TokenControl getTokenControl() {
                return SheetTokenHandler.this.getTokenControl();
            }

            @Override
            void setCurrentLocation(int n) {
                SheetTokenHandler.this.setCurrentLocation(n);
            }

            @Override
            public void control(int n, int n2) {
                SheetTokenHandler.this.control(n, n2);
            }

            @Override
            public void endOfStream(int n) {
                super.endOfStream(n);
                if (this.curlyBracketDepth > 0) {
                    this.closeRule();
                    --this.curlyBracketDepth;
                    if (SheetTokenHandler.this.curlyBracketDepth == 0 && !this.parseError) {
                        this.handleWarning(n, (byte)10, "Unexpected end of stream");
                    }
                }
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.endOfStream(n);
            }

            @Override
            protected void endDeclarationList() {
            }

            @Override
            CSSParseException createException(int n, byte by, String string) {
                return SheetTokenHandler.this.createException(n, by, string);
            }
        }

        private class MyFontFeatureValuesTH
        extends FontFeatureValuesTH {
            MyFontFeatureValuesTH() {
            }

            @Override
            public void control(int n, int n2) {
                SheetTokenHandler.this.control(n, n2);
            }

            @Override
            TokenControl getTokenControl() {
                return SheetTokenHandler.this.getTokenControl();
            }

            @Override
            void setCurrentLocation(int n) {
                SheetTokenHandler.this.setCurrentLocation(n);
            }

            @Override
            void endBlockList(int n) {
                super.endBlockList(n);
                SheetTokenHandler.this.endRuleBody();
            }

            @Override
            protected void abortRule() {
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.curlyBracketDepth += this.getCurlyBracketDepth();
                SheetTokenHandler.this.parseError = true;
                SheetTokenHandler.this.stage = (byte)127;
            }

            @Override
            public void endOfStream(int n) {
                super.endOfStream(n);
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.endOfStream(n);
            }

            @Override
            CSSParseException createException(int n, byte by, String string) {
                return SheetTokenHandler.this.createException(n, by, string);
            }
        }

        private class MyIgnoredDeclarationTokenHandler
        extends IgnoredDeclarationTokenHandler {
            MyIgnoredDeclarationTokenHandler() {
            }

            @Override
            protected void endDeclarationBlock() {
                SheetTokenHandler.this.setSelectorHandler(125);
            }

            @Override
            public void control(int n, int n2) {
                SheetTokenHandler.this.control(n, n2);
            }

            public void endOfStream(int n) {
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.endOfStream(n);
            }
        }

        private class MyKeyFrameBlockListTH
        extends KeyFrameBlockListTH {
            MyKeyFrameBlockListTH() {
            }

            @Override
            public void control(int n, int n2) {
                SheetTokenHandler.this.control(n, n2);
            }

            @Override
            TokenControl getTokenControl() {
                return SheetTokenHandler.this.getTokenControl();
            }

            @Override
            void setCurrentLocation(int n) {
                SheetTokenHandler.this.setCurrentLocation(n);
            }

            @Override
            void endBlockList(int n) {
                super.endBlockList(n);
                SheetTokenHandler.this.endRuleBody();
            }

            @Override
            protected void abortRule() {
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.curlyBracketDepth += this.getCurlyBracketDepth();
                SheetTokenHandler.this.parseError = true;
                SheetTokenHandler.this.stage = (byte)127;
            }

            @Override
            public void endOfStream(int n) {
                super.endOfStream(n);
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.endOfStream(n);
            }

            @Override
            CSSParseException createException(int n, byte by, String string) {
                return SheetTokenHandler.this.createException(n, by, string);
            }
        }

        private class MyMediaQueryTokenHandler
        extends MediaQueryTokenHandler {
            MyMediaQueryTokenHandler(MediaQueryFactory mediaQueryFactory, MediaQueryHandler mediaQueryHandler) {
                super(mediaQueryFactory, mediaQueryHandler);
                mediaQueryHandler.startQuery();
            }

            @Override
            public void control(int n, int n2) {
                SheetTokenHandler.this.control(n, n2);
            }

            @Override
            void endOfCondition(int n) {
                super.endOfCondition(n);
                MediaQueryList mediaQueryList = this.getPredicateHandler().getMediaQueryHandler().getMediaQueryList();
                SheetTokenHandler.this.currentCondition = new ConditionWrapper(mediaQueryList, SheetTokenHandler.this.currentCondition);
                CSSParser.this.handler.startMedia(SheetTokenHandler.this.currentCondition.getMediaList());
                SheetTokenHandler.this.setSelectorHandler();
            }

            @Override
            void handleLeftCurlyBracket(int n) {
                this.endOfCondition(n);
                SheetTokenHandler.this.curlyBracketDepth++;
            }

            @Override
            public void endOfStream(int n) {
                this.handleError(n, (byte)10, "Unexpected end of stream");
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.endOfStream(n);
            }

            @Override
            CSSParseException createException(int n, byte by, String string) {
                return SheetTokenHandler.this.createException(n, by, string);
            }
        }

        private class MyPageTH
        extends PageTokenHandler {
            MyPageTH() {
            }

            @Override
            public void control(int n, int n2) {
                SheetTokenHandler.this.control(n, n2);
            }

            @Override
            TokenControl getTokenControl() {
                return SheetTokenHandler.this.getTokenControl();
            }

            @Override
            void setCurrentLocation(int n) {
                SheetTokenHandler.this.setCurrentLocation(n);
            }

            @Override
            void endBlockList(int n) {
                super.endBlockList(n);
                SheetTokenHandler.this.endRuleBody();
            }

            @Override
            protected void abortRule() {
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.curlyBracketDepth += this.getCurlyBracketDepth();
                SheetTokenHandler.this.parseError = true;
                SheetTokenHandler.this.stage = (byte)127;
            }

            @Override
            public void endOfStream(int n) {
                super.endOfStream(n);
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.endOfStream(n);
            }

            @Override
            CSSParseException createException(int n, byte by, String string) {
                return SheetTokenHandler.this.createException(n, by, string);
            }
        }

        private class MySelectorTokenHandler
        extends SelectorTokenHandler {
            MySelectorTokenHandler(Parser.NamespaceMap namespaceMap) {
                super(namespaceMap);
            }

            @Override
            public void leftCurlyBracket(int n) {
                ((SheetTokenHandler)SheetTokenHandler.this).declarationHandler.curlyBracketDepth = 1;
                SheetTokenHandler.this.contextHandler = SheetTokenHandler.this.declarationHandler;
                if (!this.parseError) {
                    SheetTokenHandler.this.selectorHandler.processBuffer(n, 123, true);
                    if (!this.parseError) {
                        if (this.addCurrentSelector(n)) {
                            this.selist.trimToSize();
                            CSSParser.this.handler.startSelector(this.selist);
                        } else {
                            this.unexpectedCharError(n, 123);
                        }
                    }
                }
                this.stage = 0;
                if (this.parseError) {
                    this.buffer.setLength(0);
                    this.ignoreRule();
                }
            }

            private void ignoreRule() {
                this.selist.clear();
                this.currentsel = null;
                SheetTokenHandler.this.contextHandler = new MyIgnoredDeclarationTokenHandler();
            }

            @Override
            public void rightCurlyBracket(int n) {
                if (SheetTokenHandler.this.stage == 2) {
                    byte by = SheetTokenHandler.this.ruleType;
                    if (by == 4) {
                        CSSParser.this.handler.endMedia(SheetTokenHandler.this.currentCondition.getMediaList());
                        SheetTokenHandler.this.currentCondition = SheetTokenHandler.this.currentCondition.getParent();
                        if (SheetTokenHandler.this.currentCondition == null) {
                            this.resetSelectorHandler(true);
                        } else {
                            if (!SheetTokenHandler.this.currentCondition.isMediaCondition()) {
                                SheetTokenHandler.this.ruleType = (byte)12;
                            }
                            this.resetSelectorHandler(false);
                        }
                        return;
                    }
                    if (by == 12) {
                        CSSParser.this.handler.endSupports(SheetTokenHandler.this.currentCondition.getCondition());
                        SheetTokenHandler.this.currentCondition = SheetTokenHandler.this.currentCondition.getParent();
                        if (SheetTokenHandler.this.currentCondition == null) {
                            this.resetSelectorHandler(true);
                        } else {
                            if (SheetTokenHandler.this.currentCondition.isMediaCondition()) {
                                SheetTokenHandler.this.ruleType = (byte)4;
                            }
                            this.resetSelectorHandler(false);
                        }
                        return;
                    }
                    if (SheetTokenHandler.this.curlyBracketDepth == 0) {
                        this.resetSelectorHandler(true);
                        return;
                    }
                }
                this.handleError(n, (byte)4, "Unexpected '}'");
                if (SheetTokenHandler.this.curlyBracketDepth <= 0) {
                    this.resetSelectorHandler(true);
                    SheetTokenHandler.this.curlyBracketDepth = 0;
                }
            }

            private void resetSelectorHandler(boolean bl) {
                this.resetHandler();
                SheetTokenHandler.this.contextHandler = SheetTokenHandler.this.selectorHandler;
                SheetTokenHandler.this.curlyBracketDepth--;
                if (bl) {
                    SheetTokenHandler.this.ruleType = (byte)0;
                    SheetTokenHandler.this.stage = (byte)0;
                }
            }

            @Override
            boolean skipCharacterHandling() {
                return this.parseError && (this.prevcp != 59 || SheetTokenHandler.this.curlyBracketDepth != 0);
            }

            @Override
            protected void handleAtKeyword(int n) {
                if (this.prevcp == 59) {
                    this.parseError = false;
                    this.stage = 0;
                } else if (this.stage > 0) {
                    int n2 = this.buffer.length();
                    if (n2 != 0) {
                        int n3 = this.buffer.codePointAt(0);
                        String string = Character.isAlphabetic(n3) ? "Unknown token: " + this.buffer.toString() : "Unknown token starting with code point U+" + Integer.toHexString(n3);
                        this.handleError(n - n2, (byte)9, string);
                    } else {
                        this.unexpectedCharError(n, 64);
                    }
                    return;
                }
                SheetTokenHandler.this.contextHandler = new AtRuleLauncherTH();
                SheetTokenHandler.this.prevcp = 64;
                SheetTokenHandler.this.buffer.append('@');
            }

            @Override
            boolean isTopLevel() {
                return SheetTokenHandler.this.topLevel;
            }

            @Override
            TokenControl getTokenControl() {
                return SheetTokenHandler.this.getTokenControl();
            }

            @Override
            void setCurrentLocation(int n) {
                SheetTokenHandler.this.setCurrentLocation(n);
            }

            @Override
            public void control(int n, int n2) {
                SheetTokenHandler.this.control(n, n2);
            }

            @Override
            public void endOfStream(int n) {
                if (this.stage != 0) {
                    this.handleError(n, (byte)10, "Unexpected end of stream");
                }
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.endOfStream(n);
            }

            @Override
            protected void handleError(int n, byte by, String string) {
                this.stage = (byte)127;
                if (!this.parseError) {
                    CSSParseException cSSParseException = this.prevcp == this.endcp ? this.createException(n, by, "Expected end of file") : this.createException(n, by, string);
                    this.handleError(cSSParseException);
                }
                this.selist.clear();
                this.buffer.setLength(0);
            }

            @Override
            CSSParseException createException(int n, byte by, String string) {
                return SheetTokenHandler.this.createException(n, by, string);
            }
        }

        private class MySupportsTokenHandler
        extends SupportsTokenHandler {
            MySupportsTokenHandler() {
                super(null, (SheetContext)((Object)CSSParser.this.handler.getStyleSheet()));
            }

            @Override
            void setCurrentLocation(int n) {
                SheetTokenHandler.this.setCurrentLocation(n);
            }

            @Override
            public void control(int n, int n2) {
                SheetTokenHandler.this.control(n, n2);
            }

            @Override
            void endOfCondition(int n) {
                super.endOfCondition(n);
                BooleanCondition booleanCondition = this.getCondition();
                SheetTokenHandler.this.currentCondition = new ConditionWrapper(booleanCondition, SheetTokenHandler.this.currentCondition);
                CSSParser.this.handler.startSupports(booleanCondition);
                SheetTokenHandler.this.setSelectorHandler();
            }

            @Override
            void handleLeftCurlyBracket(int n) {
                this.endOfCondition(n);
                SheetTokenHandler.this.curlyBracketDepth++;
            }

            @Override
            public void endOfStream(int n) {
                this.handleError(n, (byte)10, "Unexpected end of stream");
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.endOfStream(n);
            }

            @Override
            CSSParseException createException(int n, byte by, String string) {
                return SheetTokenHandler.this.createException(n, by, string);
            }
        }

        private class PropertyRuleTokenHandler
        extends MyDeclarationRuleTokenHandler {
            private CSSValueSyntax syntax;
            private boolean isUniversalSyntax;
            private boolean hasInherits;
            private LexicalUnit initialValue;

            private PropertyRuleTokenHandler() {
                super(ShorthandDatabase.getInstance());
                this.syntax = null;
                this.initialValue = null;
                this.setRuleName("property");
                this.setStage((byte)2);
            }

            @Override
            protected void startAtRule(int n, String string, String string2) {
                if (string2 == null) {
                    this.handleError(n, (byte)33, "Null name in @property rule.");
                    this.setStage((byte)127);
                } else {
                    try {
                        string2 = ParseHelper.parseIdent(string2);
                    }
                    catch (DOMException dOMException) {
                        this.handleError(n, (byte)33, "Bad name in @property rule: " + string2, dOMException);
                        this.setStage((byte)127);
                        return;
                    }
                    CSSParser.this.handler.startProperty(string2);
                }
            }

            @Override
            protected void handleProperty(int n, String string, LexicalUnitImpl lexicalUnitImpl, boolean bl) {
                if ("syntax".equalsIgnoreCase(string)) {
                    if (lexicalUnitImpl.getLexicalUnitType() != LexicalUnit.LexicalType.STRING) {
                        this.handleError(n, (byte)33, "'syntax' descriptor in @property rule must be a string.");
                        return;
                    }
                    String string2 = lexicalUnitImpl.getStringValue().trim();
                    SyntaxParser syntaxParser = new SyntaxParser();
                    try {
                        this.syntax = syntaxParser.parseSyntax(string2);
                    }
                    catch (CSSException cSSException) {
                        this.handleError(n, (byte)33, "Wrong 'syntax' descriptor in @property rule: '" + string2 + '\'');
                        return;
                    }
                    this.isUniversalSyntax = this.syntax.getCategory() == CSSValueSyntax.Category.universal;
                } else if ("inherits".equalsIgnoreCase(string)) {
                    String string3;
                    if (lexicalUnitImpl.getLexicalUnitType() != LexicalUnit.LexicalType.IDENT || !"true".equals(string3 = lexicalUnitImpl.getStringValue().toLowerCase(Locale.ROOT)) && !"false".equals(string3)) {
                        this.handleError(n, (byte)33, "'inherits' descriptor in @property rule must be either 'true' or 'false'.");
                        return;
                    }
                    this.hasInherits = true;
                } else if ("initial-value".equalsIgnoreCase(string)) {
                    this.handleLexicalProperty(n, string, lexicalUnitImpl, bl);
                    this.initialValue = lexicalUnitImpl;
                    return;
                }
                super.handleProperty(n, string, lexicalUnitImpl, bl);
            }

            @Override
            protected void endAtRule(int n) {
                if (this.syntax == null) {
                    this.handleError(n, (byte)33, "@property rule lacks mandatory 'syntax' descriptor.");
                    CSSParser.this.handler.endProperty(true);
                } else if (!this.hasInherits) {
                    this.handleError(n, (byte)33, "@property rule lacks mandatory 'inherits' descriptor.");
                    CSSParser.this.handler.endProperty(true);
                } else if (!this.isUniversalSyntax && (this.initialValue == null || this.initialValue.matches(this.syntax) != CSSValueSyntax.Match.TRUE || this.initialValue.getLexicalUnitType() == LexicalUnit.LexicalType.DIMENSION && CSSUnit.isRelativeLengthUnitType(this.initialValue.getCssUnit()))) {
                    this.handleError(n, (byte)33, "@property rule lacks a valid 'initial-value' descriptor.");
                    CSSParser.this.handler.endProperty(true);
                } else {
                    CSSParser.this.handler.endProperty(false);
                }
                SheetTokenHandler.this.endRuleBody();
            }
        }

        private class ViewportTokenHandler
        extends MyDeclarationRuleTokenHandler {
            private ViewportTokenHandler() {
                super(ShorthandDatabase.getInstance());
                this.setRuleName("viewport");
                this.setStage((byte)2);
            }

            @Override
            protected void startAtRule(int n, String string, String string2) {
                if (string2 == null) {
                    CSSParser.this.handler.startViewport();
                } else {
                    this.handleError(n, (byte)9, "Unexpected token after @viewport: " + string2);
                    this.setStage((byte)127);
                }
            }

            @Override
            protected void endAtRule(int n) {
                CSSParser.this.handler.endViewport();
                SheetTokenHandler.this.endRuleBody();
            }
        }
    }

    private class SupportsTokenHandler
    extends ConditionTokenHandler<SupportsConditionFactory> {
        private byte errorCode;
        private CSSParseException errorException;
        private final CSSRule rule;

        SupportsTokenHandler(CSSRule cSSRule, SheetContext sheetContext) {
            super(CSSParser.this, (BooleanConditionFactory)CSSParser.this.createSupportsConditionFactory(sheetContext));
            this.errorCode = 0;
            this.errorException = null;
            this.rule = cSSRule;
            this.setPredicateHandler(new SupportsDelegateHandler());
        }

        BooleanCondition getCondition() {
            BooleanCondition booleanCondition = this.currentCond;
            if (booleanCondition != null) {
                while (booleanCondition.getParentCondition() != null) {
                    booleanCondition = booleanCondition.getParentCondition();
                }
            }
            return booleanCondition;
        }

        @Override
        protected void handleError(int n, byte by, String string) {
            if (!this.parseError) {
                if (this.errorCode == 0) {
                    this.errorCode = by;
                    this.errorException = this.createException(n, by, string);
                    this.handleError(this.errorException);
                }
                this.parseError = true;
            }
        }

        @Override
        protected void handleError(int n, byte by, String string, Throwable throwable) {
            if (!this.parseError) {
                if (this.errorCode == 0) {
                    this.errorCode = by;
                    this.errorException = this.createException(n, by, string);
                    this.errorException.initCause(throwable);
                    this.handleError(this.errorException);
                }
                this.parseError = true;
            }
        }

        @Override
        protected void handleError(CSSParseException cSSParseException) throws CSSParseException {
            if (this.rule != null) {
                this.rule.getParentStyleSheet().getErrorHandler().ruleParseError(this.rule, this.errorException);
                this.parseError = true;
            } else {
                super.handleError(cSSParseException);
            }
        }

        @Override
        void resetHandler() {
            super.resetHandler();
            this.errorCode = 0;
        }

        private class SupportsDelegateHandler
        extends DelegateHandler {
            private boolean readingValue = false;
            private boolean functionToken = false;
            private short valueParendepth;

            SupportsDelegateHandler() {
            }

            @Override
            boolean isAllowedTopLevel() {
                return this.functionToken;
            }

            public void word(int n, CharSequence charSequence) {
                if (SupportsTokenHandler.this.buffer.length() != 0) {
                    if (!this.readingValue && !this.functionToken) {
                        SupportsTokenHandler.this.unexpectedTokenError(n, charSequence);
                        return;
                    }
                    if (SupportsTokenHandler.this.isPrevCpWhitespace()) {
                        SupportsTokenHandler.this.buffer.append(' ');
                    }
                }
                SupportsTokenHandler.this.buffer.append(charSequence);
            }

            public void leftParenthesis(int n) {
                if (this.readingValue || this.functionToken) {
                    SupportsTokenHandler.this.buffer.append('(');
                } else if (SupportsTokenHandler.this.buffer.length() != 0) {
                    if (!SupportsTokenHandler.this.isPrevCpWhitespace()) {
                        String string = SupportsTokenHandler.this.buffer.toString();
                        SupportsTokenHandler.this.buffer.setLength(0);
                        if (!"selector".equalsIgnoreCase(string)) {
                            SupportsTokenHandler.this.unexpectedTokenError(n, "Unknown function: " + string);
                            return;
                        }
                        this.functionToken = true;
                        this.valueParendepth = SupportsTokenHandler.this.getCurrentParenDepth();
                        this.valueParendepth = (short)(this.valueParendepth - 1);
                    } else {
                        SupportsTokenHandler.this.unexpectedCharError(n, 40);
                    }
                }
                SupportsTokenHandler.this.prevcp = 40;
            }

            public void leftSquareBracket(int n) {
                if (this.readingValue || this.functionToken) {
                    SupportsTokenHandler.this.buffer.append('[');
                } else {
                    SupportsTokenHandler.this.unexpectedCharError(n, 91);
                }
            }

            public void leftCurlyBracket(int n) {
                SupportsTokenHandler.this.handleLeftCurlyBracket(n);
            }

            public void rightParenthesis(int n) {
                if (this.readingValue) {
                    if (this.valueParendepth == SupportsTokenHandler.this.getCurrentParenDepth()) {
                        String string = SupportsTokenHandler.this.buffer.toString();
                        SupportsTokenHandler.this.buffer.setLength(0);
                        if (!string.isEmpty()) {
                            this.setDeclarationPredicate(n, string);
                        } else {
                            SupportsTokenHandler.this.unexpectedCharError(n, 41);
                        }
                        this.readingValue = false;
                        SupportsTokenHandler.this.readingPredicate = false;
                        SupportsTokenHandler.this.escapedTokenIndex = -1;
                    } else {
                        SupportsTokenHandler.this.buffer.append(')');
                    }
                } else if (this.functionToken) {
                    if (this.valueParendepth == SupportsTokenHandler.this.getCurrentParenDepth()) {
                        BooleanCondition booleanCondition;
                        this.functionToken = false;
                        SupportsTokenHandler.this.readingPredicate = false;
                        SupportsTokenHandler.this.escapedTokenIndex = -1;
                        SupportsTokenHandler.this.prevcp = 41;
                        String string = SupportsTokenHandler.this.buffer.toString();
                        SupportsTokenHandler.this.buffer.setLength(0);
                        try {
                            SelectorList selectorList = CSSParser.this.parseSelectors(string);
                            if (!SupportsTokenHandler.this.parseError) {
                                booleanCondition = ((SupportsConditionFactory)SupportsTokenHandler.this.conditionFactory).createSelectorFunction(selectorList);
                            } else {
                                booleanCondition = ((SupportsConditionFactory)SupportsTokenHandler.this.conditionFactory).createFalseCondition("selector(" + string + ')');
                                SupportsTokenHandler.this.parseError = false;
                            }
                        }
                        catch (CSSBudgetException cSSBudgetException) {
                            SupportsTokenHandler.this.handleError(n, (byte)127, "Hit a limit while parsing @supports condition selector.", cSSBudgetException);
                            booleanCondition = ((SupportsConditionFactory)SupportsTokenHandler.this.conditionFactory).createFalseCondition("selector(" + string + ')');
                        }
                        catch (CSSException cSSException) {
                            SupportsTokenHandler.this.handleWarning(n, (byte)127, "Unkown selector in @supports condition.", cSSException);
                            booleanCondition = ((SupportsConditionFactory)SupportsTokenHandler.this.conditionFactory).createFalseCondition("selector(" + string + ')');
                        }
                        if (SupportsTokenHandler.this.currentCond != null) {
                            SupportsTokenHandler.this.currentCond.addCondition(booleanCondition);
                        }
                        SupportsTokenHandler.this.currentCond = booleanCondition;
                    } else {
                        SupportsTokenHandler.this.buffer.append(')');
                    }
                } else {
                    SupportsTokenHandler.this.unexpectedCharError(n, 41);
                }
            }

            private void setDeclarationPredicate(int n, String string) {
                LexicalUnit lexicalUnit;
                String string2 = ((DeclarationPredicate)SupportsTokenHandler.this.currentCond).getName();
                CSSParser cSSParser = new CSSParser(CSSParser.this.parserFlags);
                StringReader stringReader = new StringReader(string);
                try {
                    lexicalUnit = cSSParser.parsePropertyValue(string2, stringReader);
                }
                catch (Exception exception) {
                    this.warnAndSetFalseCondition(n, string2, string, exception);
                    return;
                }
                try {
                    ((DeclarationPredicate)SupportsTokenHandler.this.currentCond).setValue(lexicalUnit);
                }
                catch (Exception exception) {
                    this.warnAndSetFalseCondition(n, string2, string, exception);
                }
            }

            private void warnAndSetFalseCondition(int n, String string, String string2, Exception exception) {
                SupportsTokenHandler.this.handleWarning(n, (byte)-5, "Bad @supports condition value.", exception);
                StringBuilder stringBuilder = new StringBuilder(32);
                stringBuilder.append('(').append(string).append(':').append(string2).append(')');
                BooleanCondition booleanCondition = ((SupportsConditionFactory)SupportsTokenHandler.this.conditionFactory).createFalseCondition(stringBuilder.toString());
                booleanCondition.setParentCondition(SupportsTokenHandler.this.currentCond.getParentCondition());
                SupportsTokenHandler.this.currentCond = booleanCondition;
            }

            public void rightSquareBracket(int n) {
                if (this.readingValue || this.functionToken) {
                    SupportsTokenHandler.this.buffer.append(']');
                } else {
                    SupportsTokenHandler.this.unexpectedCharError(n, 93);
                }
            }

            public void rightCurlyBracket(int n) {
                if (this.readingValue) {
                    SupportsTokenHandler.this.buffer.append('}');
                } else {
                    SupportsTokenHandler.this.unexpectedCharError(n, 125);
                }
            }

            public void character(int n, int n2) {
                if (this.readingValue) {
                    if (n2 == 59) {
                        SupportsTokenHandler.this.unexpectedCharError(n, n2);
                    } else {
                        SupportsTokenHandler.this.bufferAppend(n2);
                    }
                } else if (this.functionToken) {
                    SupportsTokenHandler.this.bufferAppend(n2);
                } else if (n2 == 58 && SupportsTokenHandler.this.getCurrentParenDepth() > 0) {
                    BooleanCondition booleanCondition = ((SupportsConditionFactory)SupportsTokenHandler.this.conditionFactory).createPredicate(SupportsTokenHandler.this.buffer.toString());
                    if (SupportsTokenHandler.this.currentCond != null) {
                        SupportsTokenHandler.this.currentCond.addCondition(booleanCondition);
                    }
                    SupportsTokenHandler.this.currentCond = booleanCondition;
                    SupportsTokenHandler.this.buffer.setLength(0);
                    this.valueParendepth = SupportsTokenHandler.this.getCurrentParenDepth();
                    this.valueParendepth = (short)(this.valueParendepth - 1);
                    this.readingValue = true;
                    SupportsTokenHandler.this.escapedTokenIndex = -1;
                } else {
                    SupportsTokenHandler.this.unexpectedCharError(n, n2);
                }
                SupportsTokenHandler.this.prevcp = n2;
            }

            public void quoted(int n, CharSequence charSequence, int n2) {
                if (this.readingValue || this.functionToken) {
                    if (SupportsTokenHandler.this.buffer.length() != 0) {
                        SupportsTokenHandler.this.buffer.append(' ');
                    }
                    char c = (char)n2;
                    SupportsTokenHandler.this.buffer.append(c).append(charSequence).append(c);
                    SupportsTokenHandler.this.prevcp = 65;
                } else {
                    SupportsTokenHandler.this.handleError(n, (byte)9, "Unexpected: '" + charSequence + '\'');
                }
            }

            public void escaped(int n, int n2) {
                if (ParseHelper.isHexCodePoint(n2) || n2 == 92) {
                    SupportsTokenHandler.this.setEscapedTokenStart(n);
                    SupportsTokenHandler.this.buffer.append('\\');
                }
                SupportsTokenHandler.this.bufferAppend(n2);
            }

            public void separator(int n, int n2) {
                if (SupportsTokenHandler.this.escapedTokenIndex != -1 && CSSParser.bufferEndsWithEscapedCharOrWS(SupportsTokenHandler.this.buffer)) {
                    SupportsTokenHandler.this.buffer.append(' ');
                }
            }

            public void endOfStream(int n) {
                if (SupportsTokenHandler.this.readingPredicate) {
                    SupportsTokenHandler.this.handleError(n, (byte)10, "Unexpected end of file");
                } else if (SupportsTokenHandler.this.buffer.length() != 0) {
                    SupportsTokenHandler.this.handleError(n, (byte)9, "Unexpected token: " + SupportsTokenHandler.this.buffer);
                } else if (SupportsTokenHandler.this.currentCond == null) {
                    SupportsTokenHandler.this.handleError(n, (byte)10, "No condition found");
                }
            }
        }
    }
}

