/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.crypto;

import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import docking.widgets.OptionDialog;
import docking.widgets.tree.GTreeNode;
import ghidra.file.crypto.CryptoKeyFileTemplateWriter;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.plugins.fsbrowser.FSBActionContext;
import ghidra.plugins.fsbrowser.FSBFileHandler;
import ghidra.plugins.fsbrowser.FSBFileHandlerContext;
import ghidra.plugins.fsbrowser.FSBFileNode;
import ghidra.plugins.fsbrowser.FSBNode;
import ghidra.plugins.fsbrowser.FSBRootNode;
import java.io.IOException;
import java.util.List;

public class CryptoKeysFSBFileHandler
implements FSBFileHandler {
    private FSBFileHandlerContext context;

    public void init(FSBFileHandlerContext context) {
        this.context = context;
    }

    public List<DockingAction> createActions() {
        return List.of((DockingAction)new ActionBuilder("FSB Create Crypto Key Template", this.context.plugin().getName()).withContext(FSBActionContext.class).enabledWhen(ac -> ac.notBusy() && ac.getSelectedNode() instanceof FSBRootNode && ac.getFSRL(true) != null).popupMenuPath(new String[]{"Create Crypto Key Template..."}).popupMenuGroup("Z", "B").onAction(ac -> {
            FSRL fsrl = ac.getFSRL(true);
            FSBNode patt0$temp = ac.getSelectedNode();
            if (patt0$temp instanceof FSBRootNode) {
                FSBRootNode rootNode = (FSBRootNode)patt0$temp;
                if (fsrl != null) {
                    this.createCryptoTemplate(fsrl, rootNode);
                }
            }
        }).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCryptoTemplate(FSRL fsrl, FSBRootNode node) {
        try {
            int answer;
            String fsContainerName = fsrl.getFS().getContainer().getName();
            CryptoKeyFileTemplateWriter writer = new CryptoKeyFileTemplateWriter(fsContainerName);
            if (writer.exists() && (answer = OptionDialog.showYesNoDialog(null, (String)"WARNING!! Crypto Key File Already Exists", (String)"WARNING!!\nThe crypto key file already exists. Are you really sure that you want to overwrite it?")) == 2) {
                return;
            }
            writer.open();
            try {
                this.writeFile(writer, node.getChildren());
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            FSUtilities.displayException((Object)this, null, (String)"Error writing crypt key file", (String)e.getMessage(), (Throwable)e);
        }
    }

    private void writeFile(CryptoKeyFileTemplateWriter writer, List<GTreeNode> children) throws IOException {
        if (children == null || children.isEmpty()) {
            return;
        }
        for (GTreeNode child : children) {
            if (child instanceof FSBFileNode) {
                FSBFileNode fileNode = (FSBFileNode)child;
                FSRL childFSRL = fileNode.getFSRL();
                writer.write(childFSRL.getName());
                continue;
            }
            this.writeFile(writer, child.getChildren());
        }
    }
}

