/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.fieldpanel.field.Field;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.TokenIterator;
import ghidra.app.decompiler.component.ClangTextField;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.decompiler.component.HighlightToken;
import ghidra.app.decompiler.component.TokenHighlights;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.util.HelpLocation;
import java.util.List;

public class NextHighlightedTokenAction
extends AbstractDecompilerAction {
    public NextHighlightedTokenAction() {
        super("Next Highlighted Token");
        this.setPopupMenuData(new MenuData(new String[]{"Next Highlight"}, "Decompile"));
        this.setKeyBindingData(new KeyBindingData("Ctrl period"));
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "GoToMiddleMouseHighlight"));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        if (!context.hasRealFunction()) {
            return false;
        }
        DecompilerPanel panel = context.getDecompilerPanel();
        TokenHighlights highlights = panel.getMiddleMouseHighlights();
        if (highlights != null) {
            return highlights.size() > 1;
        }
        return false;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        DecompilerPanel panel = context.getDecompilerPanel();
        TokenHighlights highlights = panel.getMiddleMouseHighlights();
        ClangToken cursorToken = context.getTokenAtCursor();
        TokenIterator it = new TokenIterator(cursorToken, true);
        it.next();
        if (this.goToNexToken(panel, it, highlights)) {
            return;
        }
        ClangToken firstToken = this.getFirstToken(panel);
        it = new TokenIterator(firstToken, true);
        this.goToNexToken(panel, it, highlights);
    }

    private ClangToken getFirstToken(DecompilerPanel panel) {
        List<Field> fields = panel.getFields();
        Field line = fields.get(0);
        ClangTextField tf = (ClangTextField)line;
        return tf.getFirstToken();
    }

    private boolean goToNexToken(DecompilerPanel panel, TokenIterator it, TokenHighlights highlights) {
        while (it.hasNext()) {
            ClangToken nextToken = it.next();
            HighlightToken hlToken = highlights.get(nextToken);
            if (hlToken == null) continue;
            ClangToken token = hlToken.getToken();
            panel.goToToken(token);
            return true;
        }
        return false;
    }
}

