/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.util.HelpLocation;

public class CloseVersionTrackingSessionAction
extends DockingAction {
    private final VTController controller;

    public CloseVersionTrackingSessionAction(VTController controller) {
        super("Close Session", VTPlugin.OWNER);
        this.controller = controller;
        String[] menuPath = new String[]{"&File", "Close Session..."};
        this.setMenuBarData(new MenuData(menuPath, "AAB"));
        this.setDescription("Closes the current Version Tracking Session");
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Version_Tracking_Tool"));
    }

    public void actionPerformed(ActionContext context) {
        this.controller.closeVersionTrackingSession();
    }

    public boolean isEnabledForContext(ActionContext context) {
        return this.controller.getSession() != null;
    }
}

