/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh;

import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.PcodeEmit;
import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.app.plugin.processors.sleigh.VarnodeData;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.InstructionContext;
import ghidra.program.model.pcode.AddressXML;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.PatchEncoder;
import ghidra.program.model.pcode.PcodeOverride;
import java.io.IOException;
import java.util.ArrayList;

public class PcodeEmitPacked
extends PcodeEmit {
    private PatchEncoder encoder;
    private ArrayList<LabelRef> labelref = null;
    private boolean hasRelativePatch = false;

    public PcodeEmitPacked(PatchEncoder encoder, ParserWalker walk, InstructionContext ictx, int fallOffset, PcodeOverride override) {
        super(walk, ictx, fallOffset, override);
        this.encoder = encoder;
    }

    public void emitHeader() throws IOException {
        this.encoder.openElement(ElementId.ELEM_INST);
        this.encoder.writeSignedInteger(AttributeId.ATTRIB_OFFSET, this.getFallOffset());
        AddressXML.encode(this.encoder, this.getStartAddress());
    }

    public void emitTail() throws IOException {
        this.encoder.closeElement(ElementId.ELEM_INST);
    }

    @Override
    public void resolveRelatives() {
        if (this.labelref == null) {
            return;
        }
        for (LabelRef ref : this.labelref) {
            if (ref.labelIndex >= this.labeldef.size() || this.labeldef.get(ref.labelIndex) == null) {
                throw new SleighException("Reference to non-existant sleigh label");
            }
            long res = (long)((Integer)this.labeldef.get(ref.labelIndex)).intValue() - (long)ref.opIndex;
            if (ref.labelSize < 8) {
                long mask = -1L;
                res &= (mask >>>= (8 - ref.labelSize) * 8);
            }
            if (this.encoder.patchIntegerAttribute(ref.streampos, AttributeId.ATTRIB_OFFSET, res)) continue;
            throw new SleighException("PcodeEmitPacked: Unable to patch relative offset");
        }
    }

    @Override
    void addLabelRef() {
        if (this.labelref == null) {
            this.labelref = new ArrayList();
        }
        this.hasRelativePatch = true;
    }

    private void addLabelRefDelayed() {
        int labelIndex = (int)this.incache[0].offset;
        int labelSize = this.incache[0].size;
        this.incache[0].offset = -1L;
        this.labelref.add(new LabelRef(this, this.numOps, labelIndex, labelSize, this.encoder.size()));
        this.hasRelativePatch = false;
    }

    @Override
    void dump(Address instrAddr, int opcode, VarnodeData[] in, int isize, VarnodeData out) throws IOException {
        int updatedOpcode = this.checkOverrides(opcode, in);
        if (opcode == 9 && updatedOpcode == 7) {
            isize = 1;
        }
        this.encoder.openElement(ElementId.ELEM_OP);
        this.encoder.writeSignedInteger(AttributeId.ATTRIB_CODE, updatedOpcode);
        this.encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, isize);
        if (out == null) {
            this.encoder.openElement(ElementId.ELEM_VOID);
            this.encoder.closeElement(ElementId.ELEM_VOID);
        } else {
            out.encode(this.encoder);
        }
        int i = 0;
        if (updatedOpcode == 2 || updatedOpcode == 3) {
            this.dumpSpaceId(in[0]);
            i = 1;
        } else if (this.hasRelativePatch) {
            this.addLabelRefDelayed();
        }
        while (i < isize) {
            in[i].encode(this.encoder);
            ++i;
        }
        this.encoder.closeElement(ElementId.ELEM_OP);
    }

    private void dumpSpaceId(VarnodeData v) throws IOException {
        this.encoder.openElement(ElementId.ELEM_SPACEID);
        this.encoder.writeSpaceId(AttributeId.ATTRIB_NAME, v.offset);
        this.encoder.closeElement(ElementId.ELEM_SPACEID);
    }

    public class LabelRef {
        public int opIndex;
        public int labelIndex;
        public int labelSize;
        public int streampos;

        public LabelRef(PcodeEmitPacked this$0, int op, int lab, int size, int stream) {
            this.opIndex = op;
            this.labelIndex = lab;
            this.labelSize = size;
            this.streampos = stream;
        }
    }
}

