/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.CompositeInternal;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataOrganizationImpl;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Union;

public class CompositeAlignmentHelper {
    private static int getCompositeAlignmentMultiple(DataOrganization dataOrganization, CompositeInternal composite) {
        DataTypeComponent[] dataTypeComponents;
        int allComponentsLCM = 1;
        int packingValue = composite.getStoredPackingValue();
        for (DataTypeComponent dataTypeComponent : dataTypeComponents = composite.getDefinedComponents()) {
            int impartedAlignment = CompositeAlignmentHelper.getPackedAlignment(dataOrganization, packingValue, dataTypeComponent);
            if (impartedAlignment == 0) continue;
            allComponentsLCM = DataOrganizationImpl.getLeastCommonMultiple(allComponentsLCM, impartedAlignment);
        }
        return allComponentsLCM;
    }

    public static int getPackedAlignment(DataOrganization dataOrganization, int packingValue, DataTypeComponent component) {
        if (component.isZeroBitFieldComponent() && component.getParent() instanceof Union && !dataOrganization.getBitFieldPacking().useMSConvention()) {
            return 0;
        }
        DataType componentDt = component.getDataType();
        return CompositeAlignmentHelper.getPackedAlignment(componentDt.getAlignment(), packingValue);
    }

    static int getPackedAlignment(int componentAlignment, int packingValue) {
        int alignment = componentAlignment;
        if (packingValue > 0 && packingValue < componentAlignment) {
            alignment = packingValue;
        }
        return alignment;
    }

    public static int getAlignment(DataOrganization dataOrganization, CompositeInternal composite) {
        int absoluteMaxAlignment;
        int minimumAlignment = composite.getStoredMinimumAlignment();
        if (minimumAlignment < 0) {
            minimumAlignment = dataOrganization.getMachineAlignment();
        }
        if (!composite.isPackingEnabled()) {
            return minimumAlignment == 0 ? 1 : minimumAlignment;
        }
        int lcm = CompositeAlignmentHelper.getCompositeAlignmentMultiple(dataOrganization, composite);
        if (minimumAlignment != 0 && lcm % minimumAlignment != 0) {
            lcm = DataOrganizationImpl.getLeastCommonMultiple(lcm, minimumAlignment);
        }
        return (absoluteMaxAlignment = dataOrganization.getAbsoluteMaxAlignment()) == 0 || lcm < absoluteMaxAlignment ? lcm : absoluteMaxAlignment;
    }
}

