/*
 * Decompiled with CFR 0.152.
 */
package functioncalls.graph;

import functioncalls.graph.FcgDirection;

public class FcgLevel
implements Comparable<FcgLevel> {
    private int row;
    private FcgDirection direction;

    public static FcgLevel sourceLevel() {
        return new FcgLevel(0, FcgDirection.IN_AND_OUT);
    }

    public FcgLevel(int distance, FcgDirection direction) {
        this.row = this.toRow(distance);
        this.direction = direction;
        if (this.row == 0) {
            throw new IllegalArgumentException("The FcgLevel uses a 1-based row system");
        }
        if (this.row == 1 && direction != FcgDirection.IN_AND_OUT) {
            throw new IllegalArgumentException("Row 1 must be FcgDirection.IN_AND_OUT");
        }
    }

    private int toRow(int distance) {
        int oneBased = distance + 1;
        return this.direction == FcgDirection.OUT ? -oneBased : oneBased;
    }

    public int getRow() {
        return this.row;
    }

    public int getDistance() {
        return Math.abs(this.row) - 1;
    }

    public FcgDirection getDirection() {
        return this.direction;
    }

    public boolean isSource() {
        return this.direction.isSource();
    }

    public FcgLevel parent() {
        if (this.direction == FcgDirection.IN_AND_OUT) {
            throw new IllegalArgumentException("To get the parent of the source level you must use the constructor directly");
        }
        int newDistance = this.getDistance() - 1;
        FcgDirection newDirection = this.direction;
        if (newDistance == 0) {
            newDirection = FcgDirection.IN_AND_OUT;
        }
        return new FcgLevel(newDistance, newDirection);
    }

    public FcgLevel child() {
        if (this.direction == FcgDirection.IN_AND_OUT) {
            throw new IllegalArgumentException("To get the child of the source level you must use the constructor directly");
        }
        return this.child(this.direction);
    }

    public boolean isParentOf(FcgLevel other) {
        if (this.isSource()) {
            return other.getDistance() == 1;
        }
        if (this.direction != other.direction) {
            return false;
        }
        return other.getDistance() - this.getDistance() == 1;
    }

    public boolean isChildOf(FcgLevel other) {
        return other.isParentOf(this);
    }

    public FcgLevel child(FcgDirection newDirection) {
        if (newDirection == FcgDirection.IN_AND_OUT) {
            throw new IllegalArgumentException("Direction cannot be IN_AND_OUT");
        }
        int newDistance = this.getDistance() + 1;
        return new FcgLevel(newDistance, newDirection);
    }

    public String toString() {
        return String.valueOf((Object)this.direction) + " - row " + Integer.toString(this.getRelativeRow());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.direction == null ? 0 : this.direction.hashCode());
        result = 31 * result + this.row;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FcgLevel other = (FcgLevel)obj;
        if (this.direction != other.direction) {
            return false;
        }
        return this.row == other.row;
    }

    private int getRelativeRow() {
        return this.direction == FcgDirection.OUT ? -this.row : this.row;
    }

    @Override
    public int compareTo(FcgLevel l2) {
        int result = this.getDirection().compareTo(l2.getDirection());
        if (result != 0) {
            return result;
        }
        return -(this.getRelativeRow() - l2.getRelativeRow());
    }
}

