/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;

public class CreateMultipleFunctionsCmd
extends BackgroundCommand<Program> {
    private AddressSetView selection;
    private SourceType source;

    public CreateMultipleFunctionsCmd(AddressSetView selection, SourceType source) {
        super("Create Multiple Functions", true, true, false);
        this.selection = selection;
        this.source = source;
    }

    public boolean applyTo(Program program, TaskMonitor monitor) {
        Listing listing = program.getListing();
        AddressSet addressSet = new AddressSet(this.selection);
        Address address = addressSet.getMinAddress();
        int functionsCreated = 0;
        long numInitialAddresses = addressSet.getNumAddresses();
        monitor.initialize(numInitialAddresses);
        monitor.setMessage("Creating functions from selection.");
        while (address != null && !monitor.isCancelled()) {
            CreateFunctionCmd createFunctionCmd;
            Function function = listing.getFunctionContaining(address);
            if (function == null && (createFunctionCmd = new CreateFunctionCmd(null, address, null, this.source)).applyTo(program, monitor)) {
                function = createFunctionCmd.getFunction();
                ++functionsCreated;
            }
            if (function != null) {
                AddressSetView body = function.getBody();
                addressSet.delete(body);
            }
            addressSet.deleteRange(address, address);
            address = addressSet.getMinAddress();
            long numRemainingAddresses = addressSet.getNumAddresses();
            monitor.setProgress(numInitialAddresses - numRemainingAddresses);
        }
        if (monitor.isCancelled()) {
            Msg.info((Object)((Object)this), (Object)("User canceled " + this.getName() + "."));
            return false;
        }
        Msg.info((Object)((Object)this), (Object)(functionsCreated + " functions created by " + this.getName() + "."));
        return true;
    }
}

