/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.client.tables;

import ghidra.features.bsim.query.client.tables.CachedStatement;
import ghidra.features.bsim.query.client.tables.SQLComplexTable;
import ghidra.features.bsim.query.description.CallgraphEntry;
import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.features.bsim.query.description.RowKey;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.help.UnsupportedOperationException;

public class CallgraphTable
extends SQLComplexTable {
    private static final String SELECT_STMT = "SELECT ALL * FROM callgraphtable WHERE src = ?";
    private static final String INSERT_STMT = "INSERT INTO callgraphtable (src,dest) VALUES(?,?)";
    private final CachedStatement<PreparedStatement> selectStatement = new CachedStatement();
    private final CachedStatement<PreparedStatement> insertStatement = new CachedStatement();

    public CallgraphTable() {
        super("callgraphtable", "src");
    }

    @Override
    public void close() {
        this.selectStatement.close();
        this.insertStatement.close();
        super.close();
    }

    @Override
    public void create(Statement st) throws SQLException {
        st.executeUpdate("CREATE TABLE callgraphtable (src BIGINT,dest BIGINT,PRIMARY KEY (src,dest) )");
    }

    @Override
    public void drop(Statement st) throws SQLException {
        throw new UnsupportedOperationException("CallgraphTable may not be dropped");
    }

    public static CallgraphRow extractCallgraphRow(ResultSet pgres) throws SQLException {
        CallgraphRow res = new CallgraphRow();
        res.src = pgres.getLong(1);
        res.dest = pgres.getLong(2);
        return res;
    }

    public List<CallgraphRow> queryCallgraphRows(FunctionDescription func, boolean trackcallgraph) throws SQLException {
        if (!trackcallgraph) {
            throw new SQLException("SQL database does not have callgraph information enabled");
        }
        PreparedStatement s = this.selectStatement.prepareIfNeeded(() -> this.db.prepareStatement(SELECT_STMT));
        RowKey funcid = func.getId();
        if (funcid == null) {
            throw new SQLException("FunctionDescription does not have id");
        }
        s.setLong(1, funcid.getLong());
        try (ResultSet rs = s.executeQuery();){
            ArrayList<CallgraphRow> callvec = new ArrayList<CallgraphRow>();
            while (rs.next()) {
                CallgraphRow row = CallgraphTable.extractCallgraphRow(rs);
                if (row.dest == 0L) continue;
                callvec.add(row);
            }
            ArrayList<CallgraphRow> arrayList = callvec;
            return arrayList;
        }
    }

    @Override
    public long insert(Object ... arguments) throws SQLException {
        if (arguments == null || arguments.length != 1 || !(arguments[0] instanceof FunctionDescription)) {
            throw new IllegalArgumentException("Insert method for CallgraphTable must take exactly one FunctionDescription argument");
        }
        FunctionDescription func = (FunctionDescription)arguments[0];
        PreparedStatement s = this.insertStatement.prepareIfNeeded(() -> this.db.prepareStatement(INSERT_STMT));
        long srcid = func.getId().getLong();
        List<CallgraphEntry> callvec = func.getCallgraphRecord();
        if (callvec != null) {
            for (CallgraphEntry element : callvec) {
                FunctionDescription destFunc = element.getFunctionDescription();
                long destid = destFunc.getId().getLong();
                s.setLong(1, srcid);
                s.setLong(2, destid);
                s.executeUpdate();
            }
        }
        return 0L;
    }

    public static class CallgraphRow {
        public long src;
        public long dest;
    }
}

