/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import org.jungrapht.visualization.PropertyLoader;
import org.jungrapht.visualization.control.AbstractGraphMousePlugin;
import org.jungrapht.visualization.control.GraphMousePlugin;
import org.jungrapht.visualization.control.PluggableGraphMouse;
import org.jungrapht.visualization.control.ScalingGraphMousePlugin;

public abstract class AbstractGraphMouse
extends PluggableGraphMouse {
    private static final String VERTEX_SELECTION_ONLY = "jungrapht.vertexSelectionOnly";
    protected float in;
    protected float out;
    protected boolean vertexSelectionOnly;
    protected GraphMousePlugin scalingPlugin;
    protected AbstractGraphMousePlugin selectingPlugin;
    protected AbstractGraphMousePlugin regionSelectingPlugin;
    protected AbstractGraphMousePlugin translatingPlugin;

    protected AbstractGraphMouse(float in, float out, boolean vertexSelectionOnly) {
        this.in = in;
        this.out = out;
        this.vertexSelectionOnly = vertexSelectionOnly;
    }

    public void setZoomAtMouse(boolean zoomAtMouse) {
        ((ScalingGraphMousePlugin)this.scalingPlugin).setZoomAtMouse(zoomAtMouse);
    }

    static {
        PropertyLoader.load();
    }

    public static abstract class Builder<T extends AbstractGraphMouse, B extends Builder<T, B>> {
        protected boolean vertexSelectionOnly = Boolean.parseBoolean(System.getProperty("jungrapht.vertexSelectionOnly", "false"));
        protected float in = 1.1f;
        protected float out = 0.9090909f;
        protected int selectionMask = 1024;
        protected int addToSelectionMask = 64;

        public B self() {
            return (B)this;
        }

        public B in(float in) {
            this.in = in;
            return this.self();
        }

        public B out(float out) {
            this.out = out;
            return this.self();
        }

        public B vertexSelectionOnly(boolean vertexSelectionOnly) {
            this.vertexSelectionOnly = vertexSelectionOnly;
            return this.self();
        }

        public abstract T build();
    }
}

