/*
 * Decompiled with CFR 0.152.
 */
package docking.util;

import docking.util.AnimationPainter;
import docking.util.AnimationRunner;
import docking.util.TextShaper;
import generic.json.Json;
import generic.theme.Gui;
import generic.util.WindowUtilities;
import generic.util.image.ImageUtils;
import ghidra.util.Swing;
import ghidra.util.bean.GGlassPane;
import ghidra.util.timer.GTimer;
import ghidra.util.timer.GTimerMonitor;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.time.Duration;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class GGlassPaneMessage {
    private static final int HIDE_DELAY_MILLIS = 2000;
    private AnimationRunner animationRunner;
    private GTimerMonitor timerMonitor;
    private Duration hideDelay = Duration.ofMillis(2000L);
    private JComponent component;
    private String message;

    public GGlassPaneMessage(JComponent component) {
        this.component = component;
        component.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27 && GGlassPaneMessage.this.animationRunner != null) {
                    GGlassPaneMessage.this.hide();
                    e.consume();
                }
            }
        });
    }

    public void setHideDelay(Duration duration) {
        this.hideDelay = Objects.requireNonNull(duration);
    }

    public void showCenteredMessage(String newMessage) {
        CenterTextPainter painter = new CenterTextPainter(this);
        this.showMessage(newMessage, painter);
    }

    public void showBottomMessage(String newMessage) {
        BottomTextPainter painter = new BottomTextPainter(this);
        this.showMessage(newMessage, painter);
    }

    public void showMessage(String newMessage, AnimationPainter painter) {
        this.hide();
        this.message = Objects.requireNonNull(newMessage);
        AnimationRunner runner = new AnimationRunner(this.component);
        double full = 1.0;
        double emphasized = 1.2;
        Double[] stages = new Double[]{full, emphasized, emphasized, emphasized, full};
        runner.setValues(stages);
        runner.setDuration(Duration.ofMillis(500L));
        runner.setRemovePainterWhenFinished(false);
        runner.setPainter(painter);
        runner.start();
        this.animationRunner = runner;
        this.timerMonitor = GTimer.scheduleRunnable((long)this.hideDelay.toMillis(), () -> Swing.runNow(() -> this.hide()));
    }

    public void hide() {
        if (this.animationRunner != null) {
            this.animationRunner.stop();
            this.animationRunner = null;
        }
        if (this.timerMonitor != null) {
            this.timerMonitor.cancel();
            this.timerMonitor = null;
        }
    }

    public String toString() {
        return Json.toString((Object)this.message);
    }

    private class CenterTextPainter
    extends AbstractTextPainer {
        private CenterTextPainter(GGlassPaneMessage gGlassPaneMessage) {
        }

        @Override
        public void paint(GGlassPane glassPane, Graphics graphics, double intensity) {
            Graphics2D g2d = (Graphics2D)graphics;
            Image image = this.updateImage(g2d, intensity);
            if (image == null) {
                return;
            }
            Rectangle componentBounds = this.getComponentBounds(glassPane);
            int imageHeight = image.getHeight(null);
            if (imageHeight > componentBounds.height) {
                return;
            }
            this.paintOverComponent(g2d, glassPane);
            int textHeight = image.getHeight(null);
            int textWidth = image.getWidth(null);
            int padding = 5;
            int middleY = componentBounds.y + componentBounds.height / 2;
            int middleX = componentBounds.x + componentBounds.width / 2;
            int requiredHeight = textHeight + padding;
            int requiredWidth = textWidth + padding;
            int y = middleY - requiredHeight / 2;
            int x = middleX - requiredWidth / 2;
            g2d.drawImage(image, x, y, null);
        }
    }

    private class BottomTextPainter
    extends AbstractTextPainer {
        private BottomTextPainter(GGlassPaneMessage gGlassPaneMessage) {
        }

        @Override
        public void paint(GGlassPane glassPane, Graphics graphics, double intensity) {
            Graphics2D g2d = (Graphics2D)graphics;
            Image image = this.updateImage(g2d, intensity);
            if (image == null) {
                return;
            }
            Rectangle componentBounds = this.getComponentBounds(glassPane);
            int imageHeight = image.getHeight(null);
            if (imageHeight > componentBounds.height) {
                return;
            }
            this.paintOverComponent(g2d, glassPane);
            int textHeight = image.getHeight(null);
            int padding = 5;
            int bottom = componentBounds.y + componentBounds.height;
            int requiredHeight = textHeight + padding;
            int y = bottom - requiredHeight;
            int x = componentBounds.x + padding;
            g2d.drawImage(image, x, y, null);
        }
    }

    private abstract class AbstractTextPainer
    implements AnimationPainter {
        private static String FONT_ID = "font.glasspane.message";
        private static final String MESSAGE_FG_COLOR_ID = "color.fg.glasspane.message";
        protected Image baseTextImage;
        private ComponentListener resizeListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                AbstractTextPainer.this.baseTextImage = null;
                Window w = WindowUtilities.windowForComponent((Component)GGlassPaneMessage.this.component);
                w.repaint();
            }
        };

        AbstractTextPainer() {
            GGlassPaneMessage.this.component.addComponentListener(this.resizeListener);
        }

        private void createImage() {
            if (this.baseTextImage != null) {
                return;
            }
            Font font = Gui.getFont((String)FONT_ID);
            BufferedImage tempImage = new BufferedImage(10, 10, 2);
            Graphics2D scratchG2d = (Graphics2D)tempImage.getGraphics();
            scratchG2d.setFont(font);
            Dimension size = this.getComponentSize();
            int padding = 20;
            size.width -= padding;
            TextShaper textShaper = new TextShaper(GGlassPaneMessage.this.message, size, scratchG2d);
            Dimension textSize = textShaper.getTextSize();
            if (textSize.width == 0 || textSize.height == 0) {
                return;
            }
            int roundingPadding = 5;
            int w = textSize.width + roundingPadding;
            int h = textSize.height;
            BufferedImage bi = new BufferedImage(w, h, 2);
            Graphics2D g2d = (Graphics2D)bi.getGraphics();
            g2d.setFont(font);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(Gui.getColor((String)MESSAGE_FG_COLOR_ID));
            textShaper.drawText(g2d);
            g2d.dispose();
            this.baseTextImage = bi;
        }

        protected Dimension getComponentSize() {
            Rectangle r = GGlassPaneMessage.this.component.getVisibleRect();
            Dimension size = r.getSize();
            Container parent = GGlassPaneMessage.this.component.getParent();
            if (parent instanceof JScrollPane || parent instanceof JViewport) {
                size = parent.getSize();
            }
            return size;
        }

        protected Rectangle getComponentBounds(GGlassPane glassPane) {
            Container parent;
            Rectangle r = GGlassPaneMessage.this.component.getVisibleRect();
            Point point = r.getLocation();
            Dimension size = r.getSize();
            Container coordinateSource = parent = GGlassPaneMessage.this.component.getParent();
            if (parent instanceof JScrollPane || parent instanceof JViewport) {
                point = parent.getLocation();
                size = parent.getSize();
                coordinateSource = parent.getParent();
            }
            point = SwingUtilities.convertPoint(coordinateSource, point, (Component)glassPane);
            return new Rectangle(point, size);
        }

        protected Image updateImage(Graphics2D g2d, double scale) {
            this.baseTextImage = null;
            this.createImage();
            if (this.baseTextImage == null) {
                return null;
            }
            int w = this.baseTextImage.getWidth(null);
            int h = this.baseTextImage.getHeight(null);
            int sw = (int)((double)w * scale);
            int sh = (int)((double)h * scale);
            int iw = this.baseTextImage.getWidth(null);
            int ih = this.baseTextImage.getHeight(null);
            if (iw == sw && ih == sh) {
                return this.baseTextImage;
            }
            return ImageUtils.createScaledImage((Image)this.baseTextImage, (int)sw, (int)sh, (int)0);
        }

        protected void paintOverComponent(Graphics2D g2d, GGlassPane glassPane) {
            Rectangle bounds = this.getComponentBounds(glassPane);
            float alpha = 0.7f;
            AlphaComposite alphaComposite = AlphaComposite.getInstance(AlphaComposite.SrcOver.getRule(), alpha);
            Composite originalComposite = g2d.getComposite();
            Color originalColor = g2d.getColor();
            g2d.setComposite(alphaComposite);
            g2d.setColor(GGlassPaneMessage.this.component.getBackground());
            g2d.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            g2d.setComposite(originalComposite);
            g2d.setColor(originalColor);
        }
    }
}

