/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.coverage.gnu.trove;

import java.io.Serializable;
import org.jetbrains.coverage.gnu.trove.HashFunctions;
import org.jetbrains.coverage.gnu.trove.TIntHashingStrategy;
import org.jetbrains.coverage.gnu.trove.TIntProcedure;
import org.jetbrains.coverage.gnu.trove.TPrimitiveHash;

public abstract class TIntHash
extends TPrimitiveHash
implements Serializable,
TIntHashingStrategy {
    protected transient int[] _set;
    protected TIntHashingStrategy _hashingStrategy;

    public TIntHash() {
        this._hashingStrategy = this;
    }

    /*
     * WARNING - void declaration
     */
    public TIntHash(int initialCapacity) {
        super((int)var1_1);
        void var1_1;
        this._hashingStrategy = this;
    }

    /*
     * WARNING - void declaration
     */
    public TIntHash(int initialCapacity, float loadFactor) {
        super((int)var1_1, (float)var2_2);
        void var2_2;
        void var1_1;
        this._hashingStrategy = this;
    }

    /*
     * WARNING - void declaration
     */
    public TIntHash(TIntHashingStrategy strategy) {
        void var1_1;
        this._hashingStrategy = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TIntHash(int initialCapacity, TIntHashingStrategy strategy) {
        super((int)var1_1);
        void var2_2;
        void var1_1;
        this._hashingStrategy = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public TIntHash(int initialCapacity, float loadFactor, TIntHashingStrategy strategy) {
        super((int)var1_1, (float)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this._hashingStrategy = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Object clone() {
        void var1_1;
        TIntHash h = (TIntHash)super.clone();
        ((TIntHash)super.clone())._set = (int[])this._set.clone();
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected int setUp(int initialCapacity) {
        void var1_1;
        int capacity = super.setUp(initialCapacity);
        this._set = new int[capacity];
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(int val) {
        void var1_1;
        return this.index((int)var1_1) >= 0;
    }

    public boolean forEach(TIntProcedure procedure) {
        byte[] states = this._states;
        int[] set = this._set;
        int i = this._set.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(set[i])) continue;
            return false;
        }
        return true;
    }

    protected void removeAt(int index) {
        super.removeAt(index);
        this._set[var1_1] = 0;
    }

    /*
     * WARNING - void declaration
     */
    protected int index(int val) {
        void var2_2;
        byte[] states = this._states;
        int[] set = this._set;
        int length = states.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (states[index] != 0 && (states[index] == 2 || set[index] != val)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (states[index] != 0 && (states[index] == 2 || set[index] != val));
        }
        if (var2_2[index] == false) {
            return -1;
        }
        return index;
    }

    /*
     * WARNING - void declaration
     */
    protected int insertionIndex(int val) {
        void var2_2;
        byte[] states = this._states;
        int[] set = this._set;
        int length = states.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (states[index] == 0) {
            return index;
        }
        if (states[index] == 1 && set[index] == val) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        do {
            if ((index -= probe) >= 0) continue;
            index += length;
        } while (states[index] == 1 && set[index] != val);
        if (states[index] == 2) {
            int firstRemoved = index;
            while (states[index] != 0 && (states[index] == 2 || set[index] != val)) {
                if ((index -= probe) >= 0) continue;
                index += length;
            }
            if (states[index] == 1) {
                return -index - 1;
            }
            return firstRemoved;
        }
        if (var2_2[index] == true) {
            return -index - 1;
        }
        return index;
    }

    public final int computeHashCode(int val) {
        return HashFunctions.hash(val);
    }
}

