/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit4;

import com.intellij.junit4.ExpectedPatterns;
import com.intellij.junit4.JUnit4ReflectionUtil;
import com.intellij.junit4.JUnitTestTreeNodeManager;
import com.intellij.rt.execution.junit.ComparisonFailureData;
import com.intellij.rt.execution.junit.MapSerializerUtil;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class JUnit4TestListener
extends RunListener {
    public static final String EMPTY_SUITE_NAME = "junit.framework.TestSuite$1";
    public static final String EMPTY_SUITE_WARNING = "warning";
    private final List<Description> myStartedSuites = new ArrayList<Description>();
    private final Map<Description, List<List<Description>>> myParents = new HashMap<Description, List<List<Description>>>();
    private final Map<Description, String> myMethodNames = new HashMap<Description, String>();
    private final PrintStream myPrintStream;
    private String myRootName;
    private long myCurrentTestStart;
    private Description myCurrentTest;
    private final Map<Description, TestEvent> myWaitingQueue = new LinkedHashMap<Description, TestEvent>();
    private static final JUnitTestTreeNodeManager NODE_NAMES_MANAGER = JUnit4TestListener.getTestTreeNodeManager();

    public JUnit4TestListener() {
        this(System.out);
    }

    public JUnit4TestListener(PrintStream printStream) {
        this.myPrintStream = printStream;
        this.myPrintStream.println("##teamcity[enteredTheMatrix]");
    }

    private static String escapeName(String str) {
        return MapSerializerUtil.escapeStr((String)str, (MapSerializerUtil.EscapeInfoProvider)MapSerializerUtil.STD_ESCAPER);
    }

    public void testRunStarted(Description description) {
        if (this.myRootName != null && !this.myRootName.equals("null") && !this.myRootName.startsWith("[")) {
            JUnitTestTreeNodeManager.TestNodePresentation rootNodePresentation = NODE_NAMES_MANAGER.getRootNodePresentation(this.myRootName);
            this.myPrintStream.println("##teamcity[rootName name = '" + JUnit4TestListener.escapeName(rootNodePresentation.getName()) + (rootNodePresentation.getComment() != null ? "' comment = '" + JUnit4TestListener.escapeName(rootNodePresentation.getComment()) : "") + "' location = 'java:suite://" + JUnit4TestListener.escapeName(this.myRootName) + "']");
            this.myRootName = JUnit4TestListener.getShortName(this.myRootName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRunFinished(Result result) {
        try {
            this.dumpQueue(true);
        }
        finally {
            for (int i = this.myStartedSuites.size() - 1; i >= 0; --i) {
                String className = JUnit4ReflectionUtil.getClassName(this.myStartedSuites.get(i));
                if (className.equals(this.myRootName)) continue;
                this.myPrintStream.println("##teamcity[testSuiteFinished name='" + JUnit4TestListener.escapeName(JUnit4TestListener.getShortName(className)) + "']");
            }
            this.myStartedSuites.clear();
        }
    }

    public void testStarted(Description description) {
        this.testStarted(description, null);
    }

    private void testStarted(Description description, String methodName) {
        int i;
        Description currentParent;
        Description currentClass;
        int idx;
        List<List<Description>> parents = this.myParents.get(description);
        if (!(this.myCurrentTest == null || parents != null && !parents.isEmpty() && parents.get(0).contains(this.myCurrentTest) || this.myWaitingQueue.containsKey(description))) {
            this.myWaitingQueue.put(description, new TestEvent());
            return;
        }
        this.myCurrentTest = description;
        String classFQN = JUnit4ReflectionUtil.getClassName(description);
        List<Object> parentsHierarchy = new ArrayList();
        if (parents != null && !parents.isEmpty()) {
            parentsHierarchy = parents.remove(0);
        }
        if (parentsHierarchy.isEmpty()) {
            parentsHierarchy = Collections.singletonList(Description.createSuiteDescription((String)classFQN, (Annotation[])new Annotation[0]));
        }
        if (methodName == null && (methodName = this.getFullMethodName(description, (Description)parentsHierarchy.get(parentsHierarchy.size() - 1))) == null) {
            return;
        }
        for (idx = 0; idx < this.myStartedSuites.size() && idx < parentsHierarchy.size() && !JUnit4TestListener.isHierarchyDifferent(parents, currentClass = this.myStartedSuites.get(idx), currentParent = (Description)parentsHierarchy.get(parentsHierarchy.size() - 1 - idx)); ++idx) {
        }
        for (i = this.myStartedSuites.size() - 1; i >= idx; --i) {
            currentClass = this.myStartedSuites.remove(i);
            this.myPrintStream.println("##teamcity[testSuiteFinished name='" + JUnit4TestListener.escapeName(JUnit4TestListener.getShortName(JUnit4ReflectionUtil.getClassName(currentClass))) + "']");
        }
        for (i = idx; i < parentsHierarchy.size(); ++i) {
            Description descriptionFromHistory = (Description)parentsHierarchy.get(parentsHierarchy.size() - 1 - i);
            String fqName = JUnit4ReflectionUtil.getClassName(descriptionFromHistory);
            String className = JUnit4TestListener.getShortName(fqName);
            if (!className.equals(this.myRootName)) {
                this.myPrintStream.println("##teamcity[testSuiteStarted name='" + JUnit4TestListener.escapeName(className) + "'" + JUnit4TestListener.getSuiteLocation(descriptionFromHistory, description, fqName) + "]");
            }
            this.myStartedSuites.add(descriptionFromHistory);
        }
        this.myPrintStream.println("##teamcity[testStarted name='" + JUnit4TestListener.escapeName(methodName.replaceFirst("/", ".")) + "' " + NODE_NAMES_MANAGER.getTestLocation(description, classFQN, methodName) + "]");
        this.myCurrentTestStart = this.currentTime();
    }

    private static boolean isHierarchyDifferent(List<?> parents, Description currentClass, Description currentParent) {
        if (parents == null) {
            return !currentClass.equals((Object)currentParent);
        }
        return System.identityHashCode(currentClass) != System.identityHashCode(currentParent);
    }

    protected long currentTime() {
        return System.currentTimeMillis();
    }

    public void testFinished(Description description) {
        if (this.startedInParallel(description)) {
            TestEvent testEvent = this.myWaitingQueue.get(description);
            testEvent.setFinished(true);
            return;
        }
        this.testFinishedNoDumping(this.getFullMethodName(description));
        this.dumpQueue(false);
    }

    private boolean startedInParallel(Description description) {
        return this.myWaitingQueue.containsKey(description) && (this.myCurrentTest == null || !this.myCurrentTest.equals((Object)description));
    }

    private void testFinishedNoDumping(String methodName) {
        if (methodName != null) {
            long duration = this.currentTime() - this.myCurrentTestStart;
            this.myPrintStream.println("##teamcity[testFinished name='" + JUnit4TestListener.escapeName(methodName.replaceFirst("/", ".")) + (duration > 0L ? "' duration='" + duration : "") + "']");
        }
        this.myCurrentTest = null;
    }

    public void testFailure(Failure failure) {
        this.testFailure(failure, failure.getDescription(), "testFailed");
    }

    private void testFailure(Failure failure, Description description, String messageName) {
        boolean isIgnored = "testIgnored".equals(messageName);
        String methodName = this.getFullMethodName(description);
        if (methodName == null) {
            if (!isIgnored) {
                this.classConfigurationStarted(description);
                this.testFailure(failure, description, messageName, "Class Configuration");
                this.classConfigurationFinished(description);
            }
            if (this.myStartedSuites.isEmpty() || !description.equals((Object)this.myStartedSuites.get(this.myStartedSuites.size() - 1))) {
                for (Description next : description.getChildren()) {
                    this.testStarted(next);
                    this.testFailure((Failure)(isIgnored ? failure : null), next, "testIgnored");
                    this.testFinished(next);
                }
            }
        } else {
            this.testFailure(failure, description, messageName, methodName.replaceFirst("/", "."));
        }
    }

    private void classConfigurationFinished(Description description) {
        if (this.startedInParallel(description)) {
            TestEvent testEvent = this.myWaitingQueue.get(description);
            testEvent.setFinished(true);
            return;
        }
        this.myPrintStream.println("##teamcity[testFinished name='" + JUnit4TestListener.escapeName("Class Configuration") + "']");
        this.myCurrentTest = null;
    }

    private void classConfigurationStarted(Description description) {
        if (this.myCurrentTest != null) {
            TestEvent value = new TestEvent();
            value.setMethodName("Class Configuration");
            this.myWaitingQueue.put(description, value);
            return;
        }
        this.myCurrentTest = description;
        this.myPrintStream.println("##teamcity[testStarted name='" + JUnit4TestListener.escapeName("Class Configuration") + "'" + JUnit4TestListener.getSuiteLocation(JUnit4ReflectionUtil.getClassName(description)) + " ]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFailure(Failure failure, Description description, String messageName, String methodName) {
        Throwable ex;
        boolean isIgnored = "testIgnored".equals(messageName);
        if (this.startedInParallel(description)) {
            TestEvent testEvent = this.myWaitingQueue.get(description);
            if (testEvent == null) {
                testEvent = new TestEvent();
                this.myWaitingQueue.put(description, testEvent);
            }
            testEvent.setIgnored(isIgnored);
            testEvent.setFailure(failure);
            return;
        }
        Throwable throwable = ex = failure != null ? failure.getException() : null;
        if (ex != null && JUnit4TestListener.isMultipleFailuresError(ex.getClass())) {
            try {
                Object failures = Class.forName("org.opentest4j.MultipleFailuresError").getDeclaredMethod("getFailures", new Class[0]).invoke((Object)ex, new Object[0]);
                for (Throwable throwable2 : (List)failures) {
                    this.testFailure(new Failure(description, throwable2), description, messageName, methodName);
                }
                return;
            }
            catch (Throwable failures) {
                // empty catch block
            }
        }
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        attrs.put("name", methodName);
        long duration = this.currentTime() - this.myCurrentTestStart;
        if (duration > 0L) {
            attrs.put("duration", Long.toString(duration));
        }
        try {
            if (failure != null) {
                String trace = this.getTrace(failure);
                ComparisonFailureData notification = ExpectedPatterns.createExceptionNotification(ex);
                ComparisonFailureData.registerSMAttributes((ComparisonFailureData)notification, (String)trace, (String)failure.getMessage(), attrs, (Throwable)ex);
            }
        }
        catch (Throwable e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(stringWriter);
            e.printStackTrace(writer);
            ComparisonFailureData.registerSMAttributes(null, (String)stringWriter.toString(), (String)e.getMessage(), attrs, (Throwable)e);
        }
        finally {
            this.myPrintStream.println(MapSerializerUtil.asString((String)messageName, attrs));
        }
    }

    private static boolean isMultipleFailuresError(Class<?> aClass) {
        if (aClass.getName().equals("org.opentest4j.MultipleFailuresError")) {
            return true;
        }
        Class<?> superclass = aClass.getSuperclass();
        return superclass != null && JUnit4TestListener.isMultipleFailuresError(superclass);
    }

    protected String getTrace(Failure failure) {
        return failure.getTrace();
    }

    public void testAssumptionFailure(Failure failure) {
        this.testFailure(failure, failure.getDescription(), "testIgnored");
    }

    private String getFullMethodName(Description description) {
        return this.getFullMethodName(description, null);
    }

    private String getFullMethodName(Description description, Description parent) {
        return this.getFullMethodName(description, parent, false);
    }

    private String getFullMethodName(Description description, Description parent, boolean acceptNull) {
        String methodName = this.myMethodNames.get(description);
        if (methodName == null) {
            methodName = JUnit4ReflectionUtil.getMethodName(description);
            if (!(methodName == null || parent != null && JUnit4TestListener.isParameter(parent))) {
                String shortName = JUnit4TestListener.getShortName(JUnit4ReflectionUtil.getClassName(description));
                String string = methodName = shortName.isEmpty() ? methodName : shortName + "/" + methodName;
            }
            if (!acceptNull && methodName == null && description.getChildren().isEmpty()) {
                methodName = JUnit4TestListener.getShortName(description.getDisplayName());
            }
            this.myMethodNames.put(description, methodName);
        }
        return methodName;
    }

    public void testIgnored(Description description) {
        String methodName = this.getFullMethodName(description);
        if (methodName == null) {
            for (Description testDescription : description.getChildren()) {
                this.testIgnored(testDescription, this.getFullMethodName(testDescription));
            }
        } else {
            this.testIgnored(description, methodName.replaceFirst("/", "."));
        }
    }

    private void testIgnored(Description description, String methodName) {
        this.testStarted(description);
        HashMap<String, String> attrs = new HashMap<String, String>();
        try {
            String val;
            Ignore ignoredAnnotation = (Ignore)description.getAnnotation(Ignore.class);
            if (ignoredAnnotation != null && (val = ignoredAnnotation.value()) != null) {
                attrs.put("message", val);
            }
        }
        catch (NoSuchMethodError ignoredAnnotation) {
            // empty catch block
        }
        attrs.put("name", methodName);
        if (this.startedInParallel(description)) {
            TestEvent testEvent = this.myWaitingQueue.get(description);
            if (testEvent == null) {
                testEvent = new TestEvent();
                this.myWaitingQueue.put(description, testEvent);
            }
            testEvent.setIgnored(true);
            testEvent.setAttrs(attrs);
        } else {
            this.myPrintStream.println(MapSerializerUtil.asString((String)"testIgnored", attrs));
        }
        this.testFinished(description);
    }

    private void dumpQueue(boolean acceptUnfinished) {
        Iterator<Description> iterator = this.myWaitingQueue.keySet().iterator();
        while (iterator.hasNext()) {
            Description description = iterator.next();
            TestEvent testEvent = this.myWaitingQueue.get(description);
            if (!acceptUnfinished && !testEvent.isFinished()) continue;
            this.testStarted(description, testEvent.getMethodName());
            iterator.remove();
            Failure failure = testEvent.getFailure();
            if (testEvent.isIgnored()) {
                Map<String, String> attrs = testEvent.getAttrs();
                if (attrs == null) {
                    this.testFailure(failure, description, "testIgnored");
                } else {
                    this.myPrintStream.println(MapSerializerUtil.asString((String)"testIgnored", attrs));
                }
            } else if (failure != null) {
                this.testFailure(failure);
            }
            String methodName = testEvent.getMethodName();
            this.testFinishedNoDumping(methodName != null ? methodName : this.getFullMethodName(description));
        }
    }

    private void sendTree(Description description, Description parent, List<Description> currentParents) {
        List<List<Description>> parents;
        String parentClassName;
        ArrayList<Description> pParents = new ArrayList<Description>(3);
        pParents.addAll(currentParents);
        if (parent != null && !this.myRootName.equals(parentClassName = JUnit4ReflectionUtil.getClassName(parent))) {
            pParents.add(0, parent);
        }
        if ((parents = this.myParents.get(description)) == null) {
            parents = new ArrayList<List<Description>>(1);
            this.myParents.put(description, parents);
        }
        parents.add(pParents);
        String className = JUnit4ReflectionUtil.getClassName(description);
        if (description.isTest()) {
            String methodName = this.getFullMethodName(description, parent, true);
            if (methodName != null) {
                if (JUnit4TestListener.isWarning(methodName, className) && parent != null) {
                    className = JUnit4ReflectionUtil.getClassName(parent);
                }
                this.myPrintStream.println("##teamcity[suiteTreeNode name='" + JUnit4TestListener.escapeName(methodName.replaceFirst("/", ".")) + "' " + NODE_NAMES_MANAGER.getTestLocation(description, className, methodName) + "]");
            } else {
                this.myPrintStream.println("##teamcity[suiteTreeStarted name='" + JUnit4TestListener.escapeName(JUnit4TestListener.getShortName(className)) + "' locationHint='java:suite://" + JUnit4TestListener.escapeName(className) + "']");
                this.myPrintStream.println("##teamcity[suiteTreeEnded name='" + JUnit4TestListener.escapeName(JUnit4TestListener.getShortName(className)) + "']");
            }
            return;
        }
        ArrayList tests = description.getChildren();
        boolean pass = false;
        for (Description nextDescription : tests) {
            if (!(this.myRootName != null && this.myRootName.equals(className) || pass)) {
                pass = true;
                this.myPrintStream.println("##teamcity[suiteTreeStarted name='" + JUnit4TestListener.escapeName(JUnit4TestListener.getShortName(className)) + "'" + JUnit4TestListener.getSuiteLocation(description, nextDescription, className) + "]");
            }
            this.sendTree(nextDescription, description, pParents);
        }
        if (pass) {
            this.myPrintStream.println("##teamcity[suiteTreeEnded name='" + JUnit4TestListener.escapeName(JUnit4TestListener.getShortName(JUnit4ReflectionUtil.getClassName(description))) + "']");
        }
    }

    private static String getSuiteLocation(Description parentDescription, Description description, String parentClassName) {
        String displayName;
        int paramIdx;
        String locationHint = parentClassName;
        if (JUnit4TestListener.isParameter(parentDescription) && (paramIdx = (displayName = description.getDisplayName()).indexOf(locationHint)) > -1 && (locationHint = displayName.substring(paramIdx + locationHint.length())).startsWith("(") && locationHint.endsWith(")")) {
            locationHint = locationHint.substring(1, locationHint.length() - 1) + "." + parentClassName;
        }
        return JUnit4TestListener.getSuiteLocation(locationHint);
    }

    private static String getSuiteLocation(String locationHint) {
        return " locationHint='java:suite://" + JUnit4TestListener.escapeName(locationHint) + "'";
    }

    private static boolean isWarning(String methodName, String className) {
        return EMPTY_SUITE_WARNING.equals(methodName) && EMPTY_SUITE_NAME.equals(className);
    }

    private static boolean isParameter(Description description) {
        String displayName = description.getDisplayName();
        return displayName.startsWith("[") && displayName.endsWith("]");
    }

    public void sendTree(Description description) {
        this.myRootName = JUnit4ReflectionUtil.getClassName(description);
        this.sendTree(description, null, new ArrayList<Description>());
        this.myPrintStream.println("##teamcity[treeEnded]");
    }

    private static String getShortName(String fqName) {
        return JUnit4TestListener.getShortName(fqName, false);
    }

    private static String getShortName(String fqName, boolean splitBySlash) {
        return NODE_NAMES_MANAGER.getNodeName(fqName, splitBySlash);
    }

    private static JUnitTestTreeNodeManager getTestTreeNodeManager() {
        String junitNodeNamesManagerClassName = System.getProperty("nodeNamesHandler");
        JUnitTestTreeNodeManager result = JUnitTestTreeNodeManager.JAVA_NODE_NAMES_MANAGER;
        if (junitNodeNamesManagerClassName != null) {
            try {
                Class<JUnitTestTreeNodeManager> junitNodeNamesManagerClass = Class.forName(junitNodeNamesManagerClassName).asSubclass(JUnitTestTreeNodeManager.class);
                result = junitNodeNamesManagerClass.newInstance();
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException exception) {
                // empty catch block
            }
        }
        return result;
    }

    private static class TestEvent {
        private Failure myFailure;
        private boolean myIgnored;
        private boolean myFinished;
        private Map<String, String> myAttrs;
        private String myMethodName;

        private TestEvent() {
        }

        public Failure getFailure() {
            return this.myFailure;
        }

        public boolean isIgnored() {
            return this.myIgnored;
        }

        public boolean isFinished() {
            return this.myFinished;
        }

        public void setFinished(boolean finished) {
            this.myFinished = finished;
        }

        public void setFailure(Failure failure) {
            this.myFailure = failure;
        }

        public void setIgnored(boolean ignored) {
            this.myIgnored = ignored;
        }

        public void setAttrs(Map<String, String> attrs) {
            this.myAttrs = attrs;
        }

        public Map<String, String> getAttrs() {
            return this.myAttrs;
        }

        public void setMethodName(String methodName) {
            this.myMethodName = methodName;
        }

        public String getMethodName() {
            return this.myMethodName;
        }
    }
}

