/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.tools.Utils;

public abstract class AbstractCopyAction
extends AbstractAction {
    private final JTable tagTable;
    private final IntFunction<String> keySupplier;
    private final Supplier<Collection<? extends Tagged>> objectSupplier;

    protected AbstractCopyAction(JTable tagTable, IntFunction<String> keySupplier, Supplier<Collection<? extends Tagged>> objectSupplier) {
        this.tagTable = Objects.requireNonNull(tagTable);
        this.keySupplier = Objects.requireNonNull(keySupplier);
        this.objectSupplier = Objects.requireNonNull(objectSupplier);
    }

    protected abstract Collection<String> getString(Tagged var1, String var2);

    protected Stream<String> valueStream() {
        int[] rows = this.tagTable.getSelectedRows();
        Collection<? extends Tagged> sel = this.objectSupplier.get();
        if (rows.length == 0 || Utils.isEmpty(sel)) {
            return Stream.empty();
        }
        return Arrays.stream(rows).mapToObj(this.keySupplier).flatMap(key -> sel.stream().map(p -> this.getString((Tagged)p, (String)key))).filter(Objects::nonNull).flatMap(Collection::stream).distinct();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String values = this.valueStream().sorted().collect(Collectors.joining("\n"));
        if (!values.isEmpty()) {
            ClipboardUtils.copyString(values);
        }
    }
}

