/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openstreetmap.josm.data.UserIdentityManager;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.ChangesetClosedException;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmServerWritePostprocessor;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.UploadStrategySpecification;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class OsmServerWriter {
    private Collection<OsmPrimitive> processed;
    private static volatile List<OsmServerWritePostprocessor> postprocessors;
    private final OsmApi api = OsmApi.getOsmApi();
    private boolean canceled;
    private long uploadStartTime;

    public static void registerPostprocessor(OsmServerWritePostprocessor pp) {
        if (postprocessors == null) {
            postprocessors = new ArrayList<OsmServerWritePostprocessor>();
        }
        postprocessors.add(pp);
    }

    public static void unregisterPostprocessor(OsmServerWritePostprocessor pp) {
        if (postprocessors != null) {
            postprocessors.remove(pp);
        }
    }

    protected String timeLeft(int progress, int listSize) {
        long now = System.currentTimeMillis();
        long elapsed = now - this.uploadStartTime;
        if (elapsed == 0L) {
            elapsed = 1L;
        }
        double uploadsPerMs = (double)progress / (double)elapsed;
        double uploadsLeft = (double)listSize - (double)progress;
        long msLeft = (long)(uploadsLeft / uploadsPerMs);
        long minutesLeft = msLeft / TimeUnit.MINUTES.toMillis(1L);
        long secondsLeft = msLeft / TimeUnit.SECONDS.toMillis(1L) % TimeUnit.MINUTES.toSeconds(1L);
        StringBuilder timeLeftStr = new StringBuilder().append(minutesLeft).append(':');
        if (secondsLeft < 10L) {
            timeLeftStr.append('0');
        }
        return timeLeftStr.append(secondsLeft).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uploadChangesIndividually(Collection<? extends OsmPrimitive> primitives, ProgressMonitor progressMonitor) throws OsmTransferException {
        try {
            progressMonitor.beginTask(I18n.tr("Starting to upload with one request per primitive ...", new Object[0]));
            progressMonitor.setTicksCount(primitives.size());
            this.uploadStartTime = System.currentTimeMillis();
            for (OsmPrimitive osmPrimitive : primitives) {
                String msg;
                if (progressMonitor.isCanceled()) {
                    break;
                }
                switch (OsmPrimitiveType.from(osmPrimitive)) {
                    case NODE: {
                        msg = I18n.marktr("{0}% ({1}/{2}), {3} left. Uploading node ''{4}'' (id: {5})");
                        break;
                    }
                    case WAY: {
                        msg = I18n.marktr("{0}% ({1}/{2}), {3} left. Uploading way ''{4}'' (id: {5})");
                        break;
                    }
                    case RELATION: {
                        msg = I18n.marktr("{0}% ({1}/{2}), {3} left. Uploading relation ''{4}'' (id: {5})");
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                int progress = progressMonitor.getTicks();
                progressMonitor.subTask(I18n.tr(msg, Math.round(100.0 * (double)progress / (double)primitives.size()), progress, primitives.size(), this.timeLeft(progress, primitives.size()), osmPrimitive.getName() == null ? Long.valueOf(osmPrimitive.getId()) : osmPrimitive.getName(), osmPrimitive.getId()));
                this.makeApiRequest(osmPrimitive, progressMonitor);
                this.processed.add(osmPrimitive);
                progressMonitor.worked(1);
            }
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    protected void uploadChangesAsDiffUpload(Collection<? extends OsmPrimitive> primitives, ProgressMonitor progressMonitor) throws OsmTransferException {
        try {
            progressMonitor.beginTask(I18n.tr("Starting to upload in one request ...", new Object[0]));
            this.processed.addAll(this.api.uploadDiff(primitives, progressMonitor.createSubTaskMonitor(-1, false)));
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uploadChangesInChunks(Collection<? extends OsmPrimitive> primitives, ProgressMonitor progressMonitor, int chunkSize) throws OsmTransferException {
        if (chunkSize <= 0) {
            throw new IllegalArgumentException(I18n.tr("Value >0 expected for parameter ''{0}'', got {1}", "chunkSize", chunkSize));
        }
        try {
            progressMonitor.beginTask(I18n.tr("Starting to upload in chunks...", new Object[0]));
            ArrayList<OsmPrimitive> chunk = new ArrayList<OsmPrimitive>(chunkSize);
            Iterator<? extends OsmPrimitive> it = primitives.iterator();
            int maxChunkSize = this.api.getCapabilities().getMaxChangesetSize();
            int numChunks = (int)Math.ceil((double)primitives.size() / (double)chunkSize);
            int i = 0;
            while (it.hasNext()) {
                ++i;
                if (this.canceled) {
                    return;
                }
                chunk.clear();
                for (int j = 0; it.hasNext() && j < chunkSize && this.processed.size() + j < maxChunkSize; ++j) {
                    chunk.add(it.next());
                }
                progressMonitor.setCustomText(I18n.trn("({0}/{1}) Uploading {2} object...", "({0}/{1}) Uploading {2} objects...", chunk.size(), i, numChunks, chunk.size()));
                this.processed.addAll(this.api.uploadDiff(chunk, progressMonitor.createSubTaskMonitor(-1, false)));
                if (this.processed.size() < maxChunkSize) continue;
                throw new ChangesetClosedException(this.api.getChangeset().getId(), Instant.now(), ChangesetClosedException.Source.UPLOAD_DATA);
            }
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void uploadOsm(UploadStrategySpecification strategy, Collection<? extends OsmPrimitive> primitives, Changeset changeset, ProgressMonitor monitor) throws OsmTransferException {
        CheckParameterUtil.ensureParameterNotNull(changeset, "changeset");
        this.processed = new LinkedList<OsmPrimitive>();
        monitor = monitor == null ? NullProgressMonitor.INSTANCE : monitor;
        monitor.beginTask(I18n.tr("Uploading data ...", new Object[0]));
        try {
            this.api.initialize(monitor);
            if (changeset.getId() == 0) {
                this.api.openChangeset(changeset, monitor.createSubTaskMonitor(0, false));
                changeset.setUser(UserIdentityManager.getInstance().asUser());
            } else {
                this.api.updateChangeset(changeset, monitor.createSubTaskMonitor(0, false));
            }
            this.api.setChangeset(changeset);
            switch (strategy.getStrategy()) {
                case SINGLE_REQUEST_STRATEGY: {
                    this.uploadChangesAsDiffUpload(primitives, monitor.createSubTaskMonitor(0, false));
                    return;
                }
                case INDIVIDUAL_OBJECTS_STRATEGY: {
                    this.uploadChangesIndividually(primitives, monitor.createSubTaskMonitor(0, false));
                    return;
                }
                default: {
                    this.uploadChangesInChunks(primitives, monitor.createSubTaskMonitor(0, false), strategy.getChunkSize());
                    return;
                }
            }
        }
        finally {
            this.executePostprocessors(monitor);
            monitor.finishTask();
            this.api.setChangeset(null);
        }
    }

    void makeApiRequest(OsmPrimitive osm, ProgressMonitor progressMonitor) throws OsmTransferException {
        if (osm.isDeleted()) {
            this.api.deletePrimitive(osm, progressMonitor);
        } else if (osm.isNew()) {
            this.api.createPrimitive(osm, progressMonitor);
        } else {
            this.api.modifyPrimitive(osm, progressMonitor);
        }
    }

    public void cancel() {
        this.canceled = true;
        if (this.api != null) {
            this.api.cancel();
        }
    }

    public Collection<OsmPrimitive> getProcessedPrimitives() {
        return this.processed;
    }

    public void executePostprocessors(ProgressMonitor pm) {
        if (postprocessors != null) {
            for (OsmServerWritePostprocessor pp : postprocessors) {
                pp.postprocessUploadedPrimitives(this.processed, pm);
            }
        }
    }
}

