/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.nmea;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.io.IGpxReader;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.nmea.NmeaParser;
import org.openstreetmap.josm.tools.Logging;

public class NmeaReader
implements IGpxReader {
    private final InputStream source;
    GpxData data;
    private NmeaParser ps;

    public int getParserUnknown() {
        return this.ps.getParserUnknown();
    }

    public int getParserZeroCoordinates() {
        return this.ps.zeroCoord;
    }

    public int getParserChecksumErrors() {
        return this.ps.checksumErrors + this.ps.noChecksum;
    }

    public int getParserMalformed() {
        return this.ps.malformed;
    }

    @Override
    public int getNumberOfCoordinates() {
        return this.ps.getSuccess();
    }

    public NmeaReader(InputStream source) throws IOException {
        this.source = Objects.requireNonNull(source);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean parse(boolean tryToFinish) throws IOException {
        this.data = new GpxData();
        ArrayList<Collection<WayPoint>> currentTrack = new ArrayList<Collection<WayPoint>>();
        try (BufferedReader rd = new BufferedReader(new InputStreamReader(this.source, StandardCharsets.UTF_8));){
            StringBuilder sb = new StringBuilder(1024);
            int loopstartChar = rd.read();
            this.ps = new NmeaParser();
            if (loopstartChar == -1) {
                boolean bl = false;
                return bl;
            }
            sb.append((char)loopstartChar);
            while (true) {
                int c;
                if (sb.length() >= 1020) {
                    sb.delete(0, sb.length() - 1);
                }
                if ((c = rd.read()) == 36) {
                    this.ps.parseNMEASentence(sb.toString());
                    sb.delete(0, sb.length());
                    sb.append('$');
                    continue;
                }
                if (c == -1) {
                    this.ps.parseNMEASentence(sb.toString());
                    currentTrack.add(this.ps.getWaypoints());
                    this.data.tracks.add(new GpxTrack((Collection<Collection<WayPoint>>)currentTrack, Collections.emptyMap()));
                    return true;
                }
                sb.append((char)c);
            }
        }
        catch (IllegalDataException e) {
            Logging.warn(e);
            return false;
        }
    }

    @Override
    public GpxData getGpxData() {
        return this.data;
    }
}

