/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo;

import java.util.Map;
import org.objectweb.asm.Type;

class PrimitiveUtils {
    static final Class<?>[] PRIMITIVE_TYPES = new Class[]{Boolean.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Character.TYPE, Void.TYPE};
    static final Map<String, Class<?>> WRAPPER_CLASS_BY_PRIMITIVE_KEYWORD = Map.of("boolean", Boolean.class, "byte", Byte.class, "char", Character.class, "short", Short.class, "int", Integer.class, "long", Long.class, "float", Float.class, "double", Double.class, "void", Void.class);
    private static final Map<String, Class<?>> PRIMITIVE_TYPE_BY_DESCRIPTOR = Map.of("Z", Boolean.TYPE, "B", Byte.TYPE, "S", Short.TYPE, "I", Integer.TYPE, "J", Long.TYPE, "F", Float.TYPE, "D", Double.TYPE, "C", Character.TYPE);
    private static final Map<String, Class<?>> PRIMITIVE_TYPE_BY_WRAPPER_DESCRIPTOR = Map.of("Ljava/lang/Boolean;", Boolean.TYPE, "Ljava/lang/Byte;", Byte.TYPE, "Ljava/lang/Short;", Short.TYPE, "Ljava/lang/Integer;", Integer.TYPE, "Ljava/lang/Long;", Long.TYPE, "Ljava/lang/Float;", Float.TYPE, "Ljava/lang/Double;", Double.TYPE, "Ljava/lang/Character;", Character.TYPE);
    private static final Map<String, Boxing> BOXING_CONVERSION_BY_PRIMITIVE_DESCRIPTOR = Map.of("Z", new Boxing(Boolean.class, "booleanValue"), "B", new Boxing(Byte.class, "byteValue"), "S", new Boxing(Short.class, "shortValue"), "I", new Boxing(Integer.class, "intValue"), "J", new Boxing(Long.class, "longValue"), "F", new Boxing(Float.class, "floatValue"), "D", new Boxing(Double.class, "doubleValue"), "C", new Boxing(Character.class, "charValue"));

    PrimitiveUtils() {
    }

    static boolean isPrimitiveDescriptor(String descriptor) {
        return PRIMITIVE_TYPE_BY_DESCRIPTOR.containsKey(descriptor);
    }

    static boolean isWrapperDescriptor(String descriptor) {
        return PRIMITIVE_TYPE_BY_WRAPPER_DESCRIPTOR.containsKey(descriptor);
    }

    static boolean isPrimitiveOrWrapperDescriptor(String descriptor) {
        return PRIMITIVE_TYPE_BY_DESCRIPTOR.containsKey(descriptor) || PRIMITIVE_TYPE_BY_WRAPPER_DESCRIPTOR.containsKey(descriptor);
    }

    static Class<?> primitiveTypeFromDescriptor(String descriptor) {
        return PRIMITIVE_TYPE_BY_DESCRIPTOR.get(descriptor);
    }

    static Class<?> primitiveTypeFromWrapperDescriptor(String descriptor) {
        return PRIMITIVE_TYPE_BY_WRAPPER_DESCRIPTOR.get(descriptor);
    }

    static Boxing boxingConversion(String descriptor) {
        return BOXING_CONVERSION_BY_PRIMITIVE_DESCRIPTOR.get(descriptor);
    }

    static class Boxing {
        private final Type wrapperClass;
        private final String unboxingMethodName;

        private Boxing(Class<?> wrapperClass, String unboxingMethodName) {
            this.wrapperClass = Type.getType(wrapperClass);
            this.unboxingMethodName = unboxingMethodName;
        }

        String wrapperDescriptor() {
            return this.wrapperClass.getDescriptor();
        }

        String wrapperInternalName() {
            return this.wrapperClass.getInternalName();
        }

        String unboxingMethod() {
            return this.unboxingMethodName;
        }

        String boxingMethod() {
            return "valueOf";
        }
    }
}

